/*
 * Decompiled with CFR 0.152.
 */
package gdscript.library;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ide.progress.TasksKt;
import common.util.GdScriptProjectLifetimeService;
import gdscript.library.GdLibraryManager;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgdscript/library/GdLibraryUpdater;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "VERSION_REGEX", "Lkotlin/text/Regex;", "scheduleSkdCheck", "", "projectBasePath", "Ljava/nio/file/Path;", "checkSdk", "Companion", "intellij.rider.plugins.godot.gdscript"})
public final class GdLibraryUpdater {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Regex VERSION_REGEX;

    public GdLibraryUpdater(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.VERSION_REGEX = new Regex("config/features=PackedStringArray\\(.*\"(\\d\\.\\d)\".*\\)");
    }

    public final void scheduleSkdCheck(@NotNull Path projectBasePath) {
        Intrinsics.checkNotNullParameter((Object)projectBasePath, (String)"projectBasePath");
        BuildersKt.launch$default((CoroutineScope)GdScriptProjectLifetimeService.Companion.getInstance(this.project).getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, projectBasePath, null){
            int label;
            final /* synthetic */ GdLibraryUpdater this$0;
            final /* synthetic */ Path $projectBasePath;
            {
                this.this$0 = $receiver;
                this.$projectBasePath = $projectBasePath;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TasksKt.withBackgroundProgress((Project)GdLibraryUpdater.access$getProject$p(this.this$0), (String)GdScriptBundle.INSTANCE.message("progress.title.check.gdsdk.for.project", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$projectBasePath, null){
                            int label;
                            final /* synthetic */ GdLibraryUpdater this$0;
                            final /* synthetic */ Path $projectBasePath;
                            {
                                this.this$0 = $receiver;
                                this.$projectBasePath = $projectBasePath;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        GdLibraryUpdater.access$checkSdk(this.this$0, this.$projectBasePath);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void checkSdk(Path projectBasePath) {
        Path projectFile = projectBasePath.resolve("project.godot");
        Intrinsics.checkNotNull((Object)projectFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(projectFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
        String content = PathsKt.readText((Path)projectFile, (Charset)charset);
        Object object = Regex.find$default((Regex)this.VERSION_REGEX, (CharSequence)content, (int)0, (int)2, null);
        if (object == null || (object = object.getGroups()) == null || (object = object.get(1)) == null || (object = object.getValue()) == null) {
            throw new IllegalStateException("GdSdk version cannot be parsed from project.godot");
        }
        Object version = object;
        if (StringsKt.startsWith$default((String)version, (String)"3.", (boolean)false, (int)2, null)) {
            throw new IllegalStateException("Godot 3.x is not supported by the plugin");
        }
        if (this.project.isDisposed()) {
            return;
        }
        Path sdkPath = GdLibraryManager.INSTANCE.extractSdkIfNeeded((String)version);
        GdLibraryManager.INSTANCE.registerSdkIfNeeded(sdkPath, this.project);
    }

    public static final /* synthetic */ Project access$getProject$p(GdLibraryUpdater $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$checkSdk(GdLibraryUpdater $this, Path projectBasePath) {
        $this.checkSdk(projectBasePath);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lgdscript/library/GdLibraryUpdater$Companion;", "", "<init>", "()V", "getInstance", "Lgdscript/library/GdLibraryUpdater;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.godot.gdscript"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GdLibraryUpdater getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(GdLibraryUpdater.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (GdLibraryUpdater)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

