/*
 * Decompiled with CFR 0.152.
 */
package gdscript.library;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.Decompressor;
import gdscript.library.GdLibraryKind;
import gdscript.library.SdkIntegrityValidator;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgdscript/library/GdLibraryManager;", "", "<init>", "()V", "LIBRARY_NAME", "", "registerSdkIfNeeded", "", "path", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "extractSdkIfNeededInternal", "version", "bundledSdkPath", "extractSdkIfNeeded", "findSdkVersion", "extractionDir", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nGdLibraryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdLibraryManager.kt\ngdscript/library/GdLibraryManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,152:1\n13130#2,3:153\n4225#2,11:156\n3919#2:170\n4434#2,2:171\n1761#3,3:167\n23#4:173\n23#4:176\n23#4:177\n1#5:174\n622#6:175\n*S KotlinDebug\n*F\n+ 1 GdLibraryManager.kt\ngdscript/library/GdLibraryManager\n*L\n44#1:153,3\n47#1:156,11\n54#1:170\n54#1:171,2\n48#1:167,3\n85#1:173\n137#1:176\n145#1:177\n133#1:175\n*E\n"})
public final class GdLibraryManager {
    @NotNull
    public static final GdLibraryManager INSTANCE = new GdLibraryManager();
    @NotNull
    private static final String LIBRARY_NAME = "GdSdk";

    private GdLibraryManager() {
    }

    /*
     * WARNING - void declaration
     */
    public final void registerSdkIfNeeded(@NotNull Path path, @NotNull Project project) {
        void $this$filterTo$iv$iv;
        Object[] $this$any$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile sourceRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(((Object)path).toString());
        if (sourceRoot == null) {
            throw new Exception("Cannot find SDK at " + path);
        }
        Module module = (Module)ArraysKt.first((Object[])ModuleManager.Companion.getInstance(project).getModules());
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project);
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getLibraryTable(...)");
        LibraryTable libraryTable2 = libraryTable;
        Library library = libraryTable2.getLibraryByName(LIBRARY_NAME);
        if (library != null) {
            Library lib = library;
            boolean bl = false;
            if (lib.isValid(sourceRoot.getUrl(), OrderRootType.SOURCES)) {
                Library[] libraryArray = libraryTable2.getLibraries();
                Intrinsics.checkNotNullExpressionValue((Object)libraryArray, (String)"getLibraries(...)");
                Object[] $this$count$iv = libraryArray;
                boolean $i$f$count = false;
                int count$iv2 = 0;
                for (Object element$iv : $this$count$iv) {
                    Library library2 = (Library)element$iv;
                    boolean bl2 = false;
                    String string = library2.getName();
                    boolean bl3 = string != null ? StringsKt.startsWith$default((String)string, (String)LIBRARY_NAME, (boolean)false, (int)2, null) : false;
                    if (!bl3) continue;
                    ++count$iv2;
                }
                if (count$iv2 == 1) {
                    boolean bl4;
                    block13: {
                        Iterator $this$filterIsInstanceTo$iv$iv;
                        Iterable $this$filterIsInstance$iv;
                        OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module).getOrderEntries();
                        Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"getOrderEntries(...)");
                        $this$count$iv = orderEntryArray;
                        boolean $i$f$filterIsInstance = false;
                        void count$iv2 = $this$filterIsInstance$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof LibraryOrderEntry)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filterIsInstance$iv = (List)destination$iv$iv;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                LibraryOrderEntry it = (LibraryOrderEntry)element$iv;
                                boolean bl5 = false;
                                if (!Intrinsics.areEqual((Object)it.getLibrary(), (Object)lib)) continue;
                                bl4 = true;
                                break block13;
                            }
                            bl4 = false;
                        }
                    }
                    if (bl4) {
                        return;
                    }
                }
            }
        }
        Ref.ObjectRef tableModel = new Ref.ObjectRef();
        LibraryTable.ModifiableModel modifiableModel = libraryTable2.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"getModifiableModel(...)");
        tableModel.element = modifiableModel;
        Library[] libraryArray = ((LibraryTable.ModifiableModel)tableModel.element).getLibraries();
        Intrinsics.checkNotNullExpressionValue((Object)libraryArray, (String)"getLibraries(...)");
        Object[] $this$filter$iv = libraryArray;
        boolean $i$f$filter = false;
        $this$any$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Library library3 = (Library)element$iv$iv;
            boolean bl = false;
            String string = library3.getName();
            boolean bl6 = string != null ? StringsKt.startsWith$default((String)string, (String)LIBRARY_NAME, (boolean)false, (int)2, null) : false;
            if (!bl6) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List libraries = (List)destination$iv$iv;
        if (CollectionsKt.any((Iterable)libraries)) {
            for (Library library4 : libraries) {
                ((LibraryTable.ModifiableModel)tableModel.element).removeLibrary(library4);
            }
            ApplicationManager.getApplication().invokeAndWait(() -> GdLibraryManager.registerSdkIfNeeded$lambda$2(tableModel));
        }
        LibraryTable.ModifiableModel modifiableModel2 = libraryTable2.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel2, (String)"getModifiableModel(...)");
        tableModel.element = modifiableModel2;
        Library library5 = ((LibraryTable.ModifiableModel)tableModel.element).createLibrary(LIBRARY_NAME, (PersistentLibraryKind)GdLibraryKind.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)library5, (String)"createLibrary(...)");
        Library library6 = library5;
        Library.ModifiableModel modifiableModel3 = library6.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel3, (String)"getModifiableModel(...)");
        Library.ModifiableModel libraryModel = modifiableModel3;
        libraryModel.addRoot(sourceRoot, OrderRootType.SOURCES);
        ApplicationManager.getApplication().invokeAndWait(() -> GdLibraryManager.registerSdkIfNeeded$lambda$3(module, library6, libraryModel, tableModel));
    }

    /*
     * Unable to fully structure code
     */
    private final Path extractSdkIfNeededInternal(String version, Path bundledSdkPath) {
        v0 = PluginManager.getPluginByClass(GdLibraryManager.class);
        v1 = name = v0 != null ? v0.getName() : null;
        if (name == null) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            v2 = Logger.getInstance(GdLibraryManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
            v2.error("Cannot find Godot plugin ID");
            name = "GdScript";
        }
        extractionDir = PathManager.getPluginsDir().resolve(name).resolve("extracted");
        validator = new SdkIntegrityValidator();
        extractionStampFile = extractionDir.resolve("_gd-sdk-file-stamp.txt").toFile();
        if (!extractionDir.toFile().exists() || !extractionStampFile.exists()) ** GOTO lbl-1000
        Intrinsics.checkNotNull((Object)extractionStampFile);
        v3 = StringsKt.trim((CharSequence)FilesKt.readText$default((File)extractionStampFile, null, (int)1, null)).toString();
        Intrinsics.checkNotNull((Object)extractionDir);
        if (!Intrinsics.areEqual((Object)v3, (Object)String.valueOf(((Collection)validator.getFilesFromFs(extractionDir)).size()))) lbl-1000:
        // 2 sources

        {
            v4 = true;
        } else {
            v4 = needsExtraction = false;
        }
        if (needsExtraction) {
            if (extractionDir.toFile().exists()) {
                v5 = extractionDir.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"toFile(...)");
                FilesKt.deleteRecursively((File)v5);
            }
            Files.createDirectories(extractionDir, new FileAttribute[0]);
            new Decompressor.Tar(bundledSdkPath).extract(extractionDir);
            v6 = extractionDir.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"toFile(...)");
            validator.writeStamp(v6);
        }
        Intrinsics.checkNotNull((Object)extractionDir);
        requestedSdkDir = this.findSdkVersion(extractionDir, version);
        return requestedSdkDir;
    }

    @NotNull
    public final Path extractSdkIfNeeded(@NotNull String version) {
        boolean bl;
        Path path;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Path path2 = PluginManagerCoreKt.getPluginDistDirByClass(this.getClass());
        Path it = path = path2 != null ? path2.resolve("sdk/sdk.tar.xz") : null;
        boolean bl2 = false;
        Path path3 = it;
        if (path3 != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            bl = Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        } else {
            bl = false;
        }
        Path path4 = bl ? path : null;
        if (path4 == null) {
            throw new IllegalStateException("Bundled SDK not found".toString());
        }
        Path bundledSdkPath = path4;
        return this.extractSdkIfNeededInternal(version, bundledSdkPath);
    }

    /*
     * WARNING - void declaration
     */
    private final Path findSdkVersion(Path extractionDir, String version) {
        GdLibraryManager $this$thisLogger$iv;
        Version prefix = Version.parseVersion((String)version);
        if (prefix != null) {
            Path bestMatch;
            void $this$sortedByDescending$iv;
            Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)PathsKt.listDirectoryEntries$default((Path)extractionDir, null, (int)1, null)), GdLibraryManager::findSdkVersion$lambda$0), GdLibraryManager::findSdkVersion$lambda$1), arg_0 -> GdLibraryManager.findSdkVersion$lambda$2(prefix, arg_0));
            boolean $i$f$sortedByDescending = false;
            Pair pair = (Pair)SequencesKt.firstOrNull((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair pair = (Pair)b;
                    boolean bl = false;
                    Version semVer = (Version)pair.component1();
                    pair = (Pair)a;
                    Comparable comparable = (Comparable)semVer;
                    bl = false;
                    semVer = (Version)pair.component1();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)semVer));
                }
            }));
            Path path = bestMatch = pair != null ? (Path)pair.getSecond() : null;
            if (bestMatch != null) {
                $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(GdLibraryManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Use " + bestMatch + " version for " + version + ".");
                return bestMatch;
            }
        }
        Path masterDir = extractionDir.resolve("Master");
        Intrinsics.checkNotNull((Object)masterDir);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(masterDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GdLibraryManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Use " + masterDir + " for " + version + ".");
            return masterDir;
        }
        throw new Exception("Requested SDK version " + version + " not found in " + extractionDir);
    }

    private static final void registerSdkIfNeeded$lambda$2(Ref.ObjectRef $tableModel) {
        ApplicationManager.getApplication().runWriteAction(() -> GdLibraryManager.registerSdkIfNeeded$lambda$2$0($tableModel));
    }

    private static final void registerSdkIfNeeded$lambda$2$0(Ref.ObjectRef $tableModel) {
        ((LibraryTable.ModifiableModel)$tableModel.element).commit();
    }

    private static final void registerSdkIfNeeded$lambda$3(Module $module, Library $library, Library.ModifiableModel $libraryModel, Ref.ObjectRef $tableModel) {
        ApplicationManager.getApplication().runWriteAction(() -> GdLibraryManager.registerSdkIfNeeded$lambda$3$0($libraryModel, $tableModel));
        ModuleRootModificationUtil.addDependency((Module)$module, (Library)$library);
    }

    private static final void registerSdkIfNeeded$lambda$3$0(Library.ModifiableModel $libraryModel, Ref.ObjectRef $tableModel) {
        $libraryModel.commit();
        ((LibraryTable.ModifiableModel)$tableModel.element).commit();
    }

    private static final boolean findSdkVersion$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Files.isDirectory(it, new LinkOption[0]);
    }

    private static final Pair findSdkVersion$lambda$1(Path dir) {
        Version parsed;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Version version = parsed = Version.parseVersion((String)PathsKt.getName((Path)dir));
        return version != null ? TuplesKt.to((Object)version, (Object)dir) : null;
    }

    private static final boolean findSdkVersion$lambda$2(Version $prefix, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        Version ver = (Version)pair.component1();
        return ver.major == $prefix.major && ver.minor == $prefix.minor;
    }
}

