/*
 * Decompiled with CFR 0.152.
 */
package gdscript.inspection.validator;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import gdscript.inspection.validator.GdMethodValidationResult;
import gdscript.psi.GdElifSt;
import gdscript.psi.GdElseSt;
import gdscript.psi.GdFlowSt;
import gdscript.psi.GdIfSt;
import gdscript.psi.GdMatchSt;
import gdscript.psi.GdPattern;
import gdscript.psi.GdStmt;
import gdscript.psi.GdStmtOrSuite;
import gdscript.psi.GdSuite;
import gdscript.psi.impl.GdMatchBlockImpl;
import gdscript.psi.utils.GdExprUtil;
import gdscript.psi.utils.GdStmtUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u001a\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020%H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00050\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lgdscript/inspection/validator/GdMethodValidator;", "", "project", "Lcom/intellij/openapi/project/Project;", "returnType", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getReturnType", "()Ljava/lang/String;", "returnTypes", "", "invalidReturns", "", "Lkotlin/Pair;", "Lgdscript/psi/GdStmt;", "unreachableStatements", "alwaysReturns", "", "validate", "Lgdscript/inspection/validator/GdMethodValidationResult;", "stmtOrSuite", "Lgdscript/psi/GdStmtOrSuite;", "traverseSuite", "traverseStatements", "statements", "", "traverseMatchStatement", "statement", "Lgdscript/psi/GdMatchSt;", "traverseIfStatement", "Lgdscript/psi/GdIfSt;", "traverseLoopStatement", "checkReturnStatement", "", "Lgdscript/psi/GdFlowSt;", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nGdMethodValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdMethodValidator.kt\ngdscript/inspection/validator/GdMethodValidator\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,127:1\n455#2:128\n455#2:129\n455#2:130\n455#2:131\n*S KotlinDebug\n*F\n+ 1 GdMethodValidator.kt\ngdscript/inspection/validator/GdMethodValidator\n*L\n36#1:128\n68#1:129\n71#1:130\n107#1:131\n*E\n"})
public final class GdMethodValidator {
    @NotNull
    private final Project project;
    @NotNull
    private final String returnType;
    @NotNull
    private final Set<String> returnTypes;
    @NotNull
    private final List<Pair<GdStmt, String>> invalidReturns;
    @NotNull
    private final List<GdStmt> unreachableStatements;
    private boolean alwaysReturns;

    public GdMethodValidator(@NotNull Project project, @NotNull String returnType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        this.project = project;
        this.returnType = returnType;
        this.returnTypes = new LinkedHashSet();
        this.invalidReturns = new ArrayList();
        this.unreachableStatements = new ArrayList();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getReturnType() {
        return this.returnType;
    }

    @NotNull
    public final GdMethodValidationResult validate(@Nullable GdStmtOrSuite stmtOrSuite) {
        if (stmtOrSuite != null) {
            this.alwaysReturns = this.traverseSuite(stmtOrSuite);
        }
        return new GdMethodValidationResult(this.returnTypes, this.invalidReturns, this.unreachableStatements, this.alwaysReturns);
    }

    private final boolean traverseSuite(GdStmtOrSuite stmtOrSuite) {
        if (stmtOrSuite.getStmt() != null) {
            GdStmt gdStmt = stmtOrSuite.getStmt();
            Intrinsics.checkNotNull((Object)gdStmt);
            return this.traverseStatements(CollectionsKt.listOf((Object)gdStmt));
        }
        List<GdSuite> list = stmtOrSuite.getSuiteList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSuiteList(...)");
        boolean alwaysReturn = !((Collection)list).isEmpty();
        for (GdSuite suite : stmtOrSuite.getSuiteList()) {
            Intrinsics.checkNotNull((Object)suite);
            PsiElement $this$childrenOfType$iv = suite;
            boolean $i$f$childrenOfType = false;
            List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, GdStmt.class);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(...)");
            boolean pathReturns = this.traverseStatements(list2);
            alwaysReturn = alwaysReturn && pathReturns;
        }
        return alwaysReturn;
    }

    private final boolean traverseStatements(List<? extends GdStmt> statements) {
        boolean alwaysReturn = false;
        for (GdStmt gdStmt : statements) {
            if (alwaysReturn) {
                this.unreachableStatements.add(gdStmt);
                return true;
            }
            if (gdStmt instanceof GdFlowSt && Intrinsics.areEqual((Object)((GdFlowSt)gdStmt).getType(), (Object)"return")) {
                this.checkReturnStatement((GdFlowSt)gdStmt);
                alwaysReturn = true;
                continue;
            }
            if (gdStmt instanceof GdMatchSt) {
                alwaysReturn = this.traverseMatchStatement((GdMatchSt)gdStmt);
                continue;
            }
            if (gdStmt instanceof GdIfSt) {
                alwaysReturn = this.traverseIfStatement((GdIfSt)gdStmt);
                continue;
            }
            if (!GdStmtUtil.INSTANCE.isLoopStatement(gdStmt)) continue;
            alwaysReturn = this.traverseLoopStatement(gdStmt);
        }
        return alwaysReturn;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean traverseMatchStatement(GdMatchSt statement) {
        withDefault = false;
        alwaysReturn = true;
        $this$childrenOfType$iv = statement;
        $i$f$childrenOfType = false;
        v0 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, GdMatchBlockImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getChildrenOfTypeAsList(...)");
        for (GdMatchBlockImpl matchBlock : v0) {
            if (withDefault) ** GOTO lbl-1000
            v1 = matchBlock.getPatternList().getPatternList();
            Intrinsics.checkNotNullExpressionValue(v1, (String)"getPatternList(...)");
            if (Intrinsics.areEqual((Object)((GdPattern)CollectionsKt.first(v1)).getText(), (Object)"_")) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            withDefault = v2;
            $this$childrenOfType$iv = matchBlock;
            $i$f$childrenOfType = false;
            v3 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, GdStmtOrSuite.class);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getChildrenOfTypeAsList(...)");
            for (GdStmtOrSuite nestedElems : v3) {
                suiteReturn = this.traverseSuite(nestedElems);
                alwaysReturn = alwaysReturn != false && suiteReturn != false;
            }
        }
        return alwaysReturn != false && withDefault != false;
    }

    private final boolean traverseIfStatement(GdIfSt statement) {
        boolean hasElse = false;
        PsiElement[] psiElementArray = statement.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        boolean alwaysReturns = !(((Object[])psiElementArray).length == 0);
        PsiElement[] psiElementArray2 = statement.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"getChildren(...)");
        for (PsiElement psiElement : psiElementArray2) {
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement nestedElem = psiElement;
            if (nestedElem instanceof GdStmtOrSuite) {
                boolean suiteReturn = this.traverseSuite((GdStmtOrSuite)nestedElem);
                alwaysReturns = alwaysReturns && suiteReturn;
                continue;
            }
            if (nestedElem instanceof GdElifSt) {
                if (((GdElifSt)nestedElem).getStmtOrSuite() == null) continue;
                GdStmtOrSuite gdStmtOrSuite = ((GdElifSt)nestedElem).getStmtOrSuite();
                Intrinsics.checkNotNull((Object)gdStmtOrSuite);
                boolean suiteReturn = this.traverseSuite(gdStmtOrSuite);
                alwaysReturns = alwaysReturns && suiteReturn;
                continue;
            }
            if (!(nestedElem instanceof GdElseSt)) continue;
            if (((GdElseSt)nestedElem).getStmtOrSuite() != null) {
                GdStmtOrSuite gdStmtOrSuite = ((GdElseSt)nestedElem).getStmtOrSuite();
                Intrinsics.checkNotNull((Object)gdStmtOrSuite);
                boolean suiteReturn = this.traverseSuite(gdStmtOrSuite);
                alwaysReturns = alwaysReturns && suiteReturn;
            }
            hasElse = true;
        }
        return alwaysReturns && hasElse;
    }

    private final boolean traverseLoopStatement(GdStmt statement) {
        PsiElement $this$childrenOfType$iv = statement;
        boolean $i$f$childrenOfType = false;
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, GdStmtOrSuite.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
        List suites = list;
        boolean alwaysReturns = !((Collection)suites).isEmpty();
        for (GdStmtOrSuite suite : suites) {
            boolean suiteReturn = this.traverseSuite(suite);
            alwaysReturns = alwaysReturns && suiteReturn;
        }
        return alwaysReturns;
    }

    private final void checkReturnStatement(GdFlowSt statement) {
        Object stmtType;
        Object object = statement.getExpr();
        if (object == null || (object = object.getReturnType()) == null) {
            object = "void";
        }
        if (!GdExprUtil.INSTANCE.typeAccepts((String)(stmtType = object), this.returnType, this.project)) {
            this.invalidReturns.add((Pair<GdStmt, String>)new Pair((Object)statement, stmtType));
        }
        this.returnTypes.add((String)stmtType);
    }
}

