/*
 * Decompiled with CFR 0.152.
 */
package gdscript.inspection.fixes;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import gdscript.psi.GdElementFactory;
import gdscript.psi.GdNamedIdElement;
import gdscript.psi.GdReturnHint;
import gdscript.psi.GdTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0096\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgdscript/inspection/fixes/GdAddReturnTypeHintFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "element", "Lgdscript/psi/GdNamedIdElement;", "desired", "", "<init>", "(Lgdscript/psi/GdNamedIdElement;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "findRRBRElem", "intellij.rider.plugins.godot.gdscript"})
public final class GdAddReturnTypeHintFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final String desired;

    public GdAddReturnTypeHintFix(@NotNull GdNamedIdElement element, @NotNull String desired) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)desired, (String)"desired");
        super((PsiElement)element);
        this.desired = desired;
    }

    @NotNull
    public String getFamilyName() {
        return "Add return type";
    }

    @NotNull
    public String getText() {
        return "Specify return type [" + this.desired + "]";
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        PsiElement rrbrElem = this.findRRBRElem();
        if (rrbrElem != null) {
            GdReturnHint returnHint = GdElementFactory.INSTANCE.returnHint(project, this.desired);
            startElement.getParent().addRangeAfter(returnHint.getPrevSibling(), (PsiElement)returnHint, rrbrElem);
        }
    }

    private final PsiElement findRRBRElem() {
        for (PsiElement maybeElement = this.getStartElement().getNextSibling(); maybeElement != null; maybeElement = maybeElement.getNextSibling()) {
            if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)maybeElement), (Object)GdTypes.RRBR)) continue;
            return maybeElement;
        }
        return null;
    }
}

