/*
 * Decompiled with CFR 0.152.
 */
package gdscript.inspection;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.DocumentUtil;
import com.jetbrains.rider.godot.community.gdscript.GdFileType;
import gdscript.inspection.fixes.GdFixIndentsQuickFix;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lgdscript/inspection/GdWhitespaceLocalInspectionTool;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "WhitespaceVisitor", "intellij.rider.plugins.godot.gdscript"})
public final class GdWhitespaceLocalInspectionTool
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new WhitespaceVisitor(holder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgdscript/inspection/GdWhitespaceLocalInspectionTool$WhitespaceVisitor;", "Lcom/intellij/psi/PsiElementVisitor;", "myHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitFile", "", "file", "Lcom/intellij/psi/PsiFile;", "registerError", "range", "Lcom/intellij/openapi/util/TextRange;", "tab", "", "intellij.rider.plugins.godot.gdscript"})
    private static final class WhitespaceVisitor
    extends PsiElementVisitor {
        @NotNull
        private final ProblemsHolder myHolder;

        public WhitespaceVisitor(@NotNull ProblemsHolder myHolder) {
            Intrinsics.checkNotNullParameter((Object)myHolder, (String)"myHolder");
            this.myHolder = myHolder;
        }

        public void visitFile(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super.visitFile(file);
            if (!(file.getFileType() instanceof GdFileType)) {
                return;
            }
            Document document = file.getViewProvider().getDocument();
            if (document == null) {
                return;
            }
            Document document2 = document;
            CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((PsiFile)file);
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getSettings(...)");
            CodeStyleSettings settings = codeStyleSettings;
            CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptionsByFile(file);
            Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptionsByFile(...)");
            CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
            boolean useTabs = indentOptions2.USE_TAB_CHARACTER;
            int lineCount = document2.getLineCount();
            for (int lineIndex = 0; lineIndex < lineCount; ++lineIndex) {
                CharSequence indent;
                int startOffset = document2.getLineStartOffset(lineIndex);
                Intrinsics.checkNotNullExpressionValue((Object)DocumentUtil.getIndent((Document)document2, (int)startOffset), (String)"getIndent(...)");
                TextRange indentRange = new TextRange(startOffset, startOffset + indent.length());
                if (StringsKt.contains$default((CharSequence)indent, (char)'\t', (boolean)false, (int)2, null) && !useTabs) {
                    this.registerError(file, indentRange, true);
                }
                if (!StringsKt.contains$default((CharSequence)indent, (char)' ', (boolean)false, (int)2, null) || !useTabs) continue;
                this.registerError(file, indentRange, false);
            }
        }

        private final void registerError(PsiFile file, TextRange range, boolean tab) {
            String description = tab ? GdScriptBundle.INSTANCE.message("inspections.whitespace.spaces.problem", new Object[0]) : GdScriptBundle.INSTANCE.message("inspections.whitespace.tabs.problem", new Object[0]);
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new GdFixIndentsQuickFix()};
            this.myHolder.registerProblem((PsiElement)file, description, ProblemHighlightType.GENERIC_ERROR, range, localQuickFixArray);
        }
    }
}

