/*
 * Decompiled with CFR 0.152.
 */
package gdscript.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import gdscript.inspection.fixes.GdAddVariableTypeHintFix;
import gdscript.inspection.util.ProblemsHolderExtension;
import gdscript.psi.GdAssignTyped;
import gdscript.psi.GdClassVarDeclTl;
import gdscript.psi.GdConstDeclSt;
import gdscript.psi.GdConstDeclTl;
import gdscript.psi.GdExpr;
import gdscript.psi.GdTyped;
import gdscript.psi.GdVarDeclSt;
import gdscript.psi.GdVisitor;
import gdscript.settings.GdProjectSettingsState;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lgdscript/inspection/GdTypeHintInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkTypeHint", "", "element", "Lcom/intellij/psi/PsiElement;", "fullType", "intellij.rider.plugins.godot.gdscript"})
public final class GdTypeHintInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        boolean fullType = !GdProjectSettingsState.Companion.getInstance(project).getState().getShortTyped();
        return new GdVisitor(this, holder, fullType){
            final /* synthetic */ GdTypeHintInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $fullType;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$fullType = $fullType;
            }

            public void visitClassVarDeclTl(GdClassVarDeclTl o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                GdTypeHintInspection.access$checkTypeHint(this.this$0, o, this.$holder, this.$fullType);
            }

            public void visitConstDeclTl(GdConstDeclTl o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                GdTypeHintInspection.access$checkTypeHint(this.this$0, o, this.$holder, this.$fullType);
            }

            public void visitVarDeclSt(GdVarDeclSt o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                GdTypeHintInspection.access$checkTypeHint(this.this$0, o, this.$holder, this.$fullType);
            }

            public void visitConstDeclSt(GdConstDeclSt o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                GdTypeHintInspection.access$checkTypeHint(this.this$0, o, this.$holder, this.$fullType);
            }
        };
    }

    private final void checkTypeHint(PsiElement element, ProblemsHolder holder, boolean fullType) {
        Triple triple;
        PsiElement psiElement = element;
        if (psiElement instanceof GdConstDeclTl) {
            triple = new Triple((Object)((GdConstDeclTl)element).getAssignTyped(), (Object)((GdConstDeclTl)element).getTyped(), (Object)((GdConstDeclTl)element).getExpr());
        } else if (psiElement instanceof GdClassVarDeclTl) {
            triple = new Triple((Object)((GdClassVarDeclTl)element).getAssignTyped(), (Object)((GdClassVarDeclTl)element).getTyped(), (Object)((GdClassVarDeclTl)element).getExpr());
        } else if (psiElement instanceof GdVarDeclSt) {
            triple = new Triple((Object)((GdVarDeclSt)element).getAssignTyped(), (Object)((GdVarDeclSt)element).getTyped(), (Object)((GdVarDeclSt)element).getExpr());
        } else if (psiElement instanceof GdConstDeclSt) {
            triple = new Triple((Object)((GdConstDeclSt)element).getAssignTyped(), (Object)((GdConstDeclSt)element).getTyped(), (Object)((GdConstDeclSt)element).getExpr());
        } else {
            return;
        }
        Triple returnTypes = triple;
        GdAssignTyped assigment = (GdAssignTyped)returnTypes.getFirst();
        if (assigment != null && assigment.getText().equals(":=")) {
            if (returnTypes.getSecond() == null) {
                return;
            }
            ProblemsHolderExtension.registerError$default(ProblemsHolderExtension.INSTANCE, holder, element, ":= assigment cannot be typed", null, 4, null);
            return;
        }
        Object object = (GdTyped)returnTypes.getSecond();
        String returnType = object != null && (object = object.getTypedVal()) != null ? object.getReturnType() : null;
        GdExpr expr = (GdExpr)returnTypes.getThird();
        if (returnType != null || expr == null) {
            return;
        }
        String string = expr.getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getReturnType(...)");
        String realType = string;
        if (((CharSequence)realType).length() == 0) {
            return;
        }
        if (Intrinsics.areEqual((Object)realType, (Object)"Variant") || Intrinsics.areEqual((Object)realType, (Object)"null")) {
            return;
        }
        if (StringsKt.startsWith$default((String)realType, (String)"res", (boolean)false, (int)2, null)) {
            return;
        }
        ProblemsHolderExtension.INSTANCE.registerWeakWarning(holder, element, "Field's return type can be specified as " + realType, (LocalQuickFix)new GdAddVariableTypeHintFix(element, realType, fullType));
    }

    public static final /* synthetic */ void access$checkTypeHint(GdTypeHintInspection $this, PsiElement element, ProblemsHolder holder, boolean fullType) {
        $this.checkTypeHint(element, holder, fullType);
    }
}

