/*
 * Decompiled with CFR 0.152.
 */
package gdscript.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import gdscript.inspection.fixes.GdAddReturnTypeHintFix;
import gdscript.inspection.fixes.GdChangeReturnTypeFix;
import gdscript.inspection.util.ProblemsHolderExtension;
import gdscript.inspection.validator.GdMethodValidationResult;
import gdscript.inspection.validator.GdMethodValidator;
import gdscript.psi.GdCallEx;
import gdscript.psi.GdFuncDeclEx;
import gdscript.psi.GdFuncDeclIdNmi;
import gdscript.psi.GdMethodDeclTl;
import gdscript.psi.GdMethodIdNmi;
import gdscript.psi.GdNamedIdElement;
import gdscript.psi.GdReturnHint;
import gdscript.psi.GdReturnHintVal;
import gdscript.psi.GdStmt;
import gdscript.psi.GdStmtOrSuite;
import gdscript.psi.GdVisitor;
import gdscript.psi.utils.GdExprUtil;
import gdscript.psi.utils.GdInheritanceUtil;
import gdscript.psi.utils.GdMethodUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lgdscript/inspection/GdMethodValidationInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.rider.plugins.godot.gdscript"})
public final class GdMethodValidationInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new GdVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitFuncDeclEx(GdFuncDeclEx o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (o.getFuncDeclIdNmi() == null) {
                    return;
                }
                GdFuncDeclIdNmi gdFuncDeclIdNmi = o.getFuncDeclIdNmi();
                Intrinsics.checkNotNull((Object)gdFuncDeclIdNmi);
                GdNamedIdElement gdNamedIdElement = gdFuncDeclIdNmi;
                GdReturnHint gdReturnHint = o.getReturnHint();
                GdReturnHintVal gdReturnHintVal = gdReturnHint != null ? gdReturnHint.getReturnHintVal() : null;
                String string = o.getReturnType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getReturnType(...)");
                this.validateMethod(gdNamedIdElement, gdReturnHintVal, string, o.getStmtOrSuite());
            }

            public void visitMethodDeclTl(GdMethodDeclTl o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (o.getMethodIdNmi() == null) {
                    return;
                }
                GdMethodIdNmi gdMethodIdNmi = o.getMethodIdNmi();
                Intrinsics.checkNotNull((Object)gdMethodIdNmi);
                GdNamedIdElement gdNamedIdElement = gdMethodIdNmi;
                GdReturnHint gdReturnHint = o.getReturnHint();
                GdReturnHintVal gdReturnHintVal = gdReturnHint != null ? gdReturnHint.getReturnHintVal() : null;
                String string = o.getReturnType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getReturnType(...)");
                this.validateMethod(gdNamedIdElement, gdReturnHintVal, string, o.getStmtOrSuite());
                if (Intrinsics.areEqual((Object)o.getName(), (Object)"_init")) {
                    GdMethodIdNmi gdMethodIdNmi2 = o.getMethodIdNmi();
                    Intrinsics.checkNotNull((Object)gdMethodIdNmi2);
                    this.validateConstructor(gdMethodIdNmi2, o);
                }
            }

            private final void validateMethod(GdNamedIdElement methodId, GdReturnHintVal hint, String returnType, GdStmtOrSuite stmtOrSuite) {
                GdStmt it;
                Iterable $this$forEach$iv;
                Project project = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                GdMethodValidationResult validationResult = new GdMethodValidator(project, returnType).validate(stmtOrSuite);
                Iterable iterable = validationResult.getUnreachableStatements();
                ProblemsHolder problemsHolder = this.$holder;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (GdStmt)element$iv;
                    boolean bl = false;
                    ProblemsHolderExtension.registerWeakWarning$default(ProblemsHolderExtension.INSTANCE, problemsHolder, it, "Code is unreachable", null, 4, null);
                }
                $this$forEach$iv = validationResult.getInvalidReturns();
                problemsHolder = this.$holder;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    GdChangeReturnTypeFix gdChangeReturnTypeFix;
                    it = (Pair)element$iv;
                    boolean bl = false;
                    String stmtType = (String)it.getSecond();
                    ProblemsHolderExtension problemsHolderExtension = ProblemsHolderExtension.INSTANCE;
                    ProblemsHolder problemsHolder2 = problemsHolder;
                    PsiElement psiElement = (PsiElement)it.getFirst();
                    String string = "Returns a type [" + stmtType + "] which do not match function's [" + returnType + "]";
                    if (hint != null) {
                        String string2 = string;
                        PsiElement psiElement2 = psiElement;
                        ProblemsHolder problemsHolder3 = problemsHolder2;
                        ProblemsHolderExtension problemsHolderExtension2 = problemsHolderExtension;
                        boolean bl2 = false;
                        GdChangeReturnTypeFix gdChangeReturnTypeFix2 = new GdChangeReturnTypeFix(hint, stmtType);
                        problemsHolderExtension = problemsHolderExtension2;
                        problemsHolder2 = problemsHolder3;
                        psiElement = psiElement2;
                        string = string2;
                        gdChangeReturnTypeFix = gdChangeReturnTypeFix2;
                    } else {
                        gdChangeReturnTypeFix = null;
                    }
                    problemsHolderExtension.registerGenericError(problemsHolder2, psiElement, string, (LocalQuickFix)gdChangeReturnTypeFix);
                }
                if (((CharSequence)returnType).length() > 0 && validationResult.noReturn() && !Intrinsics.areEqual((Object)returnType, (Object)"void")) {
                    ProblemsHolderExtension.registerGenericError$default(ProblemsHolderExtension.INSTANCE, this.$holder, (PsiElement)methodId, "Function's require a return value", null, 4, null);
                } else if (!validationResult.voidOnlyReturn() && !validationResult.getAlwaysReturns()) {
                    ProblemsHolderExtension.registerGenericError$default(ProblemsHolderExtension.INSTANCE, this.$holder, (PsiElement)methodId, "Not all code paths return a value", null, 4, null);
                }
                if (((CharSequence)returnType).length() == 0 && validationResult.hasReturn()) {
                    String commonType = this.determineCommonType(validationResult.getReturnTypes());
                    if (commonType == null) {
                        ProblemsHolderExtension.registerWeakWarning$default(ProblemsHolderExtension.INSTANCE, this.$holder, (PsiElement)methodId, "Function's return type is not specified", null, 4, null);
                    } else {
                        ProblemsHolderExtension.INSTANCE.registerWeakWarning(this.$holder, (PsiElement)methodId, "Function's return type can be specified as " + commonType, (LocalQuickFix)new GdAddReturnTypeHintFix(methodId, commonType));
                    }
                }
                if (methodId instanceof GdMethodIdNmi) {
                    this.validateParentType((GdMethodIdNmi)methodId, hint, returnType);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void validateConstructor(GdMethodIdNmi methodId, GdMethodDeclTl method) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                PsiElement psiElement = method;
                Project project = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                PsiElement psiElement2 = GdInheritanceUtil.INSTANCE.getExtendedElement(psiElement, project);
                if (psiElement2 == null) {
                    return;
                }
                PsiElement parent = psiElement2;
                GdMethodDeclTl gdMethodDeclTl = GdMethodUtil.INSTANCE.findMethod(parent, "_init");
                if (gdMethodDeclTl == null) {
                    return;
                }
                GdMethodDeclTl parentConstructor = gdMethodDeclTl;
                if (parentConstructor.getParameters().isEmpty()) {
                    return;
                }
                Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)method, GdCallEx.class);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
                Iterable iterable = collection;
                boolean $i$f$filter = false;
                void var8_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    GdCallEx it = (GdCallEx)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getExpr().getText(), (Object)"super")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List stmts = (List)destination$iv$iv;
                if (stmts.isEmpty()) {
                    ProblemsHolderExtension.registerGenericError$default(ProblemsHolderExtension.INSTANCE, this.$holder, (PsiElement)methodId, "Initializing super() constructor is required", null, 4, null);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final String determineCommonType(Set<String> types) {
                if (types.isEmpty()) {
                    return null;
                }
                if (types.size() == 1) {
                    return (String)CollectionsKt.first((Iterable)types);
                }
                for (String type : types) {
                    boolean bl;
                    block6: {
                        void $this$all$iv;
                        Iterable iterable = types;
                        ProblemsHolder problemsHolder = this.$holder;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                String it = (String)element$iv;
                                boolean bl2 = false;
                                Project project = problemsHolder.getProject();
                                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                                if (GdExprUtil.INSTANCE.typeAccepts(it, type, project)) continue;
                                bl = false;
                                break block6;
                            }
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    return type;
                }
                return null;
            }

            private final void validateParentType(GdMethodIdNmi methodId, GdReturnHintVal hint, String returnType) {
                Project project = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                GdMethodDeclTl gdMethodDeclTl = GdMethodUtil.INSTANCE.findParentMethodRecursive(methodId, project);
                if (gdMethodDeclTl == null) {
                    return;
                }
                GdMethodDeclTl parent = gdMethodDeclTl;
                String string = parent.getReturnType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getReturnType(...)");
                Project project2 = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                if (!GdExprUtil.INSTANCE.typeAccepts(returnType, string, project2)) {
                    GdChangeReturnTypeFix gdChangeReturnTypeFix;
                    ProblemsHolderExtension problemsHolderExtension = ProblemsHolderExtension.INSTANCE;
                    ProblemsHolder problemsHolder = this.$holder;
                    PsiElement psiElement = (PsiElement)methodId;
                    String string2 = "Return type [" + returnType + "] does not match parent's [" + parent.getReturnType() + "]";
                    GdReturnHintVal gdReturnHintVal = hint;
                    if (gdReturnHintVal != null) {
                        GdReturnHintVal gdReturnHintVal2 = gdReturnHintVal;
                        String string3 = string2;
                        PsiElement psiElement2 = psiElement;
                        ProblemsHolder problemsHolder2 = problemsHolder;
                        ProblemsHolderExtension problemsHolderExtension2 = problemsHolderExtension;
                        boolean bl = false;
                        String string4 = parent.getReturnType();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getReturnType(...)");
                        GdChangeReturnTypeFix gdChangeReturnTypeFix2 = new GdChangeReturnTypeFix(hint, string4);
                        problemsHolderExtension = problemsHolderExtension2;
                        problemsHolder = problemsHolder2;
                        psiElement = psiElement2;
                        string2 = string3;
                        gdChangeReturnTypeFix = gdChangeReturnTypeFix2;
                    } else {
                        gdChangeReturnTypeFix = null;
                    }
                    problemsHolderExtension.registerWeakWarning(problemsHolder, psiElement, string2, (LocalQuickFix)gdChangeReturnTypeFix);
                }
            }
        };
    }
}

