/*
 * Decompiled with CFR 0.152.
 */
package gdscript.index.impl;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtil;
import common.index.StringStubIndexExtensionExt;
import gdscript.index.Indices;
import gdscript.index.impl.GdClassNamingIndex;
import gdscript.index.impl.GdFileResIndex;
import gdscript.psi.GdClassNameNmi;
import gdscript.psi.GdClassNaming;
import gdscript.psi.utils.PsiGdResourceUtil;
import gdscript.utils.VirtualFileUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lgdscript/index/impl/GdClassIdIndex;", "Lcommon/index/StringStubIndexExtensionExt;", "Lgdscript/psi/GdClassNameNmi;", "<init>", "()V", "getKey", "Lcom/intellij/psi/stubs/StubIndexKey;", "", "getVersion", "", "getGloballyResolved", "", "name", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.rider.plugins.godot.gdscript"})
public final class GdClassIdIndex
extends StringStubIndexExtensionExt<GdClassNameNmi> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final GdClassIdIndex INSTANCE = new GdClassIdIndex();

    @NotNull
    public StubIndexKey<String, GdClassNameNmi> getKey() {
        return Indices.INSTANCE.getCLASS_NAME_ID();
    }

    public int getVersion() {
        return Indices.INSTANCE.getVERSION();
    }

    @NotNull
    public final Collection<GdClassNameNmi> getGloballyResolved(@NotNull String name, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (DumbService.Companion.isDumb(project)) {
            return CollectionsKt.emptyList();
        }
        Collection fqn = this.get(name, project, GlobalSearchScope.allScope((Project)project));
        Intrinsics.checkNotNull((Object)fqn);
        if (!fqn.isEmpty()) {
            return fqn;
        }
        Object modified = null;
        if (StringsKt.startsWith$default((CharSequence)name, (char)'\"', (boolean)false, (int)2, null)) {
            int endIndex = StringsKt.indexOf$default((CharSequence)name, (char)'\"', (int)1, (boolean)false, (int)4, null);
            String string = name.substring(1, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String resource = string;
            VirtualFile virtualFile = (VirtualFile)CollectionsKt.firstOrNull((Iterable)GdFileResIndex.Companion.getFiles(resource, project));
            if (virtualFile == null) {
                return CollectionsKt.emptyList();
            }
            VirtualFile resourceFile = virtualFile;
            PsiFile psiFile = VirtualFileUtil.INSTANCE.getPsiFile(resourceFile, project);
            GdClassNaming gdClassNaming = (GdClassNaming)PsiTreeUtil.getStubChildOfType((PsiElement)((PsiElement)psiFile), GdClassNaming.class);
            Object object = gdClassNaming != null ? gdClassNaming.getClassname() : null;
            if (object == null) {
                object = modified = "";
            }
            if (name.length() > endIndex + 1) {
                String string2 = name.substring(endIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                modified = (String)modified + string2;
            }
        } else {
            char[] resource = new char[]{'.'};
            List classes = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)name, (char[])resource, (boolean)false, (int)0, (int)6, null));
            String string = (String)CollectionsKt.firstOrNull((List)classes);
            if (string == null) {
                return CollectionsKt.emptyList();
            }
            String rootClass = string;
            GdClassNaming gdClassNaming = (GdClassNaming)CollectionsKt.firstOrNull((Iterable)GdClassNamingIndex.Companion.getINSTANCE().getGlobally(rootClass, project));
            if (gdClassNaming == null) {
                return CollectionsKt.emptyList();
            }
            GdClassNaming cln = gdClassNaming;
            VirtualFile virtualFile = cln.getContainingFile().getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            String resource2 = PsiGdResourceUtil.resourcePath$default(PsiGdResourceUtil.INSTANCE, virtualFile, false, 2, null);
            classes.set(0, "\"" + resource2 + "\"");
            modified = CollectionsKt.joinToString$default((Iterable)classes, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        }
        Collection collection = this.get(modified, project, GlobalSearchScope.allScope((Project)project));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        return collection;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgdscript/index/impl/GdClassIdIndex$Companion;", "", "<init>", "()V", "INSTANCE", "Lgdscript/index/impl/GdClassIdIndex;", "getINSTANCE", "()Lgdscript/index/impl/GdClassIdIndex;", "intellij.rider.plugins.godot.gdscript"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GdClassIdIndex getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

