/*
 * Decompiled with CFR 0.152.
 */
package gdscript.formatter.block;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import gdscript.formatter.GdCodeStyleSettings;
import gdscript.formatter.block.Alignments;
import gdscript.formatter.block.GdBlocks;
import gdscript.psi.GdAnnotationTl;
import gdscript.psi.GdClassVarDeclTl;
import gdscript.psi.GdTypes;
import gdscript.psi.utils.PsiGdClassVarUtil;
import gdscript.utils.GdSettingsUtil;
import gdscript.utils.PsiElementUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001BE\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0014J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u001c\u0010\u0017\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010\"2\u0006\u0010)\u001a\u00020\"H\u0016J\b\u0010*\u001a\u00020\rH\u0016J\b\u0010+\u001a\u00020,H\u0016J\u001a\u0010-\u001a\u0004\u0018\u00010'2\u0006\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0000H\u0002J\u001e\u00100\u001a\u0004\u0018\u00010'2\b\u0010.\u001a\u0004\u0018\u00010\u00002\b\u0010/\u001a\u0004\u0018\u00010\u0000H\u0002J\u0010\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0000H\u0002J\u0010\u00103\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0000H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u00064"}, d2={"Lgdscript/formatter/block/GdBlock;", "Lcom/intellij/psi/formatter/common/AbstractBlock;", "node", "Lcom/intellij/lang/ASTNode;", "wrap", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "spacing", "Lcom/intellij/formatting/SpacingBuilder;", "indent", "Lcom/intellij/formatting/Indent;", "alignments", "Lgdscript/formatter/block/Alignments;", "<init>", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/formatting/Wrap;Lcom/intellij/formatting/Alignment;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/formatting/SpacingBuilder;Lcom/intellij/formatting/Indent;Lgdscript/formatter/block/Alignments;)V", "getSettings", "()Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "myIndent", "getMyIndent", "()Lcom/intellij/formatting/Indent;", "getSpacing", "()Lcom/intellij/formatting/SpacingBuilder;", "getAlignments", "()Lgdscript/formatter/block/Alignments;", "nextBlock", "getNextBlock", "()Lgdscript/formatter/block/GdBlock;", "setNextBlock", "(Lgdscript/formatter/block/GdBlock;)V", "buildChildren", "", "Lcom/intellij/formatting/Block;", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "", "Lcom/intellij/formatting/Spacing;", "child1", "child2", "getIndent", "isLeaf", "", "separateMultilineVars", "block1", "block2", "splitByAnnotation", "functionAnnotation", "block", "varAnnotation", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nGdBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdBlock.kt\ngdscript/formatter/block/GdBlock\n+ 2 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n91#2,5:298\n1#3:303\n*S KotlinDebug\n*F\n+ 1 GdBlock.kt\ngdscript/formatter/block/GdBlock\n*L\n74#1:298,5\n*E\n"})
public final class GdBlock
extends AbstractBlock {
    @NotNull
    private final CodeStyleSettings settings;
    @NotNull
    private final Indent myIndent;
    @NotNull
    private final SpacingBuilder spacing;
    @NotNull
    private final Alignments alignments;
    @Nullable
    private GdBlock nextBlock;

    @NotNull
    public final CodeStyleSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final Indent getMyIndent() {
        return this.myIndent;
    }

    @NotNull
    public final SpacingBuilder getSpacing() {
        return this.spacing;
    }

    @NotNull
    public final Alignments getAlignments() {
        return this.alignments;
    }

    @Nullable
    public final GdBlock getNextBlock() {
        return this.nextBlock;
    }

    public final void setNextBlock(@Nullable GdBlock gdBlock) {
        this.nextBlock = gdBlock;
    }

    public GdBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, @NotNull CodeStyleSettings settings, @NotNull SpacingBuilder spacing, @NotNull Indent indent, @NotNull Alignments alignments) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        Intrinsics.checkNotNullParameter((Object)alignments, (String)"alignments");
        super(node, wrap, alignment);
        this.settings = settings;
        this.spacing = spacing;
        this.myIndent = indent;
        this.alignments = alignments;
    }

    @NotNull
    protected List<Block> buildChildren() {
        List blocks = new ArrayList();
        ASTNode[] aSTNodeArray = this.getNode().getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        List children = ArraysKt.toMutableList((Object[])aSTNodeArray);
        boolean suited = false;
        boolean indented = false;
        GdBlock lastBlock = null;
        boolean rootPosition = this.getNode() instanceof FileElement;
        while (!children.isEmpty()) {
            boolean toIndent;
            IElementType type;
            Object object = CollectionsKt.removeFirstOrNull((List)children);
            Intrinsics.checkNotNull((Object)object);
            ASTNode child = (ASTNode)object;
            Intrinsics.checkNotNullExpressionValue((Object)child.getElementType(), (String)"getElementType(...)");
            if (suited || rootPosition) {
                this.alignments.reset(type, rootPosition ? 1 : 2);
            }
            if (ArraysKt.contains((Object[])GdBlocks.INSTANCE.getDEDENT_TOKENS(), (Object)type)) {
                indented = false;
            }
            if (ArraysKt.contains((Object[])GdBlocks.INSTANCE.getEMPTY_TOKENS(), (Object)type)) {
                if (!Intrinsics.areEqual((Object)type, (Object)GdTypes.INDENT)) continue;
                indented = true;
                continue;
            }
            if (ArraysKt.contains((Object[])GdBlocks.INSTANCE.getSKIP_TOKENS(), (Object)type)) {
                if (Intrinsics.areEqual((Object)type, (Object)GdTypes.SUITE)) {
                    suited = true;
                    this.alignments.initialize();
                }
                ASTNode[] aSTNodeArray2 = child.getChildren(null);
                Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray2, (String)"getChildren(...)");
                Object[] $this$forEachReversed$iv = aSTNodeArray2;
                boolean $i$f$forEachReversed = false;
                int i$iv = $this$forEachReversed$iv.length;
                while (i$iv > 0) {
                    ASTNode it = (ASTNode)$this$forEachReversed$iv[--i$iv];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    children.add(0, it);
                }
                continue;
            }
            boolean bl = toIndent = indented || ArraysKt.contains((Object[])GdBlocks.INSTANCE.getALWAYS_INDENTED_TOKENS(), (Object)type);
            if (!toIndent && Intrinsics.areEqual((Object)type, (Object)GdTypes.COMMENT)) {
                PsiElement psiElement = child.getPsi();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
                if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)PsiElementUtil.INSTANCE.nextNonWhiteCommentToken(psiElement)), (Object)GdTypes.INDENT)) {
                    toIndent = true;
                }
            }
            Alignment alignment = this.alignments.getAlignment(type);
            Indent indent = toIndent ? Indent.getNormalIndent() : Indent.getNoneIndent();
            Intrinsics.checkNotNull((Object)indent);
            GdBlock currentBlock = new GdBlock(child, null, alignment, this.settings, this.spacing, indent, this.alignments.clone(type));
            if (lastBlock != null) {
                lastBlock.nextBlock = currentBlock;
            }
            blocks.add(currentBlock);
            lastBlock = currentBlock;
        }
        return blocks;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        int precedingOffset;
        Indent.Type type;
        int index = newChildIndex - 1;
        Block previousBlock = index >= 0 ? (Block)this.getSubBlocks().get(index) : null;
        PsiElement preceding = previousBlock instanceof GdBlock ? ((GdBlock)previousBlock).getNode().getPsi() : null;
        boolean atEndOfStmt = this.getNode() instanceof FileElement;
        Block block = previousBlock;
        Indent.Type type2 = block != null && (block = block.getIndent()) != null ? block.getType() : (type = null);
        int n = Intrinsics.areEqual((Object)type, (Object)Indent.Type.NORMAL) ? 2 : (precedingOffset = Intrinsics.areEqual((Object)type, (Object)Indent.Type.CONTINUATION) ? 3 : 0);
        if (previousBlock instanceof GdBlock) {
            PsiElement lastNode = PsiTreeUtil.getDeepestVisibleLast((PsiElement)((GdBlock)previousBlock).getNode().getPsi());
            Object[] objectArray = new IElementType[]{GdTypes.COLON};
            PsiElement psiElement = lastNode;
            if (ArraysKt.contains((Object[])objectArray, (Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null))) {
                if (precedingOffset > 0) {
                    if (preceding != null) {
                        return new ChildAttributes(GdSettingsUtil.calculateSpaceIndents$default(GdSettingsUtil.INSTANCE, this.settings, preceding, 0, false, 6, null), null);
                    }
                    return new ChildAttributes(Indent.getContinuationIndent((boolean)false), null);
                }
                return new ChildAttributes(Indent.getNormalIndent((boolean)false), null);
            }
        }
        PsiElement psiElement = this.getNode().getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
        Integer caretOffset = PsiElementUtil.INSTANCE.getCaretOffsetIfSingle(psiElement);
        if (previousBlock instanceof GdBlock && preceding != null) {
            ASTNode aSTNode;
            ASTNode aSTNode2 = ((GdBlock)previousBlock).getNode().getLastChildNode();
            if (Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)GdTypes.STMT_OR_SUITE) && Intrinsics.areEqual((Object)((aSTNode = ((GdBlock)previousBlock).getNode().getLastChildNode()) != null && (aSTNode = aSTNode.getFirstChildNode()) != null ? aSTNode.getElementType() : null), (Object)GdTypes.SUITE)) {
                if (caretOffset != null) {
                    PsiElement psiElement2 = PsiTreeUtil.getDeepestLast((PsiElement)preceding);
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getDeepestLast(...)");
                    int emptyLines = PsiElementUtil.INSTANCE.precedingNewLines(psiElement2, caretOffset);
                    if (emptyLines > 2) {
                        return new ChildAttributes(GdSettingsUtil.calculateSpaceIndents$default(GdSettingsUtil.INSTANCE, this.settings, preceding, 2 - emptyLines - precedingOffset, false, 4, null), null);
                    }
                }
                if (atEndOfStmt) {
                    return new ChildAttributes(GdSettingsUtil.calculateSpaceIndents$default(GdSettingsUtil.INSTANCE, this.settings, preceding, 0, false, 6, null), null);
                }
                return new ChildAttributes(Indent.getContinuationIndent((boolean)false), null);
            }
        }
        if (Intrinsics.areEqual((Object)this.getNode().getElementType(), (Object)GdTypes.CALL_EX)) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
        if (ArraysKt.contains((Object[])GdBlocks.INSTANCE.getINDENT_CHILDREN_ATTRIBUTE(), (Object)this.getNode().getElementType())) {
            if (caretOffset != null) {
                PsiElement psiElement3 = PsiTreeUtil.getDeepestLast((PsiElement)this.getNode().getPsi());
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getDeepestLast(...)");
                int emptyLines = PsiElementUtil.INSTANCE.precedingNewLines(psiElement3, caretOffset);
                if (emptyLines > 2) {
                    PsiElement psiElement4 = this.getNode().getPsi();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getPsi(...)");
                    return new ChildAttributes(GdSettingsUtil.calculateSpaceIndents$default(GdSettingsUtil.INSTANCE, this.settings, psiElement4, 2 - emptyLines - precedingOffset, false, 4, null), null);
                }
                return new ChildAttributes(Indent.getNormalIndent(), null);
            }
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
        return new ChildAttributes(Indent.getNoneIndent(), null);
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        if (child1 == null || !(child1 instanceof GdBlock) || !(child2 instanceof GdBlock)) {
            return this.spacing.getSpacing((Block)this, child1, child2);
        }
        if (Intrinsics.areEqual((Object)((GdBlock)child1).getNode().getElementType(), (Object)GdTypes.COMMENT)) {
            return null;
        }
        GdBlock block2 = (GdBlock)child2;
        while (block2 != null && Intrinsics.areEqual((Object)block2.getNode().getElementType(), (Object)GdTypes.COMMENT)) {
            block2 = block2.nextBlock;
        }
        if (block2 == null) {
            return null;
        }
        Spacing spacing = this.separateMultilineVars((GdBlock)child1, block2 = this.functionAnnotation(block2));
        if (spacing != null) {
            Spacing it = spacing;
            boolean bl = false;
            return it;
        }
        spacing = this.splitByAnnotation((GdBlock)child1, block2);
        if (spacing != null) {
            Spacing it = spacing;
            boolean bl = false;
            return it;
        }
        if (Intrinsics.areEqual((Object)((GdBlock)child1).getNode().getElementType(), (Object)GdTypes.CLASS_VAR_DECL_TL) && Intrinsics.areEqual((Object)block2.getNode().getElementType(), (Object)GdTypes.CLASS_VAR_DECL_TL)) {
            PsiElement psiElement = ((GdBlock)child1).getNode().getPsi();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type gdscript.psi.GdClassVarDeclTl");
            if (PsiGdClassVarUtil.INSTANCE.isAnnotated((GdClassVarDeclTl)psiElement)) {
                CustomCodeStyleSettings customCodeStyleSettings = this.settings.getCustomSettings(GdCodeStyleSettings.class);
                Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
                GdCodeStyleSettings customSettings = (GdCodeStyleSettings)customCodeStyleSettings;
                return Spacing.createSpacing((int)0, (int)0, (int)(customSettings.LINES_BETWEEN_EXPORT_GROUPS + 1), (boolean)false, (int)0);
            }
        }
        return this.spacing.getSpacing((Block)this, child1, (Block)block2);
    }

    @NotNull
    public Indent getIndent() {
        return this.myIndent;
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    private final Spacing separateMultilineVars(GdBlock block1, GdBlock block2) {
        if (Intrinsics.areEqual((Object)block1.getNode().getElementType(), (Object)GdTypes.CLASS_VAR_DECL_TL)) {
            String string = block1.getNode().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.contains$default((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString(), (char)'\n', (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)block2.getNode().getElementType(), (Object)GdTypes.METHOD_DECL_TL)) {
                int lines = ((GdCodeStyleSettings)this.settings.getCustomSettings(GdCodeStyleSettings.class)).LINES_AROUND_MULTILINE_VAR;
                return Spacing.createSpacing((int)0, (int)0, (int)(lines + 1), (boolean)false, (int)0);
            }
        }
        GdBlock block22 = this.varAnnotation(block2);
        if (!Intrinsics.areEqual((Object)block1.getNode().getElementType(), (Object)GdTypes.COMMENT) && !Intrinsics.areEqual((Object)block1.getNode().getElementType(), (Object)GdTypes.ANNOTATION_TL) && Intrinsics.areEqual((Object)block22.getNode().getElementType(), (Object)GdTypes.CLASS_VAR_DECL_TL)) {
            String string = block22.getNode().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.contains$default((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString(), (char)'\n', (boolean)false, (int)2, null)) {
                int lines = ((GdCodeStyleSettings)this.settings.getCustomSettings(GdCodeStyleSettings.class)).LINES_AROUND_MULTILINE_VAR;
                return Spacing.createSpacing((int)0, (int)0, (int)(lines + 1), (boolean)false, (int)0);
            }
        }
        return null;
    }

    private final Spacing splitByAnnotation(GdBlock block1, GdBlock block2) {
        if (block1 == null || block2 == null) {
            return null;
        }
        if (Intrinsics.areEqual((Object)block1.getNode().getElementType(), (Object)GdTypes.CLASS_VAR_DECL_TL) && Intrinsics.areEqual((Object)block2.getNode().getElementType(), (Object)GdTypes.ANNOTATION_TL)) {
            PsiElement psiElement = block1.getNode().getPsi();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type gdscript.psi.GdClassVarDeclTl");
            GdClassVarDeclTl node1 = (GdClassVarDeclTl)psiElement;
            PsiElement node2 = block2.getNode().getPsi();
            List annotations = new ArrayList();
            while (node2 instanceof GdAnnotationTl) {
                String string = ((GdAnnotationTl)node2).getAnnotationType().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                char[] objectArray = new char[]{'@'};
                annotations.add(StringsKt.trimStart((String)string, (char[])objectArray));
                node2 = PsiElementUtil.INSTANCE.nextNonWhiteCommentToken(node2);
            }
            for (String annotator : GdBlocks.INSTANCE.getSEPARATE_ANNOTATOR_GROUPS()) {
                if (!(PsiGdClassVarUtil.INSTANCE.isAnnotatedContains(node1, annotator) ^ annotations.contains(annotator))) continue;
                CustomCodeStyleSettings customCodeStyleSettings = this.settings.getCustomSettings(GdCodeStyleSettings.class);
                Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
                GdCodeStyleSettings customSettings = (GdCodeStyleSettings)customCodeStyleSettings;
                return Spacing.createSpacing((int)0, (int)0, (int)(customSettings.LINES_BETWEEN_EXPORT_GROUPS + 1), (boolean)false, (int)0);
            }
        }
        return null;
    }

    private final GdBlock functionAnnotation(GdBlock block) {
        GdBlock current = block;
        IElementType type = block.getNode().getElementType();
        boolean any = false;
        while (Intrinsics.areEqual((Object)type, (Object)GdTypes.ANNOTATION_TL)) {
            any = true;
            GdBlock gdBlock = current;
            current = gdBlock != null ? gdBlock.nextBlock : null;
            GdBlock gdBlock2 = current;
            type = gdBlock2 != null && (gdBlock2 = gdBlock2.getNode()) != null ? gdBlock2.getElementType() : null;
        }
        if (any && Intrinsics.areEqual((Object)type, (Object)GdTypes.METHOD_DECL_TL)) {
            GdBlock gdBlock = current;
            Intrinsics.checkNotNull((Object)((Object)gdBlock));
            return gdBlock;
        }
        return block;
    }

    private final GdBlock varAnnotation(GdBlock block) {
        GdBlock current = block;
        IElementType type = block.getNode().getElementType();
        boolean any = false;
        while (Intrinsics.areEqual((Object)type, (Object)GdTypes.ANNOTATION_TL)) {
            any = true;
            GdBlock gdBlock = current;
            current = gdBlock != null ? gdBlock.nextBlock : null;
            GdBlock gdBlock2 = current;
            type = gdBlock2 != null && (gdBlock2 = gdBlock2.getNode()) != null ? gdBlock2.getElementType() : null;
        }
        if (any && Intrinsics.areEqual((Object)type, (Object)GdTypes.CLASS_VAR_DECL_TL)) {
            GdBlock gdBlock = current;
            Intrinsics.checkNotNull((Object)((Object)gdBlock));
            return gdBlock;
        }
        return block;
    }
}

