/*
 * Decompiled with CFR 0.152.
 */
package gdscript.codeInsight.documentation;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.ColorUtil;
import com.jetbrains.rider.godot.community.gdscript.GdLanguage;
import gdscript.codeInsight.documentation.GdDocUtil;
import gdscript.psi.GdTypes;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lgdscript/codeInsight/documentation/GdDocCode;", "", "<init>", "()V", "createHighlightedSnippet", "", "Lcom/intellij/openapi/util/text/HtmlChunk;", "code", "", "project", "Lcom/intellij/openapi/project/Project;", "iterate", "highlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "buildStyle", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nGdDocCode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdDocCode.kt\ngdscript/codeInsight/documentation/GdDocCode\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,108:1\n382#2,7:109\n*S KotlinDebug\n*F\n+ 1 GdDocCode.kt\ngdscript/codeInsight/documentation/GdDocCode\n*L\n36#1:109,7\n*E\n"})
public final class GdDocCode {
    @NotNull
    public static final GdDocCode INSTANCE = new GdDocCode();

    private GdDocCode() {
    }

    @NotNull
    public final List<HtmlChunk> createHighlightedSnippet(@NotNull String code, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        PsiFile psi = PsiFileFactory.getInstance((Project)project).createFileFromText((Language)GdLanguage.INSTANCE, (CharSequence)code);
        EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((VirtualFile)psi.getVirtualFile(), (EditorColorsScheme)scheme, (Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"createHighlighter(...)");
        EditorHighlighter highlighter = editorHighlighter;
        return this.iterate(code, highlighter);
    }

    /*
     * WARNING - void declaration
     */
    private final List<HtmlChunk> iterate(String code, EditorHighlighter highlighter) {
        highlighter.setText((CharSequence)code);
        HighlighterIterator highlighterIterator = highlighter.createIterator(0);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        Map attributeCache = new LinkedHashMap();
        List spans = new ArrayList();
        Object[] objectArray = new IElementType[]{GdTypes.COLON, GdTypes.RET, GdTypes.EXTENDS};
        Object[] resolveAfter = objectArray;
        IElementType lastType = null;
        while (true) {
            HtmlChunk htmlChunk;
            Object object;
            void $this$getOrPut$iv;
            IElementType type = iterator.getTokenType();
            Map map = attributeCache;
            IElementType key$iv = type;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                TextAttributes textAttributes = iterator.getTextAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"getTextAttributes(...)");
                String answer$iv = INSTANCE.buildStyle(textAttributes);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            String style = (String)object;
            Intrinsics.checkNotNullExpressionValue((Object)code.substring(iterator.getStart(), iterator.getEnd()), (String)"substring(...)");
            if (Intrinsics.areEqual((Object)type, (Object)GdTypes.IDENTIFIER) && ArraysKt.contains((Object[])resolveAfter, lastType)) {
                htmlChunk = GdDocUtil.elementLink$default(GdDocUtil.INSTANCE, text, null, 2, null);
            } else {
                HtmlChunk htmlChunk2 = HtmlChunk.text((String)text);
                htmlChunk = htmlChunk2;
                Intrinsics.checkNotNullExpressionValue((Object)htmlChunk2, (String)"text(...)");
            }
            HtmlChunk block = htmlChunk;
            HtmlChunk.Element element = HtmlChunk.tag((String)"span").style(style).child(block);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"child(...)");
            spans.add(element);
            iterator.advance();
            if (iterator.atEnd()) break;
            if (Intrinsics.areEqual((Object)type, (Object)TokenType.WHITE_SPACE)) continue;
            lastType = type;
        }
        return spans;
    }

    private final String buildStyle(TextAttributes attributes) {
        Color background;
        Object style = "";
        Color foreground = attributes.getForegroundColor();
        if (foreground != null) {
            style = (String)style + "color: " + ColorUtil.toHtmlColor((Color)foreground) + ";";
        }
        if ((background = attributes.getBackgroundColor()) != null) {
            style = (String)style + "background-color: " + ColorUtil.toHtmlColor((Color)background) + ";";
        }
        return style;
    }
}

