/*
 * Decompiled with CFR 0.152.
 */
package gdscript.codeInsight.documentation;

import com.intellij.lang.documentation.DocumentationMarkup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import gdscript.codeInsight.documentation.GdDocCode;
import gdscript.codeInsight.documentation.GdDocUtil;
import gdscript.psi.utils.GdClassUtil;
import gdscript.utils.VirtualFileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001f\u0010\u0012\u001a\u00020\u00002\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0014\"\u00020\u000b\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u000eJ\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u001a\u001a\u00020\u000eH\u0016J\u001e\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u0002J\u001e\u0010\u0019\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lgdscript/codeInsight/documentation/GdDocBuilder;", "", "<init>", "()V", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "owner", "Lcom/intellij/openapi/util/text/HtmlChunk;", "packaged", "preview", "", "bodyBlocks", "", "withOwner", "addBodyBlock", "chunks", "", "([Lcom/intellij/openapi/util/text/HtmlChunk;)Lgdscript/codeInsight/documentation/GdDocBuilder;", "withPackage", "path", "withPreview", "code", "toString", "line", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nGdDocBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdDocBuilder.kt\ngdscript/codeInsight/documentation/GdDocBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1878#2,3:101\n1869#2,2:104\n*S KotlinDebug\n*F\n+ 1 GdDocBuilder.kt\ngdscript/codeInsight/documentation/GdDocBuilder\n*L\n56#1:101,3\n79#1:104,2\n*E\n"})
public final class GdDocBuilder {
    @Nullable
    private Project project;
    @Nullable
    private HtmlChunk owner;
    @Nullable
    private HtmlChunk packaged;
    @Nullable
    private String preview;
    @NotNull
    private List<HtmlChunk> bodyBlocks;

    public GdDocBuilder() {
        this.bodyBlocks = new ArrayList();
    }

    public GdDocBuilder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.bodyBlocks = new ArrayList();
        this.project = project;
    }

    public GdDocBuilder(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.bodyBlocks = new ArrayList();
        this.project = element.getProject();
    }

    @NotNull
    public final GdDocBuilder withOwner(@Nullable PsiElement element) {
        if (element == null) {
            return this;
        }
        List<HtmlChunk> body = GdDocUtil.INSTANCE.iconed("AllIcons.Nodes.Class");
        String link = GdClassUtil.INSTANCE.getFullClassId(element);
        body.add(GdDocUtil.INSTANCE.elementLink(link, GdClassUtil.INSTANCE.getOwningClassName(element)));
        this.owner = (HtmlChunk)HtmlChunk.div().children(body);
        return this;
    }

    @NotNull
    public final GdDocBuilder addBodyBlock(HtmlChunk ... chunks) {
        Intrinsics.checkNotNullParameter((Object)chunks, (String)"chunks");
        CollectionsKt.addAll((Collection)this.bodyBlocks, (Object[])chunks);
        return this;
    }

    @NotNull
    public final GdDocBuilder withPackage(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PsiFile) {
            VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            return this.withPackage(VirtualFileUtil.INSTANCE.localParentPath(virtualFile));
        }
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return this.withPackage(VirtualFileUtil.INSTANCE.localParentPath(virtualFile));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GdDocBuilder withPackage(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        List<HtmlChunk> body = GdDocUtil.INSTANCE.iconed("AllIcons.Nodes.Package");
        Object currentPath = null;
        currentPath = "";
        String[] stringArray = new String[]{"/"};
        Iterable $this$forEachIndexed$iv = StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void s;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            currentPath = currentPath + "/" + (String)s;
            if (index == 0) {
                char[] cArray = new char[]{'/'};
                currentPath = StringsKt.trimStart((String)currentPath, (char[])cArray);
            } else {
                HtmlChunk htmlChunk = HtmlChunk.text((String)"/");
                Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"text(...)");
                body.add(htmlChunk);
            }
            body.add(GdDocUtil.INSTANCE.packageLink((String)currentPath, (String)s));
        }
        this.packaged = (HtmlChunk)HtmlChunk.div().children(body);
        return this;
    }

    @NotNull
    public final GdDocBuilder withPreview(@Nullable String code) {
        if (code == null) {
            return this;
        }
        this.preview = code;
        return this;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.line(sb, this.owner);
        this.code(sb, this.preview);
        Iterable $this$forEach$iv = this.bodyBlocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HtmlChunk it = (HtmlChunk)element$iv;
            boolean bl = false;
            sb.append(it);
        }
        this.line(sb, this.packaged);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void line(StringBuilder sb, Object element) {
        if (element == null) {
            return;
        }
        sb.append("<div class='content'>");
        sb.append(element);
        sb.append("</div>");
    }

    private final void code(StringBuilder sb, Object element) {
        if (element == null || this.project == null) {
            return;
        }
        HtmlChunk.Element element2 = HtmlChunk.tag((String)"pre");
        String string = element.toString();
        Project project = this.project;
        Intrinsics.checkNotNull((Object)project);
        sb.append(element2.children(GdDocCode.INSTANCE.createHighlightedSnippet(string, project)).wrapWith(DocumentationMarkup.DEFINITION_ELEMENT));
    }
}

