/*
 * Decompiled with CFR 0.152.
 */
package gdscript.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import gdscript.model.GdAnnotation;
import gdscript.psi.GdAnnotationTl;
import gdscript.psi.GdArgList;
import gdscript.psi.GdCallEx;
import gdscript.psi.GdClassNaming;
import gdscript.psi.GdFuncDeclEx;
import gdscript.psi.GdMethodDeclTl;
import gdscript.psi.GdRefIdRef;
import gdscript.psi.GdTypes;
import gdscript.psi.GdVarDeclSt;
import gdscript.psi.utils.GdClassMemberUtil;
import gdscript.utils.GdAnnotationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\u0015H\u0002\u00a8\u0006\u0018"}, d2={"Lgdscript/codeInsight/GdParameterInfoHandler;", "Lcom/intellij/lang/parameterInfo/ParameterInfoHandler;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "findElementForParameterInfo", "context", "Lcom/intellij/lang/parameterInfo/CreateParameterInfoContext;", "findElementForUpdatingParameterInfo", "Lcom/intellij/lang/parameterInfo/UpdateParameterInfoContext;", "updateUI", "", "declaration", "Lcom/intellij/lang/parameterInfo/ParameterInfoUIContext;", "updateParameterInfo", "parameterOwner", "showParameterInfo", "element", "getFunctionCall", "Lgdscript/psi/GdCallEx;", "Lcom/intellij/lang/parameterInfo/ParameterInfoContext;", "getAnnotation", "Lgdscript/psi/GdAnnotationTl;", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nGdParameterInfoHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdParameterInfoHandler.kt\ngdscript/codeInsight/GdParameterInfoHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,163:1\n774#2:164\n865#2,2:165\n37#3,2:167\n216#4,2:169\n*S KotlinDebug\n*F\n+ 1 GdParameterInfoHandler.kt\ngdscript/codeInsight/GdParameterInfoHandler\n*L\n32#1:164\n32#1:165,2\n34#1:167,2\n108#1:169,2\n*E\n"})
public final class GdParameterInfoHandler
implements ParameterInfoHandler<PsiElement, PsiElement>,
DumbAware {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public PsiElement findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        GdCallEx element = this.getFunctionCall((ParameterInfoContext)context);
        if (element != null) {
            Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)element.getExpr(), GdRefIdRef.class);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
            GdRefIdRef gdRefIdRef = (GdRefIdRef)CollectionsKt.lastOrNull((Iterable)collection);
            if (gdRefIdRef == null) {
                return null;
            }
            GdRefIdRef refId = gdRefIdRef;
            Object declaration = GdClassMemberUtil.findDeclaration$default(GdClassMemberUtil.INSTANCE, refId, false, false, false, 14, null);
            if (declaration instanceof GdMethodDeclTl) {
                Object[] objectArray = new GdMethodDeclTl[]{declaration};
                context.setItemsToShow(objectArray);
            } else if (declaration instanceof GdVarDeclSt) {
                if (((GdVarDeclSt)declaration).getExpr() instanceof GdFuncDeclEx) {
                    Object[] objectArray = new GdFuncDeclEx[1];
                    Intrinsics.checkNotNull((Object)((GdVarDeclSt)declaration).getExpr(), (String)"null cannot be cast to non-null type gdscript.psi.GdFuncDeclEx");
                    context.setItemsToShow(objectArray);
                }
            } else if (declaration instanceof GdClassNaming) {
                void $this$toTypedArray$iv;
                void $this$filterTo$iv$iv;
                Collection $this$filter$iv;
                List list = PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)((PsiElement)((GdClassNaming)declaration).getContainingFile()), GdMethodDeclTl.class);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStubChildrenOfTypeAsList(...)");
                List methods = list;
                Iterable iterable = methods;
                CreateParameterInfoContext createParameterInfoContext = context;
                boolean $i$f$filter = false;
                void var8_13 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    GdMethodDeclTl it = (GdMethodDeclTl)element$iv$iv;
                    boolean bl = false;
                    if (!it.isConstructor()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                createParameterInfoContext.setItemsToShow((Object[])thisCollection$iv.toArray(new GdMethodDeclTl[0]));
            }
            return element;
        }
        GdAnnotationTl gdAnnotationTl = this.getAnnotation((ParameterInfoContext)context);
        if (gdAnnotationTl == null) {
            return null;
        }
        GdAnnotationTl annotation = gdAnnotationTl;
        Object[] objectArray = new GdAnnotationTl[]{annotation};
        context.setItemsToShow(objectArray);
        return annotation;
    }

    @Nullable
    public PsiElement findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        int n;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        GdCallEx gdCallEx = this.getFunctionCall((ParameterInfoContext)context);
        if (gdCallEx != null) {
            psiElement = gdCallEx;
        } else {
            GdAnnotationTl gdAnnotationTl = this.getAnnotation((ParameterInfoContext)context);
            if (gdAnnotationTl != null) {
                psiElement = gdAnnotationTl;
            } else {
                return null;
            }
        }
        PsiElement element = psiElement;
        int offset = context.getOffset();
        TextRange textRange = element.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        TextRange elRange = textRange;
        if (offset <= elRange.getStartOffset() || offset >= elRange.getEndOffset()) {
            n = -1;
        } else {
            Object object;
            PsiElement psiElement2 = element;
            if (psiElement2 instanceof GdCallEx) {
                object = ((GdCallEx)element).getArgList();
                if (object == null || (object = object.getNode()) == null) {
                    object = ((GdCallEx)element).getNode();
                }
            } else if (psiElement2 instanceof GdAnnotationTl) {
                object = ((GdAnnotationTl)element).getAnnotationParams();
                if (object == null || (object = object.getNode()) == null) {
                    object = ((GdAnnotationTl)element).getNode();
                }
            } else {
                object = null;
            }
            if (object == null) {
                return null;
            }
            GdArgList argumentNode = object;
            n = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)argumentNode, (int)offset, (IElementType)GdTypes.COMMA);
        }
        int index = n;
        context.setCurrentParameter(index);
        return element;
    }

    public void updateUI(@Nullable PsiElement declaration, @NotNull ParameterInfoUIContext context) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int currentParam = context.getCurrentParameterIndex();
        int startOffset = 0;
        startOffset = -1;
        int endOffset = 0;
        endOffset = -1;
        boolean fullSignature = CodeInsightSettings.getInstance().SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO;
        boolean isVariadic = false;
        StringBuilder builder2 = new StringBuilder();
        Object ending = "";
        PsiElement psiElement = declaration;
        if (psiElement instanceof GdMethodDeclTl) {
            if (fullSignature) {
                builder2.append("func " + ((GdMethodDeclTl)declaration).getName() + "(");
                ending = ")";
                String string = ((GdMethodDeclTl)declaration).getReturnType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getReturnType(...)");
                if (!StringsKt.isBlank((CharSequence)string)) {
                    ending = (String)ending + " -> " + ((GdMethodDeclTl)declaration).getReturnType();
                }
            }
            isVariadic = ((GdMethodDeclTl)declaration).isVariadic();
            var12_12 = ((GdMethodDeclTl)declaration).getParameters();
            Intrinsics.checkNotNull(var12_12);
            map = var12_12;
        } else if (psiElement instanceof GdFuncDeclEx) {
            if (fullSignature) {
                Object object = ((GdFuncDeclEx)declaration).getFuncDeclIdNmi();
                if (object == null || (object = object.getText()) == null) {
                    object = "";
                }
                builder2.append("func " + (String)object + "(");
                ending = ")";
                String string = ((GdFuncDeclEx)declaration).getReturnType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getReturnType(...)");
                if (!StringsKt.isBlank((CharSequence)string)) {
                    ending = (String)ending + " -> " + ((GdFuncDeclEx)declaration).getReturnType();
                }
            }
            var12_12 = ((GdFuncDeclEx)declaration).getParameters();
            Intrinsics.checkNotNull(var12_12);
            map = var12_12;
        } else if (psiElement instanceof GdAnnotationTl) {
            GdAnnotation specification = GdAnnotationUtil.INSTANCE.get((GdAnnotationTl)declaration);
            if (fullSignature) {
                builder2.append(((GdAnnotationTl)declaration).getAnnotationType().getText() + "(");
                ending = ")";
            }
            GdAnnotation gdAnnotation = specification;
            isVariadic = gdAnnotation != null ? gdAnnotation.getVariadic() : false;
            Object object = specification;
            map = object != null && (object = ((GdAnnotation)object).getParameters()) != null ? (Map)object : MapsKt.emptyMap();
        } else {
            map = MapsKt.emptyMap();
        }
        Map parameters = map;
        int i = 0;
        Map $this$forEach$iv = parameters;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            if (i > 0) {
                builder2.append(", ");
            }
            int start = builder2.length();
            builder2.append(it.getKey() + ": " + it.getValue());
            if (currentParam == i) {
                startOffset = start;
                endOffset = builder2.length();
            }
            ++i;
        }
        if (i <= 0) {
            if (isVariadic) {
                int n = 0;
                while (n < currentParam) {
                    int it = n++;
                    boolean bl = false;
                    builder2.append(it + ", ");
                }
                v6 = builder2.append("vararg");
            } else {
                v6 = builder2.append("no parameters");
            }
        }
        builder2.append((String)ending);
        context.setupUIComponentPresentation(builder2.toString(), startOffset, endOffset, false, false, false, context.getDefaultParameterColor());
    }

    public void updateParameterInfo(@NotNull PsiElement parameterOwner, @NotNull UpdateParameterInfoContext context) {
        Intrinsics.checkNotNullParameter((Object)parameterOwner, (String)"parameterOwner");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.setParameterOwner(parameterOwner);
    }

    public void showParameterInfo(@NotNull PsiElement element, @NotNull CreateParameterInfoContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.showHint(element, element.getTextRange().getStartOffset() + 1, (ParameterInfoHandler)this);
    }

    private final GdCallEx getFunctionCall(ParameterInfoContext context) {
        PsiElement psiElement = context.getFile().findElementAt(context.getOffset());
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        return (GdCallEx)PsiTreeUtil.getParentOfType((PsiElement)element, GdCallEx.class);
    }

    private final GdAnnotationTl getAnnotation(ParameterInfoContext context) {
        PsiElement psiElement = context.getFile().findElementAt(context.getOffset());
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        return (GdAnnotationTl)PsiTreeUtil.getParentOfType((PsiElement)element, GdAnnotationTl.class);
    }
}

