/*
 * Decompiled with CFR 0.152.
 */
package gdscript.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import gdscript.GdKeywords;
import gdscript.annotator.AnnotationHolderExKt;
import gdscript.highlighter.GdHighlighterColors;
import gdscript.psi.GdTypeHint;
import gdscript.psi.GdTypeHintRef;
import gdscript.utils.PsiFileUtil;
import gdscript.utils.PsiReferenceUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lgdscript/annotator/GdTypeHintAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "invalidType", "", "Lgdscript/psi/GdTypeHintRef;", "colorTypeHints", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nGdTypeHintAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdTypeHintAnnotator.kt\ngdscript/annotator/GdTypeHintAnnotator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1869#2,2:58\n*S KotlinDebug\n*F\n+ 1 GdTypeHintAnnotator.kt\ngdscript/annotator/GdTypeHintAnnotator\n*L\n32#1:58,2\n*E\n"})
public final class GdTypeHintAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof GdTypeHint)) {
            return;
        }
        List<GdTypeHintRef> list = ((GdTypeHint)element).getTypeHintNmList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeHintNmList(...)");
        List<GdTypeHintRef> typeHints = list;
        Object object = CollectionsKt.last(typeHints);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
        if (this.invalidType((GdTypeHintRef)object)) {
            Project project = ((GdTypeHint)element).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"ERROR");
            AnnotationHolderExKt.newAnnotationGd(holder, project, highlightSeverity, "Invalid type").range(((GdTypeHint)element).getTextRange()).create();
            return;
        }
        Iterable $this$forEach$iv = typeHints;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GdTypeHintRef it = (GdTypeHintRef)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.colorTypeHints(it, holder);
        }
    }

    private final boolean invalidType(GdTypeHintRef element) {
        if (GdKeywords.INSTANCE.getBUILT_TYPES().contains(element.getText())) {
            return false;
        }
        return PsiReferenceUtil.INSTANCE.resolveRef(element) == null;
    }

    private final void colorTypeHints(GdTypeHintRef element, AnnotationHolder holder) {
        TextAttributesKey color = GdHighlighterColors.Companion.getCLASS_TYPE();
        if (GdKeywords.INSTANCE.getBUILT_TYPES().contains(element.getText())) {
            color = GdHighlighterColors.Companion.getBASE_TYPE();
        } else {
            PsiElement psiElement = PsiReferenceUtil.INSTANCE.resolveRef(element);
            boolean bl = psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? PsiFileUtil.INSTANCE.isInSdk((PsiFile)psiElement) : false;
            if (bl) {
                color = GdHighlighterColors.Companion.getENGINE_TYPE();
            }
        }
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element.getTextRange()).textAttributes(color).create();
    }
}

