/*
 * Decompiled with CFR 0.152.
 */
package gdscript.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import gdscript.annotator.AnnotationHolderExKt;
import gdscript.highlighter.GdHighlighterColors;
import gdscript.index.impl.GdFileResIndex;
import gdscript.model.GdNodeHolder;
import gdscript.psi.GdNodePath;
import gdscript.psi.GdTypes;
import gdscript.psi.utils.GdNodeUtil;
import gdscript.settings.GdProjectSettingsState;
import gdscript.settings.GdProjectState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lgdscript/annotator/GdResourceTypeAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "FORMATTER", "Lkotlin/text/Regex;", "getFORMATTER", "()Lkotlin/text/Regex;", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "stringResourceExists", "", "state", "", "resourceExists", "Lgdscript/psi/GdNodePath;", "stringFormats", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nGdResourceTypeAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdResourceTypeAnnotator.kt\ngdscript/annotator/GdResourceTypeAnnotator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,75:1\n1321#2,2:76\n*S KotlinDebug\n*F\n+ 1 GdResourceTypeAnnotator.kt\ngdscript/annotator/GdResourceTypeAnnotator\n*L\n63#1:76,2\n*E\n"})
public final class GdResourceTypeAnnotator
implements Annotator {
    @NotNull
    private final Regex FORMATTER = new Regex("((?<!%)%[scdoxXf0-9+.*\\-]+)|(\\{[a-zA-Z0-9]*})");

    @NotNull
    public final Regex getFORMATTER() {
        return this.FORMATTER;
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        String state = GdProjectSettingsState.Companion.getInstance(element).getState().getAnnotators();
        if (element instanceof GdNodePath) {
            if (!Intrinsics.areEqual((Object)state, (Object)GdProjectState.Companion.getOFF())) {
                this.resourceExists((GdNodePath)element, holder, state);
            }
        } else if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)GdTypes.STRING)) {
            if (!Intrinsics.areEqual((Object)state, (Object)GdProjectState.Companion.getOFF()) && !this.stringResourceExists(element, holder, state)) {
                return;
            }
            this.stringFormats(element, holder);
        }
    }

    private final boolean stringResourceExists(PsiElement element, AnnotationHolder holder, String state) {
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        char[] cArray = new char[]{'\"', '\''};
        String text = StringsKt.trim((String)string, (char[])cArray);
        if (StringsKt.startsWith$default((String)text, (String)"res://", (boolean)false, (int)2, null)) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (GdFileResIndex.Companion.getFiles(text, project).isEmpty()) {
                Project project2 = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                AnnotationHolderExKt.newAnnotationGd(holder, project2, GdProjectState.Companion.selectedLevel(state), "Resource not found").range(TextRange.create((int)(element.getTextRange().getStartOffset() + 1), (int)(element.getTextRange().getEndOffset() - 1))).create();
                return false;
            }
        }
        return true;
    }

    private final void resourceExists(GdNodePath element, AnnotationHolder holder, String state) {
        if (Intrinsics.areEqual((Object)element.getText(), (Object)"$\".\"")) {
            return;
        }
        GdNodeHolder node = GdNodeUtil.INSTANCE.findNode(element);
        if (node != null) {
            return;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AnnotationHolderExKt.newAnnotationGd(holder, project, GdProjectState.Companion.selectedLevel(state), "Node not found").range(element.getTextRange()).create();
    }

    private final void stringFormats(PsiElement element, AnnotationHolder holder) {
        int offset = element.getTextOffset();
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)this.FORMATTER, (CharSequence)string, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult it = (MatchResult)element$iv;
            boolean bl = false;
            IntRange range = it.getRange();
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(new TextRange(range.getFirst() + offset, range.getLast() + offset + 1)).textAttributes(GdHighlighterColors.Companion.getSTRING_FORMAT()).create();
        }
    }
}

