/*
 * Decompiled with CFR 0.152.
 */
package gdscript.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import gdscript.annotator.AnnotationHolderExKt;
import gdscript.highlighter.GdHighlighterColors;
import gdscript.psi.GdClassVarDeclTl;
import gdscript.psi.GdConstDeclTl;
import gdscript.psi.GdEnumDeclTl;
import gdscript.psi.GdMethodDeclTl;
import gdscript.psi.GdMethodIdNmi;
import gdscript.psi.GdSignalDeclTl;
import gdscript.psi.utils.GdClassMemberUtil;
import gdscript.psi.utils.GdClassUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lgdscript/annotator/GdMethodNameAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "isUnique", "Lgdscript/psi/GdMethodIdNmi;", "intellij.rider.plugins.godot.gdscript"})
public final class GdMethodNameAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof GdMethodIdNmi)) {
            return;
        }
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(((GdMethodIdNmi)element).getTextRange()).textAttributes(GdHighlighterColors.Companion.getMETHOD_DECLARATION()).create();
        this.isUnique((GdMethodIdNmi)element, holder);
    }

    private final void isUnique(GdMethodIdNmi element, AnnotationHolder holder) {
        String string = element.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        if (Intrinsics.areEqual((Object)GdClassUtil.INSTANCE.getOwningClassName((PsiElement)element), (Object)name)) {
            return;
        }
        PsiElement declaration = (PsiElement)GdClassMemberUtil.listLocalDeclarationsUpward$default(GdClassMemberUtil.INSTANCE, (PsiElement)element, false, null, 6, null).get(name);
        if (declaration != null) {
            PsiElement psiElement = declaration;
            String type = psiElement instanceof GdMethodDeclTl ? "method" : (psiElement instanceof GdClassVarDeclTl ? "variable" : (psiElement instanceof GdConstDeclTl ? "constant" : (psiElement instanceof GdSignalDeclTl ? "signal" : (psiElement instanceof GdEnumDeclTl ? "enum" : "member"))));
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"ERROR");
            AnnotationHolderExKt.newAnnotationGd(holder, project, highlightSeverity, "Name [" + element.getName() + "] already defined as " + type).range(element.getTextRange()).create();
        }
    }
}

