/*
 * Decompiled with CFR 0.152.
 */
package gdscript.annotator;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import gdscript.annotator.AnnotationHolderExKt;
import gdscript.psi.GdArrEx;
import gdscript.psi.GdAssignSt;
import gdscript.psi.GdBitAndEx;
import gdscript.psi.GdClassVarDeclTl;
import gdscript.psi.GdComparisonEx;
import gdscript.psi.GdExpr;
import gdscript.psi.GdFactorEx;
import gdscript.psi.GdPlusEx;
import gdscript.psi.GdShiftEx;
import gdscript.psi.GdTypes;
import gdscript.psi.GdVarDeclSt;
import gdscript.utils.GdExprUtil;
import gdscript.utils.GdOperand;
import gdscript.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0002J8\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010 \u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020!2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\""}, d2={"Lgdscript/annotator/GdExprTypeAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "varDeclExpr", "Lgdscript/psi/GdVarDeclSt;", "classVarDecl", "Lgdscript/psi/GdClassVarDeclTl;", "assignExpr", "Lgdscript/psi/GdAssignSt;", "factorExpr", "Lgdscript/psi/GdFactorEx;", "plusExpr", "Lgdscript/psi/GdPlusEx;", "shiftExpr", "Lgdscript/psi/GdShiftEx;", "comparisonExpr", "Lgdscript/psi/GdComparisonEx;", "bitAndExpr", "Lgdscript/psi/GdBitAndEx;", "validate", "left", "", "right", "operator", "message", "arrIndexExpr", "Lgdscript/psi/GdArrEx;", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nGdExprTypeAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdExprTypeAnnotator.kt\ngdscript/annotator/GdExprTypeAnnotator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1563#2:156\n1634#2,3:157\n*S KotlinDebug\n*F\n+ 1 GdExprTypeAnnotator.kt\ngdscript/annotator/GdExprTypeAnnotator\n*L\n140#1:156\n140#1:157,3\n*E\n"})
public final class GdExprTypeAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiElement psiElement = element;
        if (psiElement instanceof GdFactorEx) {
            this.factorExpr((GdFactorEx)element, holder);
        } else if (psiElement instanceof GdPlusEx) {
            this.plusExpr((GdPlusEx)element, holder);
        } else if (psiElement instanceof GdBitAndEx) {
            this.bitAndExpr((GdBitAndEx)element, holder);
        } else if (psiElement instanceof GdVarDeclSt) {
            this.varDeclExpr((GdVarDeclSt)element, holder);
        } else if (psiElement instanceof GdAssignSt) {
            this.assignExpr((GdAssignSt)element, holder);
        } else if (psiElement instanceof GdShiftEx) {
            this.shiftExpr((GdShiftEx)element, holder);
        } else if (psiElement instanceof GdComparisonEx) {
            this.comparisonExpr((GdComparisonEx)element, holder);
        } else if (psiElement instanceof GdClassVarDeclTl) {
            this.classVarDecl((GdClassVarDeclTl)element, holder);
        } else if (psiElement instanceof GdArrEx) {
            this.arrIndexExpr((GdArrEx)element, holder);
        }
    }

    private final void varDeclExpr(GdVarDeclSt element, AnnotationHolder holder) {
        String string = element.getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getReturnType(...)");
        String left = string;
        Object object = element.getExpr();
        if (object == null || (object = object.getReturnType()) == null) {
            return;
        }
        Object right = object;
        Object object2 = element.getAssignTyped();
        if (object2 == null || (object2 = object2.getText()) == null) {
            return;
        }
        Object operator = object2;
        this.validate(left, (String)right, (String)operator, "Cannot assign", element, holder);
    }

    private final void classVarDecl(GdClassVarDeclTl element, AnnotationHolder holder) {
        String string = element.getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getReturnType(...)");
        String left = string;
        Object object = element.getExpr();
        if (object == null || (object = object.getReturnType()) == null) {
            return;
        }
        Object right = object;
        Object object2 = element.getAssignTyped();
        if (object2 == null || (object2 = object2.getText()) == null) {
            return;
        }
        Object operator = object2;
        this.validate(left, (String)right, (String)operator, "Cannot assign", element, holder);
    }

    private final void assignExpr(GdAssignSt element, AnnotationHolder holder) {
        List<GdExpr> list = element.getExprList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
        String left = GdExprUtil.INSTANCE.left(list);
        List<GdExpr> list2 = element.getExprList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getExprList(...)");
        String right = GdExprUtil.INSTANCE.right(list2);
        String operator = element.getAssignSign().getText();
        Intrinsics.checkNotNull((Object)operator);
        this.validate(left, right, operator, "Cannot assign", element, holder);
    }

    private final void factorExpr(GdFactorEx element, AnnotationHolder holder) {
        List<GdExpr> list = element.getExprList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
        String left = GdExprUtil.INSTANCE.left(list);
        List<GdExpr> list2 = element.getExprList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getExprList(...)");
        String right = GdExprUtil.INSTANCE.right(list2);
        String operator = element.getFactorSign().getText();
        Intrinsics.checkNotNull((Object)operator);
        this.validate(left, right, operator, "Cannot factor", element, holder);
    }

    private final void plusExpr(GdPlusEx element, AnnotationHolder holder) {
        List<GdExpr> list = element.getExprList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
        String left = GdExprUtil.INSTANCE.left(list);
        List<GdExpr> list2 = element.getExprList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getExprList(...)");
        String right = GdExprUtil.INSTANCE.right(list2);
        String operator = element.getSign().getText();
        Intrinsics.checkNotNull((Object)operator);
        this.validate(left, right, operator, "Cannot factor", element, holder);
    }

    private final void shiftExpr(GdShiftEx element, AnnotationHolder holder) {
        List<GdExpr> list = element.getExprList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
        String left = GdExprUtil.INSTANCE.left(list);
        List<GdExpr> list2 = element.getExprList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getExprList(...)");
        String right = GdExprUtil.INSTANCE.right(list2);
        this.validate(left, right, "<<", "Cannot factor", element, holder);
    }

    private final void comparisonExpr(GdComparisonEx element, AnnotationHolder holder) {
        List<GdExpr> list = element.getExprList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
        String left = GdExprUtil.INSTANCE.left(list);
        List<GdExpr> list2 = element.getExprList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getExprList(...)");
        String right = GdExprUtil.INSTANCE.right(list2);
        String string = element.getOperator().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.validate(left, right, string, "Cannot factor", element, holder);
    }

    private final void bitAndExpr(GdBitAndEx element, AnnotationHolder holder) {
        List<GdExpr> list = element.getExprList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
        String left = GdExprUtil.INSTANCE.left(list);
        List<GdExpr> list2 = element.getExprList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getExprList(...)");
        String right = GdExprUtil.INSTANCE.right(list2);
        String operator = element.getBitAndSign().getText();
        Intrinsics.checkNotNull((Object)operator);
        this.validate(left, right, operator, "Incomparable", element, holder);
    }

    private final void validate(String left, String right, String operator, String message, PsiElement element, AnnotationHolder holder) {
        String l = left;
        String r = right;
        if (Intrinsics.areEqual((Object)l, (Object)r) || Intrinsics.areEqual((Object)r, (Object)"null")) {
            return;
        }
        if (StringUtil.INSTANCE.isDynamicType(l) || StringUtil.INSTANCE.isDynamicType(r)) {
            return;
        }
        if (Intrinsics.areEqual((Object)l, (Object)"PackedScene")) {
            return;
        }
        if (Intrinsics.areEqual((Object)l, (Object)"EnumDictionary")) {
            l = "int";
        }
        if (Intrinsics.areEqual((Object)r, (Object)"EnumDictionary")) {
            r = "int";
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (GdOperand.INSTANCE.isAllowed(l, r, operator, project)) {
            return;
        }
        if (StringsKt.contains$default((CharSequence)operator, (CharSequence)"=", (boolean)false, (int)2, null) && gdscript.psi.utils.GdExprUtil.INSTANCE.typeAccepts(r, l, element)) {
            return;
        }
        if (StringsKt.contains$default((CharSequence)operator, (CharSequence)"=", (boolean)false, (int)2, null) && gdscript.psi.utils.GdExprUtil.INSTANCE.typeAccepts(l, r, element)) {
            return;
        }
        Project project2 = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"ERROR");
        AnnotationHolderExKt.newAnnotationGd(holder, project2, highlightSeverity, message + " " + l + " " + operator + " " + r).range(element.getTextRange()).create();
    }

    /*
     * WARNING - void declaration
     */
    private final void arrIndexExpr(GdArrEx element, AnnotationHolder holder) {
        List<GdExpr> list = element.getExprList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
        List<GdExpr> exprs = list;
        if (CollectionsKt.getOrNull(exprs, (int)1) == null) {
            ASTNode aSTNode = element.getNode().findChildByType(GdTypes.LSBR);
            PsiElement lBracket = aSTNode != null ? aSTNode.getPsi() : null;
            ASTNode aSTNode2 = element.getNode().findChildByType(GdTypes.RSBR);
            PsiElement rBracket = aSTNode2 != null ? aSTNode2.getPsi() : null;
            TextRange range = lBracket != null && rBracket != null ? lBracket.getTextRange().union(rBracket.getTextRange()) : element.getTextRange();
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"ERROR");
            AnnotationHolderExKt.newAnnotationGd(holder, project, highlightSeverity, "Indexer has 1 parameter but is invoked with 0 argument").range(range).create();
            return;
        }
        Object object = (GdExpr)CollectionsKt.getOrNull(exprs, (int)0);
        if (object == null || (object = object.getReturnType()) == null) {
            return;
        }
        Object baseType = object;
        Object object2 = (GdExpr)CollectionsKt.getOrNull(exprs, (int)1);
        if (object2 == null || (object2 = object2.getReturnType()) == null) {
            return;
        }
        Object indexType = object2;
        if (StringUtil.INSTANCE.isDynamicType((String)baseType) || StringUtil.INSTANCE.isDynamicType((String)indexType)) {
            return;
        }
        String expectedKey = null;
        if (StringsKt.startsWith$default((String)baseType, (String)"Array[", (boolean)false, (int)2, null)) {
            expectedKey = "int";
        } else if (Intrinsics.areEqual((Object)baseType, (Object)"Array")) {
            expectedKey = "int";
        } else if (StringsKt.startsWith$default((String)baseType, (String)"Dictionary[", (boolean)false, (int)2, null)) {
            void $this$mapTo$iv$iv;
            String inside = StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)baseType, (String)"[", null, (int)2, null), (String)"]", null, (int)2, null);
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)inside, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            List parts = (List)destination$iv$iv;
            if (!((Collection)parts).isEmpty()) {
                expectedKey = (String)parts.get(0);
            }
        }
        String string = expectedKey;
        if (string == null) {
            return;
        }
        String exp = string;
        if (gdscript.psi.utils.GdExprUtil.INSTANCE.typeAccepts(exp, (String)indexType, element)) {
            return;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"ERROR");
        AnnotationBuilder annotationBuilder = AnnotationHolderExKt.newAnnotationGd(holder, project, highlightSeverity, "Invalid index type " + (String)indexType + ", expected " + exp);
        GdExpr gdExpr = (GdExpr)CollectionsKt.getOrNull(exprs, (int)1);
        if (gdExpr == null || (gdExpr = gdExpr.getTextRange()) == null) {
            gdExpr = element.getTextRange();
        }
        annotationBuilder.range((TextRange)gdExpr).create();
    }
}

