/*
 * Decompiled with CFR 0.152.
 */
package gdscript.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import gdscript.action.quickFix.GdFileClassNameAction;
import gdscript.action.quickFix.GdRemoveElementsAction;
import gdscript.annotator.AnnotationHolderExKt;
import gdscript.highlighter.GdHighlighterColors;
import gdscript.index.impl.GdClassNamingIndex;
import gdscript.psi.GdClassDeclTl;
import gdscript.psi.GdClassNameNmi;
import gdscript.psi.GdClassNaming;
import gdscript.psi.GdInheritance;
import gdscript.psi.GdInheritanceId;
import gdscript.psi.GdInheritanceIdRef;
import gdscript.psi.GdInheritanceSubIdRef;
import gdscript.psi.utils.GdClassUtil;
import gdscript.psi.utils.PsiGdFileUtil;
import gdscript.utils.PsiFileUtil;
import gdscript.utils.StringUtil;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lgdscript/annotator/GdClassNameAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "existingInheritance", "Lgdscript/psi/GdInheritanceId;", "colorInheritance", "Lgdscript/psi/GdInheritanceIdRef;", "colorClass", "", "color", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "alreadyExists", "Lgdscript/psi/GdClassNameNmi;", "classNameToFilename", "isDuplicated", "type", "", "intellij.rider.plugins.godot.gdscript"})
public final class GdClassNameAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiElement psiElement = element;
        if (psiElement instanceof GdInheritanceId) {
            this.existingInheritance((GdInheritanceId)element, holder);
        } else if (psiElement instanceof GdInheritanceIdRef) {
            this.colorInheritance((GdInheritanceIdRef)element, holder);
        } else if (psiElement instanceof GdInheritanceSubIdRef) {
            this.colorClass(element, GdHighlighterColors.Companion.getCLASS_TYPE(), holder);
        } else if (psiElement instanceof GdClassNameNmi) {
            if (!this.alreadyExists((GdClassNameNmi)element, holder) && !this.classNameToFilename((GdClassNameNmi)element, holder)) {
                this.colorClass(element, GdHighlighterColors.Companion.getCLASS_TYPE(), holder);
            }
        } else if (psiElement instanceof GdClassNaming) {
            this.isDuplicated(element, holder, "class_name");
        } else if (psiElement instanceof GdInheritance) {
            this.isDuplicated(element, holder, "Inheritance");
        }
    }

    private final void existingInheritance(GdInheritanceId element, AnnotationHolder holder) {
        PsiReference ref;
        PsiReference[] psiReferenceArray = element.getLastChild().getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        PsiReference psiReference = ref = (PsiReference)ArraysKt.firstOrNull((Object[])psiReferenceArray);
        if ((psiReference != null ? psiReference.resolve() : null) != null) {
            return;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"ERROR");
        AnnotationHolderExKt.newAnnotationGd(holder, project, highlightSeverity, "Class not found").range(element.getTextRange()).create();
    }

    private final void colorInheritance(GdInheritanceIdRef element, AnnotationHolder holder) {
        if (element.isClassName()) {
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            PsiElement psiElement = GdClassUtil.INSTANCE.getClassIdElement(string, element);
            boolean bl = (psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? PsiFileUtil.INSTANCE.isInSdk((PsiFile)psiElement) : false) ? this.colorClass(element, GdHighlighterColors.Companion.getENGINE_TYPE(), holder) : this.colorClass(element, GdHighlighterColors.Companion.getCLASS_TYPE(), holder);
        }
    }

    private final boolean colorClass(PsiElement element, TextAttributesKey color, AnnotationHolder holder) {
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element.getTextRange()).textAttributes(color).create();
        return true;
    }

    private final boolean alreadyExists(GdClassNameNmi element, AnnotationHolder holder) {
        boolean conflict;
        String string = element.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        String message = "Class defined in global scope";
        boolean bl = conflict = !GdClassNamingIndex.Companion.getINSTANCE().getGloballyWithoutSelf((PsiElement)element).isEmpty();
        if (element.isInner()) {
            conflict = conflict || !GdClassNamingIndex.Companion.getINSTANCE().getInFile((PsiElement)element).isEmpty();
            for (PsiElement prev = element.getParent().getPrevSibling(); prev != null && !conflict; prev = prev.getPrevSibling()) {
                if (!(prev instanceof GdClassDeclTl)) continue;
                GdClassNameNmi gdClassNameNmi = ((GdClassDeclTl)prev).getClassNameNmi();
                if (!Intrinsics.areEqual((Object)(gdClassNameNmi != null ? gdClassNameNmi.getName() : null), (Object)name)) continue;
                conflict = true;
                message = "Class already defined";
            }
        }
        if (conflict) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"ERROR");
            AnnotationHolderExKt.newAnnotationGd(holder, project, highlightSeverity, message).range(element.getTextRange()).create();
            return true;
        }
        return false;
    }

    private final boolean classNameToFilename(GdClassNameNmi element, AnnotationHolder holder) {
        if (!(element.getParent() instanceof GdClassNaming)) {
            return false;
        }
        String string = element.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        String filename = StringUtil.INSTANCE.snakeToPascalCase(PsiGdFileUtil.INSTANCE.filename(psiFile));
        String string2 = filename.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        if (!Intrinsics.areEqual((Object)string2, (Object)string3)) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            HighlightSeverity highlightSeverity = HighlightSeverity.WEAK_WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"WEAK_WARNING");
            AnnotationHolderExKt.newAnnotationGd(holder, project, highlightSeverity, "Class name does not match filename").range(element.getTextRange()).withFix((IntentionAction)new GdFileClassNameAction(filename, element)).create();
            return true;
        }
        return false;
    }

    private final void isDuplicated(PsiElement element, AnnotationHolder holder, String type) {
        if (PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, element.getClass()) != null) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"ERROR");
            PsiElement[] psiElementArray = new PsiElement[]{element};
            AnnotationHolderExKt.newAnnotationGd(holder, project, highlightSeverity, type + " already defined").range(element.getTextRange()).withFix((IntentionAction)new GdRemoveElementsAction(psiElementArray)).create();
        }
    }
}

