/*
 * Decompiled with CFR 0.152.
 */
package gdscript.action;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import gdscript.index.impl.GdClassNamingIndex;
import gdscript.psi.GdClassNaming;
import gdscript.psi.utils.PsiGdFileUtil;
import gdscript.run.GdConfigurationFactory;
import gdscript.run.GdRunConfiguration;
import gdscript.run.GdRunConfigurationType;
import gdscript.utils.RiderGodotSupportPluginUtilKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import tscn.psi.TscnResourceHeader;
import tscn.psi.utils.TscnResourceUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lgdscript/action/GdRunAction;", "Lcom/intellij/ide/actions/runAnything/RunAnythingAction;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "runAction", "", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getName", "", "prepareAction", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "createWarning", "project", "Lcom/intellij/openapi/project/Project;", "message", "intellij.rider.plugins.godot.gdscript"})
@SourceDebugExtension(value={"SMAP\nGdRunAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdRunAction.kt\ngdscript/action/GdRunAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class GdRunAction
extends RunAnythingAction {
    @NotNull
    private final PsiElement element;

    @NotNull
    public final PsiElement getElement() {
        return this.element;
    }

    public GdRunAction(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.element = element;
        this.getTemplatePresentation().setIcon(AllIcons.RunConfigurations.TestState.Run);
        this.getTemplatePresentation().setText(GdScriptBundle.INSTANCE.message("action.run.text", new Object[0]));
    }

    public final void runAction() {
        RunnerAndConfigurationSettings forRun = this.prepareAction();
        if (forRun != null) {
            ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)forRun, (Executor)DefaultRunExecutor.getRunExecutorInstance());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.runAction();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (RiderGodotSupportPluginUtilKt.isRiderGodotSupportPluginInstalled(PluginManagerCore.INSTANCE)) {
            e.getPresentation().setEnabledAndVisible(false);
        }
        super.update(e);
    }

    private final String getName() {
        GdClassNaming className = (GdClassNaming)CollectionsKt.firstOrNull((Iterable)GdClassNamingIndex.Companion.getINSTANCE().getInFile(this.element));
        if (className != null) {
            String string = className.getClassname();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassname(...)");
            return string;
        }
        PsiFile psiFile = this.element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        return PsiGdFileUtil.INSTANCE.filepath((PsiElement)psiFile);
    }

    private final RunnerAndConfigurationSettings prepareAction() {
        Object v1;
        Project project;
        String name;
        block4: {
            name = this.getName();
            Project project2 = this.element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            project = project2;
            Iterable iterable = RunManager.Companion.getInstance(project).getConfigurationSettingsList(GdRunConfigurationType.class);
            for (Object t : iterable) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)t;
                boolean bl = false;
                if (!(it.getConfiguration() instanceof GdRunConfiguration && Intrinsics.areEqual((Object)it.getName(), (Object)name))) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        RunnerAndConfigurationSettings configuration = v1;
        if (configuration != null) {
            return configuration;
        }
        RunManager manager = RunManager.Companion.getInstance(project);
        RunConfiguration runConfiguration = manager.getConfigurationTemplate((ConfigurationFactory)GdConfigurationFactory.INSTANCE).getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type gdscript.run.GdRunConfiguration");
        GdRunConfiguration template = (GdRunConfiguration)runConfiguration;
        GdRunConfiguration current = new GdRunConfiguration(project, GdConfigurationFactory.INSTANCE, name);
        if (template.getGodotExe() == null) {
            this.createWarning(project, GdScriptBundle.INSTANCE.message("godot.executable.not.set", new Object[0]));
            return null;
        }
        Collection<TscnResourceHeader> scenes = TscnResourceUtil.INSTANCE.findTscnByResources(this.element);
        if (scenes.isEmpty()) {
            this.createWarning(project, GdScriptBundle.INSTANCE.message("no.scene.found", new Object[0]));
            return null;
        }
        current.setTscn(((TscnResourceHeader)CollectionsKt.first((Iterable)scenes)).getContainingFile().getVirtualFile().getPath());
        current.setGodotExe(template.getGodotExe());
        RunnerAndConfigurationSettings action = manager.createConfiguration((RunConfiguration)current, (ConfigurationFactory)GdConfigurationFactory.INSTANCE);
        action.setTemporary(true);
        manager.addConfiguration(action);
        manager.setSelectedConfiguration(action);
        return action;
    }

    private final void createWarning(Project project, String message) {
        Object[] objectArray = new Object[]{message};
        NotificationGroupManager.getInstance().getNotificationGroup("GdRunNotifications").createNotification(GdScriptBundle.INSTANCE.message("notification.content.failed.to.run.due.to", objectArray), NotificationType.WARNING).notify(project);
    }
}

