/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.efcore.state;

import com.intellij.codeWithMe.ClientId;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.jetbrains.rider.plugins.efcore.state.DialogsState;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@State(name="EfCoreDialogsState", storages={@Storage(value="efCoreDialogsState.xml")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0006\u0010\n\u001a\u00020\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/plugins/efcore/state/DialogsStateService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/jetbrains/rider/plugins/efcore/state/DialogsState;", "<init>", "()V", "myState", "getState", "loadState", "", "state", "clearState", "forDialog", "Lcom/jetbrains/rider/plugins/efcore/state/DialogsStateService$SpecificDialogState;", "dialogId", "", "Companion", "SpecificDialogState", "intellij.rider.plugins.efCore"})
@SourceDebugExtension(value={"SMAP\nDialogsStateService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogsStateService.kt\ncom/jetbrains/rider/plugins/efcore/state/DialogsStateService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1869#2,2:81\n*S KotlinDebug\n*F\n+ 1 DialogsStateService.kt\ncom/jetbrains/rider/plugins/efcore/state/DialogsStateService\n*L\n27#1:81,2\n*E\n"})
public final class DialogsStateService
implements PersistentStateComponent<DialogsState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private DialogsState myState = new DialogsState();

    @NotNull
    public DialogsState getState() {
        return this.myState;
    }

    public void loadState(@NotNull DialogsState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.myState = state;
    }

    public final void clearState() {
        this.myState.getKeyValueStorage().clear();
        Iterable $this$forEach$iv = this.myState.getStoredSecureAttributes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CredentialAttributes it = (CredentialAttributes)element$iv;
            boolean bl = false;
            PasswordSafe.Companion.getInstance().set(it, null);
        }
        this.myState.getStoredSecureAttributes().clear();
    }

    @NonNls
    @NotNull
    public final SpecificDialogState forDialog(@NotNull String dialogId) {
        Intrinsics.checkNotNullParameter((Object)dialogId, (String)"dialogId");
        return new SpecificDialogState(dialogId, this.myState.getKeyValueStorage(), this.myState.getStoredSecureAttributes());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/plugins/efcore/state/DialogsStateService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/efcore/state/DialogsStateService;", "intellij.rider.plugins.efCore"})
    @SourceDebugExtension(value={"SMAP\nDialogsStateService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogsStateService.kt\ncom/jetbrains/rider/plugins/efcore/state/DialogsStateService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,80:1\n42#2,3:81\n*S KotlinDebug\n*F\n+ 1 DialogsStateService.kt\ncom/jetbrains/rider/plugins/efcore/state/DialogsStateService$Companion\n*L\n14#1:81,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DialogsStateService getInstance() {
            boolean $i$f$service = false;
            Class<DialogsStateService> serviceClass$iv = DialogsStateService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (DialogsStateService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0007J\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000eH\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0007J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0007J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0003H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/plugins/efcore/state/DialogsStateService$SpecificDialogState;", "", "dialogId", "", "storage", "", "storedSecureAttributes", "", "Lcom/intellij/credentialStore/CredentialAttributes;", "<init>", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/Set;)V", "get", "key", "getBool", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "set", "", "value", "getSensitive", "setSensitive", "createCredentialAttributes", "intellij.rider.plugins.efCore"})
    @NonNls
    public static final class SpecificDialogState {
        @NotNull
        private final String dialogId;
        @NotNull
        private final Map<String, String> storage;
        @NotNull
        private final Set<CredentialAttributes> storedSecureAttributes;

        public SpecificDialogState(@NotNull String dialogId, @NotNull Map<String, String> storage, @NotNull Set<CredentialAttributes> storedSecureAttributes) {
            Intrinsics.checkNotNullParameter((Object)dialogId, (String)"dialogId");
            Intrinsics.checkNotNullParameter(storage, (String)"storage");
            Intrinsics.checkNotNullParameter(storedSecureAttributes, (String)"storedSecureAttributes");
            this.dialogId = dialogId;
            this.storage = storage;
            this.storedSecureAttributes = storedSecureAttributes;
        }

        @NonNls
        @Nullable
        public final String get(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.storage.get(this.dialogId + ":" + key);
        }

        @NonNls
        @Nullable
        public final Boolean getBool(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String string = this.get(key);
            return string != null ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
        }

        @NonNls
        public final void set(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.storage.put(this.dialogId + ":" + key, value);
        }

        @NonNls
        public final void set(@NotNull String key, boolean value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.storage.put(this.dialogId + ":" + key, String.valueOf(value));
        }

        @NonNls
        @Nullable
        public final String getSensitive(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            CredentialAttributes attributes = this.createCredentialAttributes(key);
            Credentials credentials = PasswordSafe.Companion.getInstance().get(attributes);
            return credentials != null && (credentials = credentials.getPassword()) != null ? credentials.toString() : null;
        }

        @NonNls
        public final void setSensitive(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            CredentialAttributes attributes = this.createCredentialAttributes(key);
            this.storedSecureAttributes.add(attributes);
            PasswordSafe.Companion.getInstance().set(attributes, new Credentials("EfCoreUiPlugin", value));
        }

        @NonNls
        private final CredentialAttributes createCredentialAttributes(String key) {
            return new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)"EfCoreDialogsData", (String)(this.dialogId + ":" + key)));
        }
    }
}

