/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.efcore.features.shared.dialog;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.jetbrains.rider.plugins.efcore.EfCoreUiBundle;
import com.jetbrains.rider.plugins.efcore.features.shared.dialog.CommonDataContext;
import com.jetbrains.rider.plugins.efcore.rd.DbContextInfo;
import com.jetbrains.rider.plugins.efcore.rd.MigrationsIdentity;
import com.jetbrains.rider.plugins.efcore.rd.MigrationsProjectInfo;
import com.jetbrains.rider.plugins.efcore.rd.RiderEfCoreModel;
import com.jetbrains.rider.plugins.efcore.ui.items.BaseTargetFrameworkItem;
import com.jetbrains.rider.plugins.efcore.ui.items.BuildConfigurationItem;
import com.jetbrains.rider.plugins.efcore.ui.items.DbContextItem;
import com.jetbrains.rider.plugins.efcore.ui.items.MigrationsProjectItem;
import com.jetbrains.rider.plugins.efcore.ui.items.StartupProjectItem;
import com.jetbrains.rider.util.idea.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\f\u001a!\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\r\u00a2\u0006\u0002\b\u0012J%\u0010\u0013\u001a!\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\r\u00a2\u0006\u0002\b\u0012J%\u0010\u0015\u001a!\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\r\u00a2\u0006\u0002\b\u0012J%\u0010\u0017\u001a!\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\r\u00a2\u0006\u0002\b\u0012J%\u0010\u0019\u001a!\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\r\u00a2\u0006\u0002\b\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/plugins/efcore/features/shared/dialog/CommonDialogValidator;", "", "dataCtx", "Lcom/jetbrains/rider/plugins/efcore/features/shared/dialog/CommonDataContext;", "beModel", "Lcom/jetbrains/rider/plugins/efcore/rd/RiderEfCoreModel;", "intellijProject", "Lcom/intellij/openapi/project/Project;", "shouldHaveMigrationsForDbContext", "", "<init>", "(Lcom/jetbrains/rider/plugins/efcore/features/shared/dialog/CommonDataContext;Lcom/jetbrains/rider/plugins/efcore/rd/RiderEfCoreModel;Lcom/intellij/openapi/project/Project;Z)V", "migrationsProjectValidation", "Lkotlin/Function2;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/jetbrains/rider/plugins/efcore/ui/items/MigrationsProjectItem;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lkotlin/ExtensionFunctionType;", "startupProjectValidation", "Lcom/jetbrains/rider/plugins/efcore/ui/items/StartupProjectItem;", "dbContextValidation", "Lcom/jetbrains/rider/plugins/efcore/ui/items/DbContextItem;", "buildConfigurationValidation", "Lcom/jetbrains/rider/plugins/efcore/ui/items/BuildConfigurationItem;", "targetFrameworkValidation", "Lcom/jetbrains/rider/plugins/efcore/ui/items/BaseTargetFrameworkItem;", "intellij.rider.plugins.efCore"})
public final class CommonDialogValidator {
    @NotNull
    private final CommonDataContext dataCtx;
    @NotNull
    private final RiderEfCoreModel beModel;
    @NotNull
    private final Project intellijProject;
    private final boolean shouldHaveMigrationsForDbContext;

    public CommonDialogValidator(@NotNull CommonDataContext dataCtx, @NotNull RiderEfCoreModel beModel, @NotNull Project intellijProject, boolean shouldHaveMigrationsForDbContext) {
        Intrinsics.checkNotNullParameter((Object)dataCtx, (String)"dataCtx");
        Intrinsics.checkNotNullParameter((Object)((Object)beModel), (String)"beModel");
        Intrinsics.checkNotNullParameter((Object)intellijProject, (String)"intellijProject");
        this.dataCtx = dataCtx;
        this.beModel = beModel;
        this.intellijProject = intellijProject;
        this.shouldHaveMigrationsForDbContext = shouldHaveMigrationsForDbContext;
    }

    @NotNull
    public final Function2<ValidationInfoBuilder, ComboBox<MigrationsProjectItem>, ValidationInfo> migrationsProjectValidation() {
        return CommonDialogValidator::migrationsProjectValidation$lambda$0;
    }

    @NotNull
    public final Function2<ValidationInfoBuilder, ComboBox<StartupProjectItem>, ValidationInfo> startupProjectValidation() {
        return CommonDialogValidator::startupProjectValidation$lambda$0;
    }

    @NotNull
    public final Function2<ValidationInfoBuilder, ComboBox<DbContextItem>, ValidationInfo> dbContextValidation() {
        return (arg_0, arg_1) -> CommonDialogValidator.dbContextValidation$lambda$0(this, arg_0, arg_1);
    }

    @NotNull
    public final Function2<ValidationInfoBuilder, ComboBox<BuildConfigurationItem>, ValidationInfo> buildConfigurationValidation() {
        return (arg_0, arg_1) -> CommonDialogValidator.buildConfigurationValidation$lambda$0(this, arg_0, arg_1);
    }

    @NotNull
    public final Function2<ValidationInfoBuilder, ComboBox<BaseTargetFrameworkItem>, ValidationInfo> targetFrameworkValidation() {
        return (arg_0, arg_1) -> CommonDialogValidator.targetFrameworkValidation$lambda$0(this, arg_0, arg_1);
    }

    private static final ValidationInfo migrationsProjectValidation$lambda$0(ValidationInfoBuilder validationInfoBuilder, ComboBox it) {
        Intrinsics.checkNotNullParameter((Object)validationInfoBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getItem() == null ? validationInfoBuilder.error(EfCoreUiBundle.INSTANCE.message("dialog.message.you.should.selected.valid.migrations.project", new Object[0])) : null;
    }

    private static final ValidationInfo startupProjectValidation$lambda$0(ValidationInfoBuilder validationInfoBuilder, ComboBox it) {
        Intrinsics.checkNotNullParameter((Object)validationInfoBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getItem() == null ? validationInfoBuilder.error(EfCoreUiBundle.INSTANCE.message("dialog.message.you.should.selected.valid.startup.project", new Object[0])) : null;
    }

    private static final ValidationInfo dbContextValidation$lambda$0(CommonDialogValidator this$0, ValidationInfoBuilder validationInfoBuilder, ComboBox it) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)validationInfoBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getItem() == null || this$0.dataCtx.getAvailableDbContexts().getValue().isEmpty()) {
            object = validationInfoBuilder.error(EfCoreUiBundle.INSTANCE.message("dialog.message.migrations.project.should.have.at.least.dbcontext", new Object[0]));
        } else if (this$0.shouldHaveMigrationsForDbContext) {
            if (this$0.dataCtx.getDbContext().getValue() == null || this$0.dataCtx.getMigrationsProject().getValue() == null) {
                object = null;
            } else {
                MigrationsProjectInfo migrationsProjectInfo = this$0.dataCtx.getMigrationsProject().getValue();
                Intrinsics.checkNotNull((Object)migrationsProjectInfo);
                MigrationsIdentity migrationsIdentity = new MigrationsIdentity(migrationsProjectInfo.getId(), ((DbContextInfo)((DbContextItem)it.getItem()).getData()).getFullName());
                Boolean hasMigrations = (Boolean)ExtensionsKt.runUnderProgress(this$0.beModel.getHasAvailableMigrations(), (Object)migrationsIdentity, (Project)this$0.intellijProject, (String)EfCoreUiBundle.INSTANCE.message("progress.title.checking.migrations", new Object[0]), (boolean)true, (boolean)true);
                object = hasMigrations == null || !hasMigrations.booleanValue() ? validationInfoBuilder.error(EfCoreUiBundle.INSTANCE.message("dialog.message.selected.dbcontext.doesnt.have.migrations", new Object[0])) : null;
            }
        } else {
            object = null;
        }
        return object;
    }

    private static final ValidationInfo buildConfigurationValidation$lambda$0(CommonDialogValidator this$0, ValidationInfoBuilder validationInfoBuilder, ComboBox it) {
        Intrinsics.checkNotNullParameter((Object)validationInfoBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isEnabled() && (it.getItem() == null || this$0.dataCtx.getAvailableBuildConfigurations().getValue().isEmpty()) ? validationInfoBuilder.error(EfCoreUiBundle.INSTANCE.message("dialog.message.solution.doesnt.have.any.build.configurations", new Object[0])) : null;
    }

    private static final ValidationInfo targetFrameworkValidation$lambda$0(CommonDialogValidator this$0, ValidationInfoBuilder validationInfoBuilder, ComboBox it) {
        Intrinsics.checkNotNullParameter((Object)validationInfoBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isEnabled() && (it.getItem() == null || this$0.dataCtx.getAvailableTargetFrameworks().getValue().isEmpty()) ? validationInfoBuilder.error(EfCoreUiBundle.INSTANCE.message("dialog.message.startup.project.should.have.at.least.supported.target.framework", new Object[0])) : null;
    }
}

