/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.efcore.features.shared;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.rider.plugins.efcore.EfCoreUiBundle;
import com.jetbrains.rider.plugins.efcore.features.shared.ValidationResult;
import java.nio.file.Path;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u00a8\u0006\u0005"}, d2={"validateRelativeFolderPath", "Lcom/jetbrains/rider/plugins/efcore/features/shared/ValidationResult;", "inputString", "", "parentPath", "intellij.rider.plugins.efCore"})
public final class ValidationUtilsKt {
    @NotNull
    public static final ValidationResult validateRelativeFolderPath(@NotNull String inputString, @NotNull String parentPath) {
        Sequence invalidCharacters;
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        if (((CharSequence)inputString).length() == 0) {
            return ValidationResult.Companion.getVALID();
        }
        if (StringsKt.startsWith$default((String)inputString, (String)"\\", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)inputString, (String)"/", (boolean)false, (int)2, null)) {
            Object[] objectArray = new Object[]{Character.valueOf(StringsKt.first((CharSequence)inputString))};
            return new ValidationResult(false, EfCoreUiBundle.INSTANCE.message("relative.folder.path.validation.error.name.starts.with.0", objectArray));
        }
        if (SystemInfo.isWindows && SequencesKt.any((Sequence)(invalidCharacters = SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)new Regex("[<>\"*?|]"), (CharSequence)inputString, (int)0, (int)2, null), ValidationUtilsKt::validateRelativeFolderPath$lambda$0), ValidationUtilsKt::validateRelativeFolderPath$lambda$1))))) {
            Object[] objectArray = new Object[]{SequencesKt.joinToString$default((Sequence)invalidCharacters, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)};
            return ValidationResult.Companion.invalid(EfCoreUiBundle.INSTANCE.message("relative.folder.path.validation.error.name.contains.invalid.characters.0", objectArray));
        }
        StringTokenizer tokenizer = new StringTokenizer(inputString, "\\/");
        VirtualFile vFile = VfsUtil.findFile((Path)Path.of(parentPath, new String[0]), (boolean)true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (vFile == null) continue;
            if (Intrinsics.areEqual((Object)"..", (Object)token)) {
                if ((vFile = vFile.getParent()) != null) continue;
                return ValidationResult.Companion.invalid(EfCoreUiBundle.INSTANCE.message("relative.folder.path.validation.error.not.a.valid.directory", new Object[0]));
            }
            if (Intrinsics.areEqual((Object)".", (Object)token)) continue;
            VirtualFile child = vFile.findChild(token);
            if (child != null && !child.isDirectory()) {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNull((Object)token);
                objectArray[0] = token;
                return ValidationResult.Companion.invalid(EfCoreUiBundle.INSTANCE.message("relative.folder.path.validation.error.contains.invalid.directory", objectArray));
            }
            vFile = child;
        }
        return ValidationResult.Companion.getVALID();
    }

    private static final String validateRelativeFolderPath$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue();
    }

    private static final String validateRelativeFolderPath$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return XmlStringUtil.escapeString((String)it);
    }
}

