/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.efcore.cli.api;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.efcore.cli.api.DatabaseCommandFactory;
import com.jetbrains.rider.plugins.efcore.cli.api.DbContextCommandFactory;
import com.jetbrains.rider.plugins.efcore.cli.api.MigrationsCommandFactory;
import com.jetbrains.rider.plugins.efcore.cli.api.models.DotnetEfVersion;
import com.jetbrains.rider.plugins.efcore.cli.execution.CliCommand;
import com.jetbrains.rider.plugins.efcore.features.database.drop.DropDatabaseCommand;
import com.jetbrains.rider.plugins.efcore.features.database.update.UpdateDatabaseCommand;
import com.jetbrains.rider.plugins.efcore.features.dbcontext.scaffold.ScaffoldDbContextCommand;
import com.jetbrains.rider.plugins.efcore.features.migrations.add.AddMigrationCommand;
import com.jetbrains.rider.plugins.efcore.features.migrations.remove.RemoveLastMigrationCommand;
import com.jetbrains.rider.plugins.efcore.features.migrations.script.GenerateScriptCommand;
import com.jetbrains.rider.plugins.efcore.features.shared.dialog.DialogCommand;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000b\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/plugins/efcore/cli/api/EfCoreCliCommandFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "migrationsFactory", "Lcom/jetbrains/rider/plugins/efcore/cli/api/MigrationsCommandFactory;", "getMigrationsFactory", "()Lcom/jetbrains/rider/plugins/efcore/cli/api/MigrationsCommandFactory;", "migrationsFactory$delegate", "Lkotlin/Lazy;", "databaseFactory", "Lcom/jetbrains/rider/plugins/efcore/cli/api/DatabaseCommandFactory;", "getDatabaseFactory", "()Lcom/jetbrains/rider/plugins/efcore/cli/api/DatabaseCommandFactory;", "databaseFactory$delegate", "dbContextFactory", "Lcom/jetbrains/rider/plugins/efcore/cli/api/DbContextCommandFactory;", "getDbContextFactory", "()Lcom/jetbrains/rider/plugins/efcore/cli/api/DbContextCommandFactory;", "dbContextFactory$delegate", "create", "Lcom/jetbrains/rider/plugins/efcore/cli/execution/CliCommand;", "command", "Lcom/jetbrains/rider/plugins/efcore/features/shared/dialog/DialogCommand;", "efCoreVersion", "Lcom/jetbrains/rider/plugins/efcore/cli/api/models/DotnetEfVersion;", "Companion", "intellij.rider.plugins.efCore"})
public final class EfCoreCliCommandFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy migrationsFactory$delegate;
    @NotNull
    private final Lazy databaseFactory$delegate;
    @NotNull
    private final Lazy dbContextFactory$delegate;

    public EfCoreCliCommandFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.migrationsFactory$delegate = LazyKt.lazy(() -> EfCoreCliCommandFactory.migrationsFactory_delegate$lambda$0(this));
        this.databaseFactory$delegate = LazyKt.lazy(() -> EfCoreCliCommandFactory.databaseFactory_delegate$lambda$0(this));
        this.dbContextFactory$delegate = LazyKt.lazy(() -> EfCoreCliCommandFactory.dbContextFactory_delegate$lambda$0(this));
    }

    private final MigrationsCommandFactory getMigrationsFactory() {
        Lazy lazy = this.migrationsFactory$delegate;
        return (MigrationsCommandFactory)lazy.getValue();
    }

    private final DatabaseCommandFactory getDatabaseFactory() {
        Lazy lazy = this.databaseFactory$delegate;
        return (DatabaseCommandFactory)lazy.getValue();
    }

    private final DbContextCommandFactory getDbContextFactory() {
        Lazy lazy = this.dbContextFactory$delegate;
        return (DbContextCommandFactory)lazy.getValue();
    }

    @NotNull
    public final CliCommand create(@NotNull DialogCommand command, @NotNull DotnetEfVersion efCoreVersion) {
        CliCommand cliCommand;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)efCoreVersion, (String)"efCoreVersion");
        DialogCommand dialogCommand = command;
        if (dialogCommand instanceof AddMigrationCommand) {
            cliCommand = MigrationsCommandFactory.add$default(this.getMigrationsFactory(), command.getCommon(), ((AddMigrationCommand)command).getMigrationName(), ((AddMigrationCommand)command).getOutputFolder(), null, 8, null);
        } else if (dialogCommand instanceof RemoveLastMigrationCommand) {
            cliCommand = this.getMigrationsFactory().removeLast(command.getCommon());
        } else if (dialogCommand instanceof GenerateScriptCommand) {
            cliCommand = this.getMigrationsFactory().generateScript(efCoreVersion, command.getCommon(), ((GenerateScriptCommand)command).getFromMigration(), ((GenerateScriptCommand)command).getToMigration(), ((GenerateScriptCommand)command).getOutputFilePath(), ((GenerateScriptCommand)command).getIdempotent(), ((GenerateScriptCommand)command).getNoTransactions());
        } else if (dialogCommand instanceof DropDatabaseCommand) {
            cliCommand = this.getDatabaseFactory().drop(command.getCommon());
        } else if (dialogCommand instanceof UpdateDatabaseCommand) {
            cliCommand = this.getDatabaseFactory().update(efCoreVersion, command.getCommon(), ((UpdateDatabaseCommand)command).getTargetMigration(), ((UpdateDatabaseCommand)command).getConnection());
        } else if (dialogCommand instanceof ScaffoldDbContextCommand) {
            cliCommand = this.getDbContextFactory().scaffold(efCoreVersion, command.getCommon(), ((ScaffoldDbContextCommand)command).getConnection(), ((ScaffoldDbContextCommand)command).getProvider(), ((ScaffoldDbContextCommand)command).getOutputFolder(), ((ScaffoldDbContextCommand)command).getUseAttributes(), ((ScaffoldDbContextCommand)command).getUseDatabaseNames(), ((ScaffoldDbContextCommand)command).getGenerateOnConfiguring(), ((ScaffoldDbContextCommand)command).getUsePluralizer(), ((ScaffoldDbContextCommand)command).getDbContextName(), ((ScaffoldDbContextCommand)command).getDbContextFolder(), ((ScaffoldDbContextCommand)command).getScaffoldAllTables(), ((ScaffoldDbContextCommand)command).getTablesList(), ((ScaffoldDbContextCommand)command).getScaffoldAllSchemas(), ((ScaffoldDbContextCommand)command).getSchemasList());
        } else {
            throw new IllegalArgumentException("Unsupported command type: " + Reflection.getOrCreateKotlinClass(command.getClass()).getSimpleName());
        }
        return cliCommand;
    }

    private static final MigrationsCommandFactory migrationsFactory_delegate$lambda$0(EfCoreCliCommandFactory this$0) {
        return MigrationsCommandFactory.Companion.getInstance(this$0.project);
    }

    private static final DatabaseCommandFactory databaseFactory_delegate$lambda$0(EfCoreCliCommandFactory this$0) {
        return DatabaseCommandFactory.Companion.getInstance(this$0.project);
    }

    private static final DbContextCommandFactory dbContextFactory_delegate$lambda$0(EfCoreCliCommandFactory this$0) {
        return DbContextCommandFactory.Companion.getInstance(this$0.project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/efcore/cli/api/EfCoreCliCommandFactory$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/efcore/cli/api/EfCoreCliCommandFactory;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.efCore"})
    @SourceDebugExtension(value={"SMAP\nEfCoreCliCommandFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EfCoreCliCommandFactory.kt\ncom/jetbrains/rider/plugins/efcore/cli/api/EfCoreCliCommandFactory$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,55:1\n30#2,2:56\n*S KotlinDebug\n*F\n+ 1 EfCoreCliCommandFactory.kt\ncom/jetbrains/rider/plugins/efcore/cli/api/EfCoreCliCommandFactory$Companion\n*L\n19#1:56,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EfCoreCliCommandFactory getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<EfCoreCliCommandFactory> serviceClass$iv = EfCoreCliCommandFactory.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (EfCoreCliCommandFactory)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

