/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.observables;

import com.jetbrains.observables.Event;
import com.jetbrains.observables.ObservableProperty;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableList;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010)\n\u0000\n\u0002\u0010+\n\u0002\b\u000b\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0017\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u0012J\u001a\u0010\u0013\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\u0012J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0016J\u0015\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010 \u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0016J\u001e\u0010\u001c\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\"2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0016J\u001d\u0010\u0018\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\u0010H\u0016J\u0016\u0010(\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0016J\u0016\u0010)\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010*\u001a\u00028\u00002\u0006\u0010%\u001a\u00020\"H\u0096\u0002\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020\u0019H\u0016J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000.H\u0096\u0002J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00028\u000000H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00028\u0000002\u0006\u0010%\u001a\u00020\"H\u0016J\u0015\u00101\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00102J\u0015\u00103\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00102J\u0015\u00104\u001a\u00028\u00002\u0006\u0010%\u001a\u00020\"H\u0016\u00a2\u0006\u0002\u0010+J\u001e\u00105\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u00106\u001a\u00020\"2\u0006\u00107\u001a\u00020\"H\u0016J\u0016\u00108\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0016J\u001e\u00109\u001a\u00028\u00002\u0006\u0010%\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010:R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR0\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0007R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006;"}, d2={"Lcom/jetbrains/observables/ObservableCollection;", "T", "Lcom/jetbrains/observables/ObservableProperty;", "", "", "initialCollection", "<init>", "(Ljava/util/List;)V", "items", "onAdded", "Lcom/jetbrains/observables/Event;", "getOnAdded", "()Lcom/jetbrains/observables/Event;", "onRemoved", "getOnRemoved", "afterAdded", "", "effect", "Lkotlin/Function1;", "afterRemoved", "value", "getValue", "()Ljava/util/List;", "setValue", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "remove", "removeAll", "size", "", "getSize", "()I", "index", "(ILjava/lang/Object;)V", "clear", "containsAll", "contains", "get", "(I)Ljava/lang/Object;", "isEmpty", "iterator", "", "listIterator", "", "lastIndexOf", "(Ljava/lang/Object;)I", "indexOf", "removeAt", "subList", "fromIndex", "toIndex", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "intellij.rider.plugins.efCore"})
@SourceDebugExtension(value={"SMAP\nObservableCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObservableCollection.kt\ncom/jetbrains/observables/ObservableCollection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n1869#2,2:140\n1869#2,2:142\n1869#2,2:144\n*S KotlinDebug\n*F\n+ 1 ObservableCollection.kt\ncom/jetbrains/observables/ObservableCollection\n*L\n43#1:140,2\n66#1:142,2\n80#1:144,2\n*E\n"})
public class ObservableCollection<T>
extends ObservableProperty<List<? extends T>>
implements List<T>,
KMutableList {
    @NotNull
    private List<T> items;
    @NotNull
    private final Event<T> onAdded;
    @NotNull
    private final Event<T> onRemoved;

    public ObservableCollection(@NotNull List<? extends T> initialCollection) {
        Intrinsics.checkNotNullParameter(initialCollection, (String)"initialCollection");
        super(initialCollection);
        this.items = CollectionsKt.toMutableList((Collection)initialCollection);
        this.onAdded = new Event();
        this.onRemoved = new Event();
    }

    public /* synthetic */ ObservableCollection(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(list);
    }

    @NotNull
    public final Event<T> getOnAdded() {
        return this.onAdded;
    }

    @NotNull
    public final Event<T> getOnRemoved() {
        return this.onRemoved;
    }

    public final void afterAdded(@NotNull Function1<? super T, Unit> effect) {
        Intrinsics.checkNotNullParameter(effect, (String)"effect");
        this.onAdded.plusAssign(effect);
    }

    public final void afterRemoved(@NotNull Function1<? super T, Unit> effect) {
        Intrinsics.checkNotNullParameter(effect, (String)"effect");
        this.onRemoved.plusAssign(effect);
    }

    @Override
    @NotNull
    public List<T> getValue() {
        return this.items;
    }

    @Override
    public void setValue(@NotNull List<? extends T> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (!Intrinsics.areEqual(this.items, value) || !this.isInitialized()) {
            this.items = CollectionsKt.toMutableList((Collection)value);
            this.setInitialized(true);
            this.getOnChange().invoke(value);
        }
    }

    @Override
    public boolean add(T element) {
        if (!this.items.contains(element) && this.items.add(element)) {
            this.onAdded.invoke(element);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean changed = this.items.addAll(elements);
        if (changed) {
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                this.onAdded.invoke(it);
            }
        }
        return changed;
    }

    @Override
    public boolean remove(Object element) {
        boolean removed = false;
        if (this.items.contains(element) && this.items.remove(element)) {
            removed = true;
            this.onRemoved.invoke(element);
        }
        return removed;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean removed = this.items.removeAll(elements);
        if (removed) {
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                this.onRemoved.invoke(it);
            }
        }
        return removed;
    }

    public int getSize() {
        return this.items.size();
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean changed = this.items.addAll(index, elements);
        if (changed) {
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                this.onAdded.invoke(it);
            }
        }
        return changed;
    }

    @Override
    public void add(int index, T element) {
        if (!this.items.contains(element)) {
            this.items.add(index, element);
            this.onAdded.invoke(element);
        }
    }

    @Override
    public void clear() {
        if (!((Collection)this.items).isEmpty()) {
            this.removeAll((Collection)this.items);
        }
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.items.containsAll(elements);
    }

    @Override
    public boolean contains(Object element) {
        return this.items.contains(element);
    }

    @Override
    public T get(int index) {
        return this.items.get(index);
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return this.items.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        return this.items.listIterator(index);
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.items.lastIndexOf(element);
    }

    @Override
    public int indexOf(Object element) {
        return this.items.indexOf(element);
    }

    public T removeAt(int index) {
        T item = this.items.remove(index);
        this.onRemoved.invoke(item);
        return item;
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        return this.items.subList(fromIndex, toIndex);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List elementsToRemove = CollectionsKt.minus((Iterable)this.items, (Iterable)elements);
        return this.removeAll(elementsToRemove);
    }

    @Override
    public T set(int index, T element) {
        T old = this.items.set(index, element);
        this.onRemoved.invoke(old);
        this.onAdded.invoke(element);
        return old;
    }

    public ObservableCollection() {
        this(null, 1, null);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

