/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.jetbrains.dotCommon.CoroutineUtilsKt;
import com.jetbrains.dotCommon.externalAppToolWindow.common.CursorMapper;
import com.jetbrains.dotCommon.externalAppToolWindow.common.ResolutionFactory;
import com.jetbrains.dotCommon.externalAppToolWindow.inputHandlers.WindowInputHandlersBundle;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.Frame;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.FrameBufferStorageChannel;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.LoadingPanel;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.RemoteWidget;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.RemoteWindowKt;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.WindowTitle;
import com.jetbrains.rd.ide.model.BaseServerMessage;
import com.jetbrains.rd.ide.model.CloseWindow;
import com.jetbrains.rd.ide.model.ExternalAppInputModel;
import com.jetbrains.rd.ide.model.ExternalAppServerModel;
import com.jetbrains.rd.ide.model.FrameReceivedMessage;
import com.jetbrains.rd.ide.model.InitFramebufferMessage;
import com.jetbrains.rd.ide.model.NewCursorMessage;
import com.jetbrains.rd.ide.model.NewFrameMessage;
import com.jetbrains.rd.ide.model.ResizeWindowMessage;
import com.jetbrains.rd.ide.model.Resolution;
import com.jetbrains.rd.ide.model.WindowRootGotFocusMessage;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsConfiguration;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.YieldKt;
import kotlinx.coroutines.channels.ClosedReceiveChannelException;
import kotlinx.coroutines.channels.ReceiveChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 A2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001AB\u0085\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\b\u0010+\u001a\u00020\u001bH\u0002J\b\u0010,\u001a\u00020\u001bH\u0002J\b\u0010-\u001a\u00020\u001bH\u0016J\u0006\u0010.\u001a\u00020\u001bJ\u0010\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\nH\u0002J\u0010\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u001b2\u0006\u00102\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020\u001b2\u0006\u00102\u001a\u000207H\u0002J\b\u00108\u001a\u00020\u001bH\u0016J\b\u00109\u001a\u00020\u001bH\u0016J\b\u0010:\u001a\u00020\u001bH\u0002J\u0012\u0010;\u001a\u00020\u001b2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J\u0012\u0010>\u001a\u00020\u001b2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J\u0012\u0010?\u001a\u00020\u001b2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J\u0012\u0010@\u001a\u00020\u001b2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/RemoteWindow;", "Ljavax/swing/JPanel;", "Ljava/awt/event/ComponentListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "windowId", "Ljava/util/UUID;", "Lcom/jetbrains/rd/util/UUID;", "isDocument", "", "windowTitle", "Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/WindowTitle;", "loadingPanel", "Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/LoadingPanel;", "frameBufferStorage", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameBufferStorageChannel;", "inputModel", "Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;", "renderModel", "Lcom/jetbrains/rd/ide/model/ExternalAppServerModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "rdDispatcher", "Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "onWindowShownCallback", "Lkotlin/Function0;", "", "onWindowClosedCallback", "requestFocusEditor", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/UUID;ZLcom/jetbrains/dotCommon/externalAppToolWindow/ui/WindowTitle;Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/LoadingPanel;Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameBufferStorageChannel;Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;Lcom/jetbrains/rd/ide/model/ExternalAppServerModel;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getWindowId", "()Ljava/util/UUID;", "getLoadingPanel", "()Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/LoadingPanel;", "isClosed", "remoteWidget", "Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/RemoteWidget;", "inputHandlersBundle", "Lcom/jetbrains/dotCommon/externalAppToolWindow/inputHandlers/WindowInputHandlersBundle;", "launchRenderRoutine", "disposeInternal", "dispose", "close", "toggleWidgetVisibility", "visible", "handleNewFrame", "msg", "Lcom/jetbrains/rd/ide/model/NewFrameMessage;", "handleNewCursor", "Lcom/jetbrains/rd/ide/model/NewCursorMessage;", "handleServerMessage", "Lcom/jetbrains/rd/ide/model/BaseServerMessage;", "addNotify", "removeNotify", "sendResize", "componentResized", "e", "Ljava/awt/event/ComponentEvent;", "componentMoved", "componentShown", "componentHidden", "Companion", "intellij.rider.plugins.dotCommon"})
public final class RemoteWindow
extends JPanel
implements ComponentListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final UUID windowId;
    private final boolean isDocument;
    @NotNull
    private final WindowTitle windowTitle;
    @NotNull
    private final LoadingPanel loadingPanel;
    @NotNull
    private final FrameBufferStorageChannel frameBufferStorage;
    @NotNull
    private final ExternalAppInputModel inputModel;
    @NotNull
    private final ExternalAppServerModel renderModel;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final IRdDispatcher rdDispatcher;
    @NotNull
    private final Function0<Unit> onWindowShownCallback;
    @NotNull
    private final Function0<Unit> onWindowClosedCallback;
    @NotNull
    private final Function0<Unit> requestFocusEditor;
    private boolean isClosed;
    @Nullable
    private RemoteWidget remoteWidget;
    @NotNull
    private final WindowInputHandlersBundle inputHandlersBundle;
    @NotNull
    private static final FrameReceivedMessage frameReceivedMessageInstance = new FrameReceivedMessage();

    public RemoteWindow(@NotNull Project project, @NotNull UUID windowId, boolean isDocument, @NotNull WindowTitle windowTitle, @NotNull LoadingPanel loadingPanel, @NotNull FrameBufferStorageChannel frameBufferStorage, @NotNull ExternalAppInputModel inputModel, @NotNull ExternalAppServerModel renderModel, @NotNull Lifetime lifetime, @NotNull IRdDispatcher rdDispatcher, @NotNull Function0<Unit> onWindowShownCallback, @NotNull Function0<Unit> onWindowClosedCallback, @NotNull Function0<Unit> requestFocusEditor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        Intrinsics.checkNotNullParameter((Object)windowTitle, (String)"windowTitle");
        Intrinsics.checkNotNullParameter((Object)loadingPanel, (String)"loadingPanel");
        Intrinsics.checkNotNullParameter((Object)frameBufferStorage, (String)"frameBufferStorage");
        Intrinsics.checkNotNullParameter((Object)inputModel, (String)"inputModel");
        Intrinsics.checkNotNullParameter((Object)renderModel, (String)"renderModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)rdDispatcher, (String)"rdDispatcher");
        Intrinsics.checkNotNullParameter(onWindowShownCallback, (String)"onWindowShownCallback");
        Intrinsics.checkNotNullParameter(onWindowClosedCallback, (String)"onWindowClosedCallback");
        Intrinsics.checkNotNullParameter(requestFocusEditor, (String)"requestFocusEditor");
        this.project = project;
        this.windowId = windowId;
        this.isDocument = isDocument;
        this.windowTitle = windowTitle;
        this.loadingPanel = loadingPanel;
        this.frameBufferStorage = frameBufferStorage;
        this.inputModel = inputModel;
        this.renderModel = renderModel;
        this.lifetime = lifetime;
        this.rdDispatcher = rdDispatcher;
        this.onWindowShownCallback = onWindowShownCallback;
        this.onWindowClosedCallback = onWindowClosedCallback;
        this.requestFocusEditor = requestFocusEditor;
        this.isClosed = false;
        this.setOpaque(false);
        this.setBackground(JBColor.background());
        this.inputHandlersBundle = new WindowInputHandlersBundle(this.inputModel, this, this.rdDispatcher);
        this.frameBufferStorage.registerWindow(this.windowId);
        this.setBorder(this.isDocument ? BorderFactory.createEmptyBorder(4, 4, 4, 4) : BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.addComponentListener(this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (remoteWidget != null) {
                    RemoteWidget remoteWidget = remoteWidget;
                    Intrinsics.checkNotNull((Object)((Object)remoteWidget));
                    remoteWidget.requestFocusInWindow();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.loadingPanel, "Center");
        this.toggleWidgetVisibility(false);
        this.renderModel.getServerMessage().advise(this.lifetime, arg_0 -> RemoteWindow._init_$lambda$0(this, arg_0));
        this.launchRenderRoutine();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final UUID getWindowId() {
        return this.windowId;
    }

    @NotNull
    public final LoadingPanel getLoadingPanel() {
        return this.loadingPanel;
    }

    private final void launchRenderRoutine() {
        BuildersKt.launch$default((CoroutineScope)CoroutineUtilsKt.coroutineScope(this.project), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ RemoteWindow this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        frameChannel = RemoteWindow.access$getFrameBufferStorage$p(this.this$0).getFrameChannel(this.this$0.getWindowId());
lbl6:
                        // 5 sources

                        while (!frameChannel.isClosedForReceive()) {
                            this.L$0 = frameChannel;
                            this.L$1 = null;
                            this.label = 1;
                            v0 = frameChannel.receive((Continuation)this);
                            ** if (v0 != var4_2) goto lbl15
lbl14:
                            // 1 sources

                            return var4_2;
lbl15:
                            // 1 sources

                            ** GOTO lbl23
                        }
                        break;
                    }
                    case 1: {
                        frameChannel = (ReceiveChannel<Frame>)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl23:
                        // 2 sources

                        frame = (Frame)v0;
                        if (!Intrinsics.areEqual((Object)RemoteWindow.access$getFrameBufferStorage$p(this.this$0).getCurrentOwner(), (Object)this.this$0.getWindowId())) ** GOTO lbl6
                        if (RemoteWindow.access$isClosed$p(this.this$0) || RemoteWindow.access$getFrameBufferStorage$p(this.this$0).isDisposed()) {
                            return Unit.INSTANCE;
                        }
                        RemoteWindow.access$getFrameBufferStorage$p(this.this$0).frameRead(this.this$0.getWindowId());
                        v1 = RemoteWindow.access$getRemoteWidget$p(this.this$0);
                        if (v1 != null) {
                            v1.scheduleFrame(frame);
                        }
                        this.L$0 = frameChannel;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)frame);
                        this.label = 2;
                        v2 = YieldKt.yield((Continuation)((Continuation)this));
                        ** if (v2 != var4_2) goto lbl37
lbl36:
                        // 1 sources

                        return var4_2;
lbl37:
                        // 1 sources

                        ** GOTO lbl45
                    }
                    case 2: {
                        frame = (Frame)this.L$1;
                        frameChannel = (ReceiveChannel)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl45:
                            // 2 sources

                            if (!Intrinsics.areEqual((Object)RemoteWindow.access$getFrameBufferStorage$p(this.this$0).getCurrentOwner(), (Object)this.this$0.getWindowId())) ** GOTO lbl6
                            RemoteWindow.access$getRdDispatcher$p(this.this$0).queue((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.jetbrains.dotCommon.externalAppToolWindow.ui.RemoteWindow ), ()Lkotlin/Unit;)((RemoteWindow)this.this$0));
                        }
                        catch (ClosedReceiveChannelException <unused var>) {
                            RemoteWindowKt.access$getLogger$p().info(RemoteWindow.access$getWindowTitle$p(this.this$0) + " has been closed and frame channel has been finished");
                        }
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(RemoteWindow this$0) {
                RemoteWindow.access$getRenderModel$p(this$0).getFrameReceivedSignal().fire((Object)RemoteWindow.access$getFrameReceivedMessageInstance$cp());
                return Unit.INSTANCE;
            }
        }), (int)2, null);
    }

    private final void disposeInternal() {
        this.frameBufferStorage.closeWindowChannel(this.windowId);
        this.removeComponentListener(this);
    }

    public void dispose() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.disposeInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        try {
            this.isClosed = true;
            RemoteWidget remoteWidget = this.remoteWidget;
            if (remoteWidget != null) {
                remoteWidget.close();
            }
            this.disposeInternal();
        }
        finally {
            this.inputModel.getClientMessage().fire((Object)new CloseWindow());
        }
        RemoteWindowKt.access$getLogger$p().info(this.windowTitle + " has been closed");
    }

    private final void toggleWidgetVisibility(boolean visible) {
        RemoteWidget remoteWidget = this.remoteWidget;
        if (remoteWidget != null) {
            remoteWidget.setVisible(visible);
        }
        this.loadingPanel.setVisibility(!visible);
    }

    private final void handleNewFrame(NewFrameMessage msg) {
        if (msg.getRenderWidth() <= 0 || msg.getRenderHeight() <= 0) {
            this.frameBufferStorage.skipFrame();
            this.rdDispatcher.queue(() -> RemoteWindow.handleNewFrame$lambda$0(this));
            return;
        }
        if (this.remoteWidget != null) {
            RemoteWidget remoteWidget = this.remoteWidget;
            Intrinsics.checkNotNull((Object)((Object)remoteWidget));
            if (!remoteWidget.isVisible()) {
                this.toggleWidgetVisibility(true);
                RemoteWidget remoteWidget2 = this.remoteWidget;
                Intrinsics.checkNotNull((Object)((Object)remoteWidget2));
                remoteWidget2.requestFocusInWindow();
            }
        }
        this.frameBufferStorage.nextFrameAvailable(msg);
    }

    private final void handleNewCursor(NewCursorMessage msg) {
        this.setCursor(Cursor.getPredefinedCursor(CursorMapper.Companion.mapCursorType(msg.getCursorType())));
    }

    private final void handleServerMessage(BaseServerMessage msg) {
        BaseServerMessage baseServerMessage = msg;
        if (baseServerMessage instanceof NewFrameMessage) {
            this.handleNewFrame((NewFrameMessage)msg);
        } else if (baseServerMessage instanceof InitFramebufferMessage) {
            this.frameBufferStorage.resize((InitFramebufferMessage)msg);
        } else if (baseServerMessage instanceof NewCursorMessage) {
            this.handleNewCursor((NewCursorMessage)msg);
        } else if (baseServerMessage instanceof WindowRootGotFocusMessage) {
            if (this.isFocusOwner()) {
                return;
            }
            this.requestFocusEditor.invoke();
        }
    }

    @Override
    public void addNotify() {
        if (this.lifetime.getStatus() != LifetimeStatus.Alive) {
            return;
        }
        RemoteWidget remoteWidget = this.remoteWidget = new RemoteWidget(this.inputModel, this.inputHandlersBundle, this.rdDispatcher);
        Intrinsics.checkNotNull((Object)((Object)remoteWidget));
        remoteWidget.attachTo(this);
        RemoteWidget remoteWidget2 = this.remoteWidget;
        Intrinsics.checkNotNull((Object)((Object)remoteWidget2));
        this.add((Component)((Object)remoteWidget2), "Center");
        this.frameBufferStorage.acquireOwnership(this.windowId);
        super.addNotify();
        this.toggleWidgetVisibility(false);
        this.sendResize();
        this.onWindowShownCallback.invoke();
        Logger logger = RemoteWindowKt.access$getLogger$p();
        RemoteWidget remoteWidget3 = this.remoteWidget;
        Intrinsics.checkNotNull((Object)((Object)remoteWidget3));
        logger.info(this.windowTitle + " has been initialized. Used render API: " + remoteWidget3.getRenderApi());
    }

    @Override
    public void removeNotify() {
        if (this.remoteWidget != null) {
            RemoteWidget remoteWidget = this.remoteWidget;
            Intrinsics.checkNotNull((Object)((Object)remoteWidget));
            remoteWidget.setSize(0, 0);
            RemoteWidget remoteWidget2 = this.remoteWidget;
            Intrinsics.checkNotNull((Object)((Object)remoteWidget2));
            remoteWidget2.setVisible(false);
            RemoteWidget remoteWidget3 = this.remoteWidget;
            Intrinsics.checkNotNull((Object)((Object)remoteWidget3));
            remoteWidget3.dispose();
            this.remove((Component)((Object)this.remoteWidget));
            this.remoteWidget = null;
        }
        this.toggleWidgetVisibility(false);
        this.onWindowClosedCallback.invoke();
        super.removeNotify();
    }

    private final void sendResize() {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getGraphicsConfiguration(...)");
        Resolution resolution = ResolutionFactory.Companion.create(n, n2, graphicsConfiguration);
        this.rdDispatcher.queue(() -> RemoteWindow.sendResize$lambda$0(this, resolution));
    }

    @Override
    public void componentResized(@Nullable ComponentEvent e) {
        this.loadingPanel.setSize(this.getWidth(), this.getHeight());
        RemoteWidget remoteWidget = this.remoteWidget;
        Intrinsics.checkNotNull((Object)((Object)remoteWidget));
        remoteWidget.setSize(this.getWidth(), this.getHeight());
        this.sendResize();
    }

    @Override
    public void componentMoved(@Nullable ComponentEvent e) {
    }

    @Override
    public void componentShown(@Nullable ComponentEvent e) {
    }

    @Override
    public void componentHidden(@Nullable ComponentEvent e) {
    }

    private static final Unit _init_$lambda$0(RemoteWindow this$0, BaseServerMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this$0.handleServerMessage(msg);
        return Unit.INSTANCE;
    }

    private static final Unit handleNewFrame$lambda$0(RemoteWindow this$0) {
        this$0.renderModel.getFrameReceivedSignal().fire((Object)frameReceivedMessageInstance);
        return Unit.INSTANCE;
    }

    private static final Unit sendResize$lambda$0(RemoteWindow this$0, Resolution $resolution) {
        this$0.inputModel.getClientMessage().fire((Object)new ResizeWindowMessage($resolution));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ FrameBufferStorageChannel access$getFrameBufferStorage$p(RemoteWindow $this) {
        return $this.frameBufferStorage;
    }

    public static final /* synthetic */ boolean access$isClosed$p(RemoteWindow $this) {
        return $this.isClosed;
    }

    public static final /* synthetic */ IRdDispatcher access$getRdDispatcher$p(RemoteWindow $this) {
        return $this.rdDispatcher;
    }

    public static final /* synthetic */ WindowTitle access$getWindowTitle$p(RemoteWindow $this) {
        return $this.windowTitle;
    }

    public static final /* synthetic */ ExternalAppServerModel access$getRenderModel$p(RemoteWindow $this) {
        return $this.renderModel;
    }

    public static final /* synthetic */ FrameReceivedMessage access$getFrameReceivedMessageInstance$cp() {
        return frameReceivedMessageInstance;
    }

    static {
        if (System.getProperty("skiko.library.path") == null) {
            String string = PathManager.getLibPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLibPath(...)");
            Path path = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path path2 = path;
            Path path3 = path2.resolve("skiko-awt-runtime-all");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            Path bundledSkikoFolder = path3;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory(bundledSkikoFolder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                System.setProperty("skiko.library.path", ((Object)bundledSkikoFolder).toString());
                RemoteWindowKt.access$getLogger$p().info("Bundled Skiko has been initialized.");
            } else {
                RemoteWindowKt.access$getLogger$p().warn("Bundled Skiko not found/not readable, falling back to default");
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/RemoteWindow$Companion;", "", "<init>", "()V", "frameReceivedMessageInstance", "Lcom/jetbrains/rd/ide/model/FrameReceivedMessage;", "intellij.rider.plugins.dotCommon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

