/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.persistentMemoryMappedFile;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.ByteBufferUtil;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.Frame;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.FrameSize;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.persistentMemoryMappedFile.PersistentMemoryFrameMapper;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/persistentMemoryMappedFile/PersistentMemoryFrame;", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/Frame;", "filePath", "", "frameSize", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameSize;", "frameBufferFile", "Ljava/io/RandomAccessFile;", "mappedContent", "Ljava/nio/ByteBuffer;", "frameMapper", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/persistentMemoryMappedFile/PersistentMemoryFrameMapper;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameSize;Ljava/io/RandomAccessFile;Ljava/nio/ByteBuffer;Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/persistentMemoryMappedFile/PersistentMemoryFrameMapper;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "size", "getSize", "()Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameSize;", "content", "getContent", "()Ljava/nio/ByteBuffer;", "mapToNewLocation", "location", "renderSizeHasChanged", "", "newRenderWidth", "", "newRenderHeight", "unmap", "", "close", "intellij.rider.plugins.dotCommon"})
@SourceDebugExtension(value={"SMAP\nPersistentMemoryFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentMemoryFrame.kt\ncom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/persistentMemoryMappedFile/PersistentMemoryFrame\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,55:1\n13#2:56\n13#3:57\n*S KotlinDebug\n*F\n+ 1 PersistentMemoryFrame.kt\ncom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/persistentMemoryMappedFile/PersistentMemoryFrame\n*L\n20#1:56\n20#1:57\n*E\n"})
public final class PersistentMemoryFrame
implements Frame {
    @NotNull
    private final String filePath;
    @NotNull
    private FrameSize frameSize;
    @NotNull
    private final RandomAccessFile frameBufferFile;
    @NotNull
    private final ByteBuffer mappedContent;
    @NotNull
    private final PersistentMemoryFrameMapper frameMapper;
    @NotNull
    private final Logger logger;

    public PersistentMemoryFrame(@NotNull String filePath, @NotNull FrameSize frameSize, @NotNull RandomAccessFile frameBufferFile, @NotNull ByteBuffer mappedContent, @NotNull PersistentMemoryFrameMapper frameMapper) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)frameSize, (String)"frameSize");
        Intrinsics.checkNotNullParameter((Object)frameBufferFile, (String)"frameBufferFile");
        Intrinsics.checkNotNullParameter((Object)mappedContent, (String)"mappedContent");
        Intrinsics.checkNotNullParameter((Object)frameMapper, (String)"frameMapper");
        this.filePath = filePath;
        this.frameSize = frameSize;
        this.frameBufferFile = frameBufferFile;
        this.mappedContent = mappedContent;
        this.frameMapper = frameMapper;
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PersistentMemoryFrame.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Override
    @NotNull
    public FrameSize getSize() {
        return this.frameSize;
    }

    @Override
    @NotNull
    public ByteBuffer getContent() {
        return this.mappedContent;
    }

    @Override
    @NotNull
    public Frame mapToNewLocation(@NotNull String location, @NotNull FrameSize size) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        if (this.unmap()) {
            try {
                Files.delete(Path.of(this.filePath, new String[0]));
            }
            catch (Exception ex) {
                this.logger.error("Frame '" + location + "': Failed to unmap frame", (Throwable)ex);
            }
        }
        return this.frameMapper.mapFrame(location, size);
    }

    @Override
    public void renderSizeHasChanged(int newRenderWidth, int newRenderHeight) {
        this.frameSize = this.frameSize.withRenderSize(newRenderWidth, newRenderHeight);
    }

    private final boolean unmap() {
        this.frameBufferFile.close();
        this.frameBufferFile.getChannel().close();
        return ByteBufferUtil.cleanBuffer((ByteBuffer)this.mappedContent);
    }

    @Override
    public void close() {
        this.unmap();
    }
}

