/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.rendering;

import com.intellij.openapi.Disposable;
import com.intellij.ui.JBColor;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.Frame;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.ColorType;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skiko.SkikoRenderDelegate;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/FrameRenderer;", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "renderWidth", "", "renderHeight", "frameSize", "nextFrame", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/FrameRenderer$FrameMemory;", "setNextFrame", "", "frame", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/Frame;", "onRender", "canvas", "Lorg/jetbrains/skia/Canvas;", "width", "height", "nanoTime", "", "dispose", "FrameMemory", "intellij.rider.plugins.dotCommon"})
public final class FrameRenderer
implements SkikoRenderDelegate,
Disposable {
    private int renderWidth;
    private int renderHeight;
    private int frameSize;
    @Nullable
    private FrameMemory nextFrame;

    public final void setNextFrame(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        int newFrameSize = frame.getSize().getBufferSize();
        this.renderWidth = frame.getSize().getRenderWidth();
        this.renderHeight = frame.getSize().getRenderHeight();
        if (this.frameSize != newFrameSize) {
            if (this.nextFrame != null) {
                FrameMemory frameMemory = this.nextFrame;
                Intrinsics.checkNotNull((Object)frameMemory);
                frameMemory.free();
            }
            this.nextFrame = new FrameMemory(newFrameSize);
            this.frameSize = newFrameSize;
        }
        FrameMemory frameMemory = this.nextFrame;
        Intrinsics.checkNotNull((Object)frameMemory);
        frameMemory.copy(frame.getContent());
    }

    public void onRender(@NotNull Canvas canvas, int width, int height, long nanoTime) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.clear(JBColor.background().getRGB());
        if (this.nextFrame == null) {
            return;
        }
        FrameMemory frameMemory = this.nextFrame;
        Intrinsics.checkNotNull((Object)frameMemory);
        frameMemory.initImageObjectsIfNeeded(this.renderWidth, this.renderHeight);
        FrameMemory frameMemory2 = this.nextFrame;
        Intrinsics.checkNotNull((Object)frameMemory2);
        Image image = frameMemory2.getImg();
        Intrinsics.checkNotNull((Object)image);
        canvas.drawImage(image, 0.0f, 0.0f);
    }

    public void dispose() {
        if (this.nextFrame != null) {
            FrameMemory disposedFrameMemory = this.nextFrame;
            SwingUtilities.invokeLater(() -> FrameRenderer.dispose$lambda$0(disposedFrameMemory));
            this.nextFrame = null;
        }
    }

    private static final void dispose$lambda$0(FrameMemory $disposedFrameMemory) {
        FrameMemory frameMemory = $disposedFrameMemory;
        Intrinsics.checkNotNull((Object)frameMemory);
        frameMemory.free();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u000bJ\u0006\u0010\u001c\u001a\u00020\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/FrameRenderer$FrameMemory;", "", "size", "", "<init>", "(I)V", "imgData", "Lorg/jetbrains/skia/Data;", "getImgData", "()Lorg/jetbrains/skia/Data;", "imgBuffer", "Ljava/nio/ByteBuffer;", "previousRenderWidth", "previousRenerHeight", "pixmap", "Lorg/jetbrains/skia/Pixmap;", "img", "Lorg/jetbrains/skia/Image;", "getImg", "()Lorg/jetbrains/skia/Image;", "setImg", "(Lorg/jetbrains/skia/Image;)V", "initImageObjectsIfNeeded", "", "renderWidth", "renderHeight", "copy", "newFrame", "free", "intellij.rider.plugins.dotCommon"})
    private static final class FrameMemory {
        @NotNull
        private final Data imgData;
        @NotNull
        private final ByteBuffer imgBuffer;
        private int previousRenderWidth;
        private int previousRenerHeight;
        @Nullable
        private Pixmap pixmap;
        @Nullable
        private Image img;

        public FrameMemory(int size) {
            this.imgData = Data.Companion.makeUninitialized(size);
            ByteBuffer byteBuffer = new Pointer(this.imgData.writableData()).getByteBuffer(0L, (long)size);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getByteBuffer(...)");
            this.imgBuffer = byteBuffer;
        }

        @NotNull
        public final Data getImgData() {
            return this.imgData;
        }

        @Nullable
        public final Image getImg() {
            return this.img;
        }

        public final void setImg(@Nullable Image image) {
            this.img = image;
        }

        public final void initImageObjectsIfNeeded(int renderWidth, int renderHeight) {
            if (renderWidth == this.previousRenderWidth && renderHeight == this.previousRenerHeight) {
                if (this.img != null) {
                    Image image = this.img;
                    Intrinsics.checkNotNull((Object)image);
                    if (!image.isClosed()) {
                        Image image2 = this.img;
                        Intrinsics.checkNotNull((Object)image2);
                        image2.close();
                    }
                }
                Pixmap pixmap = this.pixmap;
                Intrinsics.checkNotNull((Object)pixmap);
                this.img = Image.Companion.makeFromPixmap(pixmap);
                return;
            }
            this.previousRenderWidth = renderWidth;
            this.previousRenerHeight = renderHeight;
            ImageInfo imgInfo = new ImageInfo(renderWidth, renderHeight, ColorType.BGRA_8888, ColorAlphaType.OPAQUE, ColorSpace.Companion.getSRGB());
            Pixmap pixmap = this.pixmap = Pixmap.Companion.make(imgInfo, this.imgData, renderWidth * 4);
            Intrinsics.checkNotNull((Object)pixmap);
            this.img = Image.Companion.makeFromPixmap(pixmap);
        }

        public final void copy(@NotNull ByteBuffer newFrame) {
            Intrinsics.checkNotNullParameter((Object)newFrame, (String)"newFrame");
            newFrame.rewind();
            this.imgBuffer.rewind();
            this.imgBuffer.put(newFrame);
        }

        public final void free() {
            if (this.img != null) {
                Image image = this.img;
                Intrinsics.checkNotNull((Object)image);
                if (!image.isClosed()) {
                    Image image2 = this.img;
                    Intrinsics.checkNotNull((Object)image2);
                    image2.close();
                }
            }
            if (this.pixmap != null) {
                Pixmap pixmap = this.pixmap;
                Intrinsics.checkNotNull((Object)pixmap);
                if (!pixmap.isClosed()) {
                    Pixmap pixmap2 = this.pixmap;
                    Intrinsics.checkNotNull((Object)pixmap2);
                    pixmap2.close();
                }
            }
            if (!this.imgData.isClosed()) {
                this.imgData.close();
            }
        }
    }
}

