/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.remoteDocumentWindow;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.dotCommon.externalAppToolWindow.common.ObjectExtensionsKt;
import com.jetbrains.dotCommon.externalAppToolWindow.remoteDocumentWindow.RemoteDocumentWindowFile;
import com.jetbrains.dotCommon.externalAppToolWindow.remoteDocumentWindow.RemoteDocumentWindowInternals;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.RemoteWindow;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.UUID;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/remoteDocumentWindow/RemoteDocumentWindow;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "remoteWindow", "Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/RemoteWindow;", "vFile", "Lcom/jetbrains/dotCommon/externalAppToolWindow/remoteDocumentWindow/RemoteDocumentWindowFile;", "controlRegistry", "", "Ljava/util/UUID;", "Lcom/jetbrains/dotCommon/externalAppToolWindow/remoteDocumentWindow/RemoteDocumentWindowInternals;", "docWindowLifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "<init>", "(Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/RemoteWindow;Lcom/jetbrains/dotCommon/externalAppToolWindow/remoteDocumentWindow/RemoteDocumentWindowFile;Ljava/util/Map;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "disposed", "", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getName", "", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "isModified", "isValid", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "getCurrentLocation", "Lcom/intellij/openapi/fileEditor/FileEditorLocation;", "intellij.rider.plugins.dotCommon"})
public final class RemoteDocumentWindow
extends UserDataHolderBase
implements FileEditor {
    @NotNull
    private final RemoteWindow remoteWindow;
    @NotNull
    private final RemoteDocumentWindowFile vFile;
    @NotNull
    private final Map<UUID, RemoteDocumentWindowInternals> controlRegistry;
    @NotNull
    private final LifetimeDefinition docWindowLifetimeDef;
    private boolean disposed;

    public RemoteDocumentWindow(@NotNull RemoteWindow remoteWindow, @NotNull RemoteDocumentWindowFile vFile, @NotNull Map<UUID, RemoteDocumentWindowInternals> controlRegistry, @NotNull LifetimeDefinition docWindowLifetimeDef) {
        Intrinsics.checkNotNullParameter((Object)remoteWindow, (String)"remoteWindow");
        Intrinsics.checkNotNullParameter((Object)((Object)vFile), (String)"vFile");
        Intrinsics.checkNotNullParameter(controlRegistry, (String)"controlRegistry");
        Intrinsics.checkNotNullParameter((Object)docWindowLifetimeDef, (String)"docWindowLifetimeDef");
        this.remoteWindow = remoteWindow;
        this.vFile = vFile;
        this.controlRegistry = controlRegistry;
        this.docWindowLifetimeDef = docWindowLifetimeDef;
    }

    @NotNull
    public VirtualFile getFile() {
        return (VirtualFile)this.vFile;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        boolean isReopen = ObjectExtensionsKt.falseIfNull((Boolean)this.vFile.getUserData(FileEditorManagerKeys.CLOSING_TO_REOPEN));
        if (!isReopen) {
            this.disposed = true;
            this.controlRegistry.remove(this.vFile.getWindowId());
            this.remoteWindow.close();
            LifetimeDefinition.terminate$default((LifetimeDefinition)this.docWindowLifetimeDef, (boolean)false, (int)1, null);
        }
    }

    @NotNull
    public JComponent getComponent() {
        return this.remoteWindow;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.remoteWindow;
    }

    @NotNull
    public String getName() {
        return "RemoteDocumentWindow";
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }
}

