/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.license;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.JBAccountInfoService;
import com.intellij.ui.LicensingFacade;
import com.jetbrains.dotCommon.externalAppToolWindow.license.CommonCheckLicense;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Signature;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0013J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0011J\u0016\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\u0015J\"\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0005H\u0002J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0005H\u0002J&\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020)0+2\u0006\u0010,\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/license/CommonCheckLicense;", "", "<init>", "()V", "KEY_PREFIX", "", "STAMP_PREFIX", "EVAL_PREFIX", "ROOT_CERTIFICATES", "", "[Ljava/lang/String;", "SECOND", "", "MINUTE", "HOUR", "TIMESTAMP_VALIDITY_PERIOD_MS", "getIsLicensed", "", "productCode", "(Ljava/lang/String;)Ljava/lang/Boolean;", "requestLicense", "", "message", "silentTrial", "startTrial", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showLicenseDialog", "register", "activateTrial", "asDataContextForDialog", "Lcom/intellij/openapi/actionSystem/DataContext;", "asDataContextForTrialActivation", "isEvaluationValid", "expirationTime", "isKeyValid", "key", "isLicenseServerStampValid", "serverStamp", "createCertificate", "Ljava/security/cert/X509Certificate;", "certBytes", "", "intermediateCertsBytes", "", "checkValidityAtCurrentDate", "intellij.rider.plugins.dotCommon"})
@SourceDebugExtension(value={"SMAP\nCommonCheckLicense.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonCheckLicense.kt\ncom/jetbrains/dotCommon/externalAppToolWindow/license/CommonCheckLicense\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,354:1\n23#2:355\n67#2,4:356\n67#2,4:360\n67#2,4:364\n67#2,4:368\n23#2:372\n739#3,9:373\n739#3,9:384\n37#4,2:382\n37#4,2:393\n*S KotlinDebug\n*F\n+ 1 CommonCheckLicense.kt\ncom/jetbrains/dotCommon/externalAppToolWindow/license/CommonCheckLicense\n*L\n133#1:355\n134#1:356,4\n136#1:360,4\n141#1:364,4\n147#1:368,4\n186#1:372\n246#1:373,9\n280#1:384,9\n246#1:382,2\n280#1:393,2\n*E\n"})
public final class CommonCheckLicense {
    @NotNull
    public static final CommonCheckLicense INSTANCE = new CommonCheckLicense();
    @NotNull
    private static final String KEY_PREFIX = "key:";
    @NotNull
    private static final String STAMP_PREFIX = "stamp:";
    @NotNull
    private static final String EVAL_PREFIX = "eval:";
    @NotNull
    private static final String[] ROOT_CERTIFICATES;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long TIMESTAMP_VALIDITY_PERIOD_MS = 3600000L;

    private CommonCheckLicense() {
    }

    @Nullable
    public final Boolean getIsLicensed(@NotNull String productCode) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        LicensingFacade licensingFacade = LicensingFacade.getInstance();
        if (licensingFacade == null) {
            return null;
        }
        LicensingFacade facade = licensingFacade;
        String string = facade.getConfirmationStamp(productCode);
        if (string == null) {
            return false;
        }
        String cstamp = string;
        if (((CharSequence)cstamp).length() == 0) {
            return null;
        }
        if (StringsKt.startsWith$default((String)cstamp, (String)KEY_PREFIX, (boolean)false, (int)2, null)) {
            String string2 = cstamp.substring(4);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return this.isKeyValid(string2);
        }
        if (StringsKt.startsWith$default((String)cstamp, (String)STAMP_PREFIX, (boolean)false, (int)2, null)) {
            String string3 = cstamp.substring(6);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            return this.isLicenseServerStampValid(string3);
        }
        if (StringsKt.startsWith$default((String)cstamp, (String)EVAL_PREFIX, (boolean)false, (int)2, null)) {
            String string4 = cstamp.substring(5);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            bl = this.isEvaluationValid(string4);
        } else {
            bl = false;
        }
        return bl;
    }

    public final void requestLicense(@NotNull String productCode, @Nullable String message, boolean silentTrial) {
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        if (silentTrial && Intrinsics.areEqual((Object)this.getIsLicensed(productCode), (Object)true)) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> CommonCheckLicense.requestLicense$lambda$0(productCode, message, silentTrial), ModalityState.nonModal());
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object startTrial(@NotNull String productCode, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof startTrial.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ CommonCheckLicense this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.startTrial(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$thisLogger$iv = this;
                $i$f$thisLogger = false;
                v0 = Logger.getInstance(CommonCheckLicense.class);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                $this$trace$iv = logger = v0;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var9_14 = $this$trace$iv;
                    $i$a$-trace-CommonCheckLicense$startTrial$2 = false;
                    var9_14.trace("Requesting license status for product " + productCode + "\u2026");
                }
                if (Intrinsics.areEqual((Object)this.getIsLicensed(productCode), (Object)Boxing.boxBoolean((boolean)true))) {
                    $this$trace$iv = logger;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var9_14 = $this$trace$iv;
                        $i$a$-trace-CommonCheckLicense$startTrial$3 = false;
                        var9_14.trace(productCode + " is already licensed.");
                    }
                    return Boxing.boxBoolean((boolean)false);
                }
                accService = JBAccountInfoService.getInstance();
                if (accService == null) {
                    $this$trace$iv = logger;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var9_14 = $this$trace$iv;
                        $i$a$-trace-CommonCheckLicense$startTrial$4 = false;
                        var9_14.trace("The account service is not found.");
                    }
                    return Boxing.boxBoolean((boolean)false);
                }
                registerAction = ActionManager.getInstance().getAction("Register");
                if (registerAction == null) {
                    $this$trace$iv = logger;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var9_14 = $this$trace$iv;
                        $i$a$-trace-CommonCheckLicense$startTrial$5 = false;
                        var9_14.trace("Register action is not found.");
                    }
                    return Boxing.boxBoolean((boolean)false);
                }
                $continuation.L$0 = productCode;
                $continuation.L$1 = logger;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)accService);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)registerAction);
                $continuation.label = 1;
                v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AnActionResult>, Object>(logger, productCode, registerAction, null){
                    int label;
                    final /* synthetic */ Logger $logger;
                    final /* synthetic */ String $productCode;
                    final /* synthetic */ AnAction $registerAction;
                    {
                        this.$logger = $logger;
                        this.$productCode = $productCode;
                        this.$registerAction = $registerAction;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                Logger $this$trace$iv = this.$logger;
                                boolean $i$f$trace = false;
                                if ($this$trace$iv.isTraceEnabled()) {
                                    Logger logger = $this$trace$iv;
                                    boolean bl = false;
                                    logger.trace("Will invoke the Register action now.");
                                }
                                AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)CommonCheckLicense.access$asDataContextForTrialActivation(CommonCheckLicense.INSTANCE, this.$productCode), (Presentation)new Presentation(), (String)"", (ActionUiKind)ActionUiKind.NONE, null);
                                Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
                                AnActionEvent event = anActionEvent;
                                return ActionUtil.performAction((AnAction)this.$registerAction, (AnActionEvent)event);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super AnActionResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl68
            }
            case 1: {
                registerAction = (AnAction)$continuation.L$3;
                accService = (JBAccountInfoService)$continuation.L$2;
                logger = (Logger)$continuation.L$1;
                productCode = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl68:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)productCode);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)logger);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)accService);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)registerAction);
                $continuation.label = 2;
                v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(logger, productCode, null){
                    int I$0;
                    int I$1;
                    int I$2;
                    int I$3;
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    int label;
                    final /* synthetic */ Logger $logger;
                    final /* synthetic */ String $productCode;
                    {
                        this.$logger = $logger;
                        this.$productCode = $productCode;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.$logger.trace("Register action triggered, UI dispatcher is free. Awaiting for license.");
                                attempts = 10;
                                var3_4 = this.$productCode;
                                var4_5 = this.$logger;
                                var5_6 = 0;
lbl10:
                                // 2 sources

                                while (var5_6 < attempts) {
                                    it = var5_6;
                                    $i$a$-repeat-CommonCheckLicense$startTrial$7$1 = 0;
                                    isLicensed = CommonCheckLicense.INSTANCE.getIsLicensed(var3_4);
                                    if (Intrinsics.areEqual((Object)isLicensed, (Object)Boxing.boxBoolean((boolean)true))) {
                                        var4_5.trace("The product is now licensed.");
                                        return Boxing.boxBoolean((boolean)true);
                                    }
                                    $this$trace$iv = var4_5;
                                    $i$f$trace = false;
                                    if ($this$trace$iv.isTraceEnabled()) {
                                        var11_12 = $this$trace$iv;
                                        $i$a$-trace-CommonCheckLicense$startTrial$7$1$1 = false;
                                        var11_12.trace("isLicensed returned " + isLicensed + ".");
                                    }
                                    this.L$0 = var3_4;
                                    this.L$1 = var4_5;
                                    this.L$2 = SpillingKt.nullOutSpilledVariable((Object)isLicensed);
                                    this.I$0 = attempts;
                                    this.I$1 = var5_6;
                                    this.I$2 = it;
                                    this.I$3 = $i$a$-repeat-CommonCheckLicense$startTrial$7$1;
                                    this.label = 1;
                                    v0 = DelayKt.delay((long)1000L, (Continuation)this);
                                    if (v0 == var13_2) {
                                        return var13_2;
                                    }
                                    ** GOTO lbl47
                                }
                                break;
                            }
                            case 1: {
                                $i$a$-repeat-CommonCheckLicense$startTrial$7$1 = this.I$3;
                                it = this.I$2;
                                var5_6 = this.I$1;
                                attempts = this.I$0;
                                isLicensed = (Boolean)this.L$2;
                                var4_5 = (Logger)this.L$1;
                                var3_4 = (String)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl47:
                                // 2 sources

                                ++var5_6;
                                ** GOTO lbl10
                            }
                        }
                        this.$logger.trace("The product is still not licensed after " + attempts + " attempts.");
                        return Boxing.boxBoolean((boolean)false);
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl84
            }
            case 2: {
                registerAction = (AnAction)$continuation.L$3;
                accService = (JBAccountInfoService)$continuation.L$2;
                logger = (Logger)$continuation.L$1;
                productCode = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl84:
                // 2 sources

                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void showLicenseDialog() {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction registerAction = actionManager.getAction("Register");
        AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)DataContext.EMPTY_CONTEXT, (Presentation)new Presentation(), (String)"", (ActionUiKind)ActionUiKind.NONE, null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        AnActionEvent event = anActionEvent;
        registerAction.actionPerformed(event);
    }

    private final void register(String productCode, String message, boolean activateTrial) {
        block5: {
            CommonCheckLicense $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CommonCheckLicense.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Logger logger2 = logger;
            ActionManager actionManager = ActionManager.getInstance();
            AnAction registerAction = actionManager.getAction("RegisterPlugins");
            if (registerAction == null) {
                registerAction = actionManager.getAction("Register");
            }
            try {
                if (activateTrial) {
                    AnAction anAction = registerAction;
                    if (anAction != null) {
                        anAction.actionPerformed(AnActionEvent.createEvent((DataContext)this.asDataContextForTrialActivation(productCode), null, (String)"", (ActionUiKind)ActionUiKind.NONE, null));
                    }
                    return;
                }
            }
            catch (Exception e) {
                logger2.error("Failed to register for trial", (Throwable)e);
            }
            AnAction anAction = registerAction;
            if (anAction == null) break block5;
            anAction.actionPerformed(AnActionEvent.createEvent((DataContext)this.asDataContextForDialog(productCode, message), (Presentation)new Presentation(), (String)"", (ActionUiKind)ActionUiKind.NONE, null));
        }
    }

    private final DataContext asDataContextForDialog(String productCode, String message) {
        return arg_0 -> CommonCheckLicense.asDataContextForDialog$lambda$0(productCode, message, arg_0);
    }

    private final DataContext asDataContextForTrialActivation(String productCode) {
        return arg_0 -> CommonCheckLicense.asDataContextForTrialActivation$lambda$0(productCode, arg_0);
    }

    private final boolean isEvaluationValid(String expirationTime) {
        boolean bl;
        try {
            Date now = new Date();
            Date expiration = new Date(Long.parseLong(expirationTime));
            bl = now.before(expiration);
        }
        catch (NumberFormatException e) {
            bl = false;
        }
        return bl;
    }

    private final boolean isKeyValid(String key) {
        List list;
        CharSequence charSequence = key;
        Regex regex = new Regex("-");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] licenseParts = thisCollection$iv.toArray(new String[0]);
        if (licenseParts.length != 4) {
            return false;
        }
        String licenseId = licenseParts[0];
        String licensePartBase64 = licenseParts[1];
        String signatureBase64 = licenseParts[2];
        String certBase64 = licenseParts[3];
        try {
            Signature sig = Signature.getInstance("SHA1withRSA");
            Base64.Decoder decoder = Base64.getMimeDecoder();
            String string = certBase64;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] byArray2 = decoder.decode(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decode(...)");
            sig.initVerify(this.createCertificate(byArray2, SetsKt.emptySet(), false));
            Base64.Decoder decoder2 = Base64.getMimeDecoder();
            string = licensePartBase64;
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            byte[] byArray3 = string.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
            byte[] licenseBytes = decoder2.decode(byArray3);
            sig.update(licenseBytes);
            Base64.Decoder decoder3 = Base64.getMimeDecoder();
            string = signatureBase64;
            Charset charset3 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"UTF_8");
            byte[] byArray4 = string.getBytes(charset3);
            Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"getBytes(...)");
            if (!sig.verify(decoder3.decode(byArray4))) {
                return false;
            }
            Intrinsics.checkNotNull((Object)licenseBytes);
            byte[] byArray5 = licenseBytes;
            Charset charset4 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset4, (String)"UTF_8");
            Charset charset5 = charset4;
            String licenseData = new String(byArray5, charset5);
            return StringsKt.contains$default((CharSequence)licenseData, (CharSequence)("\"licenseId\":\"" + licenseId + "\""), (boolean)false, (int)2, null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private final boolean isLicenseServerStampValid(String serverStamp) {
        try {
            List list;
            CharSequence charSequence = serverStamp;
            Regex regex = new Regex(":");
            int n = 0;
            List $this$dropLastWhile$iv = regex.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] parts = thisCollection$iv.toArray(new String[0]);
            Base64.Decoder base64 = Base64.getMimeDecoder();
            String expectedMachineId = parts[0];
            long timeStamp = Long.parseLong(parts[1]);
            String machineId = parts[2];
            String signatureType = parts[3];
            String string = parts[4];
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] signatureBytes = base64.decode(byArray);
            String string2 = parts[5];
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            byte[] byArray2 = string2.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            byte[] certBytes = base64.decode(byArray2);
            Collection intermediate = new ArrayList();
            int n2 = parts.length;
            for (int idx = 6; idx < n2; ++idx) {
                String string3 = parts[idx];
                Charset charset3 = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"UTF_8");
                byte[] byArray3 = string3.getBytes(charset3);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
                byte[] byArray4 = base64.decode(byArray3);
                Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"decode(...)");
                intermediate.add(byArray4);
            }
            Signature sig = Signature.getInstance(signatureType);
            Intrinsics.checkNotNull((Object)certBytes);
            sig.initVerify(this.createCertificate(certBytes, intermediate, true));
            String string4 = timeStamp + ":" + machineId;
            Charset charset4 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset4, (String)"UTF_8");
            byte[] byArray5 = string4.getBytes(charset4);
            Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"getBytes(...)");
            sig.update(byArray5);
            if (sig.verify(signatureBytes)) {
                return Intrinsics.areEqual((Object)expectedMachineId, (Object)machineId) && Math.abs((double)(System.currentTimeMillis() - timeStamp)) < 3600000.0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private final X509Certificate createCertificate(byte[] certBytes, Collection<byte[]> intermediateCertsBytes, boolean checkValidityAtCurrentDate) throws Exception {
        CertificateFactory x509factory = CertificateFactory.getInstance("X.509");
        Certificate certificate = x509factory.generateCertificate(new ByteArrayInputStream(certBytes));
        Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
        X509Certificate cert = (X509Certificate)certificate;
        Collection allCerts = new HashSet();
        allCerts.add(cert);
        for (byte[] bytes : intermediateCertsBytes) {
            allCerts.add(x509factory.generateCertificate(new ByteArrayInputStream(bytes)));
        }
        try {
            X509CertSelector selector = new X509CertSelector();
            selector.setCertificate(cert);
            Set trustAnchors = new HashSet();
            String[] stringArray = ROOT_CERTIFICATES;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String rc;
                String string = rc = stringArray[i];
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                Certificate certificate2 = x509factory.generateCertificate(new ByteArrayInputStream(byArray));
                Intrinsics.checkNotNull((Object)certificate2, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
                trustAnchors.add(new TrustAnchor((X509Certificate)certificate2, null));
            }
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
            pkixParams.setRevocationEnabled(false);
            if (!checkValidityAtCurrentDate) {
                pkixParams.setDate(cert.getNotBefore());
            }
            pkixParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(allCerts)));
            CertPath path = CertPathBuilder.getInstance("PKIX").build(pkixParams).getCertPath();
            if (path != null) {
                CertPathValidator.getInstance("PKIX").validate(path, pkixParams);
                return cert;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new Exception("Certificate used to sign the license is not signed by JetBrains root certificate");
    }

    private static final void requestLicense$lambda$0(String $productCode, String $message, boolean $silentTrial) {
        INSTANCE.register($productCode, $message, $silentTrial);
    }

    private static final Object asDataContextForDialog$lambda$0(String $productCode, String $message, String dataId) {
        String string = dataId;
        if (Intrinsics.areEqual((Object)string, (Object)"register.product-descriptor.code")) {
            return $productCode;
        }
        if (Intrinsics.areEqual((Object)string, (Object)"register.message")) {
            return $message;
        }
        return null;
    }

    private static final Object asDataContextForTrialActivation$lambda$0(String $productCode, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return switch (it) {
            case "register.product-descriptor.code" -> $productCode;
            case "register.request.revalidate" -> false;
            case "register.request.trial" -> true;
            default -> null;
        };
    }

    public static final /* synthetic */ DataContext access$asDataContextForTrialActivation(CommonCheckLicense $this, String productCode) {
        return $this.asDataContextForTrialActivation(productCode);
    }

    static {
        String[] stringArray = new String[]{"-----BEGIN CERTIFICATE-----\nMIIFOzCCAyOgAwIBAgIJANJssYOyg3nhMA0GCSqGSIb3DQEBCwUAMBgxFjAUBgNV\nBAMMDUpldFByb2ZpbGUgQ0EwHhcNMTUxMDAyMTEwMDU2WhcNNDUxMDI0MTEwMDU2\nWjAYMRYwFAYDVQQDDA1KZXRQcm9maWxlIENBMIICIjANBgkqhkiG9w0BAQEFAAOC\nAg8AMIICCgKCAgEA0tQuEA8784NabB1+T2XBhpB+2P1qjewHiSajAV8dfIeWJOYG\ny+ShXiuedj8rL8VCdU+yH7Ux/6IvTcT3nwM/E/3rjJIgLnbZNerFm15Eez+XpWBl\nm5fDBJhEGhPc89Y31GpTzW0vCLmhJ44XwvYPntWxYISUrqeR3zoUQrCEp1C6mXNX\nEpqIGIVbJ6JVa/YI+pwbfuP51o0ZtF2rzvgfPzKtkpYQ7m7KgA8g8ktRXyNrz8bo\niwg7RRPeqs4uL/RK8d2KLpgLqcAB9WDpcEQzPWegbDrFO1F3z4UVNH6hrMfOLGVA\nxoiQhNFhZj6RumBXlPS0rmCOCkUkWrDr3l6Z3spUVgoeea+QdX682j6t7JnakaOw\njzwY777SrZoi9mFFpLVhfb4haq4IWyKSHR3/0BlWXgcgI6w6LXm+V+ZgLVDON52F\nLcxnfftaBJz2yclEwBohq38rYEpb+28+JBvHJYqcZRaldHYLjjmb8XXvf2MyFeXr\nSopYkdzCvzmiEJAewrEbPUaTllogUQmnv7Rv9sZ9jfdJ/cEn8e7GSGjHIbnjV2ZM\nQ9vTpWjvsT/cqatbxzdBo/iEg5i9yohOC9aBfpIHPXFw+fEj7VLvktxZY6qThYXR\nRus1WErPgxDzVpNp+4gXovAYOxsZak5oTV74ynv1aQ93HSndGkKUE/qA/JECAwEA\nAaOBhzCBhDAdBgNVHQ4EFgQUo562SGdCEjZBvW3gubSgUouX8bMwSAYDVR0jBEEw\nP4AUo562SGdCEjZBvW3gubSgUouX8bOhHKQaMBgxFjAUBgNVBAMMDUpldFByb2Zp\nbGUgQ0GCCQDSbLGDsoN54TAMBgNVHRMEBTADAQH/MAsGA1UdDwQEAwIBBjANBgkq\nhkiG9w0BAQsFAAOCAgEAjrPAZ4xC7sNiSSqh69s3KJD3Ti4etaxcrSnD7r9rJYpK\nBMviCKZRKFbLv+iaF5JK5QWuWdlgA37ol7mLeoF7aIA9b60Ag2OpgRICRG79QY7o\nuLviF/yRMqm6yno7NYkGLd61e5Huu+BfT459MWG9RVkG/DY0sGfkyTHJS5xrjBV6\nhjLG0lf3orwqOlqSNRmhvn9sMzwAP3ILLM5VJC5jNF1zAk0jrqKz64vuA8PLJZlL\nS9TZJIYwdesCGfnN2AETvzf3qxLcGTF038zKOHUMnjZuFW1ba/12fDK5GJ4i5y+n\nfDWVZVUDYOPUixEZ1cwzmf9Tx3hR8tRjMWQmHixcNC8XEkVfztID5XeHtDeQ+uPk\nX+jTDXbRb+77BP6n41briXhm57AwUI3TqqJFvoiFyx5JvVWG3ZqlVaeU/U9e0gxn\n8qyR+ZA3BGbtUSDDs8LDnE67URzK+L+q0F2BC758lSPNB2qsJeQ63bYyzf0du3wB\n/gb2+xJijAvscU3KgNpkxfGklvJD/oDUIqZQAnNcHe7QEf8iG2WqaMJIyXZlW3me\n0rn+cgvxHPt6N4EBh5GgNZR4l0eaFEV+fxVsydOQYo1RIyFMXtafFBqQl6DDxujl\nFeU3FZ+Bcp12t7dlM4E0/sS1XdL47CfGVj4Bp+/VbF862HmkAbd7shs7sDQkHbU=\n-----END CERTIFICATE-----\n", "-----BEGIN CERTIFICATE-----\nMIIFTDCCAzSgAwIBAgIJAMCrW9HV+hjZMA0GCSqGSIb3DQEBCwUAMB0xGzAZBgNV\nBAMMEkxpY2Vuc2UgU2VydmVycyBDQTAgFw0xNjEwMTIxNDMwNTRaGA8yMTE2MTIy\nNzE0MzA1NFowHTEbMBkGA1UEAwwSTGljZW5zZSBTZXJ2ZXJzIENBMIICIjANBgkq\nhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAoT7LvHj3JKK2pgc5f02z+xEiJDcvlBi6\nfIwrg/504UaMx3xWXAE5CEPelFty+QPRJnTNnSxqKQQmg2s/5tMJpL9lzGwXaV7a\nrrcsEDbzV4el5mIXUnk77Bm/QVv48s63iQqUjVmvjQt9SWG2J7+h6X3ICRvF1sQB\nyeat/cO7tkpz1aXXbvbAws7/3dXLTgAZTAmBXWNEZHVUTcwSg2IziYxL8HRFOH0+\nGMBhHqa0ySmF1UTnTV4atIXrvjpABsoUvGxw+qOO2qnwe6ENEFWFz1a7pryVOHXg\nP+4JyPkI1hdAhAqT2kOKbTHvlXDMUaxAPlriOVw+vaIjIVlNHpBGhqTj1aqfJpLj\nqfDFcuqQSI4O1W5tVPRNFrjr74nDwLDZnOF+oSy4E1/WhL85FfP3IeQAIHdswNMJ\ny+RdkPZCfXzSUhBKRtiM+yjpIn5RBY+8z+9yeGocoxPf7l0or3YF4GUpud202zgy\nY3sJqEsZksB750M0hx+vMMC9GD5nkzm9BykJS25hZOSsRNhX9InPWYYIi6mFm8QA\n2Dnv8wxAwt2tDNgqa0v/N8OxHglPcK/VO9kXrUBtwCIfZigO//N3hqzfRNbTv/ZO\nk9lArqGtcu1hSa78U4fuu7lIHi+u5rgXbB6HMVT3g5GQ1L9xxT1xad76k2EGEi3F\n9B+tSrvru70CAwEAAaOBjDCBiTAdBgNVHQ4EFgQUpsRiEz+uvh6TsQqurtwXMd4J\n8VEwTQYDVR0jBEYwRIAUpsRiEz+uvh6TsQqurtwXMd4J8VGhIaQfMB0xGzAZBgNV\nBAMMEkxpY2Vuc2UgU2VydmVycyBDQYIJAMCrW9HV+hjZMAwGA1UdEwQFMAMBAf8w\nCwYDVR0PBAQDAgEGMA0GCSqGSIb3DQEBCwUAA4ICAQCJ9+GQWvBS3zsgPB+1PCVc\noG6FY87N6nb3ZgNTHrUMNYdo7FDeol2DSB4wh/6rsP9Z4FqVlpGkckB+QHCvqU+d\nrYPe6QWHIb1kE8ftTnwapj/ZaBtF80NWUfYBER/9c6To5moW63O7q6cmKgaGk6zv\nSt2IhwNdTX0Q5cib9ytE4XROeVwPUn6RdU/+AVqSOspSMc1WQxkPVGRF7HPCoGhd\nvqebbYhpahiMWfClEuv1I37gJaRtsoNpx3f/jleoC/vDvXjAznfO497YTf/GgSM2\nLCnVtpPQQ2vQbOfTjaBYO2MpibQlYpbkbjkd5ZcO5U5PGrQpPFrWcylz7eUC3c05\nUVeygGIthsA/0hMCioYz4UjWTgi9NQLbhVkfmVQ5lCVxTotyBzoubh3FBz+wq2Qt\niElsBrCMR7UwmIu79UYzmLGt3/gBdHxaImrT9SQ8uqzP5eit54LlGbvGekVdAL5l\nDFwPcSB1IKauXZvi1DwFGPeemcSAndy+Uoqw5XGRqE6jBxS7XVI7/4BSMDDRBz1u\na+JMGZXS8yyYT+7HdsybfsZLvkVmc9zVSDI7/MjVPdk6h0sLn+vuPC1bIi5edoNy\nPdiG2uPH5eDO6INcisyPpLS4yFKliaO4Jjap7yzLU9pbItoWgCAYa2NpxuxHJ0tB\n7tlDFnvaRnQukqSG+VqNWg==\n-----END CERTIFICATE-----"};
        ROOT_CERTIFICATES = stringArray;
    }
}

