/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.inputHandlers;

import com.jetbrains.dotCommon.externalAppToolWindow.common.JavaToAvaloniaKeyStroke;
import com.jetbrains.dotCommon.externalAppToolWindow.common.KeyUtils;
import com.jetbrains.rd.ide.model.ExternalAppInputModel;
import com.jetbrains.rd.ide.model.InputModifiers;
import com.jetbrains.rd.ide.model.KeyEventMessage;
import com.jetbrains.rd.ide.model.TextInputEventMessage;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\u0010\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/inputHandlers/RemoteWidgetKeyListener;", "Ljava/awt/event/KeyListener;", "inputModel", "Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;", "rdDispatcher", "Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "<init>", "(Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;)V", "keyTyped", "", "e", "Ljava/awt/event/KeyEvent;", "handleKeyEvent", "pressed", "", "keyPressed", "keyReleased", "intellij.rider.plugins.dotCommon"})
public final class RemoteWidgetKeyListener
implements KeyListener {
    @NotNull
    private final ExternalAppInputModel inputModel;
    @NotNull
    private final IRdDispatcher rdDispatcher;

    public RemoteWidgetKeyListener(@NotNull ExternalAppInputModel inputModel, @NotNull IRdDispatcher rdDispatcher) {
        Intrinsics.checkNotNullParameter((Object)inputModel, (String)"inputModel");
        Intrinsics.checkNotNullParameter((Object)rdDispatcher, (String)"rdDispatcher");
        this.inputModel = inputModel;
        this.rdDispatcher = rdDispatcher;
    }

    @Override
    public void keyTyped(@Nullable KeyEvent e) {
    }

    private final void handleKeyEvent(KeyEvent e, boolean pressed) {
        if (e == null) {
            return;
        }
        ArrayList<InputModifiers> inputModifiers = KeyUtils.Companion.getModifiers(e);
        if (KeyUtils.Companion.isCharKey(e)) {
            if (!pressed) {
                return;
            }
            TextInputEventMessage txtInputEvent = new TextInputEventMessage(String.valueOf(e.getKeyChar()), (List)inputModifiers);
            this.rdDispatcher.queue(() -> RemoteWidgetKeyListener.handleKeyEvent$lambda$0(this, txtInputEvent));
        } else {
            int keyCode = JavaToAvaloniaKeyStroke.INSTANCE.toAvalonia(e.getKeyCode());
            if (keyCode == 0) {
                return;
            }
            KeyEventMessage keyInput = new KeyEventMessage(pressed, keyCode, (List)inputModifiers);
            this.rdDispatcher.queue(() -> RemoteWidgetKeyListener.handleKeyEvent$lambda$1(this, keyInput));
        }
    }

    @Override
    public void keyPressed(@Nullable KeyEvent e) {
        this.handleKeyEvent(e, true);
    }

    @Override
    public void keyReleased(@Nullable KeyEvent e) {
        this.handleKeyEvent(e, false);
    }

    private static final Unit handleKeyEvent$lambda$0(RemoteWidgetKeyListener this$0, TextInputEventMessage $txtInputEvent) {
        this$0.inputModel.getInputMessage().fire((Object)$txtInputEvent);
        return Unit.INSTANCE;
    }

    private static final Unit handleKeyEvent$lambda$1(RemoteWidgetKeyListener this$0, KeyEventMessage $keyInput) {
        this$0.inputModel.getInputMessage().fire((Object)$keyInput);
        return Unit.INSTANCE;
    }
}

