/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.actions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.jetbrains.dotCommon.externalAppToolWindow.actions.ActionDataContextConstants;
import com.jetbrains.rd.ide.model.ActionMessage;
import com.jetbrains.rd.ide.model.ContextMenuValue;
import com.jetbrains.rd.ide.model.IntContextVal;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J+\u0010\u0010\u001a\u0004\u0018\u0001H\u0012\"\n\b\u0001\u0010\u0012*\u0004\u0018\u00010\u000f2\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00120\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J!\u0010\u0016\u001a\u00020\u0017\"\u0004\b\u0001\u0010\u00122\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010\u0019J \u0010\u001a\u001a\u0004\u0018\u0001H\u0012\"\u0006\b\u0001\u0010\u0012\u0018\u00012\u0006\u0010\u0011\u001a\u00020\u000eH\u0086\b\u00a2\u0006\u0002\u0010\u001bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/actions/RemoteActionDataContext;", "TAppModel", "Lcom/intellij/openapi/actionSystem/DataContext;", "riderAction", "Lcom/jetbrains/rd/ide/model/ActionMessage;", "project", "Lcom/intellij/openapi/project/Project;", "appModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rd/ide/model/ActionMessage;Lcom/intellij/openapi/project/Project;Ljava/lang/Object;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "map", "", "", "", "getData", "dataId", "T", "key", "Lcom/intellij/openapi/actionSystem/DataKey;", "(Lcom/intellij/openapi/actionSystem/DataKey;)Ljava/lang/Object;", "put", "", "data", "(Ljava/lang/String;Ljava/lang/Object;)V", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "intellij.rider.plugins.dotCommon"})
public final class RemoteActionDataContext<TAppModel>
implements DataContext {
    @NotNull
    private final Map<String, Object> map;

    public RemoteActionDataContext(@NotNull ActionMessage riderAction, @NotNull Project project, TAppModel appModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)riderAction, (String)"riderAction");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.map = new HashMap();
        if (appModel == null) {
            throw new IllegalArgumentException("AppModel parameter should not be null");
        }
        for (IntContextVal intContextVal : riderAction.getIntContextValues()) {
            this.map.put(intContextVal.getId(), intContextVal.getValue());
        }
        for (IntContextVal intContextVal : riderAction.getStringContextValues()) {
            this.map.put(intContextVal.getId(), intContextVal.getValue());
        }
        for (IntContextVal intContextVal : riderAction.getBooleanContextValues()) {
            this.map.put(intContextVal.getId(), intContextVal.getValue());
        }
        if (riderAction.getContextMenuValues() != null) {
            ContextMenuValue contextMenuValue = riderAction.getContextMenuValues();
            Intrinsics.checkNotNull((Object)contextMenuValue);
            String string = contextMenuValue.getId();
            ContextMenuValue contextMenuValue2 = riderAction.getContextMenuValues();
            Intrinsics.checkNotNull((Object)contextMenuValue2);
            this.map.put(string, contextMenuValue2.getValue());
        }
        this.map.put(CommonDataKeys.PROJECT.getName(), project);
        this.map.put(ActionDataContextConstants.Companion.getRiderAppModel(), appModel);
        this.map.put(ActionDataContextConstants.Companion.getProcessLifetime(), lifetime);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (!this.map.containsKey(dataId)) {
            return null;
        }
        return this.map.get(dataId);
    }

    @Nullable
    public <T> T getData(@NotNull DataKey<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Object data = this.getData(key.getName());
        return (T)data;
    }

    public final <T> void put(@NotNull String dataId, T data) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (data == null) {
            throw new IllegalArgumentException("Data parameter should not be null");
        }
        this.map.put(dataId, data);
    }

    public final /* synthetic */ <T> T get(String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        boolean $i$f$get = false;
        Object data = this.getData(dataId);
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        if (data instanceof Object) {
            return (T)data;
        }
        return null;
    }
}

