/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.dotCommon.externalAppToolWindow.RemoteProcess;
import com.jetbrains.dotCommon.externalAppToolWindow.common.BindableObjectExtensions;
import com.jetbrains.rd.framework.base.RdBindableBase;
import com.jetbrains.rd.ide.model.AppIsReady;
import com.jetbrains.rd.ide.model.ProcessControlFlowModel;
import com.jetbrains.rd.ide.model.RemoteApplicationState;
import com.jetbrains.rd.platform.protocol.IRdDispatcherKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010(\u001a\u00020\tJ\u0006\u0010)\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0019\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001d\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000&0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010$\u00a8\u0006*"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/RemoteProcessFactory;", "TAppModel", "Lcom/jetbrains/rd/framework/base/RdBindableBase;", "", "appName", "", "createAppModel", "Lkotlin/Function0;", "onBeforeStart", "", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "controlFlowLinkName", "backendIsReady", "Lcom/jetbrains/rd/util/reactive/IProperty;", "", "processControlFlow", "Lcom/jetbrains/rd/ide/model/ProcessControlFlowModel;", "getProcessControlFlow", "()Lcom/jetbrains/rd/ide/model/ProcessControlFlowModel;", "setProcessControlFlow", "(Lcom/jetbrains/rd/ide/model/ProcessControlFlowModel;)V", "appState", "Lcom/jetbrains/rd/util/reactive/Property;", "Lcom/jetbrains/rd/ide/model/RemoteApplicationState;", "getAppState", "()Lcom/jetbrains/rd/util/reactive/Property;", "appIsReady", "Lcom/jetbrains/rd/ide/model/AppIsReady;", "getAppIsReady", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "currentProcess", "Lcom/jetbrains/dotCommon/externalAppToolWindow/RemoteProcess;", "getCurrentProcess", "restart", "runWhenBackendReady", "intellij.rider.plugins.dotCommon"})
@SourceDebugExtension(value={"SMAP\nRemoteProcessFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteProcessFactory.kt\ncom/jetbrains/dotCommon/externalAppToolWindow/RemoteProcessFactory\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,90:1\n13#2:91\n13#3:92\n*S KotlinDebug\n*F\n+ 1 RemoteProcessFactory.kt\ncom/jetbrains/dotCommon/externalAppToolWindow/RemoteProcessFactory\n*L\n24#1:91\n24#1:92\n*E\n"})
public final class RemoteProcessFactory<TAppModel extends RdBindableBase> {
    @NotNull
    private final String appName;
    @NotNull
    private final Function0<TAppModel> createAppModel;
    @NotNull
    private final Function0<Unit> onBeforeStart;
    @NotNull
    private final Project project;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String controlFlowLinkName;
    @NotNull
    private final IProperty<Boolean> backendIsReady;
    @NotNull
    private ProcessControlFlowModel processControlFlow;
    @NotNull
    private final Property<RemoteApplicationState> appState;
    @NotNull
    private final IProperty<AppIsReady> appIsReady;
    @NotNull
    private final IProperty<RemoteProcess<TAppModel>> currentProcess;

    public RemoteProcessFactory(@NotNull String appName, @NotNull Function0<? extends TAppModel> createAppModel, @NotNull Function0<Unit> onBeforeStart, @NotNull Project project, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        Intrinsics.checkNotNullParameter(createAppModel, (String)"createAppModel");
        Intrinsics.checkNotNullParameter(onBeforeStart, (String)"onBeforeStart");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.appName = appName;
        this.createAppModel = createAppModel;
        this.onBeforeStart = onBeforeStart;
        this.project = project;
        this.lifetime = lifetime;
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RemoteProcessFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.controlFlowLinkName = this.appName + "_ProcessControlFlowModel";
        this.backendIsReady = (IProperty)new Property((Object)false);
        this.processControlFlow = new ProcessControlFlowModel();
        this.appState = new Property((Object)RemoteApplicationState.NotStarted);
        this.appIsReady = (IProperty)new Property(null);
        this.processControlFlow.getProcessTerminated().advise(this.lifetime, arg_0 -> RemoteProcessFactory._init_$lambda$0(this, arg_0));
        this.processControlFlow.getReady().advise(this.lifetime, arg_0 -> RemoteProcessFactory._init_$lambda$1(this, arg_0));
        this.processControlFlow.getBackendIsReady().advise(this.lifetime, arg_0 -> RemoteProcessFactory._init_$lambda$2(this, arg_0));
        BindableObjectExtensions.Companion.bindModel((RdBindableBase)this.processControlFlow, ApplicationProtocolKt.getProtocol((Project)this.project), this.lifetime, this.controlFlowLinkName);
        this.appState.setValue((Object)RemoteApplicationState.Starting);
        this.currentProcess = (IProperty)new Property(new RemoteProcess<TAppModel>(this.appName, this.createAppModel, this.lifetime, IRdDispatcherKt.getAsRdDispatcher((IScheduler)ApplicationProtocolKt.getProtocol((Project)this.project).getScheduler())));
        this.runWhenBackendReady();
    }

    @NotNull
    public final ProcessControlFlowModel getProcessControlFlow() {
        return this.processControlFlow;
    }

    public final void setProcessControlFlow(@NotNull ProcessControlFlowModel processControlFlowModel) {
        Intrinsics.checkNotNullParameter((Object)processControlFlowModel, (String)"<set-?>");
        this.processControlFlow = processControlFlowModel;
    }

    @NotNull
    public final Property<RemoteApplicationState> getAppState() {
        return this.appState;
    }

    @NotNull
    public final IProperty<AppIsReady> getAppIsReady() {
        return this.appIsReady;
    }

    @NotNull
    public final IProperty<RemoteProcess<TAppModel>> getCurrentProcess() {
        return this.currentProcess;
    }

    public final void restart() {
        this.currentProcess.setValue(new RemoteProcess<TAppModel>(this.appName, this.createAppModel, this.lifetime, IRdDispatcherKt.getAsRdDispatcher((IScheduler)ApplicationProtocolKt.getProtocol((Project)this.project).getScheduler())));
    }

    public final void runWhenBackendReady() {
        if (((Boolean)this.backendIsReady.getValue()).booleanValue()) {
            this.onBeforeStart.invoke();
            this.processControlFlow.getStartProcess().fire((Object)((RemoteProcess)this.currentProcess.getValue()).getProcParams());
        } else {
            SourceExKt.adviseUntil((ISource)((ISource)this.backendIsReady), (Lifetime)this.lifetime, arg_0 -> RemoteProcessFactory.runWhenBackendReady$lambda$0(this, arg_0));
        }
    }

    private static final Unit _init_$lambda$0(RemoteProcessFactory this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logger.info("processTerminated");
        this$0.appState.setValue((Object)RemoteApplicationState.Terminated);
        ((RemoteProcess)this$0.currentProcess.getValue()).terminate();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(RemoteProcessFactory this$0, AppIsReady x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        this$0.logger.info("ready");
        this$0.appIsReady.setValue((Object)x);
        this$0.appState.setValue((Object)RemoteApplicationState.Started);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(RemoteProcessFactory this$0, boolean x) {
        this$0.logger.info("ready");
        this$0.backendIsReady.setValue((Object)x);
        return Unit.INSTANCE;
    }

    private static final boolean runWhenBackendReady$lambda$0(RemoteProcessFactory this$0, boolean isLoaded) {
        if (!isLoaded) {
            return false;
        }
        this$0.onBeforeStart.invoke();
        this$0.processControlFlow.getStartProcess().fire((Object)((RemoteProcess)this$0.currentProcess.getValue()).getProcParams());
        return true;
    }
}

