/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow;

import com.intellij.execution.ui.BaseContentCloseListener;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.dotCommon.externalAppToolWindow.RemoteProcess;
import com.jetbrains.dotCommon.externalAppToolWindow.RemoteProcessFactory;
import com.jetbrains.dotCommon.externalAppToolWindow.actions.RemoteActionDataContext;
import com.jetbrains.dotCommon.externalAppToolWindow.actions.SimpleCtxMenuAction;
import com.jetbrains.dotCommon.externalAppToolWindow.common.BindableObjectExtensions;
import com.jetbrains.dotCommon.externalAppToolWindow.inputHandlers.WindowCloseListener;
import com.jetbrains.dotCommon.externalAppToolWindow.modalWindow.RemoteModalWindow;
import com.jetbrains.dotCommon.externalAppToolWindow.remoteDocumentWindow.RemoteDocumentWindowFile;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.FrameBufferStorageChannel;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.ApplicationCrashWindow;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.LoadingPanel;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.NotificationsHandler;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.RemoteWindow;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.WindowTitle;
import com.jetbrains.ide.model.BackgroundTask.BackgroundTasksModel;
import com.jetbrains.ide.model.notifications.NotificationsModel;
import com.jetbrains.ide.model.notifications.NotificationsModel_GeneratedKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdDynamic;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.framework.InterfacesKt;
import com.jetbrains.rd.framework.base.RdBindableBase;
import com.jetbrains.rd.framework.impl.RdTask;
import com.jetbrains.rd.ide.model.ActionMessage;
import com.jetbrains.rd.ide.model.AppIsReady;
import com.jetbrains.rd.ide.model.BaseActionDef;
import com.jetbrains.rd.ide.model.ContextMenuValue;
import com.jetbrains.rd.ide.model.CustomContextMenuOptions;
import com.jetbrains.rd.ide.model.ExternalAppInputModel;
import com.jetbrains.rd.ide.model.ExternalAppServerModel;
import com.jetbrains.rd.ide.model.ExternalAppTheme;
import com.jetbrains.rd.ide.model.GroupRiderActionDef;
import com.jetbrains.rd.ide.model.InvokeActionMessage;
import com.jetbrains.rd.ide.model.NewWindowMetaInfo;
import com.jetbrains.rd.ide.model.NewWindowUserData;
import com.jetbrains.rd.ide.model.RiderWindowState;
import com.jetbrains.rd.ide.model.SeparatorActionDef;
import com.jetbrains.rd.ide.model.SingleRiderActionDef;
import com.jetbrains.rd.ide.model.StartupWindow;
import com.jetbrains.rd.ide.model.StartupWindowUserData;
import com.jetbrains.rd.ide.model.WindowManagementModel;
import com.jetbrains.rd.ide.model.WindowStateUserData;
import com.jetbrains.rd.ide.model.WindowType;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.platform.protocol.IRdDispatcherKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.LifetimeStatus;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.actions.RiderActionsHostKt;
import com.jetbrains.rider.dialog.RiderDialogHandlerKt;
import com.jetbrains.rider.model.dialog.DialogModel;
import com.jetbrains.rider.model.dialog.DialogModel_PregeneratedKt;
import com.jetbrains.rider.model.messageBox.MessageBoxModel;
import com.jetbrains.rider.model.messageBox.MessageBoxModel_PregeneratedKt;
import com.jetbrains.rider.services.BackgroundProgressUtilKt;
import com.jetbrains.rider.services.RiderMessageBoxHostKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u00d7\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012`\u0010\t\u001a\\\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\n\u0012!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00140\u0016\u0012!\u0010\u0019\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00140\u0016\u0012\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u001d\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\"\u0010 \u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\"0!j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\"`#\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010$\u001a\u00020%\u0012\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140\u001d\u0012\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00140\u001d\u0012\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)\u0012\u0006\u0010*\u001a\u00020+\u00a2\u0006\u0004\b,\u0010-J\b\u0010D\u001a\u00020\u0014H\u0002J\u001e\u0010E\u001a\u0002HF\"\u0006\b\u0001\u0010F\u0018\u00012\u0006\u0010G\u001a\u00020\u0017H\u0082\b\u00a2\u0006\u0002\u0010HJ \u0010I\u001a\u0004\u0018\u0001HF\"\u0006\b\u0001\u0010F\u0018\u00012\u0006\u0010G\u001a\u00020\u0017H\u0082\b\u00a2\u0006\u0002\u0010HJ\u0018\u0010J\u001a\u00020\u00142\u0006\u0010K\u001a\u00020\u00172\u0006\u0010L\u001a\u00020MH\u0002J\u0016\u0010N\u001a\u00020\u00142\f\u0010O\u001a\b\u0012\u0004\u0012\u00028\u00000PH\u0002J\b\u0010Q\u001a\u00020\u0014H\u0002J#\u0010R\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020S2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020U0\u0007H\u0002\u00a2\u0006\u0002\u0010VJ\u001e\u0010W\u001a\u00020\u00142\f\u0010O\u001a\b\u0012\u0004\u0012\u00028\u00000P2\u0006\u0010X\u001a\u00020YH\u0002J\u001e\u0010Z\u001a\u00020\u00142\f\u0010O\u001a\b\u0012\u0004\u0012\u00028\u00000P2\u0006\u0010X\u001a\u00020YH\u0002J\u001e\u0010[\u001a\u00020\u00142\f\u0010O\u001a\b\u0012\u0004\u0012\u00028\u00000P2\u0006\u0010X\u001a\u00020YH\u0002J\u0016\u0010\\\u001a\u00020\u00142\f\u0010O\u001a\b\u0012\u0004\u0012\u00028\u00000PH\u0002J\u0014\u0010]\u001a\u0004\u0018\u00010^2\b\u0010_\u001a\u0004\u0018\u00010\u0005H\u0002J\u0014\u0010`\u001a\u0004\u0018\u00010\u00052\b\u0010a\u001a\u0004\u0018\u00010\u0005H\u0002J$\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020g2\n\u0010h\u001a\u00060ij\u0002`jH\u0002J\"\u0010k\u001a\u00020\u00142\u0006\u0010l\u001a\u00020m2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010n\u001a\u0004\u0018\u00010oH\u0002J2\u0010p\u001a\u00020\u00142\f\u0010O\u001a\b\u0012\u0004\u0012\u00028\u00000P2\u0006\u0010d\u001a\u00020e2\u0006\u0010q\u001a\u00020r2\n\u0010h\u001a\u00060ij\u0002`jH\u0002J\u0012\u0010s\u001a\u00020t2\b\u0010u\u001a\u0004\u0018\u00010vH\u0002J\b\u0010w\u001a\u00020tH\u0002J\u0016\u0010x\u001a\u00020\u00142\f\u0010O\u001a\b\u0012\u0004\u0012\u00028\u00000PH\u0002J\b\u0010y\u001a\u00020\u0014H\u0002J\b\u0010z\u001a\u00020\u0014H\u0002J\b\u0010{\u001a\u00020\u0014H\u0002J\u0010\u0010|\u001a\u00020\u00052\u0006\u0010}\u001a\u00020\u0005H\u0003J@\u0010~\u001a\u00020\u00142\u000e\u0010\u007f\u001a\n\u0012\u0005\u0012\u00030\u0081\u00010\u0080\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0084\u0001\u001a\u00020\u00172\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u00012\u0007\u0010\u0087\u0001\u001a\u00020\u0012H\u0002J(\u0010\u0088\u0001\u001a\u00020\u00142\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0084\u0001\u001a\u00020\u00172\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u0001H\u0002J*\u0010\u0089\u0001\u001a\u00020\u00172\u000b\b\u0001\u0010\u008a\u0001\u001a\u0004\u0018\u00010\u00052\t\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u00052\u0007\u0010\u008c\u0001\u001a\u00020+H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010.Rh\u0010\t\u001a\\\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00140\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0019\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00140\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00140\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010=\u001a\u0012\u0012\u0004\u0012\u00020\u00170>j\b\u0012\u0004\u0012\u00020\u0017`?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010B\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\"0CX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008d\u0001"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/RemoteApplication;", "TAppModel", "Lcom/jetbrains/rd/framework/base/RdBindableBase;", "", "appName", "", "mainWindowsTitle", "", "Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/WindowTitle;", "beforeToolWindowCreationDelegate", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "appModel", "Lcom/intellij/openapi/project/Project;", "project", "Lcom/intellij/openapi/wm/ToolWindow;", "toolWindow", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "lifetime", "", "onToolWindowTabCreated", "Lkotlin/Function1;", "Lcom/intellij/ui/content/Content;", "content", "onDocWindowTabCreated", "Lcom/jetbrains/dotCommon/externalAppToolWindow/remoteDocumentWindow/RemoteDocumentWindowFile;", "file", "availableActions", "Lkotlin/Function0;", "iconClassLoader", "Ljava/lang/ClassLoader;", "supportedKeys", "Ljava/util/HashSet;", "Lcom/intellij/openapi/util/Key;", "Lkotlin/collections/HashSet;", "dispatcher", "Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "onWindowShownCallback", "onWindowClosedCallback", "remoteProcessFactory", "Lcom/jetbrains/dotCommon/externalAppToolWindow/RemoteProcessFactory;", "hideTabs", "", "<init>", "(Ljava/lang/String;[Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/WindowTitle;Lkotlin/jvm/functions/Function4;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lcom/intellij/openapi/wm/ToolWindow;Lcom/intellij/openapi/project/Project;Ljava/lang/ClassLoader;Ljava/util/HashSet;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lcom/jetbrains/dotCommon/externalAppToolWindow/RemoteProcessFactory;Z)V", "[Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/WindowTitle;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "windowManagement", "Lcom/jetbrains/rd/ide/model/WindowManagementModel;", "dialogModel", "Lcom/jetbrains/rider/model/dialog/DialogModel;", "notificationsModel", "Lcom/jetbrains/ide/model/notifications/NotificationsModel;", "messageBoxModel", "Lcom/jetbrains/rider/model/messageBox/MessageBoxModel;", "backgroundTasksModel", "Lcom/jetbrains/ide/model/BackgroundTask/BackgroundTasksModel;", "loadingPanel", "Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/LoadingPanel;", "startupTabs", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "toolWindowFrameBufferStorage", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameBufferStorageChannel;", "supportedUserDataKeys", "", "initProcessFlowModel", "getTabContent", "TComponent", "tab", "(Lcom/intellij/ui/content/Content;)Ljava/lang/Object;", "tryGetTabContent", "setTabContent", "toolWindowTab", "component", "Ljavax/swing/JComponent;", "bindModels", "remoteProcess", "Lcom/jetbrains/dotCommon/externalAppToolWindow/RemoteProcess;", "startAppInstance", "fillContentWithUserData", "Lcom/intellij/openapi/util/UserDataHolder;", "userData", "Lcom/jetbrains/rd/ide/model/NewWindowUserData;", "(Lcom/intellij/openapi/util/UserDataHolder;[Lcom/jetbrains/rd/ide/model/NewWindowUserData;)V", "createNewToolWindowTab", "newWindowInfo", "Lcom/jetbrains/rd/ide/model/NewWindowMetaInfo;", "createNewDocumentWindow", "createNewModalWindow", "subscribeOnNewWindow", "tryConvertToShortcut", "Lcom/intellij/openapi/actionSystem/KeyboardShortcut;", "strShortcut", "convertShortcut", "shortcut", "assembleCtxMenu", "Lcom/intellij/openapi/actionSystem/AnAction;", "inputModel", "Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;", "actionDef", "Lcom/jetbrains/rd/ide/model/BaseActionDef;", "windowId", "Ljava/util/UUID;", "Lcom/jetbrains/rd/util/UUID;", "displayContextMenu", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "customLocation", "Lcom/jetbrains/rd/ide/model/CustomContextMenuOptions;", "executeActionHandler", "msg", "Lcom/jetbrains/rd/ide/model/ActionMessage;", "convertRiderTheme", "Lcom/jetbrains/rd/ide/model/ExternalAppTheme;", "laf", "Lcom/intellij/ide/ui/laf/UIThemeLookAndFeelInfo;", "getCurrentTheme", "handleClipboard", "handleThemeChanges", "reloadApp", "initStartupTabs", "wrapIntoLocalizableString", "text", "handleTabWindowStateChanges", "windowStateOpt", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "Lcom/jetbrains/rd/ide/model/RiderWindowState;", "window", "Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/RemoteWindow;", "tabContent", "closeWindowListener", "Lcom/intellij/execution/ui/BaseContentCloseListener;", "windowLifetime", "closeToolWindowTab", "createNewToolWindowTabContent", "tabTitle", "tabIcon", "closeable", "intellij.rider.plugins.dotCommon"})
@SourceDebugExtension(value={"SMAP\nRemoteApplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteApplication.kt\ncom/jetbrains/dotCommon/externalAppToolWindow/RemoteApplication\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,609:1\n164#1,3:619\n170#1,3:622\n13#2:610\n13#3:611\n1208#4,2:612\n1236#4,4:614\n1#5:618\n*S KotlinDebug\n*F\n+ 1 RemoteApplication.kt\ncom/jetbrains/dotCommon/externalAppToolWindow/RemoteApplication\n*L\n123#1:619,3\n205#1:622,3\n82#1:610\n82#1:611\n97#1:612,2\n97#1:614,4\n*E\n"})
public final class RemoteApplication<TAppModel extends RdBindableBase> {
    @NotNull
    private final String appName;
    @NotNull
    private final WindowTitle[] mainWindowsTitle;
    @NotNull
    private final Function4<TAppModel, Project, ToolWindow, Lifetime, Unit> beforeToolWindowCreationDelegate;
    @NotNull
    private final Function1<Content, Unit> onToolWindowTabCreated;
    @NotNull
    private final Function1<RemoteDocumentWindowFile, Unit> onDocWindowTabCreated;
    @NotNull
    private final Function0<String[]> availableActions;
    @NotNull
    private final ToolWindow toolWindow;
    @NotNull
    private final Project project;
    @NotNull
    private final ClassLoader iconClassLoader;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final IRdDispatcher dispatcher;
    @NotNull
    private final Function0<Unit> onWindowShownCallback;
    @NotNull
    private final Function0<Unit> onWindowClosedCallback;
    @NotNull
    private final RemoteProcessFactory<TAppModel> remoteProcessFactory;
    private final boolean hideTabs;
    @NotNull
    private final Logger logger;
    private WindowManagementModel windowManagement;
    private DialogModel dialogModel;
    private NotificationsModel notificationsModel;
    private MessageBoxModel messageBoxModel;
    private BackgroundTasksModel backgroundTasksModel;
    @NotNull
    private final LoadingPanel loadingPanel;
    @NotNull
    private final ArrayList<Content> startupTabs;
    @NotNull
    private final FrameBufferStorageChannel toolWindowFrameBufferStorage;
    @NotNull
    private final Map<String, Key<String>> supportedUserDataKeys;

    /*
     * WARNING - void declaration
     */
    public RemoteApplication(@NotNull String appName, @NotNull WindowTitle[] mainWindowsTitle, @NotNull Function4<? super TAppModel, ? super Project, ? super ToolWindow, ? super Lifetime, Unit> beforeToolWindowCreationDelegate, @NotNull Function1<? super Content, Unit> onToolWindowTabCreated, @NotNull Function1<? super RemoteDocumentWindowFile, Unit> onDocWindowTabCreated, @NotNull Function0<String[]> availableActions, @NotNull ToolWindow toolWindow, @NotNull Project project, @NotNull ClassLoader iconClassLoader, @NotNull HashSet<Key<String>> supportedKeys, @NotNull Lifetime lifetime, @NotNull IRdDispatcher dispatcher, @NotNull Function0<Unit> onWindowShownCallback, @NotNull Function0<Unit> onWindowClosedCallback, @NotNull RemoteProcessFactory<TAppModel> remoteProcessFactory, boolean hideTabs) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        Intrinsics.checkNotNullParameter((Object)mainWindowsTitle, (String)"mainWindowsTitle");
        Intrinsics.checkNotNullParameter(beforeToolWindowCreationDelegate, (String)"beforeToolWindowCreationDelegate");
        Intrinsics.checkNotNullParameter(onToolWindowTabCreated, (String)"onToolWindowTabCreated");
        Intrinsics.checkNotNullParameter(onDocWindowTabCreated, (String)"onDocWindowTabCreated");
        Intrinsics.checkNotNullParameter(availableActions, (String)"availableActions");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)iconClassLoader, (String)"iconClassLoader");
        Intrinsics.checkNotNullParameter(supportedKeys, (String)"supportedKeys");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter(onWindowShownCallback, (String)"onWindowShownCallback");
        Intrinsics.checkNotNullParameter(onWindowClosedCallback, (String)"onWindowClosedCallback");
        Intrinsics.checkNotNullParameter(remoteProcessFactory, (String)"remoteProcessFactory");
        this.appName = appName;
        this.mainWindowsTitle = mainWindowsTitle;
        this.beforeToolWindowCreationDelegate = beforeToolWindowCreationDelegate;
        this.onToolWindowTabCreated = onToolWindowTabCreated;
        this.onDocWindowTabCreated = onDocWindowTabCreated;
        this.availableActions = availableActions;
        this.toolWindow = toolWindow;
        this.project = project;
        this.iconClassLoader = iconClassLoader;
        this.lifetime = lifetime;
        this.dispatcher = dispatcher;
        this.onWindowShownCallback = onWindowShownCallback;
        this.onWindowClosedCallback = onWindowClosedCallback;
        this.remoteProcessFactory = remoteProcessFactory;
        this.hideTabs = hideTabs;
        boolean $i$f$getLogger22 = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RemoteApplication.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        Dimension dimension = this.toolWindow.getContentManager().getComponent().getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
        this.loadingPanel = new LoadingPanel(dimension, this.lifetime);
        this.toolWindowFrameBufferStorage = new FrameBufferStorageChannel(2);
        Iterable $i$f$getLogger22 = supportedKeys;
        RemoteApplication remoteApplication = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var20_22 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Key key = (Key)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = Strings.toUpperCase((String)it.toString());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            map.put(string, element$iv$iv);
        }
        remoteApplication.supportedUserDataKeys = destination$iv$iv;
        this.lifetime.onTermination(() -> RemoteApplication._init_$lambda$1(this));
        this.startupTabs = new ArrayList(this.mainWindowsTitle.length);
        this.initStartupTabs();
        this.startAppInstance();
        this.initProcessFlowModel();
    }

    private final void initProcessFlowModel() {
        SourceExKt.adviseNotNull((ISource)((ISource)this.remoteProcessFactory.getAppIsReady()), (Lifetime)this.lifetime, arg_0 -> RemoteApplication.initProcessFlowModel$lambda$0(this, arg_0));
    }

    private final /* synthetic */ <TComponent> TComponent getTabContent(Content tab) {
        boolean $i$f$getTabContent = false;
        JComponent jComponent = tab.getComponent();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.ui.SimpleToolWindowPanel");
        SimpleToolWindowPanel toolWindowPanel = (SimpleToolWindowPanel)jComponent;
        JComponent jComponent2 = toolWindowPanel.getContent();
        Intrinsics.reifiedOperationMarker((int)1, (String)"TComponent");
        return (TComponent)jComponent2;
    }

    private final /* synthetic */ <TComponent> TComponent tryGetTabContent(Content tab) {
        boolean $i$f$tryGetTabContent = false;
        JComponent jComponent = tab.getComponent();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.ui.SimpleToolWindowPanel");
        SimpleToolWindowPanel toolWindowPanel = (SimpleToolWindowPanel)jComponent;
        JComponent jComponent2 = toolWindowPanel.getContent();
        Intrinsics.reifiedOperationMarker((int)2, (String)"TComponent");
        return (TComponent)jComponent2;
    }

    private final void setTabContent(Content toolWindowTab, JComponent component) {
        JComponent jComponent = toolWindowTab.getComponent();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.ui.SimpleToolWindowPanel");
        SimpleToolWindowPanel toolWindowPanel = (SimpleToolWindowPanel)jComponent;
        toolWindowPanel.setContent(component);
    }

    private final void bindModels(RemoteProcess<TAppModel> remoteProcess) {
        this.windowManagement = new WindowManagementModel();
        this.dialogModel = DialogModel_PregeneratedKt.getDialogModel((IProtocol)((IProtocol)remoteProcess.getExternalAppProtocol()));
        this.notificationsModel = NotificationsModel_GeneratedKt.getNotificationsModel((IProtocol)((IProtocol)remoteProcess.getExternalAppProtocol()));
        this.messageBoxModel = MessageBoxModel_PregeneratedKt.getMessageBoxModel((IProtocol)((IProtocol)remoteProcess.getExternalAppProtocol()));
        this.backgroundTasksModel = new BackgroundTasksModel();
        WindowManagementModel windowManagementModel = this.windowManagement;
        if (windowManagementModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManagement");
            windowManagementModel = null;
        }
        BindableObjectExtensions.Companion.bindModel((RdBindableBase)windowManagementModel, (IProtocol)remoteProcess.getExternalAppProtocol(), remoteProcess.getProcessLifetime(), remoteProcess.getWindowMgmtLinkName());
        BackgroundTasksModel backgroundTasksModel = this.backgroundTasksModel;
        if (backgroundTasksModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundTasksModel");
            backgroundTasksModel = null;
        }
        BindableObjectExtensions.Companion.bindModel((RdBindableBase)backgroundTasksModel, (IProtocol)remoteProcess.getExternalAppProtocol(), remoteProcess.getProcessLifetime(), remoteProcess.getRiderBackgroundTaskModelName());
    }

    private final void startAppInstance() {
        RemoteProcess remoteProcess = (RemoteProcess)this.remoteProcessFactory.getCurrentProcess().getValue();
        remoteProcess.getProcessLifetime().onTermination(() -> RemoteApplication.startAppInstance$lambda$0(this));
        this.bindModels(remoteProcess);
        this.beforeToolWindowCreationDelegate.invoke(remoteProcess.getAppModel(), (Object)this.project, (Object)this.toolWindow, (Object)remoteProcess.getProcessLifetime());
        this.subscribeOnNewWindow(remoteProcess);
        this.handleThemeChanges();
        this.handleClipboard(remoteProcess);
        MessageBoxModel messageBoxModel = this.messageBoxModel;
        if (messageBoxModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageBoxModel");
            messageBoxModel = null;
        }
        RiderMessageBoxHostKt.handleEvents((MessageBoxModel)messageBoxModel);
        BackgroundTasksModel backgroundTasksModel = this.backgroundTasksModel;
        if (backgroundTasksModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundTasksModel");
            backgroundTasksModel = null;
        }
        BackgroundProgressUtilKt.handleEvents((BackgroundTasksModel)backgroundTasksModel, (Lifetime)this.lifetime, () -> RemoteApplication.startAppInstance$lambda$1(this));
        DialogModel dialogModel = this.dialogModel;
        if (dialogModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogModel");
            dialogModel = null;
        }
        RiderDialogHandlerKt.handleEvents((DialogModel)dialogModel, () -> RemoteApplication.startAppInstance$lambda$2(this), (Logger)this.logger);
        NotificationsModel notificationsModel = this.notificationsModel;
        if (notificationsModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationsModel");
            notificationsModel = null;
        }
        new NotificationsHandler(notificationsModel, new ArrayList(), this.project, this.appName + "_Group", remoteProcess.getProcessLifetime(), this.logger);
    }

    private final void fillContentWithUserData(UserDataHolder content, NewWindowUserData[] userData) {
        for (NewWindowUserData data : userData) {
            Key<String> key;
            String keyString = Strings.toUpperCase((String)data.getId());
            if (!this.supportedUserDataKeys.containsKey(keyString)) continue;
            Intrinsics.checkNotNull(this.supportedUserDataKeys.get(keyString));
            content.putUserData(key, (Object)data.getValue());
        }
    }

    private final void createNewToolWindowTab(RemoteProcess<TAppModel> remoteProcess, NewWindowMetaInfo newWindowInfo) {
        LifetimeDefinition windowLifetimeDef = remoteProcess.getProcessLifetime().createNested();
        ExternalAppInputModel inputModel = new ExternalAppInputModel();
        BindableObjectExtensions.Companion.bindModel((RdBindableBase)inputModel, (IProtocol)remoteProcess.getExternalAppProtocol(), windowLifetimeDef.getLifetime(), newWindowInfo.getWindowInputProtocolLink());
        inputModel.getExecuteAction().advise(this.lifetime, arg_0 -> RemoteApplication.createNewToolWindowTab$lambda$0(this, remoteProcess, inputModel, newWindowInfo, arg_0));
        ExternalAppServerModel renderModel = new ExternalAppServerModel();
        BindableObjectExtensions.Companion.bindModel((RdBindableBase)renderModel, (IProtocol)remoteProcess.getExternalAppRenderProtocol(), windowLifetimeDef.getLifetime(), newWindowInfo.getWindowServerProtocolLink());
        Dimension dimension = this.toolWindow.getContentManager().getComponent().getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
        LoadingPanel panel = new LoadingPanel(dimension, windowLifetimeDef.getLifetime());
        WindowTitle title = new WindowTitle(this.appName, newWindowInfo.getTitle(), newWindowInfo.getIcon());
        Content newTabContent = this.createNewToolWindowTabContent(this.hideTabs ? null : newWindowInfo.getTitle(), newWindowInfo.getIcon(), true);
        RemoteWindow window = new RemoteWindow(this.project, newWindowInfo.getId(), false, title, panel, this.toolWindowFrameBufferStorage, inputModel, renderModel, windowLifetimeDef.getLifetime(), this.dispatcher, this.onWindowShownCallback, this.onWindowClosedCallback, (Function0<Unit>)((Function0)() -> RemoteApplication.createNewToolWindowTab$lambda$1(this, newTabContent)));
        this.setTabContent(newTabContent, window);
        newTabContent.setPreferredFocusedComponent(() -> RemoteApplication.createNewToolWindowTab$lambda$2(window));
        WindowCloseListener closeWindowListener = new WindowCloseListener(newTabContent, window, this.project, windowLifetimeDef);
        this.handleTabWindowStateChanges((IOptProperty<RiderWindowState>)inputModel.getWindowState(), window, newTabContent, closeWindowListener, windowLifetimeDef.getLifetime());
        this.fillContentWithUserData((UserDataHolder)newTabContent, newWindowInfo.getUserData());
        this.onToolWindowTabCreated.invoke((Object)newTabContent);
        this.toolWindow.getContentManager().addContentManagerListener((ContentManagerListener)closeWindowListener);
        windowLifetimeDef.onTermination(() -> RemoteApplication.createNewToolWindowTab$lambda$3(this, window, newTabContent, closeWindowListener));
        this.toolWindow.getContentManager().addContent(newTabContent);
        if (newWindowInfo.getFocusImmediately()) {
            this.toolWindow.getContentManager().setSelectedContent(newTabContent, true);
        }
    }

    private final void createNewDocumentWindow(RemoteProcess<TAppModel> remoteProcess, NewWindowMetaInfo newWindowInfo) {
        LifetimeDefinition windowLifetimeDef = remoteProcess.getProcessLifetime().createNested();
        ExternalAppInputModel inputModel = new ExternalAppInputModel();
        BindableObjectExtensions.Companion.bindModel((RdBindableBase)inputModel, (IProtocol)remoteProcess.getExternalAppProtocol(), windowLifetimeDef.getLifetime(), newWindowInfo.getWindowInputProtocolLink());
        inputModel.getExecuteAction().advise(this.lifetime, arg_0 -> RemoteApplication.createNewDocumentWindow$lambda$0(this, remoteProcess, inputModel, newWindowInfo, arg_0));
        ExternalAppServerModel renderModel = new ExternalAppServerModel();
        BindableObjectExtensions.Companion.bindModel((RdBindableBase)renderModel, (IProtocol)remoteProcess.getExternalAppRenderProtocol(), windowLifetimeDef.getLifetime(), newWindowInfo.getWindowServerProtocolLink());
        WindowTitle title = new WindowTitle(this.appName, newWindowInfo.getTitle(), newWindowInfo.getIcon());
        RemoteDocumentWindowFile docWindowFile = new RemoteDocumentWindowFile(this.project, title, newWindowInfo.getId(), inputModel, renderModel, this.iconClassLoader, this.dispatcher, windowLifetimeDef, this.onWindowShownCallback, this.onWindowClosedCallback);
        this.fillContentWithUserData((UserDataHolder)docWindowFile, newWindowInfo.getUserData());
        this.onDocWindowTabCreated.invoke((Object)docWindowFile);
        FileEditorManagerEx.Companion.getInstanceEx(this.project).openFile((VirtualFile)docWindowFile, newWindowInfo.getFocusImmediately(), false);
    }

    private final void createNewModalWindow(RemoteProcess<TAppModel> remoteProcess, NewWindowMetaInfo newWindowInfo) {
        LifetimeDefinition windowLifetimeDef = remoteProcess.getProcessLifetime().createNested();
        ExternalAppInputModel inputModel = new ExternalAppInputModel();
        BindableObjectExtensions.Companion.bindModel((RdBindableBase)inputModel, (IProtocol)remoteProcess.getExternalAppProtocol(), windowLifetimeDef.getLifetime(), newWindowInfo.getWindowInputProtocolLink());
        inputModel.getExecuteAction().advise(this.lifetime, arg_0 -> RemoteApplication.createNewModalWindow$lambda$0(this, remoteProcess, inputModel, newWindowInfo, arg_0));
        ExternalAppServerModel renderModel = new ExternalAppServerModel();
        BindableObjectExtensions.Companion.bindModel((RdBindableBase)renderModel, (IProtocol)remoteProcess.getExternalAppRenderProtocol(), windowLifetimeDef.getLifetime(), newWindowInfo.getWindowServerProtocolLink());
        WindowTitle title = new WindowTitle(this.appName, newWindowInfo.getTitle(), newWindowInfo.getIcon());
        RemoteModalWindow modalWindow = new RemoteModalWindow(this.project, title, newWindowInfo.getId(), inputModel, renderModel, this.dispatcher, newWindowInfo.getInitialResolution(), windowLifetimeDef);
        SwingUtilities.invokeLater(() -> RemoteApplication.createNewModalWindow$lambda$1(modalWindow));
    }

    private final void subscribeOnNewWindow(RemoteProcess<TAppModel> remoteProcess) {
        WindowManagementModel windowManagementModel = this.windowManagement;
        if (windowManagementModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManagement");
            windowManagementModel = null;
        }
        windowManagementModel.getCreateNewWindow().advise(remoteProcess.getProcessLifetime(), arg_0 -> RemoteApplication.subscribeOnNewWindow$lambda$0(this, remoteProcess, arg_0));
    }

    private final KeyboardShortcut tryConvertToShortcut(String strShortcut) {
        CharSequence charSequence = strShortcut;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        try {
            boolean isCopyCutPressed;
            KeyboardShortcut keyboardShortcut = RiderActionsHostKt.toIdeaShortcut((String)strShortcut);
            if (keyboardShortcut == null) {
                return null;
            }
            KeyboardShortcut keyboardShortcut2 = keyboardShortcut;
            boolean bl = isCopyCutPressed = (keyboardShortcut2.getFirstKeyStroke().getModifiers() == 128 || keyboardShortcut2.getFirstKeyStroke().getModifiers() == 130 || keyboardShortcut2.getFirstKeyStroke().getModifiers() == 192 || keyboardShortcut2.getFirstKeyStroke().getModifiers() == 195 || keyboardShortcut2.getFirstKeyStroke().getModifiers() == 256 || keyboardShortcut2.getFirstKeyStroke().getModifiers() == 260 || keyboardShortcut2.getFirstKeyStroke().getModifiers() == 320 || keyboardShortcut2.getFirstKeyStroke().getModifiers() == 325 || keyboardShortcut2.getFirstKeyStroke().getModifiers() == 323) && keyboardShortcut2.getFirstKeyStroke().getKeyCode() == 67;
            if (!isCopyCutPressed) {
                return null;
            }
            return keyboardShortcut2;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private final String convertShortcut(String shortcut) {
        if (Intrinsics.areEqual((Object)shortcut, (Object)"Del")) {
            return "Delete";
        }
        return shortcut;
    }

    private final AnAction assembleCtxMenu(ExternalAppInputModel inputModel, BaseActionDef actionDef, UUID windowId) {
        if (actionDef instanceof SingleRiderActionDef) {
            return new SimpleCtxMenuAction(((SingleRiderActionDef)actionDef).getTitle(), ((SingleRiderActionDef)actionDef).getIcon(), this.tryConvertToShortcut(this.convertShortcut(((SingleRiderActionDef)actionDef).getShortcut())), true, (Function0<Unit>)((Function0)() -> RemoteApplication.assembleCtxMenu$lambda$0(inputModel, windowId, actionDef)));
        }
        if (actionDef instanceof GroupRiderActionDef) {
            List childCtxDefs = new ArrayList();
            for (BaseActionDef child : ((GroupRiderActionDef)actionDef).getChildren()) {
                AnAction childDef = this.assembleCtxMenu(inputModel, child, windowId);
                childCtxDefs.add(childDef);
            }
            String string = ((GroupRiderActionDef)actionDef).getTitle();
            return (AnAction)new ActionGroup(childCtxDefs, string){
                final /* synthetic */ List<AnAction> $childCtxDefs;
                {
                    this.$childCtxDefs = $childCtxDefs;
                    super($super_call_param$1, true);
                }

                public AnAction[] getChildren(AnActionEvent e) {
                    Collection $this$toTypedArray$iv = this.$childCtxDefs;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    return thisCollection$iv.toArray(new AnAction[0]);
                }
            };
        }
        if (actionDef instanceof SeparatorActionDef) {
            return (AnAction)new Separator(((SeparatorActionDef)actionDef).getTitle());
        }
        return (AnAction)new Separator();
    }

    private final void displayContextMenu(ActionGroup actionGroup, Project project, CustomContextMenuOptions customLocation) {
        Component component = WindowManager.getInstance().getFocusedComponent(project);
        if (component == null) {
            return;
        }
        Component component2 = component;
        String place = "BE_CONTROLS_CONTEXT_MENU";
        ActionManager actionManager = ActionManager.getInstance();
        ActionPopupMenu actionPopupMenu = actionManager.createActionPopupMenu(place, actionGroup);
        Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"createActionPopupMenu(...)");
        ActionPopupMenu popupMenu = actionPopupMenu;
        Point location = null;
        if (customLocation != null && customLocation.getX() != null && customLocation.getY() != null) {
            Double d = customLocation.getX();
            Intrinsics.checkNotNull((Object)d);
            int n = (int)d.doubleValue();
            Double d2 = customLocation.getY();
            Intrinsics.checkNotNull((Object)d2);
            location = new Point(n, (int)d2.doubleValue());
        } else {
            Point point = MouseInfo.getPointerInfo().getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
            location = point;
            SwingUtilities.convertPointFromScreen(location, component2);
        }
        popupMenu.getComponent().show(component2, location.x, location.y);
        CustomContextMenuOptions customContextMenuOptions = customLocation;
        boolean bl = customContextMenuOptions != null ? customContextMenuOptions.getRightToLeft() : false;
        if (bl) {
            Dimension preferredSize = popupMenu.getComponent().getPreferredSize();
            location.x -= preferredSize.width;
            SwingUtilities.convertPointToScreen(location, component2);
            popupMenu.getComponent().setLocation(location.x, location.y);
        }
    }

    private final void executeActionHandler(RemoteProcess<TAppModel> remoteProcess, ExternalAppInputModel inputModel, ActionMessage msg, UUID windowId) {
        if (msg.getContextMenuValues() != null) {
            ContextMenuValue contextMenuValue = msg.getContextMenuValues();
            Intrinsics.checkNotNull((Object)contextMenuValue);
            AnAction ctxMenuEntry = this.assembleCtxMenu(inputModel, contextMenuValue.getValue(), windowId);
            ActionGroup ctxGroup2 = ctxMenuEntry instanceof ActionGroup ? (ActionGroup)ctxMenuEntry : (ActionGroup)new ActionGroup(ctxMenuEntry){
                final /* synthetic */ AnAction $ctxMenuEntry;
                {
                    this.$ctxMenuEntry = $ctxMenuEntry;
                }

                public AnAction[] getChildren(AnActionEvent e) {
                    AnAction[] anActionArray = new AnAction[]{this.$ctxMenuEntry};
                    return anActionArray;
                }
            };
            this.displayContextMenu(ctxGroup2, this.project, msg.getOptions());
        } else {
            ActionManager actionManager = ActionManager.getInstance();
            AnAction anAction = ActionManager.getInstance().getAction(msg.getId());
            if (anAction == null) {
                return;
            }
            AnAction action = anAction;
            if (actionManager.isGroup(msg.getId())) {
                ActionGroup ctxGroup3 = (ActionGroup)action;
                this.displayContextMenu(ctxGroup3, this.project, msg.getOptions());
            } else {
                RemoteActionDataContext<TAppModel> dataContext = new RemoteActionDataContext<TAppModel>(msg, this.project, remoteProcess.getAppModel(), remoteProcess.getProcessLifetime());
                AnActionEvent anActionEvent = AnActionEvent.createEvent((AnAction)action, (DataContext)dataContext, null, (String)"unknown", (ActionUiKind)ActionUiKind.NONE, null);
                Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
                AnActionEvent actionEvent = anActionEvent;
                action.actionPerformed(actionEvent);
            }
        }
    }

    private final ExternalAppTheme convertRiderTheme(UIThemeLookAndFeelInfo laf) {
        Object object = laf;
        if (object == null || (object = object.getId()) == null) {
            object = "ExperimentalLight";
        }
        UIThemeLookAndFeelInfo uIThemeLookAndFeelInfo = laf;
        return new ExternalAppTheme((String)object, uIThemeLookAndFeelInfo != null ? uIThemeLookAndFeelInfo.isDark() : false, !ExperimentalUI.Companion.isNewUI());
    }

    private final ExternalAppTheme getCurrentTheme() {
        UIThemeLookAndFeelInfo laf = LafManager.getInstance().getCurrentUIThemeLookAndFeel();
        return this.convertRiderTheme(laf);
    }

    private final void handleClipboard(RemoteProcess<TAppModel> remoteProcess) {
        WindowManagementModel windowManagementModel = this.windowManagement;
        if (windowManagementModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManagement");
            windowManagementModel = null;
        }
        windowManagementModel.getCopyToClipboard().advise(remoteProcess.getProcessLifetime(), RemoteApplication::handleClipboard$lambda$0);
        WindowManagementModel windowManagementModel2 = this.windowManagement;
        if (windowManagementModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManagement");
            windowManagementModel2 = null;
        }
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)windowManagementModel2.getPasteFromClipboard()), null, null, RemoteApplication::handleClipboard$lambda$1, (int)3, null);
    }

    private final void handleThemeChanges() {
        Ref.ObjectRef selectedTheme = new Ref.ObjectRef();
        selectedTheme.element = this.getCurrentTheme();
        MessageBusConnection messageBusConnection = ApplicationKt.getApplication().getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null));
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> RemoteApplication.handleThemeChanges$lambda$0(this, selectedTheme, arg_0));
    }

    private final void reloadApp() {
        Content content = this.startupTabs.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"get(...)");
        this.setTabContent(content, this.loadingPanel);
        int n = this.startupTabs.size();
        for (int i = 1; i < n; ++i) {
            this.toolWindow.getContentManager().addContent(this.startupTabs.get(i));
        }
        this.remoteProcessFactory.restart();
        this.startAppInstance();
        this.remoteProcessFactory.runWhenBackendReady();
    }

    private final void initStartupTabs() {
        for (WindowTitle windowTitle : this.mainWindowsTitle) {
            Dimension dimension = this.toolWindow.getContentManager().getComponent().getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
            LoadingPanel loadingPanel = new LoadingPanel(dimension, this.lifetime);
            Content mainTabContent = this.createNewToolWindowTabContent(this.hideTabs ? null : windowTitle.getTitle(), windowTitle.getIcon(), false);
            this.setTabContent(mainTabContent, loadingPanel);
            this.toolWindow.getContentManager().addContent(mainTabContent);
            this.startupTabs.add(mainTabContent);
        }
    }

    @NlsContexts.TabTitle
    private final String wrapIntoLocalizableString(String text) {
        return text;
    }

    private final void handleTabWindowStateChanges(IOptProperty<RiderWindowState> windowStateOpt, RemoteWindow window, Content tabContent, BaseContentCloseListener closeWindowListener, Lifetime windowLifetime) {
        windowStateOpt.advise(windowLifetime, arg_0 -> RemoteApplication.handleTabWindowStateChanges$lambda$0(this, windowLifetime, tabContent, window, closeWindowListener, arg_0));
    }

    private final void closeToolWindowTab(RemoteWindow window, Content tabContent, BaseContentCloseListener closeWindowListener) {
        window.dispose();
        if (closeWindowListener != null) {
            this.toolWindow.getContentManager().removeContentManagerListener((ContentManagerListener)closeWindowListener);
        }
        this.toolWindow.getContentManager().removeContent(tabContent, false);
    }

    /*
     * WARNING - void declaration
     */
    private final Content createNewToolWindowTabContent(@NlsContexts.TabTitle String tabTitle, String tabIcon, boolean closeable) {
        void $this$createNewToolWindowTabContent_u24lambda_u240_u240;
        SimpleToolWindowPanel simpleToolWindowPanel;
        Content content;
        Content $this$createNewToolWindowTabContent_u24lambda_u240 = content = ContentFactory.getInstance().createContent(null, tabTitle, false);
        boolean bl = false;
        SimpleToolWindowPanel simpleToolWindowPanel2 = simpleToolWindowPanel = new SimpleToolWindowPanel(false).setProvideQuickActions(true);
        Content content2 = $this$createNewToolWindowTabContent_u24lambda_u240;
        boolean bl2 = false;
        if (tabIcon != null) {
            $this$createNewToolWindowTabContent_u24lambda_u240.setIcon(IconLoader.getIcon((String)tabIcon, (ClassLoader)this.iconClassLoader));
        }
        JComponent jComponent = $this$createNewToolWindowTabContent_u24lambda_u240_u240.getToolbar();
        if (jComponent != null) {
            JComponent it = jComponent;
            boolean bl3 = false;
            $this$createNewToolWindowTabContent_u24lambda_u240_u240.setToolbar(it);
        }
        content2.setComponent((JComponent)simpleToolWindowPanel);
        $this$createNewToolWindowTabContent_u24lambda_u240.setCloseable(closeable);
        Content content3 = content;
        Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"apply(...)");
        Content content4 = content3;
        content4.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
        return content4;
    }

    private static final Unit _init_$lambda$1(RemoteApplication this$0) {
        this$0.toolWindowFrameBufferStorage.dispose();
        return Unit.INSTANCE;
    }

    private static final Unit initProcessFlowModel$lambda$0(RemoteApplication this$0, AppIsReady appIsReady) {
        Intrinsics.checkNotNullParameter((Object)appIsReady, (String)"appIsReady");
        if (appIsReady.getStartupWindows().length != this$0.mainWindowsTitle.length) {
            throw new Exception("External app startup windows count is not equal to Rider's requested windows count");
        }
        RemoteProcess remoteProcess = (RemoteProcess)this$0.remoteProcessFactory.getCurrentProcess().getValue();
        WindowManagementModel windowManagementModel = this$0.windowManagement;
        if (windowManagementModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManagement");
            windowManagementModel = null;
        }
        windowManagementModel.getCurrentTheme().set((Object)this$0.getCurrentTheme());
        int n = appIsReady.getStartupWindows().length;
        for (int i = 0; i < n; ++i) {
            Content startupTab;
            StartupWindow startupWindow = appIsReady.getStartupWindows()[i];
            Intrinsics.checkNotNullExpressionValue((Object)this$0.startupTabs.get(i), (String)"get(...)");
            RemoteApplication remoteApplication = this$0;
            Content tab$iv = startupTab;
            boolean $i$f$getTabContent = false;
            JComponent jComponent = tab$iv.getComponent();
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.ui.SimpleToolWindowPanel");
            SimpleToolWindowPanel toolWindowPanel$iv = (SimpleToolWindowPanel)jComponent;
            JComponent jComponent2 = toolWindowPanel$iv.getContent();
            if (jComponent2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.dotCommon.externalAppToolWindow.ui.LoadingPanel");
            }
            LoadingPanel loadingPanel = (LoadingPanel)jComponent2;
            ExternalAppInputModel inputModel = new ExternalAppInputModel();
            BindableObjectExtensions.Companion.bindModel((RdBindableBase)inputModel, (IProtocol)remoteProcess.getExternalAppProtocol(), remoteProcess.getProcessLifetime(), startupWindow.getInputProtocolLink());
            inputModel.getExecuteAction().advise(this$0.lifetime, arg_0 -> RemoteApplication.initProcessFlowModel$lambda$0$0(this$0, remoteProcess, inputModel, startupWindow, arg_0));
            ExternalAppServerModel renderModel = new ExternalAppServerModel();
            BindableObjectExtensions.Companion.bindModel((RdBindableBase)renderModel, (IProtocol)remoteProcess.getExternalAppRenderProtocol(), remoteProcess.getProcessLifetime(), startupWindow.getServerProtocolLink());
            WindowTitle title = new WindowTitle(this$0.appName, this$0.mainWindowsTitle[i].getTitle(), this$0.mainWindowsTitle[i].getIcon());
            RemoteWindow window = new RemoteWindow(this$0.project, startupWindow.getWindowId(), false, title, loadingPanel, this$0.toolWindowFrameBufferStorage, inputModel, renderModel, remoteProcess.getProcessLifetime(), this$0.dispatcher, this$0.onWindowShownCallback, this$0.onWindowClosedCallback, (Function0<Unit>)((Function0)() -> RemoteApplication.initProcessFlowModel$lambda$0$1(this$0, startupTab)));
            startupTab.setPreferredFocusedComponent(() -> RemoteApplication.initProcessFlowModel$lambda$0$2(window));
            this$0.onToolWindowTabCreated.invoke((Object)startupTab);
            for (StartupWindowUserData data : startupWindow.getUserData()) {
                Key<String> key;
                String keyString = Strings.toUpperCase((String)data.getId());
                if (!this$0.supportedUserDataKeys.containsKey(keyString)) continue;
                Intrinsics.checkNotNull(this$0.supportedUserDataKeys.get(keyString));
                startupTab.putUserData(key, (Object)data.getValue());
            }
            this$0.setTabContent(startupTab, window);
            this$0.handleTabWindowStateChanges((IOptProperty<RiderWindowState>)inputModel.getWindowState(), window, startupTab, null, remoteProcess.getProcessLifetime());
            remoteProcess.getProcessLifetime().onTermination(() -> RemoteApplication.initProcessFlowModel$lambda$0$3(window));
        }
        return Unit.INSTANCE;
    }

    private static final Unit initProcessFlowModel$lambda$0$0(RemoteApplication this$0, RemoteProcess $remoteProcess, ExternalAppInputModel $inputModel, StartupWindow $startupWindow, ActionMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this$0.executeActionHandler($remoteProcess, $inputModel, msg, $startupWindow.getWindowId());
        return Unit.INSTANCE;
    }

    private static final Unit initProcessFlowModel$lambda$0$1(RemoteApplication this$0, Content $startupTab) {
        this$0.toolWindow.getContentManager().setSelectedContent($startupTab, true);
        return Unit.INSTANCE;
    }

    private static final JComponent initProcessFlowModel$lambda$0$2(RemoteWindow $window) {
        return $window;
    }

    private static final Unit initProcessFlowModel$lambda$0$3(RemoteWindow $window) {
        $window.dispose();
        return Unit.INSTANCE;
    }

    private static final Unit startAppInstance$lambda$0(RemoteApplication this$0) {
        if (this$0.lifetime.getStatus() == LifetimeStatus.Alive) {
            ApplicationCrashWindow crashWindow = new ApplicationCrashWindow(this$0.appName, (Function0<Unit>)((Function0)() -> RemoteApplication.startAppInstance$lambda$0$0(this$0)));
            Content content = this$0.startupTabs.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)content, (String)"get(...)");
            this$0.setTabContent(content, crashWindow);
            int n = this$0.startupTabs.size();
            for (int i = 1; i < n; ++i) {
                RemoteWindow remoteWindow;
                Content tab;
                Intrinsics.checkNotNullExpressionValue((Object)this$0.startupTabs.get(i), (String)"get(...)");
                RemoteApplication remoteApplication = this$0;
                Content tab$iv = tab;
                boolean $i$f$tryGetTabContent = false;
                JComponent jComponent = tab$iv.getComponent();
                Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.ui.SimpleToolWindowPanel");
                SimpleToolWindowPanel toolWindowPanel$iv = (SimpleToolWindowPanel)jComponent;
                JComponent jComponent2 = toolWindowPanel$iv.getContent();
                if (!(jComponent2 instanceof RemoteWindow)) {
                    jComponent2 = null;
                }
                if ((remoteWindow = (RemoteWindow)jComponent2) != null) {
                    this$0.setTabContent(tab, remoteWindow.getLoadingPanel());
                }
                this$0.toolWindow.getContentManager().removeContent(this$0.startupTabs.get(i), false);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit startAppInstance$lambda$0$0(RemoteApplication this$0) {
        this$0.reloadApp();
        return Unit.INSTANCE;
    }

    private static final Project startAppInstance$lambda$1(RemoteApplication this$0) {
        return this$0.project;
    }

    private static final Project startAppInstance$lambda$2(RemoteApplication this$0) {
        return this$0.project;
    }

    private static final Unit createNewToolWindowTab$lambda$0(RemoteApplication this$0, RemoteProcess $remoteProcess, ExternalAppInputModel $inputModel, NewWindowMetaInfo $newWindowInfo, ActionMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this$0.executeActionHandler($remoteProcess, $inputModel, msg, $newWindowInfo.getId());
        return Unit.INSTANCE;
    }

    private static final Unit createNewToolWindowTab$lambda$1(RemoteApplication this$0, Content $newTabContent) {
        this$0.toolWindow.getContentManager().setSelectedContent($newTabContent, true);
        return Unit.INSTANCE;
    }

    private static final JComponent createNewToolWindowTab$lambda$2(RemoteWindow $window) {
        return $window;
    }

    private static final Unit createNewToolWindowTab$lambda$3(RemoteApplication this$0, RemoteWindow $window, Content $newTabContent, WindowCloseListener $closeWindowListener) {
        this$0.closeToolWindowTab($window, $newTabContent, $closeWindowListener);
        return Unit.INSTANCE;
    }

    private static final Unit createNewDocumentWindow$lambda$0(RemoteApplication this$0, RemoteProcess $remoteProcess, ExternalAppInputModel $inputModel, NewWindowMetaInfo $newWindowInfo, ActionMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this$0.executeActionHandler($remoteProcess, $inputModel, msg, $newWindowInfo.getId());
        return Unit.INSTANCE;
    }

    private static final Unit createNewModalWindow$lambda$0(RemoteApplication this$0, RemoteProcess $remoteProcess, ExternalAppInputModel $inputModel, NewWindowMetaInfo $newWindowInfo, ActionMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this$0.executeActionHandler($remoteProcess, $inputModel, msg, $newWindowInfo.getId());
        return Unit.INSTANCE;
    }

    private static final void createNewModalWindow$lambda$1(RemoteModalWindow $modalWindow) {
        $modalWindow.getWindow().setVisible(true);
    }

    private static final Unit subscribeOnNewWindow$lambda$0(RemoteApplication this$0, RemoteProcess $remoteProcess, NewWindowMetaInfo newWindowInfo) {
        Intrinsics.checkNotNullParameter((Object)newWindowInfo, (String)"newWindowInfo");
        switch (WhenMappings.$EnumSwitchMapping$0[newWindowInfo.getWindowType().ordinal()]) {
            case 1: {
                this$0.createNewToolWindowTab($remoteProcess, newWindowInfo);
                break;
            }
            case 2: {
                this$0.createNewDocumentWindow($remoteProcess, newWindowInfo);
                break;
            }
            case 3: {
                this$0.createNewModalWindow($remoteProcess, newWindowInfo);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit assembleCtxMenu$lambda$0(ExternalAppInputModel $inputModel, UUID $windowId, BaseActionDef $actionDef) {
        IRdDispatcherKt.getAsRdDispatcher((IScheduler)InterfacesKt.getProtocolOrThrow((IRdDynamic)((IRdDynamic)$inputModel)).getScheduler()).queue(() -> RemoteApplication.assembleCtxMenu$lambda$0$0($inputModel, $windowId, $actionDef));
        return Unit.INSTANCE;
    }

    private static final Unit assembleCtxMenu$lambda$0$0(ExternalAppInputModel $inputModel, UUID $windowId, BaseActionDef $actionDef) {
        $inputModel.getClientMessage().fire((Object)new InvokeActionMessage($windowId, ((SingleRiderActionDef)$actionDef).getActionId()));
        return Unit.INSTANCE;
    }

    private static final Unit handleClipboard$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(it));
        return Unit.INSTANCE;
    }

    private static final RdTask handleClipboard$lambda$1(Lifetime lifetime, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
        Transferable clipboardContent = CopyPasteManager.getInstance().getContents();
        Object content = null;
        try {
            Object object = clipboardContent;
            if (object == null || (object = object.getTransferData(DataFlavor.stringFlavor)) == null || (object = object.toString()) == null) {
                object = "";
            }
            content = object;
        }
        catch (Exception e) {
            content = "";
        }
        return RdTask.Companion.fromResult(content);
    }

    private static final void handleThemeChanges$lambda$0(RemoteApplication this$0, Ref.ObjectRef $selectedTheme, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ExternalAppTheme newTheme = this$0.convertRiderTheme(it.getCurrentUIThemeLookAndFeel());
        if (Intrinsics.areEqual((Object)$selectedTheme.element, (Object)newTheme)) {
            return;
        }
        $selectedTheme.element = newTheme;
        WindowManagementModel windowManagementModel = this$0.windowManagement;
        if (windowManagementModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"windowManagement");
            windowManagementModel = null;
        }
        windowManagementModel.getCurrentTheme().set($selectedTheme.element);
    }

    private static final Unit handleTabWindowStateChanges$lambda$0(RemoteApplication this$0, Lifetime $windowLifetime, Content $tabContent, RemoteWindow $window, BaseContentCloseListener $closeWindowListener, RiderWindowState windowState) {
        Intrinsics.checkNotNullParameter((Object)windowState, (String)"windowState");
        if (!this$0.hideTabs) {
            windowState.getWindowTitle().advise($windowLifetime, arg_0 -> RemoteApplication.handleTabWindowStateChanges$lambda$0$0($tabContent, this$0, arg_0));
        }
        windowState.getWindowIcon().advise($windowLifetime, arg_0 -> RemoteApplication.handleTabWindowStateChanges$lambda$0$1($tabContent, this$0, arg_0));
        windowState.getClose().advise($windowLifetime, arg_0 -> RemoteApplication.handleTabWindowStateChanges$lambda$0$2(this$0, $window, $tabContent, $closeWindowListener, arg_0));
        windowState.getPutUserData().advise($windowLifetime, arg_0 -> RemoteApplication.handleTabWindowStateChanges$lambda$0$3(this$0, $tabContent, arg_0));
        windowState.getFocusInIde().advise($windowLifetime, arg_0 -> RemoteApplication.handleTabWindowStateChanges$lambda$0$4(this$0, $tabContent, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit handleTabWindowStateChanges$lambda$0$0(Content $tabContent, RemoteApplication this$0, String newTitle) {
        Intrinsics.checkNotNullParameter((Object)newTitle, (String)"newTitle");
        $tabContent.setDisplayName(this$0.wrapIntoLocalizableString(newTitle));
        return Unit.INSTANCE;
    }

    private static final Unit handleTabWindowStateChanges$lambda$0$1(Content $tabContent, RemoteApplication this$0, String iconPath) {
        if (iconPath != null) {
            $tabContent.setIcon(IconLoader.getIcon((String)iconPath, (ClassLoader)this$0.iconClassLoader));
        }
        return Unit.INSTANCE;
    }

    private static final Unit handleTabWindowStateChanges$lambda$0$2(RemoteApplication this$0, RemoteWindow $window, Content $tabContent, BaseContentCloseListener $closeWindowListener, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.closeToolWindowTab($window, $tabContent, $closeWindowListener);
        return Unit.INSTANCE;
    }

    private static final Unit handleTabWindowStateChanges$lambda$0$3(RemoteApplication this$0, Content $tabContent, WindowStateUserData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        WindowStateUserData userData = it;
        if (!this$0.supportedUserDataKeys.containsKey(userData.getKey())) {
            return Unit.INSTANCE;
        }
        Key<String> key = this$0.supportedUserDataKeys.get(userData.getKey());
        Intrinsics.checkNotNull(key);
        Key<String> key2 = key;
        $tabContent.putUserData(key2, (Object)userData.getValue());
        return Unit.INSTANCE;
    }

    private static final Unit handleTabWindowStateChanges$lambda$0$4(RemoteApplication this$0, Content $tabContent, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.toolWindow.getContentManager().setSelectedContent($tabContent, true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WindowType.values().length];
            try {
                nArray[WindowType.ToolWindow.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowType.DocumentWindow.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowType.ModalWindow.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

