/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import com.jetbrains.dotCommon.Architecture;
import com.jetbrains.rider.plugins.RiderBundledPluginHelpers;
import java.io.File;
import java.io.FileNotFoundException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0016\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u0086 J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0010J\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0010H\u0082 J\u0011\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0010H\u0086 J\u0011\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0010H\u0086 J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c2\u0006\u0010\u0016\u001a\u00020\u0010H\u0086 \u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0010J\u0011\u0010 \u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0010H\u0082 J\u0011\u0010!\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0010H\u0086 J\u0011\u0010\"\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0010H\u0086 J\u0019\u0010#\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&H\u0086 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/dotCommon/ProcessInfoApi;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "os", "", "architecture", "libraryPrefix", "libraryExtension", "JNI_LIBRARY_NAME", "processInfoApiRelativePath", "processInfoApiFile", "Ljava/io/File;", "MICROSECONDS_IN_SECOND", "", "NANOSECONDS_IN_MICROSECOND", "getQpcTimestamp", "", "getProcessArchitecture", "Lcom/jetbrains/dotCommon/Architecture;", "processId", "getProcessArchitectureJNI", "", "getProcessExecutable", "getProcessCommandLine", "getProcessEnvironmentVariables", "", "(I)[Ljava/lang/String;", "getProcessStartTime", "Ljava/time/LocalDateTime;", "getProcessStartTimeInMicrosecondsJNI", "getProcessPrivateMemory", "getProcessWorkingSet", "getProcessCpuUsage", "", "previousTimes", "", "intellij.rider.plugins.dotCommon"})
@SourceDebugExtension(value={"SMAP\nProcessInfoApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessInfoApi.kt\ncom/jetbrains/dotCommon/ProcessInfoApi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,89:1\n295#2,2:90\n13#3:92\n13#4:93\n*S KotlinDebug\n*F\n+ 1 ProcessInfoApi.kt\ncom/jetbrains/dotCommon/ProcessInfoApi\n*L\n66#1:90,2\n14#1:92\n14#1:93\n*E\n"})
public final class ProcessInfoApi {
    @NotNull
    public static final ProcessInfoApi INSTANCE;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String os;
    @NotNull
    private static final String architecture;
    @NotNull
    private static final String libraryPrefix;
    @NotNull
    private static final String libraryExtension;
    @NotNull
    private static final String JNI_LIBRARY_NAME = "JetBrains.Common.ProcessInfoApi";
    @NotNull
    private static final String processInfoApiRelativePath;
    @Nullable
    private static final File processInfoApiFile;
    private static final int MICROSECONDS_IN_SECOND = 1000000;
    private static final int NANOSECONDS_IN_MICROSECOND = 1000;

    private ProcessInfoApi() {
    }

    public final native long getQpcTimestamp();

    @Nullable
    public final Architecture getProcessArchitecture(int processId) {
        Object v0;
        block1: {
            short architectureId = UShort.constructor-impl((short)this.getProcessArchitectureJNI(processId));
            boolean bl = false;
            Iterable $this$firstOrNull$iv = (Iterable)Architecture.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Architecture it = (Architecture)((Object)element$iv);
                boolean bl2 = false;
                if (!(it.getId-Mh2AYeg() == architectureId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final native short getProcessArchitectureJNI(int var1);

    @NotNull
    public final native String getProcessExecutable(int var1);

    @NotNull
    public final native String getProcessCommandLine(int var1);

    @NotNull
    public final native String[] getProcessEnvironmentVariables(int var1);

    @NotNull
    public final LocalDateTime getProcessStartTime(int processId) {
        long microSecondsSinceEpoch = this.getProcessStartTimeInMicrosecondsJNI(processId);
        Instant instant = Instant.ofEpochSecond(microSecondsSinceEpoch / (long)1000000, microSecondsSinceEpoch % (long)1000000 * (long)1000);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofInstant(...)");
        return localDateTime;
    }

    private final native long getProcessStartTimeInMicrosecondsJNI(int var1);

    public final native long getProcessPrivateMemory(int var1);

    public final native long getProcessWorkingSet(int var1);

    public final native double getProcessCpuUsage(int var1, @NotNull long[] var2);

    static {
        CpuArch currentArchitecture;
        OS currentOS;
        INSTANCE = new ProcessInfoApi();
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProcessInfoApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProcessInfoApi.logger = logger;
        OS oS = currentOS = OS.CURRENT;
        os = switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1 -> "windows";
            case 2 -> "linux";
            case 3 -> "macos";
            default -> throw new IllegalStateException("Unsupported OS: " + currentOS);
        };
        CpuArch cpuArch = currentArchitecture = CpuArch.CURRENT;
        architecture = switch (cpuArch == null ? -1 : WhenMappings.$EnumSwitchMapping$1[cpuArch.ordinal()]) {
            case 1 -> "x86";
            case 2 -> "x64";
            case 3 -> "arm";
            case 4 -> "arm64";
            default -> throw new IllegalStateException("Unsupported architecture: " + currentArchitecture);
        };
        OS oS2 = currentOS = OS.CURRENT;
        libraryPrefix = switch (oS2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS2.ordinal()]) {
            case 1 -> "";
            case 2, 3 -> "lib";
            default -> throw new IllegalStateException("Unsupported OS: " + currentOS);
        };
        OS oS3 = currentOS = OS.CURRENT;
        libraryExtension = switch (oS3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS3.ordinal()]) {
            case 1 -> ".dll";
            case 2 -> ".so";
            case 3 -> ".dylib";
            default -> throw new IllegalStateException("Unsupported OS: " + currentOS);
        };
        processInfoApiRelativePath = os + "-" + architecture + File.separatorChar + libraryPrefix + JNI_LIBRARY_NAME + libraryExtension;
        processInfoApiFile = RiderBundledPluginHelpers.Companion.getBundledPluginDotFile(INSTANCE.getClass(), processInfoApiRelativePath, ProcessInfoApi.logger);
        try {
            if (processInfoApiFile == null) {
                throw new FileNotFoundException();
            }
            System.load(processInfoApiFile.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError e) {
            ProcessInfoApi.logger.warn((Throwable)e);
        }
        catch (FileNotFoundException e) {
            ProcessInfoApi.logger.warn((Throwable)e);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CpuArch.values().length];
            try {
                nArray[CpuArch.X86.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.X86_64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.ARM32.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.ARM64.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

