/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.shared.run;

import com.intellij.execution.Platform;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.shared.run.IORedirectionMode;
import com.jetbrains.rider.shared.run.WindowsInputStream;
import com.jetbrains.rider.shared.run.WindowsOutputStream;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.function.LongConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 02\u00020\u0001:\u00040123BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u001b\u001a\u00020\u001cJ \u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0002J \u0010\u001d\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u0003H\u0002J\n\u0010&\u001a\u0004\u0018\u00010\u0016H\u0016J\n\u0010'\u001a\u0004\u0018\u00010\u0012H\u0016J\n\u0010(\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010)\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010*\u001a\u00020\u0003H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u0003H\u0016J\b\u0010.\u001a\u00020,H\u0016J\b\u0010/\u001a\u00020\u001cH\u0016R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00064"}, d2={"Lcom/jetbrains/rider/shared/run/WindowsProcess;", "Ljava/lang/Process;", "isConsoleApp", "", "ioRedirectionMode", "Lcom/jetbrains/rider/shared/run/IORedirectionMode;", "command", "", "environment", "", "directory", "winSuspendedProcessCallback", "Ljava/util/function/LongConsumer;", "WindowsProcess", "(ZLcom/jetbrains/rider/shared/run/IORedirectionMode;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;Ljava/util/function/LongConsumer;)V", "processInputStream", "Ljava/io/InputStream;", "processOutputStream", "Ljava/io/OutputStream;", "processErrStream", "procHandle", "Ljava/util/Optional;", "Ljava/lang/ProcessHandle;", "processInfo", "Lcom/sun/jna/platform/win32/WinBase$PROCESS_INFORMATION;", "getProcessInfo", "()Lcom/sun/jna/platform/win32/WinBase$PROCESS_INFORMATION;", "dispose", "", "x", "readPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLEByReference;", "writePipe", "pipeAttributes", "Lcom/sun/jna/platform/win32/WinBase$SECURITY_ATTRIBUTES;", "parentHandle", "childHandle", "parentInputs", "toHandle", "getOutputStream", "getInputStream", "getErrorStream", "supportsNormalTermination", "waitFor", "", "isAlive", "exitValue", "destroy", "Companion", "Kernel32Ex", "NullInputStream", "NullOutputStream", "intellij.rider.shared"})
@SourceDebugExtension(value={"SMAP\nWindowsProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsProcess.kt\ncom/jetbrains/rider/shared/run/WindowsProcess\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,310:1\n126#2:311\n153#2,3:312\n13#3:315\n13#3:316\n*S KotlinDebug\n*F\n+ 1 WindowsProcess.kt\ncom/jetbrains/rider/shared/run/WindowsProcess\n*L\n85#1:311\n85#1:312,3\n122#1:315\n271#1:316\n*E\n"})
public final class WindowsProcess
extends Process {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Map<String, String> environment;
    @Nullable
    private final InputStream processInputStream;
    @Nullable
    private final OutputStream processOutputStream;
    @Nullable
    private final InputStream processErrStream;
    @NotNull
    private final Optional<ProcessHandle> procHandle;
    @NotNull
    private final WinBase.PROCESS_INFORMATION processInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowsProcess(boolean isConsoleApp, @NotNull IORedirectionMode ioRedirectionMode, @NotNull String command, @Nullable Map<String, String> environment, @Nullable String directory, @Nullable LongConsumer winSuspendedProcessCallback) {
        Intrinsics.checkNotNullParameter((Object)((Object)ioRedirectionMode), (String)"ioRedirectionMode");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.environment = environment;
        if (!(Platform.current() == Platform.WINDOWS)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        WinBase.STARTUPINFO sTARTUPINFO = new WinBase.STARTUPINFO();
        sTARTUPINFO.cb = new WinDef.DWORD((long)sTARTUPINFO.size());
        this.processInfo = new WinBase.PROCESS_INFORMATION();
        WinNT.HANDLEByReference hANDLEByReference = new WinNT.HANDLEByReference();
        WinNT.HANDLEByReference hANDLEByReference2 = new WinNT.HANDLEByReference();
        WinNT.HANDLEByReference hANDLEByReference3 = new WinNT.HANDLEByReference();
        WinNT.HANDLEByReference hANDLEByReference4 = new WinNT.HANDLEByReference();
        WinNT.HANDLEByReference hANDLEByReference5 = new WinNT.HANDLEByReference();
        WinNT.HANDLEByReference hANDLEByReference6 = new WinNT.HANDLEByReference();
        try {
            Object object;
            Memory memory;
            if (ioRedirectionMode == IORedirectionMode.Enabled) {
                this.x(hANDLEByReference, hANDLEByReference2, true);
                this.x(hANDLEByReference3, hANDLEByReference4, false);
                this.x(hANDLEByReference5, hANDLEByReference6, false);
                sTARTUPINFO.hStdInput = hANDLEByReference2.getValue();
                sTARTUPINFO.hStdOutput = hANDLEByReference4.getValue();
                sTARTUPINFO.hStdError = hANDLEByReference6.getValue();
                sTARTUPINFO.dwFlags = 256;
            }
            char[] cArray = new char[]{'\u0000'};
            char[] cArray2 = (StringsKt.trimEnd((String)command, (char[])cArray) + "\u0000").toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"toCharArray(...)");
            char[] cArray3 = cArray2;
            WindowsProcess windowsProcess = this;
            boolean bl = false;
            if (windowsProcess.environment == null || windowsProcess.environment.isEmpty()) {
                memory = null;
            } else {
                SortedMap sortedMap = MapsKt.toSortedMap((Map)MapsKt.toMutableMap(windowsProcess.environment));
                Object object2 = sortedMap;
                boolean bl2 = false;
                Map map = object2;
                object = new ArrayList(object2.size());
                boolean bl3 = false;
                Iterator iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry;
                    Map.Entry entry2 = entry = iterator2.next();
                    Collection collection = object;
                    boolean bl4 = false;
                    String string = (String)entry2.getKey();
                    String string2 = (String)entry2.getValue();
                    collection.add(string + "=" + string2 + "\u0000");
                }
                String string = CollectionsKt.joinToString$default((Iterable)((List)object), (CharSequence)"", null, (CharSequence)"\u0000", (int)0, null, null, (int)58, null);
                byte[] byArray = string.getBytes(Charsets.UTF_16LE);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                object2 = byArray;
                Memory memory2 = new Memory((long)((Object)object2).length);
                memory2.write(0L, (byte[])object2, 0, ((Object)object2).length);
                memory = memory2;
            }
            cArray = memory;
            long l = winSuspendedProcessCallback != null ? 4L : 0L;
            long l2 = isConsoleApp && ioRedirectionMode == IORedirectionMode.ExternalConsole ? 528L : 0x8000000L;
            boolean bl5 = ioRedirectionMode == IORedirectionMode.Enabled;
            boolean bl6 = Kernel32.INSTANCE.CreateProcessW(null, cArray3, null, null, bl5, new WinDef.DWORD(0x400L | l | l2), (Pointer)cArray, directory, sTARTUPINFO, this.processInfo);
            if (!bl6) {
                int n = Kernel32.INSTANCE.GetLastError();
                object = Kernel32Util.formatMessage((int)n);
                throw new RuntimeException("CreateProcessW failed with error code: " + n + ". Error message: " + (String)object);
            }
            long l3 = this.processInfo.dwProcessId.longValue();
            if (winSuspendedProcessCallback != null) {
                try {
                    winSuspendedProcessCallback.accept(l3);
                }
                catch (Throwable throwable) {
                    boolean bl7 = false;
                    Logger logger = Logger.getInstance(WindowsProcess.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error(throwable.getMessage(), throwable.getCause());
                }
                Kernel32Ex kernel32Ex = Kernel32Ex.Companion.getINSTANCE();
                WinNT.HANDLE hANDLE = this.processInfo.hThread;
                Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)"hThread");
                if (!kernel32Ex.ResumeThread(hANDLE)) {
                    int n = Kernel32.INSTANCE.GetLastError();
                    String string = Kernel32Util.formatMessage((int)n);
                    throw new RuntimeException("WindowProcess resume thread exception. Error code: " + n + ". Error message: " + string);
                }
            }
            Optional<ProcessHandle> optional = ProcessHandle.of(l3);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            this.procHandle = optional;
        }
        catch (Exception exception) {
            Kernel32Ex.Companion.closeHandleRefSafe(hANDLEByReference);
            Kernel32Ex.Companion.closeHandleRefSafe(hANDLEByReference3);
            Kernel32Ex.Companion.closeHandleRefSafe(hANDLEByReference5);
            throw new RuntimeException("Process creation exception", exception);
        }
        finally {
            Kernel32Ex.Companion.closeHandleRefSafe(hANDLEByReference2);
            Kernel32Ex.Companion.closeHandleRefSafe(hANDLEByReference4);
            Kernel32Ex.Companion.closeHandleRefSafe(hANDLEByReference6);
        }
        if (ioRedirectionMode == IORedirectionMode.Enabled) {
            WinNT.HANDLE hANDLE = hANDLEByReference.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)"getValue(...)");
            this.processOutputStream = new WindowsOutputStream(hANDLE);
            WinNT.HANDLE hANDLE2 = hANDLEByReference3.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE2, (String)"getValue(...)");
            this.processInputStream = new WindowsInputStream(hANDLE2);
            WinNT.HANDLE hANDLE3 = hANDLEByReference5.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE3, (String)"getValue(...)");
            this.processErrStream = new WindowsInputStream(hANDLE3);
        } else {
            this.processOutputStream = NullOutputStream.Companion.getInstance();
            this.processInputStream = NullInputStream.Companion.getInstance();
            this.processErrStream = NullInputStream.Companion.getInstance();
        }
    }

    @NotNull
    public final WinBase.PROCESS_INFORMATION getProcessInfo() {
        return this.processInfo;
    }

    public final void dispose() {
        Kernel32.INSTANCE.CloseHandle(this.processInfo.hProcess);
        Kernel32.INSTANCE.CloseHandle(this.processInfo.hThread);
    }

    private final void x(WinNT.HANDLEByReference hANDLEByReference, WinNT.HANDLEByReference hANDLEByReference2, WinBase.SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES) {
        boolean bl = Kernel32.INSTANCE.CreatePipe(hANDLEByReference, hANDLEByReference2, sECURITY_ATTRIBUTES, 0);
        if (!bl) {
            throw new RuntimeException("Cannot create a pipe");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void x(WinNT.HANDLEByReference hANDLEByReference, WinNT.HANDLEByReference hANDLEByReference2, boolean bl) {
        WinBase.SECURITY_ATTRIBUTES sECURITY_ATTRIBUTES = new WinBase.SECURITY_ATTRIBUTES();
        sECURITY_ATTRIBUTES.dwLength = new WinDef.DWORD((long)sECURITY_ATTRIBUTES.size());
        sECURITY_ATTRIBUTES.bInheritHandle = true;
        WinNT.HANDLEByReference hANDLEByReference3 = new WinNT.HANDLEByReference();
        try {
            if (bl) {
                this.x(hANDLEByReference2, hANDLEByReference3, sECURITY_ATTRIBUTES);
            } else {
                this.x(hANDLEByReference3, hANDLEByReference2, sECURITY_ATTRIBUTES);
            }
            WinNT.HANDLE hANDLE = Kernel32.INSTANCE.GetCurrentProcess();
            boolean bl2 = Kernel32.INSTANCE.DuplicateHandle(hANDLE, hANDLEByReference3.getValue(), hANDLE, hANDLEByReference, 0, false, 2);
            if (!bl2) {
                throw new RuntimeException("Cannot duplicate pipe handle");
            }
        }
        finally {
            Kernel32Util.closeHandleRef((WinNT.HANDLEByReference)hANDLEByReference3);
        }
    }

    @Override
    @Nullable
    public ProcessHandle toHandle() {
        return this.procHandle.isEmpty() ? null : this.procHandle.get();
    }

    @Override
    @Nullable
    public OutputStream getOutputStream() {
        return this.processOutputStream;
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        return this.processInputStream;
    }

    @Override
    @Nullable
    public InputStream getErrorStream() {
        return this.processErrStream;
    }

    @Override
    public boolean supportsNormalTermination() {
        return false;
    }

    @Override
    public int waitFor() {
        Kernel32.INSTANCE.WaitForSingleObject(this.processInfo.hProcess, -1);
        IntByReference intByReference = new IntByReference();
        if (!Kernel32.INSTANCE.GetExitCodeProcess(this.processInfo.hProcess, intByReference)) {
            int n = Kernel32.INSTANCE.GetLastError();
            String string = Kernel32Util.formatMessage((int)n);
            throw new RuntimeException("WindowsProcess.waitFor exception. Error code: " + n + ". Error message: " + string);
        }
        return intByReference.getValue();
    }

    @Override
    public boolean isAlive() {
        WinNT.HANDLE hANDLE = this.processInfo.hProcess;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)"hProcess");
        return Companion.isProcessAlive(hANDLE);
    }

    @Override
    public int exitValue() {
        IntByReference intByReference = new IntByReference();
        if (!Kernel32.INSTANCE.GetExitCodeProcess(this.processInfo.hProcess, intByReference)) {
            int n = Kernel32.INSTANCE.GetLastError();
            String string = Kernel32Util.formatMessage((int)n);
            throw new RuntimeException("WindowsProcess.exitValue exception. Error code: " + n + ". Error message: " + string);
        }
        return intByReference.getValue();
    }

    @Override
    public void destroy() {
        if (!this.isAlive()) {
            return;
        }
        if (!Kernel32.INSTANCE.TerminateProcess(this.processInfo.hProcess, -1)) {
            int n = Kernel32.INSTANCE.GetLastError();
            String string = Kernel32Util.formatMessage((int)n);
            boolean bl = false;
            Logger logger = Logger.getInstance(WindowsProcess.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Failed to terminate process " + this.processInfo.dwProcessId + ". Error code: " + n + ".Error message: " + string);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/shared/run/WindowsProcess$Companion;", "", "WindowsProcess$Companion", "()V", "isProcessAlive", "", "processHandle", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "intellij.rider.shared"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isProcessAlive(@NotNull WinNT.HANDLE processHandle) {
            Intrinsics.checkNotNullParameter((Object)processHandle, (String)"processHandle");
            int n = Kernel32.INSTANCE.WaitForSingleObject(processHandle, 0);
            return switch (n) {
                case 0 -> false;
                case 258 -> true;
                case 128 -> throw new IllegalStateException("WaitForSingleObject() returned WAIT_ABANDONED");
                case -1 -> {
                    int var3_3 = Kernel32.INSTANCE.GetLastError();
                    throw new RuntimeException("WaitForSingleObject() failed with error code: " + var3_3);
                }
                default -> throw new RuntimeException("Unexpected result from WaitForSingleObject(): " + n);
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rider/shared/run/WindowsProcess$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "ResumeThread", "", "hThread", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "Companion", "intellij.rider.shared"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean ResumeThread(@NotNull WinNT.HANDLE var1);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/shared/run/WindowsProcess$Kernel32Ex$Companion;", "", "WindowsProcess$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rider/shared/run/WindowsProcess$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rider/shared/run/WindowsProcess$Kernel32Ex;", "closeHandleRefSafe", "", "handleRef", "Lcom/sun/jna/platform/win32/WinNT$HANDLEByReference;", "intellij.rider.shared"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            public final void closeHandleRefSafe(@NotNull WinNT.HANDLEByReference handleRef) {
                Intrinsics.checkNotNullParameter((Object)handleRef, (String)"handleRef");
                if (handleRef.getValue() == null) {
                    return;
                }
                Kernel32.INSTANCE.CloseHandle(handleRef.getValue());
            }

            static {
                $$INSTANCE = new Companion();
                Library library = Native.load((String)"kernel32", Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)library, (String)"load(...)");
                INSTANCE = (Kernel32Ex)library;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/shared/run/WindowsProcess$NullInputStream;", "Ljava/io/InputStream;", "WindowsProcess$NullInputStream", "()V", "read", "", "available", "Companion", "intellij.rider.shared"})
    private static final class NullInputStream
    extends InputStream {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final NullInputStream Instance = new NullInputStream();

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int available() {
            return 0;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/shared/run/WindowsProcess$NullInputStream$Companion;", "", "WindowsProcess$NullInputStream$Companion", "()V", "Instance", "Lcom/jetbrains/rider/shared/run/WindowsProcess$NullInputStream;", "getInstance", "()Lcom/jetbrains/rider/shared/run/WindowsProcess$NullInputStream;", "intellij.rider.shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final NullInputStream getInstance() {
                return Instance;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/shared/run/WindowsProcess$NullOutputStream;", "Ljava/io/OutputStream;", "WindowsProcess$NullOutputStream", "()V", "write", "", "b", "", "Companion", "intellij.rider.shared"})
    private static final class NullOutputStream
    extends OutputStream {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final NullOutputStream Instance = new NullOutputStream();

        @Override
        public void write(int b) {
            throw new IOException("Stream closed");
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/shared/run/WindowsProcess$NullOutputStream$Companion;", "", "WindowsProcess$NullOutputStream$Companion", "()V", "Instance", "Lcom/jetbrains/rider/shared/run/WindowsProcess$NullOutputStream;", "getInstance", "()Lcom/jetbrains/rider/shared/run/WindowsProcess$NullOutputStream;", "intellij.rider.shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final NullOutputStream getInstance() {
                return Instance;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

