/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.shared.run;

import com.intellij.execution.Platform;
import com.intellij.execution.configurations.CommandLineWithSuspendedProcessCallback;
import com.intellij.execution.configurations.CompositeParameterTargetedValue;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.rider.shared.run.IORedirectionMode;
import com.jetbrains.rider.shared.run.RawCommandLine;
import com.jetbrains.rider.shared.run.RawCommandLineKt;
import com.jetbrains.rider.shared.run.RawParameterValue;
import com.jetbrains.rider.shared.run.WindowsProcess;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.LongConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0014J\u0012\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\rH\u0016J\u001f\u0010\u0016\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\r\u00a2\u0006\u0002\b\u00180\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J,\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\u0006\u0010\u001d\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\rH\u0016J\b\u0010\"\u001a\u00020\u0001H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u000bH\u0016J\n\u0010%\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/rider/shared/run/SuspendableRawCommandLine;", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "Lcom/jetbrains/rider/shared/run/RawCommandLine;", "Lcom/intellij/execution/configurations/CommandLineWithSuspendedProcessCallback;", "ioRedirectionMode", "Lcom/jetbrains/rider/shared/run/IORedirectionMode;", "isConsole", "", "SuspendableRawCommandLine", "(Lcom/jetbrains/rider/shared/run/IORedirectionMode;Z)V", "winSuspendedProcessCallback", "Ljava/util/function/LongConsumer;", "getExecutionReadyCommandLine", "", "startProcess", "Ljava/lang/Process;", "toProcessBuilder", "Ljava/lang/ProcessBuilder;", "createProcess", "processBuilder", "getCommandLineString", "exeName", "getCommandLineList", "", "Lcom/intellij/openapi/util/NlsSafe;", "getPreparedCommandLine", "platform", "Lcom/intellij/execution/Platform;", "prepareCommandLine", "command", "parameters", "addRawParameter", "", "parameter", "stripFormatting", "withWinSuspendedProcessCallback", "callback", "getWinSuspendedProcessCallback", "intellij.rider.shared"})
@SourceDebugExtension(value={"SMAP\nRawCommandLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RawCommandLine.kt\ncom/jetbrains/rider/shared/run/SuspendableRawCommandLine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,227:1\n1#2:228\n1374#3:229\n1460#3,5:230\n13#4:235\n*S KotlinDebug\n*F\n+ 1 RawCommandLine.kt\ncom/jetbrains/rider/shared/run/SuspendableRawCommandLine\n*L\n113#1:229\n113#1:230,5\n123#1:235\n*E\n"})
public final class SuspendableRawCommandLine
extends GeneralCommandLine
implements RawCommandLine,
CommandLineWithSuspendedProcessCallback {
    @NotNull
    private final IORedirectionMode ioRedirectionMode;
    private final boolean isConsole;
    @Nullable
    private LongConsumer winSuspendedProcessCallback;

    public SuspendableRawCommandLine(@NotNull IORedirectionMode ioRedirectionMode, boolean isConsole) {
        Intrinsics.checkNotNullParameter((Object)((Object)ioRedirectionMode), (String)"ioRedirectionMode");
        this.ioRedirectionMode = ioRedirectionMode;
        this.isConsole = isConsole;
    }

    public /* synthetic */ SuspendableRawCommandLine(IORedirectionMode iORedirectionMode, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iORedirectionMode = IORedirectionMode.Enabled;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(iORedirectionMode, bl);
    }

    @NotNull
    public final String getExecutionReadyCommandLine() {
        String string;
        if (SystemInfo.isWindows) {
            String string2 = this.getExePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExePath(...)");
            string = RawCommandLineKt.access$toWindowsPath(string2);
        } else {
            String string3 = this.getExePath();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getExePath(...)");
        }
        return this.getCommandLineString(string);
    }

    @NotNull
    protected Process startProcess() {
        if (SystemInfo.isWindows && !this.isProcessCreatorSet()) {
            Path path2 = this.getWorkingDirectory();
            return new WindowsProcess(this.isConsole, this.ioRedirectionMode, this.getExecutionReadyCommandLine(), this.getEffectiveEnvironment(), path2 != null ? ((Object)path2).toString() : null, this.winSuspendedProcessCallback);
        }
        Process process = super.startProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"startProcess(...)");
        return process;
    }

    @NotNull
    public ProcessBuilder toProcessBuilder() {
        if (SystemInfo.isWindows && !this.isProcessCreatorSet()) {
            ProcessBuilder processBuilder;
            ProcessBuilder processBuilder2 = processBuilder = new ProcessBuilder(ParametersListUtil.parse((String)this.getExecutionReadyCommandLine()));
            boolean bl = false;
            this.setupEnvironment(processBuilder2.environment());
            processBuilder2.redirectErrorStream(this.isRedirectErrorStream());
            Comparable<Path> comparable = this.getWorkingDirectory();
            if (comparable != null && (comparable = comparable.toFile()) != null) {
                Comparable<Path> comparable2 = comparable;
                boolean bl2 = false;
                processBuilder2.directory((File)comparable2);
            }
            File file = this.getInputFile();
            if (file != null) {
                File file2 = file;
                boolean bl3 = false;
                processBuilder2.redirectInput(ProcessBuilder.Redirect.from(file2));
            }
            return processBuilder;
        }
        ProcessBuilder processBuilder = super.toProcessBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)processBuilder, (String)"toProcessBuilder(...)");
        return processBuilder;
    }

    @NotNull
    protected Process createProcess(@NotNull ProcessBuilder processBuilder) {
        ProcessBuilder processBuilder2;
        Intrinsics.checkNotNullParameter((Object)processBuilder, (String)"processBuilder");
        if (!SystemInfo.isWindows && this.ioRedirectionMode == IORedirectionMode.Disabled) {
            ProcessBuilder processBuilder3;
            ProcessBuilder processBuilder4 = processBuilder3 = processBuilder;
            boolean bl = false;
            processBuilder4.redirectOutput(ProcessBuilder.Redirect.DISCARD);
            processBuilder4.redirectError(ProcessBuilder.Redirect.DISCARD);
            processBuilder4.redirectInput();
            processBuilder2 = processBuilder3;
        } else {
            processBuilder2 = processBuilder;
        }
        ProcessBuilder processBuilder5 = processBuilder2;
        Process process = super.createProcess(processBuilder5);
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"createProcess(...)");
        return process;
    }

    @NotNull
    public String getCommandLineString(@Nullable String exeName) {
        String string;
        if (Platform.current() == Platform.WINDOWS) {
            string = CollectionsKt.joinToString$default((Iterable)this.getCommandLineList(exeName), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        } else {
            String string2 = super.getCommandLineString(exeName);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCommandLineString(...)");
        }
        return string;
    }

    @NotNull
    public List<String> getCommandLineList(@Nullable String exeName) {
        List list2;
        if (SystemInfo.isWindows) {
            List list3;
            List list4 = list3 = CollectionsKt.toMutableList((Collection)RawCommandLineKt.access$getPreparedCommandList(this));
            boolean bl = false;
            String string = exeName;
            if (string == null) {
                String string2 = this.getExePath();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExePath(...)");
            }
            list4.add(0, string);
            list2 = list3;
        } else {
            List list5 = super.getCommandLineList(exeName);
            Intrinsics.checkNotNull((Object)list5);
            list2 = list5;
        }
        return list2;
    }

    @NotNull
    public String getPreparedCommandLine(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        if (!SystemInfo.isWindows) {
            String string = super.getPreparedCommandLine(platform);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPreparedCommandLine(...)");
            return string;
        }
        CharSequence charSequence = "\n";
        String string = this.getExePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExePath(...)");
        String string2 = String.join(charSequence, (Iterable<? extends CharSequence>)this.prepareCommandLine(string, RawCommandLineKt.access$getPreparedCommandList(this), platform));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
        return string2;
    }

    @NotNull
    protected List<String> prepareCommandLine(@NotNull String command, @NotNull List<String> parameters, @NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        if (platform == Platform.WINDOWS) {
            List list2;
            List list3 = list2 = CollectionsKt.toMutableList((Collection)parameters);
            boolean bl = false;
            list3.add(0, command);
            return list2;
        }
        List list4 = super.prepareCommandLine(command, parameters, platform);
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"prepareCommandLine(...)");
        return list4;
    }

    @Override
    public void addRawParameter(@NotNull String parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        this.getParametersList().add((CompositeParameterTargetedValue)new RawParameterValue(parameter));
    }

    @Override
    @NotNull
    public GeneralCommandLine stripFormatting() {
        if (!SystemInfo.isWindows) {
            return this;
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withExePath(this.getExePath()).withWorkingDirectory(this.getWorkingDirectory()).withEnvironment(this.getEnvironment()).withParentEnvironmentType(this.getParentEnvironmentType()).withCharset(this.getCharset()).withRedirectErrorStream(this.isRedirectErrorStream()).withInput(this.getInputFile());
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withInput(...)");
        GeneralCommandLine generalCommandLine2 = generalCommandLine;
        List list2 = this.getParametersList().getList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getList(...)");
        Iterable iterable = list2;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t : iterable2) {
            Object object = (String)t;
            boolean bl3 = false;
            List list3 = ParametersListUtil.parse((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"parse(...)");
            object = list3;
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
        }
        List list4 = (List)collection;
        GeneralCommandLine generalCommandLine3 = generalCommandLine2.withParameters(list4);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine3, (String)"withParameters(...)");
        return generalCommandLine3;
    }

    public void withWinSuspendedProcessCallback(@NotNull LongConsumer callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LongConsumer longConsumer = arg_0 -> SuspendableRawCommandLine.x(callback, arg_0);
        if (this.winSuspendedProcessCallback == null) {
            this.winSuspendedProcessCallback = longConsumer;
        } else {
            LongConsumer longConsumer2 = this.winSuspendedProcessCallback;
            Intrinsics.checkNotNull((Object)longConsumer2);
            this.winSuspendedProcessCallback = longConsumer2.andThen(longConsumer);
        }
    }

    @Nullable
    public LongConsumer getWinSuspendedProcessCallback() {
        return this.winSuspendedProcessCallback;
    }

    private static final void x(LongConsumer longConsumer, long l) {
        try {
            longConsumer.accept(l);
        }
        catch (Throwable throwable) {
            boolean bl = false;
            Logger logger = Logger.getInstance(SuspendableRawCommandLine.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(throwable);
        }
    }

    public SuspendableRawCommandLine() {
        this(null, false, 3, null);
    }
}

