/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.languages.fileTypes.csharp.indenter;

import com.jetbrains.rider.languages.fileTypes.csharp.indenter.FormatterUtils;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.FormatterUtilsKt;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.IndentingRule;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.TextContent;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.TreeWalker;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.TreeWalkerKt;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a:\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0000\u001a,\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u001f\u0010\f\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000eH\u0000\u00a2\u0006\u0002\u0010\u000f\u001a\u0016\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007*\u0006\u0012\u0002\b\u00030\u0007H\u0000\u001a\u0016\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007*\u0006\u0012\u0002\b\u00030\u0007H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030\u0007H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030\u0007H\u0000\u001a\u0014\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0007*\u0006\u0012\u0002\b\u00030\u0007H\u0000\u00a8\u0006\u0016"}, d2={"getRegionLineRange", "Lkotlin/ranges/LongRange;", "rule", "Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/IndentingRule;", "text", "Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/TextContent;", "openNode", "Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/TreeWalker;", "exitNode", "lastIndentedLine", "", "getFirstRuleLine", "peekOrNull", "T", "Ljava/util/Stack;", "(Ljava/util/Stack;)Ljava/lang/Object;", "nextToken", "prevToken", "isFirstNonWsNodeOnLine", "", "isLastNodeOnLine", "root", "intellij.rider.languages"})
public final class IndentingSessionUtilsKt {
    @NotNull
    public static final LongRange getRegionLineRange(@NotNull IndentingRule rule, @NotNull TextContent text, @NotNull TreeWalker<?> openNode, @Nullable TreeWalker<?> exitNode, long lastIndentedLine) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(openNode, (String)"openNode");
        long l = IndentingSessionUtilsKt.getFirstRuleLine(rule, text, openNode, lastIndentedLine);
        long l2 = FormatterUtils.INSTANCE.lastApplyingLineOfRegion(rule.getEndsInclusive(), text, openNode, exitNode);
        return new LongRange(l, l2);
    }

    public static final long getFirstRuleLine(@NotNull IndentingRule rule, @NotNull TextContent text, @NotNull TreeWalker<?> openNode, long lastIndentedLine) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(openNode, (String)"openNode");
        long l = FormatterUtils.INSTANCE.firstApplyingLineOfRegion(rule.getStartsInclusive(), text, openNode);
        return Math.max(l, lastIndentedLine + 1L);
    }

    @Nullable
    public static final <T> T peekOrNull(@NotNull Stack<T> $this$peekOrNull) {
        Intrinsics.checkNotNullParameter($this$peekOrNull, (String)"<this>");
        return $this$peekOrNull.isEmpty() ? null : (T)$this$peekOrNull.peek();
    }

    @Nullable
    public static final TreeWalker<?> nextToken(@NotNull TreeWalker<?> $this$nextToken) {
        Intrinsics.checkNotNullParameter($this$nextToken, (String)"<this>");
        TreeWalker<?> treeWalker = TreeWalkerKt.next($this$nextToken);
        while (treeWalker != null && !FormatterUtilsKt.isToken(treeWalker)) {
            treeWalker = TreeWalkerKt.next(treeWalker);
        }
        return treeWalker;
    }

    @Nullable
    public static final TreeWalker<?> prevToken(@NotNull TreeWalker<?> $this$prevToken) {
        Intrinsics.checkNotNullParameter($this$prevToken, (String)"<this>");
        TreeWalker<?> treeWalker = TreeWalkerKt.leafLeft($this$prevToken);
        while (treeWalker != null && !FormatterUtilsKt.isToken(treeWalker)) {
            treeWalker = TreeWalkerKt.leafLeft(treeWalker);
        }
        return treeWalker;
    }

    public static final boolean isFirstNonWsNodeOnLine(@NotNull TreeWalker<?> $this$isFirstNonWsNodeOnLine) {
        Intrinsics.checkNotNullParameter($this$isFirstNonWsNodeOnLine, (String)"<this>");
        TreeWalker<?> treeWalker = $this$isFirstNonWsNodeOnLine;
        block0: while (TreeWalkerKt.leafLeft(treeWalker) != null) {
            CharSequence charSequence = StringsKt.reversed((CharSequence)treeWalker.getText());
            int n = 0;
            while (true) {
                if (n >= charSequence.length()) continue block0;
                char c = charSequence.charAt(n);
                if (c == '\n') {
                    return true;
                }
                if (!CharsKt.isWhitespace((char)c)) {
                    return false;
                }
                ++n;
            }
            break;
        }
        return true;
    }

    public static final boolean isLastNodeOnLine(@NotNull TreeWalker<?> $this$isLastNodeOnLine) {
        Intrinsics.checkNotNullParameter($this$isLastNodeOnLine, (String)"<this>");
        TreeWalker<?> treeWalker = $this$isLastNodeOnLine;
        block0: while (TreeWalkerKt.leafRight(treeWalker) != null) {
            CharSequence charSequence = treeWalker.getText();
            int n = 0;
            while (true) {
                if (n >= charSequence.length()) continue block0;
                char c = charSequence.charAt(n);
                if (c == '\n') {
                    return true;
                }
                if (!CharsKt.isWhitespace((char)c)) {
                    return false;
                }
                ++n;
            }
            break;
        }
        return true;
    }

    @NotNull
    public static final TreeWalker<?> root(@NotNull TreeWalker<?> $this$root) {
        Intrinsics.checkNotNullParameter($this$root, (String)"<this>");
        TreeWalker<?> treeWalker = $this$root;
        while (true) {
            if (treeWalker.parent() != null) continue;
            return treeWalker;
        }
    }
}

