/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.languages.fileTypes.csharp.indenter;

import com.jetbrains.rider.languages.fileTypes.csharp.indenter.IndentingRule;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.RegionIndents;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.TextContent;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.TreeWalker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u0012\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)H\u0002J*\u0010*\u001a\u00020\u000e2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)J\b\u0010-\u001a\u00020.H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0015\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001e\"\u0004\b!\u0010\"\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/ActiveIndentRegion;", "", "rule", "Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/IndentingRule;", "startLineNumber", "", "initialRegionIndent", "indentBeforeOpening", "id", "", "enterNode", "Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/TreeWalker;", "endNode", "isGreedy", "", "ActiveIndentRegion", "(Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/IndentingRule;JJJILcom/jetbrains/rider/languages/fileTypes/csharp/indenter/TreeWalker;Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/TreeWalker;Z)V", "getRule", "()Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/IndentingRule;", "getStartLineNumber", "()J", "getId", "()I", "getEnterNode", "()Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/TreeWalker;", "getEndNode", "()Z", "originIndent", "Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/RegionIndents;", "getOriginIndent", "()Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/RegionIndents;", "adjustedIndent", "getAdjustedIndent", "setAdjustedIndent", "(Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/RegionIndents;)V", "adjustDelta", "", "delta", "x", "region", "text", "Lcom/jetbrains/rider/languages/fileTypes/csharp/indenter/TextContent;", "isCollapsesWith", "currentNode", "currentNodeStartLine", "toString", "", "intellij.rider.languages"})
public final class ActiveIndentRegion {
    @NotNull
    private final IndentingRule rule;
    private final long startLineNumber;
    private final int id;
    @NotNull
    private final TreeWalker<?> enterNode;
    @Nullable
    private final TreeWalker<?> endNode;
    private final boolean isGreedy;
    @NotNull
    private final RegionIndents originIndent;
    @NotNull
    private RegionIndents adjustedIndent;

    public ActiveIndentRegion(@NotNull IndentingRule rule, long startLineNumber, long initialRegionIndent, long indentBeforeOpening, int id, @NotNull TreeWalker<?> enterNode, @Nullable TreeWalker<?> endNode, boolean isGreedy) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter(enterNode, (String)"enterNode");
        this.rule = rule;
        this.startLineNumber = startLineNumber;
        this.id = id;
        this.enterNode = enterNode;
        this.endNode = endNode;
        this.isGreedy = isGreedy;
        this.adjustedIndent = this.originIndent = new RegionIndents(initialRegionIndent, indentBeforeOpening);
    }

    @NotNull
    public final IndentingRule getRule() {
        return this.rule;
    }

    public final long getStartLineNumber() {
        return this.startLineNumber;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final TreeWalker<?> getEnterNode() {
        return this.enterNode;
    }

    @Nullable
    public final TreeWalker<?> getEndNode() {
        return this.endNode;
    }

    public final boolean isGreedy() {
        return this.isGreedy;
    }

    @NotNull
    public final RegionIndents getOriginIndent() {
        return this.originIndent;
    }

    @NotNull
    public final RegionIndents getAdjustedIndent() {
        return this.adjustedIndent;
    }

    public final void setAdjustedIndent(@NotNull RegionIndents regionIndents) {
        Intrinsics.checkNotNullParameter((Object)regionIndents, (String)"<set-?>");
        this.adjustedIndent = regionIndents;
    }

    public final void adjustDelta(long delta) {
        this.adjustedIndent = RegionIndents.copy$default(this.adjustedIndent, this.adjustedIndent.getIndentBefore() + delta, 0L, 2, null);
    }

    private final long x(ActiveIndentRegion activeIndentRegion, TextContent textContent) {
        return activeIndentRegion.endNode == null ? textContent.linesCount() - 1L : textContent.lineNumber(activeIndentRegion.endNode.getEndOffset());
    }

    public final boolean isCollapsesWith(@NotNull TreeWalker<?> currentNode, long currentNodeStartLine, @NotNull IndentingRule rule, @NotNull TextContent text) {
        long l;
        Intrinsics.checkNotNullParameter(currentNode, (String)"currentNode");
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ActiveIndentRegion activeIndentRegion = new ActiveIndentRegion(rule, currentNodeStartLine, 0L, 0L, 0, currentNode, (TreeWalker)rule.getEndLocator().invoke(currentNode), false);
        if (this.startLineNumber != activeIndentRegion.startLineNumber) {
            return false;
        }
        if (this.rule.getIndentType() != activeIndentRegion.rule.getIndentType()) {
            return false;
        }
        long l2 = this.x(this, text);
        return l2 == (l = this.x(activeIndentRegion, text));
    }

    @NotNull
    public String toString() {
        TreeWalker<?> treeWalker = this.endNode;
        return "'" + this.rule.getName() + "':" + this.startLineNumber + " " + this.rule.getIndentType() + " [" + this.enterNode.getType() + ".." + (treeWalker != null ? treeWalker.getType() : null) + "]";
    }
}

