/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.languages.fileTypes.csharp.assists;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpLineIndentProviderKt;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.RiderStructuralNavigation;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.TabNavigationBehaviour;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.TypingAssistUtils;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.UtilsKt;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.CSharpTokenNodeType;
import com.jetbrains.rider.languages.fileTypes.csharp.lexer.CSharpLexer;
import com.jetbrains.rider.rdclient.languages.FrontendRemoteEditorActionHandler;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/csharp/assists/TabNavigationAction;", "", "TabNavigationAction", "()V", "Companion", "intellij.rider.languages"})
public final class TabNavigationAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/csharp/assists/TabNavigationAction$Companion;", "", "TabNavigationAction$Companion", "()V", "handleAction", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "caret", "Lcom/intellij/openapi/editor/Caret;", "editor", "Lcom/intellij/openapi/editor/Editor;", "forBackwardAction", "", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "shouldFallback", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "x", "Lcom/jetbrains/rider/languages/fileTypes/csharp/assists/TabNavigationAction$Companion$LineEndCaretPositionKind;", "lexer", "Lcom/jetbrains/rider/languages/fileTypes/csharp/lexer/CSharpLexer;", "selection", "Lcom/intellij/openapi/util/TextRange;", "x", "LineEndCaretPositionKind", "intellij.rider.languages"})
    public static final class Companion {
        private Companion() {
        }

        public final void handleAction(@Nullable DataContext dataContext, @Nullable Caret caret, @NotNull Editor editor, boolean forBackwardAction, @NotNull EditorActionHandler originalHandler) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)originalHandler, (String)"originalHandler");
            if (!CSharpLineIndentProviderKt.isPatchEngineEnabled() || dataContext == null || caret == null) {
                originalHandler.execute(editor, caret, dataContext);
                return;
            }
            String string = forBackwardAction ? "EditorUnindentSelection" : "EditorTab";
            ClientAppSession clientAppSession = FrontendSessionsUtilKt.getFrontendAppSession(dataContext);
            Intrinsics.checkNotNull((Object)clientAppSession);
            boolean bl = FrontendRemoteEditorActionHandler.Companion.getInstance(clientAppSession).handleEditorActionSynchronously(string, editor);
            if (bl) {
                return;
            }
            Project project = (Project)dataContext.getData(LangDataKeys.PROJECT);
            PsiFile psiFile = (PsiFile)dataContext.getData(LangDataKeys.PSI_FILE);
            if (project != null && psiFile != null && !this.shouldFallback(editor, forBackwardAction, project, psiFile)) {
                return;
            }
            originalHandler.execute(editor, caret, dataContext);
        }

        public final boolean shouldFallback(@NotNull Editor editor, boolean forBackwardAction, @NotNull Project project, @NotNull PsiFile psiFile) {
            LineEndCaretPositionKind lineEndCaretPositionKind;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            if (!UtilsKt.isCSharpFile(psiFile)) {
                return true;
            }
            if (!((Boolean)RiderStructuralNavigation.Companion.getInstance(project).isEnabled().getValue()).booleanValue()) {
                return true;
            }
            if (((Boolean)RiderStructuralNavigation.Companion.getInstance(project).isSelectedByTabNavigation().getValue()).booleanValue()) {
                return false;
            }
            TextRange textRange = new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
            CSharpLexer cSharpLexer = new CSharpLexer();
            cSharpLexer.start(editor.getDocument().getText(), textRange.getStartOffset(), editor.getDocument().getText().length());
            if (cSharpLexer.getTokenType() == null) {
                return true;
            }
            TabNavigationBehaviour tabNavigationBehaviour = (TabNavigationBehaviour)RiderStructuralNavigation.Companion.getInstance(project).getSettings().getValue();
            if (tabNavigationBehaviour.getDisabledAtLineEnd() && (lineEndCaretPositionKind = this.x(cSharpLexer, editor, textRange)) != null && (lineEndCaretPositionKind != LineEndCaretPositionKind.STRICT || !forBackwardAction || tabNavigationBehaviour.getBackwardEnabledAtStrictLineEnd())) {
                return true;
            }
            if (tabNavigationBehaviour.getDisabledOnIndenting() && TypingAssistUtils.isCaretOnIndenting(editor, textRange)) {
                return true;
            }
            if (tabNavigationBehaviour.getDisabledOnSelection() && TypingAssistUtils.isBlockOfCodeSelected(editor, textRange)) {
                return true;
            }
            return tabNavigationBehaviour.getDisabledInCommentsAndStringLiterals() && this.x(editor, cSharpLexer, textRange);
        }

        private final LineEndCaretPositionKind x(CSharpLexer cSharpLexer, Editor editor, TextRange textRange) {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            int n = textRange.getStartOffset();
            int n2 = textRange.getEndOffset();
            LogicalPosition logicalPosition = editor.offsetToLogicalPosition(n);
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
            LogicalPosition logicalPosition2 = logicalPosition;
            LogicalPosition logicalPosition3 = editor.offsetToLogicalPosition(n2);
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition3, (String)"offsetToLogicalPosition(...)");
            LogicalPosition logicalPosition4 = logicalPosition3;
            if (logicalPosition2.line != logicalPosition4.line) {
                return null;
            }
            int n3 = document2.getLineEndOffset(logicalPosition2.line);
            TextRange textRange2 = new TextRange(n, n3);
            String string = document2.getText(textRange2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            if (StringsKt.isBlank((CharSequence)string2)) {
                if (logicalPosition2.column != 0) {
                    TextRange textRange3 = new TextRange(n - 1, n);
                    String string3 = document2.getText(textRange3);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                    if (StringsKt.isBlank((CharSequence)string3)) {
                        return LineEndCaretPositionKind.WHITESPACE;
                    }
                }
                return LineEndCaretPositionKind.STRICT;
            }
            cSharpLexer.start(document2.getText(), n, document2.getText().length());
            while (cSharpLexer.getTokenType() != null && cSharpLexer.getTokenEnd() == n) {
                cSharpLexer.advance();
            }
            boolean bl = false;
            while (cSharpLexer.getTokenType() != null && cSharpLexer.getTokenStart() < n3) {
                CSharpTokenNodeType cSharpTokenNodeType;
                IElementType iElementType = cSharpLexer.getTokenType();
                CSharpTokenNodeType cSharpTokenNodeType2 = cSharpTokenNodeType = iElementType instanceof CSharpTokenNodeType ? (CSharpTokenNodeType)iElementType : null;
                if (cSharpTokenNodeType != null) {
                    if (!cSharpTokenNodeType.isStringLiteral() && !cSharpTokenNodeType.isComment()) {
                        return null;
                    }
                    if (cSharpTokenNodeType.isComment()) {
                        bl = true;
                        iElementType = new TextRange(cSharpLexer.getTokenStart(), cSharpLexer.getTokenEnd());
                        if (iElementType.intersectsStrict(textRange)) {
                            return null;
                        }
                    }
                }
                cSharpLexer.advance();
            }
            return bl ? LineEndCaretPositionKind.BEFORE_COMMENT : null;
        }

        private final boolean x(Editor editor, CSharpLexer cSharpLexer, TextRange textRange) {
            int n = textRange.getStartOffset();
            cSharpLexer.start(editor.getDocument().getText(), RangesKt.coerceAtLeast((int)0, (int)(n - 1)), textRange.getEndOffset());
            int n2 = textRange.getEndOffset();
            while (cSharpLexer.getTokenType() != null && cSharpLexer.getTokenStart() < n2) {
                TextRange textRange2;
                CSharpTokenNodeType cSharpTokenNodeType;
                IElementType iElementType = cSharpLexer.getTokenType();
                if (cSharpLexer.getTokenEnd() < n) {
                    cSharpLexer.advance();
                    continue;
                }
                CSharpTokenNodeType cSharpTokenNodeType2 = cSharpTokenNodeType = iElementType instanceof CSharpTokenNodeType ? (CSharpTokenNodeType)iElementType : null;
                if (cSharpTokenNodeType != null && (cSharpTokenNodeType.isStringLiteral() || cSharpTokenNodeType.isComment()) && (textRange2 = new TextRange(cSharpLexer.getTokenStart(), cSharpLexer.getTokenEnd())).containsRange(textRange.getStartOffset(), textRange.getEndOffset())) {
                    return true;
                }
                cSharpLexer.advance();
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/csharp/assists/TabNavigationAction$Companion$LineEndCaretPositionKind;", "", "TabNavigationAction$Companion$LineEndCaretPositionKind", "(Ljava/lang/String;I)V", "WHITESPACE", "STRICT", "BEFORE_COMMENT", "intellij.rider.languages"})
        public static final class LineEndCaretPositionKind
        extends Enum<LineEndCaretPositionKind> {
            public static final /* enum */ LineEndCaretPositionKind WHITESPACE = new LineEndCaretPositionKind();
            public static final /* enum */ LineEndCaretPositionKind STRICT = new LineEndCaretPositionKind();
            public static final /* enum */ LineEndCaretPositionKind BEFORE_COMMENT = new LineEndCaretPositionKind();
            private static final /* synthetic */ LineEndCaretPositionKind[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static LineEndCaretPositionKind[] values() {
                return (LineEndCaretPositionKind[])$VALUES.clone();
            }

            public static LineEndCaretPositionKind valueOf(String value2) {
                return Enum.valueOf(LineEndCaretPositionKind.class, value2);
            }

            @NotNull
            public static EnumEntries<LineEndCaretPositionKind> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = lineEndCaretPositionKindArray = new LineEndCaretPositionKind[]{LineEndCaretPositionKind.WHITESPACE, LineEndCaretPositionKind.STRICT, LineEndCaretPositionKind.BEFORE_COMMENT};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

