/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.languages.fileTypes.csharp.assists;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpLineIndentProviderKt;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.UtilsKt;
import com.jetbrains.rider.rdclient.languages.FrontendRemoteEditorActionHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/csharp/assists/CSharpDeleteHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler$ForEachCaret;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "CSharpDeleteHandler", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "getOriginalHandler", "()Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "executeWriteAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "x", "", "intellij.rider.languages"})
public final class CSharpDeleteHandler
extends EditorWriteActionHandler.ForEachCaret {
    @NotNull
    private final EditorActionHandler originalHandler;

    public CSharpDeleteHandler(@NotNull EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)originalHandler, (String)"originalHandler");
        this.originalHandler = originalHandler;
    }

    @NotNull
    public final EditorActionHandler getOriginalHandler() {
        return this.originalHandler;
    }

    public void executeWriteAction(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!CSharpLineIndentProviderKt.isPatchEngineEnabled() || dataContext == null || caret == null || !this.x(editor, caret, dataContext)) {
            this.originalHandler.execute(editor, caret, dataContext);
        }
    }

    private final boolean x(Editor editor, Caret caret, DataContext dataContext) {
        PsiFile psiFile = (PsiFile)dataContext.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null || !UtilsKt.isCSharpFile(psiFile)) {
            return false;
        }
        ClientAppSession clientAppSession = FrontendSessionsUtilKt.getFrontendAppSession(dataContext);
        Intrinsics.checkNotNull((Object)clientAppSession);
        boolean bl = FrontendRemoteEditorActionHandler.Companion.handleSynchronously(editor, "EditorDelete", clientAppSession);
        if (bl) {
            return true;
        }
        if (editor.getCaretModel().getPrimaryCaret().hasSelection()) {
            return false;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        if (caret.getOffset() < 0 || caret.getOffset() >= document2.getTextLength()) {
            return false;
        }
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence charSequence2 = charSequence;
        CharSequence charSequence3 = charSequence2.subSequence(caret.getOffset(), caret.getOffset() + 1);
        if (!Intrinsics.areEqual((Object)charSequence3, (Object)"\n")) {
            return false;
        }
        document2.deleteString(caret.getOffset(), caret.getOffset() + 1);
        if (caret.getOffset() >= 1 && CharsKt.isWhitespace((char)charSequence2.charAt(caret.getOffset() - 1))) {
            document2.deleteString(caret.getOffset(), CharArrayUtil.shiftForward((CharSequence)charSequence2, (int)caret.getOffset(), (String)"\t "));
        }
        return true;
    }
}

