/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.showImplementations;

import com.intellij.codeInsight.hint.ImplementationViewElement;
import com.intellij.codeInsight.hint.ImplementationViewSession;
import com.intellij.codeInsight.hint.ImplementationViewSessionFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.jetbrains.rd.ide.model.ImplementationViewElementModel;
import com.jetbrains.rd.ide.model.ImplementationViewSessionModel;
import com.jetbrains.rd.ide.model.ShowImplementationsModel_GeneratedKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.AddRemove;
import com.jetbrains.rd.util.reactive.IMutableViewableList;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.reactive.ViewableList;
import com.jetbrains.rd.util.threading.SpinWait;
import com.jetbrains.rd.util.time.DurationKt;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.showImplementations.FrontendImplementationViewElement;
import com.jetbrains.rdclient.showImplementations.FrontendImplementationViewSessionFactory;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ&\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00180\u001e2\u0006\u0010&\u001a\u00020'2\u000e\u0010(\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00180)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020+H\u0016J\b\u0010-\u001a\u00020.H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u0004\u0018\u00010\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006/"}, d2={"Lcom/jetbrains/rdclient/showImplementations/FrontendImplementationViewSession;", "Lcom/intellij/codeInsight/hint/ImplementationViewSession;", "project", "Lcom/intellij/openapi/project/Project;", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "sessionModel", "Lcom/jetbrains/rd/ide/model/ImplementationViewSessionModel;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "FrontendImplementationViewSession", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rdclient/services/IdeBackend;Lcom/jetbrains/rd/ide/model/ImplementationViewSessionModel;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "elements", "Lcom/jetbrains/rd/util/reactive/ViewableList;", "Lcom/intellij/codeInsight/hint/ImplementationViewElement;", "factory", "Lcom/intellij/codeInsight/hint/ImplementationViewSessionFactory;", "getFactory", "()Lcom/intellij/codeInsight/hint/ImplementationViewSessionFactory;", "implementationElements", "", "getImplementationElements", "()Ljava/util/List;", "text", "", "getText", "()Ljava/lang/String;", "searchImplementationsInBackground", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "processor", "Lcom/intellij/util/Processor;", "elementRequiresIncludeSelf", "", "needUpdateInBackground", "dispose", "", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendImplementationViewSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendImplementationViewSession.kt\ncom/jetbrains/rdclient/showImplementations/FrontendImplementationViewSession\n+ 2 SpinWait.kt\ncom/jetbrains/rd/util/threading/SpinWait$Companion\n*L\n1#1,248:1\n27#2,12:249\n*S KotlinDebug\n*F\n+ 1 FrontendImplementationViewSession.kt\ncom/jetbrains/rdclient/showImplementations/FrontendImplementationViewSession\n*L\n175#1:249,12\n*E\n"})
public final class FrontendImplementationViewSession
implements ImplementationViewSession {
    @NotNull
    private final Project project;
    @NotNull
    private final IdeBackend backend;
    @NotNull
    private final ImplementationViewSessionModel sessionModel;
    @Nullable
    private final VirtualFile file;
    @Nullable
    private final Editor editor;
    @NotNull
    private final LifetimeDefinition sessionLifetime;
    @NotNull
    private final ViewableList<ImplementationViewElement> elements;

    public FrontendImplementationViewSession(@NotNull Project project, @NotNull IdeBackend backend, @NotNull ImplementationViewSessionModel sessionModel, @Nullable VirtualFile file, @Nullable Editor editor, @NotNull LifetimeDefinition sessionLifetime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        Intrinsics.checkNotNullParameter((Object)((Object)sessionModel), (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        this.project = project;
        this.backend = backend;
        this.sessionModel = sessionModel;
        this.file = file;
        this.editor = editor;
        this.sessionLifetime = sessionLifetime;
        this.elements = new ViewableList(null, 1, null);
        SourceExKt.flowInto((ISource)((ISource)this.sessionModel.getItems()), (Lifetime)((Lifetime)this.sessionLifetime), (IMutableViewableList)((IMutableViewableList)this.elements), arg_0 -> FrontendImplementationViewSession.x(this, arg_0));
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.file;
    }

    @Nullable
    public Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public ImplementationViewSessionFactory getFactory() {
        return (ImplementationViewSessionFactory)ImplementationViewSessionFactory.EP_NAME.findExtensionOrFail(FrontendImplementationViewSessionFactory.class);
    }

    @NotNull
    public List<ImplementationViewElement> getImplementationElements() {
        return (List)this.elements;
    }

    @Nullable
    public String getText() {
        return (String)this.sessionModel.getText().getValue();
    }

    @NotNull
    public List<ImplementationViewElement> searchImplementationsInBackground(@NotNull ProgressIndicator indicator, @NotNull Processor<? super ImplementationViewElement> processor) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        this.sessionLifetime.createNested(arg_0 -> FrontendImplementationViewSession.x(this, processor, indicator, arg_0));
        return (List)this.elements;
    }

    public boolean elementRequiresIncludeSelf() {
        return false;
    }

    public boolean needUpdateInBackground() {
        return true;
    }

    public void dispose() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.sessionLifetime, (boolean)false, (int)1, null);
        ShowImplementationsModel_GeneratedKt.getShowImplementationsModel(this.backend.getSolution()).getSession().set(null);
    }

    private static final ImplementationViewElement x(FrontendImplementationViewSession frontendImplementationViewSession, ImplementationViewElementModel implementationViewElementModel) {
        Intrinsics.checkNotNullParameter((Object)implementationViewElementModel, (String)"it");
        return new FrontendImplementationViewElement(frontendImplementationViewSession.getProject(), frontendImplementationViewSession.sessionModel, implementationViewElementModel);
    }

    private static final Unit x(FrontendImplementationViewSession frontendImplementationViewSession, Processor processor, ProgressIndicator progressIndicator2, LifetimeDefinition lifetimeDefinition) {
        Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"it");
        frontendImplementationViewSession.elements.adviseAddRemove((Lifetime)lifetimeDefinition, (arg_0, arg_1, arg_2) -> FrontendImplementationViewSession.x(processor, lifetimeDefinition, arg_0, arg_1, arg_2));
        SpinWait.Companion companion = SpinWait.Companion;
        Lifetime lifetime = (Lifetime)frontendImplementationViewSession.sessionLifetime;
        Duration duration = DurationKt.getInfiniteDuration();
        boolean bl = false;
        long l = System.nanoTime();
        long l2 = 0L;
        while (true) {
            boolean bl2 = false;
            if (InterfacesKt.getHasValue((IOptPropertyView)((IOptPropertyView)frontendImplementationViewSession.sessionModel.getSearchDone())) || progressIndicator2.isCanceled() || !RLifetimeKt.isAlive((Lifetime)lifetime) || System.nanoTime() - l > duration.toNanos()) break;
            long l3 = l2;
            l2 = l3 + 1L;
            if (l3 < 100L) {
                Thread.yield();
                continue;
            }
            Thread.sleep(l2 / (long)100);
        }
        return Unit.INSTANCE;
    }

    private static final Unit x(Processor processor, LifetimeDefinition lifetimeDefinition, AddRemove addRemove, int n, ImplementationViewElement implementationViewElement) {
        Intrinsics.checkNotNullParameter((Object)addRemove, (String)"addRemove");
        Intrinsics.checkNotNullParameter((Object)implementationViewElement, (String)"elt");
        if (addRemove != AddRemove.Add) {
            return Unit.INSTANCE;
        }
        if (!processor.process((Object)implementationViewElement)) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
        return Unit.INSTANCE;
    }
}

