/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.requests;

import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.requests.PatchEngineRetryTimestampWithGeneration;
import com.jetbrains.rd.ide.requests.SpeculativelyEqualsResult;
import com.jetbrains.rdclient.requests.BackendOriginatedChange;
import com.jetbrains.rdclient.requests.BackendResponse;
import com.jetbrains.rdclient.requests.ChangeFromBackend;
import com.jetbrains.rdclient.requests.RebaseConflictStatisticsCollector;
import com.jetbrains.rdclient.requests.SpeculativeRequest;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004:\u00016B\u001f\u0012\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u00020\u00162\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012J\u0006\u0010\u001b\u001a\u00020\u0016J\u0006\u0010\u001c\u001a\u00020\u0016J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u001eJ\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00120\u001eJ\u0006\u0010 \u001a\u00020\u0014J\u0006\u0010!\u001a\u00020\nJ\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\fH\u0002J\b\u0010$\u001a\u00020%H\u0002J\u001d\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010)J\u0015\u0010*\u001a\u00020\u00162\u0006\u0010(\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010+J)\u0010,\u001a\u00020\u00162\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010-2\u0006\u0010\u0017\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010.J\u0018\u0010/\u001a\u00020\u0016*\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000100H\u0002J1\u0010,\u001a\u00020\u00162\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010-2\u0006\u0010\u0017\u001a\u00028\u00012\u0006\u0010(\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00101J%\u00102\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00028\u00002\u0006\u00103\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u00020\u0016H\u0002R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/jetbrains/rdclient/requests/SpeculativeQueueProcessor;", "TContext", "TReq", "Lcom/jetbrains/rdclient/requests/SpeculativeRequest;", "", "statisticsCollector", "Lcom/jetbrains/rdclient/requests/RebaseConflictStatisticsCollector;", "SpeculativeQueueProcessor", "(Lcom/jetbrains/rdclient/requests/RebaseConflictStatisticsCollector;)V", "lastSubmittedRequestId", "", "globalRetryTimestamp", "Lcom/jetbrains/rd/ide/requests/PatchEngineRetryTimestampWithGeneration;", "backendChangesCounter", "pendingRequestsQueue", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "pendingResponses", "Ljava/util/ArrayDeque;", "Lcom/jetbrains/rdclient/requests/ChangeFromBackend;", "processing", "", "submitRequest", "", "request", "(Lcom/jetbrains/rdclient/requests/SpeculativeRequest;)V", "onBackendResponse", "response", "process", "cancelAndRemoveAllPending", "getPendingRequests", "", "getPendingResponses", "isEmpty", "appliedResponsesCount", "x", "oldTimestamp", "x", "Lcom/jetbrains/rdclient/requests/SpeculativeQueueProcessor$FastPathResult;", "x", "virtually", "context", "(ZLjava/lang/Object;)V", "x", "(Ljava/lang/Object;)V", "x", "Lcom/jetbrains/rdclient/requests/BackendResponse$Success;", "(Lcom/jetbrains/rdclient/requests/BackendResponse$Success;Lcom/jetbrains/rdclient/requests/SpeculativeRequest;)V", "x", "Lcom/jetbrains/rdclient/requests/BackendOriginatedChange;", "(Lcom/jetbrains/rdclient/requests/BackendResponse$Success;Lcom/jetbrains/rdclient/requests/SpeculativeRequest;Ljava/lang/Object;)V", "x", "timestampChanged", "(ZLjava/lang/Object;Z)V", "x", "FastPathResult", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nSpeculativeQueueProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpeculativeQueueProcessor.kt\ncom/jetbrains/rdclient/requests/SpeculativeQueueProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,340:1\n1869#2,2:341\n1761#2,3:343\n1869#2,2:346\n1869#2,2:348\n*S KotlinDebug\n*F\n+ 1 SpeculativeQueueProcessor.kt\ncom/jetbrains/rdclient/requests/SpeculativeQueueProcessor\n*L\n119#1:341,2\n175#1:343,3\n320#1:346,2\n329#1:348,2\n*E\n"})
public final class SpeculativeQueueProcessor<TContext, TReq extends SpeculativeRequest<TContext>> {
    @Nullable
    private final RebaseConflictStatisticsCollector<TContext, TReq> statisticsCollector;
    private long lastSubmittedRequestId;
    @NotNull
    private PatchEngineRetryTimestampWithGeneration globalRetryTimestamp;
    private long backendChangesCounter;
    @NotNull
    private final ConcurrentLinkedDeque<TReq> pendingRequestsQueue;
    @NotNull
    private final ArrayDeque<ChangeFromBackend<TContext, TReq>> pendingResponses;
    private boolean processing;

    public SpeculativeQueueProcessor(@Nullable RebaseConflictStatisticsCollector<TContext, TReq> statisticsCollector) {
        this.statisticsCollector = statisticsCollector;
        this.lastSubmittedRequestId = Long.MIN_VALUE;
        this.globalRetryTimestamp = new PatchEngineRetryTimestampWithGeneration(0L, 0L);
        this.pendingRequestsQueue = new ConcurrentLinkedDeque();
        this.pendingResponses = new ArrayDeque();
    }

    public /* synthetic */ SpeculativeQueueProcessor(RebaseConflictStatisticsCollector rebaseConflictStatisticsCollector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            rebaseConflictStatisticsCollector = null;
        }
        this(rebaseConflictStatisticsCollector);
    }

    public final void submitRequest(@NotNull TReq request) {
        boolean bl;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        boolean bl2 = bl = !this.processing;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Submitting requests: " + request + " during processing is prohibited";
            throw new AssertionError((Object)string);
        }
        boolean bl4 = bl = this.lastSubmittedRequestId < request.getUniqueId();
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "request.uniqueId: " + request.getUniqueId() + " must be more then previous id: " + this.lastSubmittedRequestId;
            throw new AssertionError((Object)string);
        }
        this.lastSubmittedRequestId = request.getUniqueId();
        this.pendingRequestsQueue.add(request);
        request.send(this.globalRetryTimestamp);
    }

    public final void onBackendResponse(@NotNull ChangeFromBackend<TContext, TReq> response) {
        boolean bl;
        Intrinsics.checkNotNullParameter(response, (String)"response");
        boolean bl2 = bl = !this.processing;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Submitting responses: " + response + " during processing is prohibited";
            throw new AssertionError((Object)string);
        }
        this.pendingResponses.add(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process() {
        if (this.pendingResponses.isEmpty()) {
            return;
        }
        List list2 = CollectionsKt.toList((Iterable)this.pendingResponses);
        PatchEngineRetryTimestampWithGeneration patchEngineRetryTimestampWithGeneration = this.globalRetryTimestamp;
        this.processing = true;
        try {
            switch (WhenMappings.$EnumSwitchMapping$0[this.x().ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl;
                    boolean bl2 = bl = patchEngineRetryTimestampWithGeneration.compareTo(this.globalRetryTimestamp) < 0;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl3 = false;
                        String string = "Old timestamp: " + patchEngineRetryTimestampWithGeneration + " < globalRetryTimestamp: " + this.globalRetryTimestamp;
                        throw new AssertionError((Object)string);
                    }
                    this.x();
                    break;
                }
                case 3: {
                    this.x(patchEngineRetryTimestampWithGeneration);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean bl = this.pendingResponses.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "All pending responses must be processed";
                throw new AssertionError((Object)string);
            }
            Iterable iterable = list2;
            boolean bl5 = false;
            for (Object t : iterable) {
                ChangeFromBackend changeFromBackend = (ChangeFromBackend)t;
                boolean bl6 = false;
                changeFromBackend.executed();
            }
        }
        finally {
            this.processing = false;
        }
    }

    public final void cancelAndRemoveAllPending() {
        ThreadingAssertions.assertEventDispatchThread();
        ThreadingAssertions.assertWriteIntentReadAccess();
        this.pendingResponses.clear();
        this.pendingRequestsQueue.clear();
        this.globalRetryTimestamp = this.globalRetryTimestamp.incrementGeneration();
    }

    @NotNull
    public final List<TReq> getPendingRequests() {
        return CollectionsKt.toList((Iterable)this.pendingRequestsQueue);
    }

    @NotNull
    public final List<ChangeFromBackend<TContext, TReq>> getPendingResponses() {
        return CollectionsKt.toList((Iterable)this.pendingResponses);
    }

    public final boolean isEmpty() {
        return this.pendingRequestsQueue.isEmpty();
    }

    public final long appliedResponsesCount() {
        return this.backendChangesCounter;
    }

    private final void x(PatchEngineRetryTimestampWithGeneration patchEngineRetryTimestampWithGeneration) {
        ((ChangeFromBackend)CollectionsKt.first((Iterable)this.pendingResponses)).withChangeContext(this.pendingResponses.size(), arg_0 -> SpeculativeQueueProcessor.x(this, patchEngineRetryTimestampWithGeneration, arg_0));
    }

    private final FastPathResult x() {
        Iterator<ChangeFromBackend<TContext, TReq>> iterator2 = this.pendingResponses.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<ChangeFromBackend<TContext, TReq>> iterator3 = iterator2;
        FastPathResult fastPathResult = FastPathResult.Processed;
        while (iterator3.hasNext()) {
            boolean bl;
            ChangeFromBackend<TContext, TReq> changeFromBackend = iterator3.next();
            if (changeFromBackend instanceof BackendOriginatedChange) {
                boolean bl2;
                block16: {
                    Iterable iterable = this.pendingRequestsQueue;
                    bl = false;
                    if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object t : iterable) {
                            SpeculativeRequest speculativeRequest = (SpeculativeRequest)t;
                            boolean bl3 = false;
                            BackendOriginatedChange backendOriginatedChange = (BackendOriginatedChange)changeFromBackend;
                            Intrinsics.checkNotNull((Object)speculativeRequest);
                            if (!backendOriginatedChange.conflictsWith(speculativeRequest)) continue;
                            bl2 = true;
                            break block16;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    return FastPathResult.Rebase;
                }
                iterator3.remove();
                this.x((BackendOriginatedChange)changeFromBackend);
                long l = this.backendChangesCounter;
                this.backendChangesCounter = l + 1L;
                continue;
            }
            if (changeFromBackend instanceof BackendResponse.RetryRequired) {
                boolean bl4;
                iterator3.remove();
                boolean bl5 = bl4 = this.globalRetryTimestamp.compareTo(((BackendResponse.RetryRequired)changeFromBackend).getNewGlobalRetryTimestamp()) < 0;
                if (_Assertions.ENABLED && !bl4) {
                    bl = false;
                    String string = "Global retry timestamp must be less than new global retry timestamp";
                    throw new AssertionError((Object)string);
                }
                this.globalRetryTimestamp = ((BackendResponse.RetryRequired)changeFromBackend).getNewGlobalRetryTimestamp();
                fastPathResult = FastPathResult.JustRetry;
                continue;
            }
            if (changeFromBackend instanceof BackendResponse.Success) {
                boolean bl6;
                PatchEngineRetryTimestampWithGeneration patchEngineRetryTimestampWithGeneration;
                SpeculativeRequest speculativeRequest = (SpeculativeRequest)this.pendingRequestsQueue.peek();
                boolean bl7 = bl = ((BackendResponse.Success)changeFromBackend).getRequestId() == speculativeRequest.getUniqueId();
                if (_Assertions.ENABLED && !bl) {
                    boolean bl8 = false;
                    String string = "Unexpected response " + changeFromBackend + " for " + speculativeRequest;
                    throw new AssertionError((Object)string);
                }
                BackendResponse.Success success = (BackendResponse.Success)changeFromBackend;
                Intrinsics.checkNotNull((Object)speculativeRequest);
                switch (WhenMappings.$EnumSwitchMapping$1[success.compare(speculativeRequest).ordinal()]) {
                    case 1: {
                        iterator3.remove();
                        this.x((BackendResponse.Success)changeFromBackend, speculativeRequest);
                        break;
                    }
                    case 2: {
                        iterator3.remove();
                        ChangeFromBackend.withChangeContext$default(changeFromBackend, 0, arg_0 -> SpeculativeQueueProcessor.x(this, changeFromBackend, speculativeRequest, arg_0), 1, null);
                        break;
                    }
                    case 3: {
                        return FastPathResult.Rebase;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                if ((patchEngineRetryTimestampWithGeneration = ((BackendResponse.Success)changeFromBackend).getNewRetryTimestamp()) == null) continue;
                boolean bl9 = bl6 = this.globalRetryTimestamp.compareTo(patchEngineRetryTimestampWithGeneration) < 0;
                if (_Assertions.ENABLED && !bl6) {
                    boolean bl10 = false;
                    String string = "Global retry timestamp must be less than new global retry timestamp";
                    throw new AssertionError((Object)string);
                }
                this.globalRetryTimestamp = patchEngineRetryTimestampWithGeneration;
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return fastPathResult;
    }

    private final void x(boolean bl, TContext TContext) {
        int n = this.pendingRequestsQueue.size() - 1;
        if (!bl) {
            RebaseConflictStatisticsCollector<TContext, SpeculativeRequest> rebaseConflictStatisticsCollector = this.statisticsCollector;
            if (rebaseConflictStatisticsCollector != null) {
                rebaseConflictStatisticsCollector.collectRebase(TContext, (SpeculativeRequest)CollectionsKt.firstOrNull((Iterable)this.pendingRequestsQueue), (ChangeFromBackend)CollectionsKt.firstOrNull((Iterable)this.pendingResponses), n);
            }
        }
        Iterator<TReq> iterator2 = this.pendingRequestsQueue.descendingIterator();
        while (iterator2.hasNext()) {
            SpeculativeRequest speculativeRequest = (SpeculativeRequest)iterator2.next();
            speculativeRequest.rollback(bl, TContext);
        }
    }

    private final void x(TContext TContext) {
        Iterator<ChangeFromBackend<TContext, TReq>> iterator2 = this.pendingResponses.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<ChangeFromBackend<TContext, TReq>> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            ChangeFromBackend<TContext, TReq> changeFromBackend = iterator3.next();
            if (changeFromBackend instanceof BackendOriginatedChange) {
                ((BackendOriginatedChange)changeFromBackend).apply(TContext);
                long l = this.backendChangesCounter;
                this.backendChangesCounter = l + 1L;
            } else if (changeFromBackend instanceof BackendResponse.RetryRequired) {
                boolean bl;
                boolean bl2 = bl = this.globalRetryTimestamp.compareTo(((BackendResponse.RetryRequired)changeFromBackend).getNewGlobalRetryTimestamp()) < 0;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "Global retry timestamp must be less than new global retry timestamp";
                    throw new AssertionError((Object)string);
                }
                this.globalRetryTimestamp = ((BackendResponse.RetryRequired)changeFromBackend).getNewGlobalRetryTimestamp();
            } else if (changeFromBackend instanceof BackendResponse.Success) {
                SpeculativeRequest speculativeRequest;
                PatchEngineRetryTimestampWithGeneration patchEngineRetryTimestampWithGeneration = ((BackendResponse.Success)changeFromBackend).getNewRetryTimestamp();
                if (patchEngineRetryTimestampWithGeneration != null) {
                    boolean bl;
                    boolean bl4 = bl = this.globalRetryTimestamp.compareTo(patchEngineRetryTimestampWithGeneration) < 0;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl5 = false;
                        String string = "Global retry timestamp must be less than new global retry timestamp";
                        throw new AssertionError((Object)string);
                    }
                    this.globalRetryTimestamp = patchEngineRetryTimestampWithGeneration;
                }
                if ((speculativeRequest = (SpeculativeRequest)this.pendingRequestsQueue.peek()).getUniqueId() != ((BackendResponse.Success)changeFromBackend).getRequestId()) {
                    throw new IllegalStateException(("Unexpected response: " + changeFromBackend + ". Current first pending request is " + speculativeRequest).toString());
                }
                BackendResponse.Success success = (BackendResponse.Success)changeFromBackend;
                Intrinsics.checkNotNull((Object)speculativeRequest);
                success.apply(false, speculativeRequest, TContext);
                this.x((BackendResponse.Success)changeFromBackend, speculativeRequest, TContext);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            iterator3.remove();
        }
    }

    private final void x(BackendResponse.Success<TContext, TReq> success, TReq TReq) {
        ChangeFromBackend.withChangeContext$default(success, 0, arg_0 -> SpeculativeQueueProcessor.x(this, success, TReq, arg_0), 1, null);
    }

    private final void x(BackendOriginatedChange<TContext, TReq> backendOriginatedChange) {
        backendOriginatedChange.withChangeContext(1, (Function1)new Function1<TContext, Unit>(backendOriginatedChange){

            public final void invoke(TContext p0) {
                ((BackendOriginatedChange)this.receiver).apply(p0);
            }
        });
    }

    private final void x(BackendResponse.Success<TContext, TReq> success, TReq TReq, TContext TContext) {
        boolean bl;
        SpeculativeRequest speculativeRequest = (SpeculativeRequest)this.pendingRequestsQueue.poll();
        boolean bl2 = bl = speculativeRequest == TReq;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Expected request to be removed: " + TReq + ", but actual: " + speculativeRequest;
            throw new AssertionError((Object)string);
        }
        success.complete(TReq, TContext);
        long l = this.backendChangesCounter;
        this.backendChangesCounter = l + 1L;
    }

    private final void x(boolean bl, TContext TContext, boolean bl2) {
        int n = this.pendingRequestsQueue.size();
        if (!bl) {
            RebaseConflictStatisticsCollector<TContext, TReq> rebaseConflictStatisticsCollector = this.statisticsCollector;
            if (rebaseConflictStatisticsCollector != null) {
                rebaseConflictStatisticsCollector.collectRedone(TContext, n);
            }
        }
        Iterable iterable = this.pendingRequestsQueue;
        boolean bl3 = false;
        for (Object t : iterable) {
            SpeculativeRequest speculativeRequest = (SpeculativeRequest)t;
            boolean bl4 = false;
            speculativeRequest.replay(bl, TContext);
            if (bl || !bl2) continue;
            speculativeRequest.send(this.globalRetryTimestamp);
        }
    }

    private final void x() {
        Iterable iterable = this.pendingRequestsQueue;
        boolean bl = false;
        for (Object t : iterable) {
            SpeculativeRequest speculativeRequest = (SpeculativeRequest)t;
            boolean bl2 = false;
            speculativeRequest.send(this.globalRetryTimestamp);
        }
    }

    private static final Unit x(SpeculativeQueueProcessor speculativeQueueProcessor, PatchEngineRetryTimestampWithGeneration patchEngineRetryTimestampWithGeneration, Object object) {
        speculativeQueueProcessor.x(false, object);
        speculativeQueueProcessor.x(object);
        speculativeQueueProcessor.x(false, object, !Intrinsics.areEqual((Object)patchEngineRetryTimestampWithGeneration, (Object)speculativeQueueProcessor.globalRetryTimestamp));
        return Unit.INSTANCE;
    }

    private static final Unit x(SpeculativeQueueProcessor speculativeQueueProcessor, ChangeFromBackend changeFromBackend, SpeculativeRequest speculativeRequest, Object object) {
        speculativeQueueProcessor.x(true, object);
        BackendResponse.Success success = (BackendResponse.Success)changeFromBackend;
        Intrinsics.checkNotNull((Object)speculativeRequest);
        success.apply(true, speculativeRequest, object);
        speculativeQueueProcessor.x((BackendResponse.Success)changeFromBackend, speculativeRequest, object);
        speculativeQueueProcessor.x(true, object, false);
        return Unit.INSTANCE;
    }

    private static final Unit x(SpeculativeQueueProcessor speculativeQueueProcessor, BackendResponse.Success success, SpeculativeRequest speculativeRequest, Object object) {
        speculativeQueueProcessor.x(success, speculativeRequest, object);
        return Unit.INSTANCE;
    }

    public SpeculativeQueueProcessor() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdclient/requests/SpeculativeQueueProcessor$FastPathResult;", "", "SpeculativeQueueProcessor$FastPathResult", "(Ljava/lang/String;I)V", "Processed", "JustRetry", "Rebase", "intellij.rd.client"})
    private static final class FastPathResult
    extends Enum<FastPathResult> {
        public static final /* enum */ FastPathResult Processed = new FastPathResult();
        public static final /* enum */ FastPathResult JustRetry = new FastPathResult();
        public static final /* enum */ FastPathResult Rebase = new FastPathResult();
        private static final /* synthetic */ FastPathResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FastPathResult[] values() {
            return (FastPathResult[])$VALUES.clone();
        }

        public static FastPathResult valueOf(String value2) {
            return Enum.valueOf(FastPathResult.class, value2);
        }

        @NotNull
        public static EnumEntries<FastPathResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fastPathResultArray = new FastPathResult[]{FastPathResult.Processed, FastPathResult.JustRetry, FastPathResult.Rebase};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[FastPathResult.values().length];
            try {
                nArray[FastPathResult.Processed.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FastPathResult.JustRetry.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FastPathResult.Rebase.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SpeculativelyEqualsResult.values().length];
            try {
                nArray[SpeculativelyEqualsResult.Equals.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpeculativelyEqualsResult.Equivalent.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpeculativelyEqualsResult.Different.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

