/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.requests;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdResponse;
import com.jetbrains.rd.ide.requests.RdPatchUtilsKt;
import com.jetbrains.rd.ide.requests.SpeculativelyEqualsResult;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemHandlerKt;
import com.jetbrains.rdclient.patches.FrontendRdPatchHandlerRegistry;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutor;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestListener;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u001a\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u00100\rH\u0007J*\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010J0\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010%\u001a\u00020&J(\u0010'\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010%\u001a\u00020&J(\u0010(\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010%\u001a\u00020&J\u0016\u0010)\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u000eJ\u001c\u0010*\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0+J\u001e\u0010,\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020.J\u001c\u0010/\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\f\u00100\u001a\b\u0012\u0004\u0012\u00020.0+J\u0016\u00101\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&2\u0006\u00102\u001a\u000203R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bRH\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u00100\r2\u001a\u0010\f\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u00100\r8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00064"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutorHelper;", "", "FrontendAsyncRequestExecutorHelper", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "rebaseListener", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$RebaseListener;", "getRebaseListener", "()Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$RebaseListener;", "setRebaseListener", "(Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$RebaseListener;)V", "value", "Lkotlin/Function2;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "Lcom/jetbrains/rd/ide/model/RdPatch;", "", "forceRebase", "getForceRebase", "()Lkotlin/jvm/functions/Function2;", "withForceRebase", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "check", "speculativelyEquals", "Lcom/jetbrains/rd/ide/requests/SpeculativelyEqualsResult;", "speculatedPatch", "backendPatch", "request", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestWithImmediateResult;", "allowEquivalentChanges", "applyBackendChangesOnly", "patch", "virtually", "rebaseSession", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "applyBackendFeaturesOnlyAndUpdate", "applyBackendPatch", "fireRequestSubmitted", "fireRequestsSent", "", "fireRequestCompleted", "response", "Lcom/jetbrains/rd/ide/model/RdResponse;", "fireResponsesExecuted", "responses", "fireProblemOccurred", "throwable", "", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendAsyncRequestExecutorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAsyncRequestExecutorHelper.kt\ncom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutorHelper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,107:1\n23#2:108\n*S KotlinDebug\n*F\n+ 1 FrontendAsyncRequestExecutorHelper.kt\ncom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutorHelper\n*L\n17#1:108\n*E\n"})
public final class FrontendAsyncRequestExecutorHelper {
    @NotNull
    public static final FrontendAsyncRequestExecutorHelper INSTANCE;
    @NotNull
    private static final Logger logger;
    @TestOnly
    @Nullable
    private static FrontendAsyncRequestExecutor.RebaseListener rebaseListener;
    @TestOnly
    @NotNull
    private static Function2<? super FrontendAsyncRequest, ? super RdPatch, Boolean> forceRebase;

    private FrontendAsyncRequestExecutorHelper() {
    }

    @Nullable
    public final FrontendAsyncRequestExecutor.RebaseListener getRebaseListener() {
        return rebaseListener;
    }

    public final void setRebaseListener(@Nullable FrontendAsyncRequestExecutor.RebaseListener rebaseListener) {
        FrontendAsyncRequestExecutorHelper.rebaseListener = rebaseListener;
    }

    @NotNull
    public final Function2<FrontendAsyncRequest, RdPatch, Boolean> getForceRebase() {
        return forceRebase;
    }

    @TestOnly
    public final void withForceRebase(@NotNull Lifetime lifetime, @NotNull Function2<? super FrontendAsyncRequest, ? super RdPatch, Boolean> check) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(check, (String)"check");
        Function2<? super FrontendAsyncRequest, ? super RdPatch, Boolean> function2 = forceRebase;
        lifetime.bracketOrThrow(() -> FrontendAsyncRequestExecutorHelper.x(check), () -> FrontendAsyncRequestExecutorHelper.x(check, function2));
    }

    @NotNull
    public final SpeculativelyEqualsResult speculativelyEquals(@Nullable RdPatch speculatedPatch, @Nullable RdPatch backendPatch, @NotNull FrontendAsyncRequestWithImmediateResult request, boolean allowEquivalentChanges) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (((Boolean)forceRebase.invoke((Object)request, (Object)backendPatch)).booleanValue()) {
            return SpeculativelyEqualsResult.Different;
        }
        return RdPatchUtilsKt.speculativelyEquals(speculatedPatch, backendPatch, allowEquivalentChanges);
    }

    public final void applyBackendChangesOnly(@NotNull RdPatch patch, boolean virtually, @NotNull FrontendRebaseSession rebaseSession, @Nullable FrontendAsyncRequest request, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Intrinsics.checkNotNullParameter((Object)rebaseSession, (String)"rebaseSession");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FrontendRdPatchHandlerRegistry frontendRdPatchHandlerRegistry = FrontendRdPatchHandlerRegistry.Companion.getInstance();
        PatchItemOperationType patchItemOperationType = virtually ? (PatchItemOperationType)PatchItemOperationType.SoftPerform.INSTANCE : (PatchItemOperationType)PatchItemOperationType.Perform.INSTANCE;
        FrontendRdPatchHandlerContext frontendRdPatchHandlerContext = new FrontendRdPatchHandlerContext(session, patch, request, patchItemOperationType, rebaseSession);
        rebaseSession.validateAndUpdateVersions(patch.getExpectedItemVersions(), frontendRdPatchHandlerContext);
        FrontendRdPatchItemHandlerKt.withHandlerContext(frontendRdPatchHandlerContext, () -> FrontendAsyncRequestExecutorHelper.x(frontendRdPatchHandlerRegistry, patch, frontendRdPatchHandlerContext));
        frontendRdPatchHandlerRegistry.update(patch.getUpdatedItemVersions(), frontendRdPatchHandlerContext);
        rebaseSession.validateAndUpdateVersions(patch.getUpdatedItemVersions(), frontendRdPatchHandlerContext);
    }

    public final void applyBackendFeaturesOnlyAndUpdate(@NotNull RdPatch patch, @NotNull FrontendRebaseSession rebaseSession, @Nullable FrontendAsyncRequest request, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Intrinsics.checkNotNullParameter((Object)rebaseSession, (String)"rebaseSession");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FrontendRdPatchHandlerRegistry frontendRdPatchHandlerRegistry = FrontendRdPatchHandlerRegistry.Companion.getInstance();
        FrontendRdPatchHandlerContext frontendRdPatchHandlerContext = new FrontendRdPatchHandlerContext(session, patch, request, PatchItemOperationType.Perform.INSTANCE, rebaseSession);
        FrontendRdPatchItemHandlerKt.withHandlerContext(frontendRdPatchHandlerContext, () -> FrontendAsyncRequestExecutorHelper.G(frontendRdPatchHandlerRegistry, patch, frontendRdPatchHandlerContext));
        frontendRdPatchHandlerRegistry.update(patch.getUpdatedItemVersions(), frontendRdPatchHandlerContext);
    }

    public final void applyBackendPatch(@NotNull RdPatch patch, @NotNull FrontendRebaseSession rebaseSession, @Nullable FrontendAsyncRequest request, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Intrinsics.checkNotNullParameter((Object)rebaseSession, (String)"rebaseSession");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.applyBackendChangesOnly(patch, false, rebaseSession, request, session);
        this.applyBackendFeaturesOnlyAndUpdate(patch, rebaseSession, request, session);
    }

    public final void fireRequestSubmitted(@NotNull ClientAppSession session, @NotNull FrontendAsyncRequest request) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ((FrontendAsyncRequestListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendAsyncRequestListener.Companion.getTOPIC())).requestSubmitted(session, request);
    }

    public final void fireRequestsSent(@NotNull ClientAppSession session, @NotNull List<? extends FrontendAsyncRequest> request) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        ((FrontendAsyncRequestListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendAsyncRequestListener.Companion.getTOPIC())).requestsSent(session, request);
    }

    public final void fireRequestCompleted(@NotNull ClientAppSession session, @NotNull FrontendAsyncRequest request, @NotNull RdResponse response) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        ((FrontendAsyncRequestListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendAsyncRequestListener.Companion.getTOPIC())).requestCompleted(session, request, response);
    }

    public final void fireResponsesExecuted(@NotNull ClientAppSession session, @NotNull List<? extends RdResponse> responses) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(responses, (String)"responses");
        ((FrontendAsyncRequestListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendAsyncRequestListener.Companion.getTOPIC())).responsesExecuted(session, responses);
    }

    public final void fireProblemOccurred(@NotNull ClientAppSession session, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        ((FrontendAsyncRequestListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendAsyncRequestListener.Companion.getTOPIC())).problemOccurred(session, throwable);
    }

    private static final boolean x(FrontendAsyncRequest frontendAsyncRequest, RdPatch rdPatch) {
        Intrinsics.checkNotNullParameter((Object)frontendAsyncRequest, (String)"request");
        return false;
    }

    private static final Unit x(Function2 function2) {
        forceRebase = function2;
        return Unit.INSTANCE;
    }

    private static final Unit x(Function2 function2, Function2 function22) {
        if (forceRebase == function2) {
            forceRebase = function22;
        } else {
            logger.error("forceRebase" + " was changed. Incorrect scoping");
            forceRebase = FrontendAsyncRequestExecutorHelper::G;
        }
        return Unit.INSTANCE;
    }

    private static final boolean G(FrontendAsyncRequest frontendAsyncRequest, RdPatch rdPatch) {
        Intrinsics.checkNotNullParameter((Object)frontendAsyncRequest, (String)"request");
        return false;
    }

    private static final Unit x(FrontendRdPatchHandlerRegistry frontendRdPatchHandlerRegistry, RdPatch rdPatch, FrontendRdPatchHandlerContext frontendRdPatchHandlerContext) {
        frontendRdPatchHandlerRegistry.apply(rdPatch.getChanges(), frontendRdPatchHandlerContext);
        return Unit.INSTANCE;
    }

    private static final Unit G(FrontendRdPatchHandlerRegistry frontendRdPatchHandlerRegistry, RdPatch rdPatch, FrontendRdPatchHandlerContext frontendRdPatchHandlerContext) {
        frontendRdPatchHandlerRegistry.apply(rdPatch.getFeatures(), frontendRdPatchHandlerContext);
        return Unit.INSTANCE;
    }

    static {
        FrontendAsyncRequestExecutorHelper frontendAsyncRequestExecutorHelper = INSTANCE = new FrontendAsyncRequestExecutorHelper();
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendAsyncRequestExecutorHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendAsyncRequestExecutorHelper.logger = logger;
        forceRebase = FrontendAsyncRequestExecutorHelper::x;
    }
}

