/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.requests;

import com.intellij.openapi.client.ClientAppSession;
import com.jetbrains.rd.ide.document.DocumentSynchronizerListeners;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.tracing.SyncEventsLogger;
import com.jetbrains.rdclient.diagnostics.CaretMovementTracker;
import com.jetbrains.rdclient.diagnostics.ConflictTracker;
import com.jetbrains.rdclient.requests.BackendOriginatedChange;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutorHelper;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.requests.SpeculativeRequestWrapper;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J$\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00120\u0018H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdclient/requests/BackendChangeWrapper;", "Lcom/jetbrains/rdclient/requests/BackendOriginatedChange;", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "Lcom/jetbrains/rdclient/requests/SpeculativeRequestWrapper;", "patch", "Lcom/jetbrains/rd/ide/model/RdPatch;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "BackendChangeWrapper", "(Lcom/jetbrains/rd/ide/model/RdPatch;Lcom/intellij/openapi/client/ClientAppSession;)V", "getPatch", "()Lcom/jetbrains/rd/ide/model/RdPatch;", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "conflictsWith", "", "req", "apply", "", "context", "withChangeContext", "elementsInContext", "", "action", "Lkotlin/Function1;", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nBackendChangeWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendChangeWrapper.kt\ncom/jetbrains/rdclient/requests/BackendChangeWrapper\n+ 2 FrontendRebaseSession.kt\ncom/jetbrains/rdclient/requests/FrontendRebaseSession$Companion\n*L\n1#1,19:1\n36#2,13:20\n*S KotlinDebug\n*F\n+ 1 BackendChangeWrapper.kt\ncom/jetbrains/rdclient/requests/BackendChangeWrapper\n*L\n17#1:20,13\n*E\n"})
public final class BackendChangeWrapper
implements BackendOriginatedChange<FrontendRebaseSession, SpeculativeRequestWrapper> {
    @NotNull
    private final RdPatch patch;
    @NotNull
    private final ClientAppSession session;

    public BackendChangeWrapper(@NotNull RdPatch patch, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.patch = patch;
        this.session = session;
    }

    @NotNull
    public final RdPatch getPatch() {
        return this.patch;
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    @Override
    public boolean conflictsWith(@NotNull SpeculativeRequestWrapper req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        return req.getRequest().conflictWith(this.patch);
    }

    @Override
    public void apply(@NotNull FrontendRebaseSession context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FrontendAsyncRequestExecutorHelper.INSTANCE.applyBackendPatch(this.patch, context, null, this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withChangeContext(int elementsInContext, @NotNull Function1<? super FrontendRebaseSession, Unit> action3) {
        Intrinsics.checkNotNullParameter(action3, (String)"action");
        FrontendRebaseSession.Companion companion = FrontendRebaseSession.Companion;
        ClientAppSession clientAppSession = this.session;
        SyncEventsLogger.RebaseSessionType rebaseSessionType = SyncEventsLogger.RebaseSessionType.BACKEND_CHANGE;
        int n = elementsInContext;
        boolean bl = false;
        ConflictTracker conflictTracker = new ConflictTracker(rebaseSessionType, n);
        CaretMovementTracker caretMovementTracker = new CaretMovementTracker();
        FrontendRebaseSession frontendRebaseSession = companion.createEmpty(rebaseSessionType, conflictTracker, caretMovementTracker);
        try {
            DocumentSynchronizerListeners.Companion.getInstance(clientAppSession).addListener(frontendRebaseSession);
            action3.invoke((Object)frontendRebaseSession);
        }
        finally {
            DocumentSynchronizerListeners.Companion.getInstance(clientAppSession).removeListener(frontendRebaseSession);
            caretMovementTracker.reportAllMovements(conflictTracker);
            conflictTracker.reportSummary();
        }
    }
}

