/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.gotoType;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.actions.SearchEverywhereAction;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereToggleAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.rd.ide.model.GotoKey;
import com.jetbrains.rdclient.gotoType.GotoHost;
import com.jetbrains.rdclient.gotoType.GotoPopupSession;
import com.jetbrains.rdclient.gotoType.GotoResult;
import com.jetbrains.rdclient.gotoType.ProtocolNavigationItem;
import com.jetbrains.rdclient.gotoType.ProtocolSearchEverywhereContributor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J.\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0014\u0010!\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020$0#0\"H\u0007J\u000e\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0019\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lcom/jetbrains/rdclient/gotoType/ProtocolSearchEverywhereItemsProcessor;", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "project", "Lcom/intellij/openapi/project/Project;", "gotoKeyProvider", "Lkotlin/Function0;", "Lcom/jetbrains/rd/ide/model/GotoKey;", "shouldAccessVfsWhenPresentingItemsPredicate", "", "everywhereActionFetcher", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereToggleAction;", "contributorDisposable", "Lcom/intellij/openapi/Disposable;", "ProtocolSearchEverywhereItemsProcessor", "(Lcom/intellij/openapi/diagnostic/Logger;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lcom/intellij/openapi/Disposable;)V", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getGotoKeyProvider", "()Lkotlin/jvm/functions/Function0;", "getShouldAccessVfsWhenPresentingItemsPredicate", "getEverywhereActionFetcher", "getContributorDisposable", "()Lcom/intellij/openapi/Disposable;", "fetchWeightedElements", "", "pattern", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/ide/actions/searcheverywhere/FoundItemDescriptor;", "Lcom/jetbrains/rdclient/gotoType/ProtocolNavigationItem;", "processSelectedItem", "selected", "intellij.rd.client"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nProtocolSearchEverywhereItemsProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolSearchEverywhereItemsProcessor.kt\ncom/jetbrains/rdclient/gotoType/ProtocolSearchEverywhereItemsProcessor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n10890#2,5:86\n1011#3,2:91\n1869#3,2:93\n1869#3,2:95\n*S KotlinDebug\n*F\n+ 1 ProtocolSearchEverywhereItemsProcessor.kt\ncom/jetbrains/rdclient/gotoType/ProtocolSearchEverywhereItemsProcessor\n*L\n44#1:86,5\n45#1:91,2\n50#1:93,2\n60#1:95,2\n*E\n"})
public final class ProtocolSearchEverywhereItemsProcessor {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<GotoKey> gotoKeyProvider;
    @NotNull
    private final Function0<Boolean> shouldAccessVfsWhenPresentingItemsPredicate;
    @NotNull
    private final Function0<SearchEverywhereToggleAction> everywhereActionFetcher;
    @NotNull
    private final Disposable contributorDisposable;

    public ProtocolSearchEverywhereItemsProcessor(@NotNull Logger logger, @NotNull Project project, @NotNull Function0<? extends GotoKey> gotoKeyProvider, @NotNull Function0<Boolean> shouldAccessVfsWhenPresentingItemsPredicate, @NotNull Function0<? extends SearchEverywhereToggleAction> everywhereActionFetcher, @NotNull Disposable contributorDisposable) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(gotoKeyProvider, (String)"gotoKeyProvider");
        Intrinsics.checkNotNullParameter(shouldAccessVfsWhenPresentingItemsPredicate, (String)"shouldAccessVfsWhenPresentingItemsPredicate");
        Intrinsics.checkNotNullParameter(everywhereActionFetcher, (String)"everywhereActionFetcher");
        Intrinsics.checkNotNullParameter((Object)contributorDisposable, (String)"contributorDisposable");
        this.logger = logger;
        this.project = project;
        this.gotoKeyProvider = gotoKeyProvider;
        this.shouldAccessVfsWhenPresentingItemsPredicate = shouldAccessVfsWhenPresentingItemsPredicate;
        this.everywhereActionFetcher = everywhereActionFetcher;
        this.contributorDisposable = contributorDisposable;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Function0<GotoKey> getGotoKeyProvider() {
        return this.gotoKeyProvider;
    }

    @NotNull
    public final Function0<Boolean> getShouldAccessVfsWhenPresentingItemsPredicate() {
        return this.shouldAccessVfsWhenPresentingItemsPredicate;
    }

    @NotNull
    public final Function0<SearchEverywhereToggleAction> getEverywhereActionFetcher() {
        return this.everywhereActionFetcher;
    }

    @NotNull
    public final Disposable getContributorDisposable() {
        return this.contributorDisposable;
    }

    @RequiresReadLock
    public final void fetchWeightedElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator2, @NotNull Processor<? super FoundItemDescriptor<ProtocolNavigationItem>> consumer) {
        Object object5;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)progressIndicator2, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (progressIndicator2.isCanceled()) {
            this.logger.info("Progress is canceled. Aborting protocol search");
            return;
        }
        GotoHost gotoHost = GotoHost.Companion.getInstance(this.project);
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)this.project.getUserData(SearchEverywhereAction.SEARCH_EVERYWHERE_POPUP);
        JBPopup jBPopup = concurrentHashMap != null ? (JBPopup)concurrentHashMap.get(ClientId.Companion.getCurrent()) : null;
        Disposable disposable = jBPopup instanceof Disposable ? (Disposable)jBPopup : null;
        jBPopup = disposable == null ? this.contributorDisposable : null;
        Disposable disposable2 = disposable;
        if (disposable2 == null && (disposable2 = jBPopup) == null) {
            throw new IllegalStateException("Can't find session lifetime".toString());
        }
        Disposable disposable3 = disposable2;
        GotoPopupSession gotoPopupSession = gotoHost.getSessionForPopup(disposable3, (GotoKey)this.gotoKeyProvider.invoke());
        SearchEverywhereToggleAction searchEverywhereToggleAction = (SearchEverywhereToggleAction)this.everywhereActionFetcher.invoke();
        String[] stringArray = gotoPopupSession.getItemsSync(pattern, searchEverywhereToggleAction != null ? Boolean.valueOf(searchEverywhereToggleAction.isEverywhere()) : null, progressIndicator2);
        ArrayList arrayList = new ArrayList();
        Object object2 = stringArray;
        Collection collection = arrayList;
        boolean bl = false;
        int n = ((String[])object2).length;
        for (int j = 0; j < n; ++j) {
            Object object3;
            object5 = object3 = object2[j];
            boolean bl2 = false;
            object5 = gotoPopupSession.getItemByShortName((String)object5);
            CollectionsKt.addAll((Collection)collection, (Iterable)object5);
        }
        object2 = arrayList;
        boolean bl3 = false;
        if (object2.size() > 1) {
            CollectionsKt.sortWith((List)object2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    GotoResult gotoResult = (GotoResult)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(-gotoResult.getSearchItemData().getMatchScore());
                    gotoResult = (GotoResult)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(-gotoResult.getSearchItemData().getMatchScore()));
                }
            });
        }
        if (this.logger.isTraceEnabled()) {
            Object object4 = object2 = new StringBuilder();
            Logger logger = this.logger;
            bl = false;
            ((StringBuilder)object4).append("(" + object4.getClass().getSimpleName() + ") Got " + arrayList.size() + " items for " + this.gotoKeyProvider.invoke() + " contributor. Items: \n");
            Iterable iterable = arrayList;
            n = 0;
            for (Object object5 : iterable) {
                GotoResult gotoResult = (GotoResult)object5;
                boolean bl4 = false;
                ((StringBuilder)object4).append("(" + gotoResult.getClass().getSimpleName() + ") " + gotoResult.getSearchItemData().getShortName() + " ");
                if (gotoResult.getSearchItemData().getClrName() != null) {
                    ((StringBuilder)object4).append("CLR: " + gotoResult.getSearchItemData().getClrName());
                }
                ((StringBuilder)object4).append("\n");
            }
            logger.trace(((StringBuilder)object2).toString());
        }
        object2 = arrayList;
        boolean bl5 = false;
        Iterator iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            GotoResult gotoResult = (GotoResult)t;
            boolean bl6 = false;
            progressIndicator2.checkCanceled();
            object5 = ProtocolSearchEverywhereContributor.Companion.createNavigationItem(this.project, (Boolean)this.shouldAccessVfsWhenPresentingItemsPredicate.invoke(), pattern, gotoResult, gotoPopupSession);
            if (consumer.process((Object)new FoundItemDescriptor(object5, gotoResult.getSearchItemData().getMatchScore()))) continue;
        }
    }

    public final boolean processSelectedItem(@NotNull ProtocolNavigationItem selected) {
        Intrinsics.checkNotNullParameter((Object)((Object)selected), (String)"selected");
        ApplicationManager.getApplication().invokeLater(() -> ProtocolSearchEverywhereItemsProcessor.x(selected));
        return true;
    }

    private static final void x(ProtocolNavigationItem protocolNavigationItem) {
        protocolNavigationItem.getSearchPopup().getItemExecutedSignal().fire((Object)protocolNavigationItem.getSearchItemData());
    }
}

