/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.gotoType;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.jetbrains.rd.ide.model.GotoInputWithId;
import com.jetbrains.rd.ide.model.GotoKey;
import com.jetbrains.rd.ide.model.GotoResultListBase;
import com.jetbrains.rd.ide.model.SearchItemData;
import com.jetbrains.rd.ide.model.SearchPopup;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IAsyncSignal;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rdclient.gotoType.GotoResult;
import com.jetbrains.rdclient.gotoType.ProtocolNavigationItem;
import com.jetbrains.rdclient.gotoType.ProtocolNavigationItemRendererData;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.SyncEventWithInterrupt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 52\u00020\u0001:\u00015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u000eJ-\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010%J?\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0018\u0010)\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001f\u0012\u0004\u0012\u00020'0*\u00a2\u0006\u0002\u0010+JQ\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0018\u0010)\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001f\u0012\u0004\u0012\u00020'0*H\u0002\u00a2\u0006\u0002\u0010/J\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u000e012\u0006\u00102\u001a\u00020\fJ\u000e\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rb\u0010\n\u001aV\u0012\u0004\u0012\u00020\f\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000f0\u000bj*\u0012\u0004\u0012\u00020\f\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000f`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001b0\u000bj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001b`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/jetbrains/rdclient/gotoType/GotoPopupSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "popupLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "gotoKey", "Lcom/jetbrains/rd/ide/model/GotoKey;", "GotoPopupSession", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/ide/model/GotoKey;)V", "shortNameToItemsMap", "Ljava/util/HashMap;", "", "Lcom/jetbrains/rd/ide/model/SearchItemData;", "Lcom/jetbrains/rdclient/gotoType/GotoResult;", "Lkotlin/collections/HashMap;", "requestLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "sequentialLifetimesLocks", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "perTypeRequestIds", "Ljava/util/concurrent/atomic/AtomicInteger;", "getModelSearchPopup", "Lcom/jetbrains/rd/ide/model/SearchPopup;", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "navItemCache", "Lcom/jetbrains/rdclient/gotoType/ProtocolNavigationItem;", "getCachedPerResultNavItem", "gotoRes", "getItemsSync", "", "text", "searchInLibraries", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Ljava/lang/String;Ljava/lang/Boolean;Lcom/intellij/openapi/progress/ProgressIndicator;)[Ljava/lang/String;", "getItemsAsync", "", "lifetime", "whenReady", "Lkotlin/Function1;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;Ljava/lang/Boolean;Lkotlin/jvm/functions/Function1;)V", "x", "requestId", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;ILcom/jetbrains/rdclient/services/IdeBackend;Ljava/lang/String;Ljava/lang/Boolean;Lkotlin/jvm/functions/Function1;)V", "getItemByShortName", "", "shortName", "getRecentVersionOfResult", "data", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nGotoPopupSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GotoPopupSession.kt\ncom/jetbrains/rdclient/gotoType/GotoPopupSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,190:1\n1#2:191\n67#3,4:192\n67#3,4:199\n67#3,4:203\n67#3,4:207\n66#4,3:196\n1491#5:211\n1516#5,3:212\n1519#5,3:222\n1869#5,2:232\n382#6,7:215\n382#6,7:225\n37#7,2:234\n*S KotlinDebug\n*F\n+ 1 GotoPopupSession.kt\ncom/jetbrains/rdclient/gotoType/GotoPopupSession\n*L\n52#1:192,4\n143#1:199,4\n59#1:203,4\n148#1:207,4\n79#1:196,3\n168#1:211\n168#1:212,3\n168#1:222,3\n171#1:232,2\n168#1:215,7\n170#1:225,7\n177#1:234,2\n*E\n"})
public final class GotoPopupSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lifetime popupLifetime;
    @NotNull
    private final GotoKey gotoKey;
    @NotNull
    private final HashMap<String, HashMap<SearchItemData, GotoResult>> shortNameToItemsMap;
    @NotNull
    private final SequentialLifetimes requestLifetimes;
    @NotNull
    private final ReentrantReadWriteLock sequentialLifetimesLocks;
    @NotNull
    private AtomicInteger perTypeRequestIds;
    @NotNull
    private final HashMap<GotoResult, ProtocolNavigationItem> navItemCache;
    @NotNull
    private static final Logger logger;

    public GotoPopupSession(@NotNull Project project, @NotNull Lifetime popupLifetime, @NotNull GotoKey gotoKey) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)popupLifetime, (String)"popupLifetime");
        Intrinsics.checkNotNullParameter((Object)gotoKey, (String)"gotoKey");
        this.project = project;
        this.popupLifetime = popupLifetime;
        this.gotoKey = gotoKey;
        this.shortNameToItemsMap = new HashMap();
        this.requestLifetimes = new SequentialLifetimes(this.popupLifetime);
        this.sequentialLifetimesLocks = new ReentrantReadWriteLock();
        this.perTypeRequestIds = new AtomicInteger(0);
        this.navItemCache = new HashMap();
    }

    @NotNull
    public final SearchPopup getModelSearchPopup(@NotNull IdeBackend backend) {
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        IMutableViewableMap<GotoKey, SearchPopup> iMutableViewableMap = backend.getGotoModel().getSearchPopups();
        SearchPopup searchPopup = (SearchPopup)((Object)iMutableViewableMap.get((Object)this.gotoKey));
        if (searchPopup == null) {
            boolean bl;
            GotoPopupSession gotoPopupSession = this;
            boolean bl2 = false;
            SearchPopup searchPopup2 = new SearchPopup(gotoPopupSession.gotoKey);
            boolean bl3 = bl = !iMutableViewableMap.containsKey((Object)gotoPopupSession.gotoKey);
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "May not execute overlapping popup of type " + gotoPopupSession.gotoKey;
                throw new AssertionError((Object)string);
            }
            ((Map)iMutableViewableMap).put(gotoPopupSession.gotoKey, searchPopup2);
            Logger logger = GotoPopupSession.logger;
            boolean bl5 = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl6 = false;
                logger2.trace("Putting protocol popup model for type " + gotoPopupSession.gotoKey);
            }
            gotoPopupSession.popupLifetime.onTermination(() -> GotoPopupSession.x(gotoPopupSession, iMutableViewableMap, searchPopup2));
            searchPopup = searchPopup2;
        }
        return searchPopup;
    }

    @NotNull
    public final ProtocolNavigationItem getCachedPerResultNavItem(@NotNull GotoResult gotoRes) {
        Intrinsics.checkNotNullParameter((Object)gotoRes, (String)"gotoRes");
        SearchItemData searchItemData = gotoRes.component1();
        SearchPopup searchPopup = gotoRes.component2();
        Map map = this.navItemCache;
        GotoResult gotoResult = gotoRes;
        boolean bl = false;
        Object object = map.get(gotoResult);
        if (object == null) {
            GotoResult gotoResult2 = gotoResult;
            boolean bl2 = false;
            VirtualFile virtualFile = ProtocolNavigationItem.Companion.calculateVirtualFile(searchItemData, true, this.project);
            ProtocolNavigationItemRendererData protocolNavigationItemRendererData = ProtocolNavigationItemRendererData.Companion.calculateRenderData$default(ProtocolNavigationItemRendererData.Companion, virtualFile, true, this.project, null, 8, null);
            ProtocolNavigationItem protocolNavigationItem = new ProtocolNavigationItem(searchItemData, searchPopup, this.project, this, virtualFile, protocolNavigationItemRendererData, null, null, null, 448, null);
            boolean bl3 = false;
            map.put(gotoResult, protocolNavigationItem);
            object = protocolNavigationItem;
        }
        return (ProtocolNavigationItem)((Object)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String[] getItemsSync(@NotNull String text, @Nullable Boolean searchInLibraries, @Nullable ProgressIndicator progressIndicator2) {
        LifetimeDefinition lifetimeDefinition;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = new String[0];
        SyncEventWithInterrupt syncEventWithInterrupt = new SyncEventWithInterrupt();
        ReentrantReadWriteLock reentrantReadWriteLock = this.sequentialLifetimesLocks;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            lifetimeDefinition = this.requestLifetimes.next();
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        LifetimeDefinition lifetimeDefinition2 = lifetimeDefinition;
        ApplicationManager.getApplication().invokeLater(() -> GotoPopupSession.x(this, lifetimeDefinition2, text, searchInLibraries, objectRef, syncEventWithInterrupt), ModalityState.any());
        SyncEventWithInterrupt.waitFor$default(syncEventWithInterrupt, (Lifetime)lifetimeDefinition2, false, () -> GotoPopupSession.x(progressIndicator2), 2, null);
        return (String[])objectRef.element;
    }

    public final void getItemsAsync(@NotNull Lifetime lifetime, @NotNull String text, @Nullable Boolean searchInLibraries, @NotNull Function1<? super String[], Unit> whenReady) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(whenReady, (String)"whenReady");
        IdeBackend ideBackend = IdeBackend.Companion.getInstance(this.project);
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)ideBackend.getSolution().isLoaded()))) {
            whenReady.invoke((Object)new String[0]);
            return;
        }
        this.x(lifetime, this.perTypeRequestIds.incrementAndGet(), ideBackend, text, searchInLibraries, (Function1<? super String[], Unit>)((Function1)arg_0 -> GotoPopupSession.x(whenReady, arg_0)));
    }

    private final void x(Lifetime lifetime, int n, IdeBackend ideBackend, String string, Boolean bl, Function1<? super String[], Unit> function1) {
        Logger logger = GotoPopupSession.logger;
        boolean bl2 = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl3 = false;
            logger2.trace("getItemsAsync.Start text: '" + string + "', kind: '" + this.gotoKey + "', searchInLibraries: '" + bl + "'");
        }
        logger = new Ref.BooleanRef();
        lifetime.onTermination(() -> GotoPopupSession.x((Ref.BooleanRef)logger, string, this, bl));
        SearchPopup searchPopup = this.getModelSearchPopup(ideBackend);
        IAsyncSignal<GotoResultListBase> iAsyncSignal = searchPopup.getGetItemsTask();
        IScheduler iScheduler = ideBackend.getProtocol().getScheduler();
        Intrinsics.checkNotNull((Object)iScheduler, (String)"null cannot be cast to non-null type com.jetbrains.rd.platform.protocol.IRdDispatcher");
        iAsyncSignal.adviseOn(lifetime, ((IRdDispatcher)iScheduler).getBackgroundScheduler(), arg_0 -> GotoPopupSession.x((Ref.BooleanRef)logger, string, bl, this, n, function1, searchPopup, arg_0));
        searchPopup.getInput().set((Object)new GotoInputWithId(n, string, bl));
    }

    @NotNull
    public final Collection<GotoResult> getItemByShortName(@NotNull String shortName) {
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        HashMap<SearchItemData, GotoResult> hashMap = this.shortNameToItemsMap.get(shortName);
        if (hashMap == null || (hashMap = hashMap.values()) == null) {
            hashMap = CollectionsKt.emptyList();
        }
        return hashMap;
    }

    @NotNull
    public final SearchItemData getRecentVersionOfResult(@NotNull SearchItemData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        HashMap<SearchItemData, GotoResult> hashMap = this.shortNameToItemsMap.get(data.getShortName());
        if (hashMap == null || (hashMap = hashMap.get(data)) == null || (hashMap = ((GotoResult)((Object)hashMap)).getSearchItemData()) == null) {
            hashMap = data;
        }
        return hashMap;
    }

    private static final Unit x(GotoPopupSession gotoPopupSession, IMutableViewableMap iMutableViewableMap, SearchPopup searchPopup) {
        SwingUtilities.invokeLater(() -> GotoPopupSession.x(gotoPopupSession, iMutableViewableMap, searchPopup));
        return Unit.INSTANCE;
    }

    private static final void x(GotoPopupSession gotoPopupSession, IMutableViewableMap iMutableViewableMap, SearchPopup searchPopup) {
        FocusManagerImpl.getInstance((Project)gotoPopupSession.project).doWhenFocusSettlesDown(() -> GotoPopupSession.x(iMutableViewableMap, gotoPopupSession, searchPopup));
    }

    private static final void x(IMutableViewableMap iMutableViewableMap, GotoPopupSession gotoPopupSession, SearchPopup searchPopup) {
        boolean bl;
        boolean bl2 = bl = iMutableViewableMap.get((Object)gotoPopupSession.gotoKey) == searchPopup;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Removing non-own popup from popup model for goto kind " + gotoPopupSession.gotoKey + ", bug?";
            throw new AssertionError((Object)string);
        }
        iMutableViewableMap.remove((Object)gotoPopupSession.gotoKey);
        Logger logger = GotoPopupSession.logger;
        boolean bl4 = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl5 = false;
            logger2.trace("Removing protocol model for type " + gotoPopupSession.gotoKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void x(GotoPopupSession gotoPopupSession, LifetimeDefinition lifetimeDefinition, String string, Boolean bl, Ref.ObjectRef objectRef, SyncEventWithInterrupt syncEventWithInterrupt) {
        ReentrantReadWriteLock.ReadLock readLock = gotoPopupSession.sequentialLifetimesLocks.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            if (!RLifetimeKt.isAlive((Lifetime)((Lifetime)lifetimeDefinition))) {
                return;
            }
            gotoPopupSession.getItemsAsync((Lifetime)lifetimeDefinition, string, bl, (Function1<? super String[], Unit>)((Function1)arg_0 -> GotoPopupSession.x(objectRef, syncEventWithInterrupt, arg_0)));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    private static final Unit x(Ref.ObjectRef objectRef, SyncEventWithInterrupt syncEventWithInterrupt, String[] stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"it");
        objectRef.element = stringArray;
        syncEventWithInterrupt.set();
        return Unit.INSTANCE;
    }

    private static final Unit x(ProgressIndicator progressIndicator2) {
        ProgressIndicator progressIndicator3 = progressIndicator2;
        if (progressIndicator3 != null) {
            progressIndicator3.checkCanceled();
        }
        ProgressManager.checkCanceled();
        if (ApplicationManagerEx.getApplicationEx().isWriteActionPending()) {
            throw new ProcessCanceledException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit x(Function1 function1, String[] stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"resultFromBackend");
        function1.invoke((Object)stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit x(Ref.BooleanRef booleanRef, String string, GotoPopupSession gotoPopupSession, Boolean bl) {
        if (!booleanRef.element) {
            Logger logger = GotoPopupSession.logger;
            boolean bl2 = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl3 = false;
                logger2.trace("getItemsAsync.Cancel text: '" + string + "', kind: '" + gotoPopupSession.gotoKey + "', searchInLibraries: '" + bl + "'");
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit x(Ref.BooleanRef booleanRef, String string, Boolean bl, GotoPopupSession gotoPopupSession, int n, Function1 function1, SearchPopup searchPopup, GotoResultListBase gotoResultListBase) {
        Object object;
        HashMap hashMap;
        Intrinsics.checkNotNullParameter((Object)gotoResultListBase, (String)"resultFromBackend");
        booleanRef.element = true;
        if (!Intrinsics.areEqual((Object)gotoResultListBase.getRequestText(), (Object)string) || !Intrinsics.areEqual((Object)gotoResultListBase.getRequestScope(), (Object)bl) || gotoPopupSession.perTypeRequestIds.get() != n) {
            logger.trace("Got response for wrong goto request, ignoring it");
            return Unit.INSTANCE;
        }
        logger.debug("Search items task for " + string + " from " + gotoPopupSession.gotoKey + " is done. Got " + ((Collection)gotoResultListBase.getItems()).size() + " items");
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterable object22 = gotoResultListBase.getItems();
        boolean collection2 = false;
        Iterable iterable = object22;
        Map map = new LinkedHashMap();
        boolean bl2 = false;
        for (Object object2 : iterable) {
            Object object3;
            hashMap = (SearchItemData)object2;
            boolean hashMap3 = false;
            String string2 = ((SearchItemData)((Object)hashMap)).getShortName();
            object = map;
            String string3 = string2;
            boolean bl3 = false;
            Object v = object.get(string3);
            if (v == null) {
                boolean bl4 = false;
                List list2 = new ArrayList();
                object.put(string3, list2);
                object3 = list2;
            } else {
                object3 = v;
            }
            hashMap = (List)object3;
            hashMap.add(object2);
        }
        for (Map.Entry entry : map.entrySet()) {
            HashMap hashMap2;
            Object object2;
            String string4 = (String)entry.getKey();
            iterable = (List)entry.getValue();
            arrayList.add(string4);
            Object object4 = gotoPopupSession.shortNameToItemsMap;
            String string5 = string4;
            boolean bl5 = false;
            hashMap = object4.get(string5);
            if (hashMap == null) {
                boolean searchItemData = false;
                HashMap hashMap3 = new HashMap();
                object4.put(string5, hashMap3);
                hashMap2 = hashMap3;
            } else {
                hashMap2 = hashMap;
            }
            map = hashMap2;
            object4 = iterable;
            boolean bl6 = false;
            object2 = object4.iterator();
            while (object2.hasNext()) {
                hashMap = object2.next();
                SearchItemData searchItemData = (SearchItemData)((Object)hashMap);
                boolean bl7 = false;
                object = new GotoResult(searchItemData, searchPopup, gotoPopupSession);
                boolean bl8 = false;
                map.put(searchItemData, object);
            }
        }
        Collection collection = arrayList;
        boolean bl9 = false;
        Object object5 = collection;
        function1.invoke((Object)object5.toArray(new String[0]));
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(GotoPopupSession.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        GotoPopupSession.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdclient/gotoType/GotoPopupSession$Companion;", "", "GotoPopupSession$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

