/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.fileEditors;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.RuntimeFlagsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.impl.EditorId;
import com.intellij.openapi.editor.impl.EditorIdKt;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.KernelAwareTextControlId;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.platform.util.idea.EditorKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendPsiAwareTextEditorProvider;", "Lcom/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "textControlModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "host", "Lcom/jetbrains/rdclient/editors/FrontendTextControlHost;", "editorLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "FrontendPsiAwareTextEditorProvider", "(Lcom/jetbrains/rd/ide/model/TextControlId;Lcom/jetbrains/rd/ide/model/TextControlModel;Lcom/jetbrains/rdclient/editors/FrontendTextControlHost;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "initializeEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "factory", "Lcom/intellij/openapi/editor/impl/EditorFactoryImpl;", "effectiveDocument", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "highlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "asyncLoader", "Lcom/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader;", "x", "", "document", "x", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendPsiAwareTextEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendPsiAwareTextEditorProvider.kt\ncom/jetbrains/rdclient/fileEditors/FrontendPsiAwareTextEditorProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n67#2,4:111\n13#2:116\n1#3:115\n*S KotlinDebug\n*F\n+ 1 FrontendPsiAwareTextEditorProvider.kt\ncom/jetbrains/rdclient/fileEditors/FrontendPsiAwareTextEditorProvider\n*L\n58#1:111,4\n40#1:116\n*E\n"})
public final class FrontendPsiAwareTextEditorProvider
extends PsiAwareTextEditorProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextControlId textControlId;
    @NotNull
    private final TextControlModel textControlModel;
    @NotNull
    private final FrontendTextControlHost host;
    @NotNull
    private final Lifetime editorLifetime;
    @NotNull
    private static final Logger LOG;

    public FrontendPsiAwareTextEditorProvider(@NotNull TextControlId textControlId, @NotNull TextControlModel textControlModel, @NotNull FrontendTextControlHost host, @NotNull Lifetime editorLifetime) {
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter((Object)((Object)textControlModel), (String)"textControlModel");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)editorLifetime, (String)"editorLifetime");
        this.textControlId = textControlId;
        this.textControlModel = textControlModel;
        this.host = host;
        this.editorLifetime = editorLifetime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected EditorImpl initializeEditor(@NotNull EditorFactoryImpl factory, @NotNull Document effectiveDocument, @NotNull Project project, @NotNull VirtualFile file, @NotNull EditorHighlighter highlighter, @NotNull AsyncEditorLoader asyncLoader) {
        EditorImpl editorImpl;
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)effectiveDocument, (String)"effectiveDocument");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)asyncLoader, (String)"asyncLoader");
        Logger logger = factory.editors(effectiveDocument, project).filter(arg_0 -> FrontendPsiAwareTextEditorProvider.x(arg_0 -> FrontendPsiAwareTextEditorProvider.x(this, arg_0), arg_0)).findFirst();
        Intrinsics.checkNotNullExpressionValue(logger, (String)"findFirst(...)");
        Editor editor = (Editor)OptionalsKt.getOrNull(logger);
        if (editor != null) {
            logger = LOG;
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Found existing editor for document with provided textControlId. documentId=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(this.textControlId.getDocumentId()) + ", textControlId=" + UtilKt.toDebugString(this.textControlId));
            }
            return (EditorImpl)editor;
        }
        logger = EditorKt.toEditorKind(this.textControlId.getKind());
        if (!(logger == EditorKind.MAIN_EDITOR)) {
            boolean bl = false;
            String string = "Invalid Editor Kind has been found for " + UtilKt.toDebugString(this.textControlId) + ". Expected MAIN_EDITOR, but found " + logger.name();
            throw new IllegalArgumentException(string.toString());
        }
        this.x(effectiveDocument, this.textControlId);
        try {
            editorImpl = factory.createMainEditor(effectiveDocument, project, file, highlighter, arg_0 -> FrontendPsiAwareTextEditorProvider.x(this, asyncLoader, arg_0));
        }
        finally {
            this.x(effectiveDocument);
        }
        return editorImpl;
    }

    private final void x(Document document, TextControlId textControlId) {
        if (RuntimeFlagsKt.isRhizomeAdEnabled()) {
            ThreadingAssertions.assertEventDispatchThread();
            EditorId editorId = (EditorId)document.getUserData(EditorIdKt.getKERNEL_EDITOR_ID_KEY());
            if (!(editorId == null)) {
                boolean bl = false;
                String string = "editorId is not expected to be in document's user data but found " + editorId;
                throw new IllegalArgumentException(string.toString());
            }
            if (textControlId instanceof KernelAwareTextControlId) {
                EditorId editorId2 = EditorId.Companion.deserializeFromString(((KernelAwareTextControlId)textControlId).getKernelEditorId());
                document.putUserData(EditorIdKt.getKERNEL_EDITOR_ID_KEY(), (Object)editorId2);
            }
        }
    }

    private final void x(Document document) {
        if (RuntimeFlagsKt.isRhizomeAdEnabled()) {
            ThreadingAssertions.assertEventDispatchThread();
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)document), (Key)EditorIdKt.getKERNEL_EDITOR_ID_KEY());
        }
    }

    private static final boolean x(FrontendPsiAwareTextEditorProvider frontendPsiAwareTextEditorProvider, Editor editor) {
        Intrinsics.checkNotNull((Object)editor);
        return Intrinsics.areEqual((Object)DocumentExKt.getTextControlId(editor), (Object)frontendPsiAwareTextEditorProvider.textControlId);
    }

    private static final boolean x(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }

    private static final Unit x(FrontendPsiAwareTextEditorProvider frontendPsiAwareTextEditorProvider, AsyncEditorLoader asyncEditorLoader, EditorImpl editorImpl) {
        Intrinsics.checkNotNullParameter((Object)editorImpl, (String)"it");
        if (frontendPsiAwareTextEditorProvider.textControlId instanceof KernelAwareTextControlId) {
            editorImpl.putUserData(EditorIdKt.getKERNEL_EDITOR_ID_KEY(), (Object)EditorId.Companion.deserializeFromString(((KernelAwareTextControlId)frontendPsiAwareTextEditorProvider.textControlId).getKernelEditorId()));
        }
        editorImpl.putUserData(AsyncEditorLoader.ASYNC_LOADER, (Object)asyncEditorLoader);
        editorImpl.putUserData(FrontendTextControlHost.Companion.getBackendBoundEditor(), (Object)true);
        Boolean bl = (Boolean)frontendPsiAwareTextEditorProvider.textControlModel.isReadonly().getValueOrNull();
        ((EditorEx)editorImpl).setViewer(bl != null ? bl : false);
        FrontendTextControlHost frontendTextControlHost = frontendPsiAwareTextEditorProvider.host;
        Lifetime lifetime = frontendPsiAwareTextEditorProvider.editorLifetime;
        Disposable disposable = editorImpl.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        frontendTextControlHost.bindTextControl$intellij_rd_client(RLifetimeKt.intersect((Lifetime)lifetime, (Lifetime)LifetimeDisposableExKt.createLifetime((Disposable)disposable)), frontendPsiAwareTextEditorProvider.textControlId, frontendPsiAwareTextEditorProvider.textControlModel, (Editor)editorImpl);
        return Unit.INSTANCE;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendPsiAwareTextEditorProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendPsiAwareTextEditorProvider$Companion;", "", "FrontendPsiAwareTextEditorProvider$Companion", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

