/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editors.patchItemHandlers;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.editor.CaretRestoreHelper;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.editor.PatchEngineEditorSynchronizer;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.RdCaret;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdPatchItemVersion;
import com.jetbrains.rd.ide.model.RdSelection;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.editors.deferred.FrontendPostponedSynchronizersRegistryKt;
import com.jetbrains.rdclient.editors.deferred.PostponedEditorSynchronizer;
import com.jetbrains.rdclient.editors.patchItemHandlers.FrontendSelectionChangeHandlerKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemHandler;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/editors/patchItemHandlers/FrontendSelectionChangeHandler;", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchItemHandler;", "Lcom/jetbrains/rd/ide/model/RdPatchItemVersion;", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "FrontendSelectionChangeHandler", "()V", "apply", "", "item", "context", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;", "x", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizer;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "x", "step", "rebaseSession", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "x", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendSelectionChangeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendSelectionChangeHandler.kt\ncom/jetbrains/rdclient/editors/patchItemHandlers/FrontendSelectionChangeHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,119:1\n67#2,4:120\n67#2,4:124\n67#2,4:128\n*S KotlinDebug\n*F\n+ 1 FrontendSelectionChangeHandler.kt\ncom/jetbrains/rdclient/editors/patchItemHandlers/FrontendSelectionChangeHandler\n*L\n23#1:120,4\n68#1:124,4\n75#1:128,4\n*E\n"})
public final class FrontendSelectionChangeHandler
implements FrontendRdPatchItemHandler<RdPatchItemVersion, RdSelectionChangeBase> {
    @Override
    public void apply(@NotNull RdSelectionChangeBase item, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PatchItemOperationType patchItemOperationType = context.getOperation();
        Object object = FrontendSelectionChangeHandlerKt.access$getLogger$p();
        boolean bl = false;
        if (object.isTraceEnabled()) {
            Logger logger = object;
            boolean bl2 = false;
            logger.trace("Applying selection change step: " + item.getEditorId() + " with operation type " + patchItemOperationType);
        }
        object = patchItemOperationType;
        if (Intrinsics.areEqual((Object)object, (Object)PatchItemOperationType.Rollback.INSTANCE)) {
            this.x(item, context, context.getRebaseSession());
        } else if (Intrinsics.areEqual((Object)object, (Object)PatchItemOperationType.Redo.INSTANCE)) {
            this.x(item, context);
        } else {
            EditorSynchronizer editorSynchronizer = this.x(item, context.getSession());
            if (editorSynchronizer == null) {
                FrontendSelectionChangeHandler frontendSelectionChangeHandler = this;
                boolean bl3 = false;
                FrontendSelectionChangeHandlerKt.access$getLogger$p().warn("There is no synchronizer for " + item.getEditorId());
                return;
            }
            EditorSynchronizer editorSynchronizer2 = editorSynchronizer;
            if (patchItemOperationType instanceof PatchItemOperationType.SoftRollback) {
                return;
            }
            if (patchItemOperationType instanceof PatchItemOperationType.SoftPerform || patchItemOperationType instanceof PatchItemOperationType.SoftRedo) {
                EditorSynchronizer editorSynchronizer3 = editorSynchronizer2;
                if (editorSynchronizer3 instanceof PatchEngineEditorSynchronizer) {
                    ((PatchEngineEditorSynchronizer)editorSynchronizer2).softUpdate(item, patchItemOperationType instanceof PatchItemOperationType.SoftRedo);
                } else if (editorSynchronizer3 instanceof PostponedEditorSynchronizer) {
                    ((PostponedEditorSynchronizer)editorSynchronizer2).softUpdate(item, patchItemOperationType instanceof PatchItemOperationType.SoftRedo);
                }
            } else {
                editorSynchronizer2.receiveSelection(item);
            }
        }
    }

    private final EditorSynchronizer x(RdSelectionChangeBase rdSelectionChangeBase, ClientAppSession clientAppSession) {
        PostponedEditorSynchronizer postponedEditorSynchronizer = FrontendPostponedSynchronizersRegistryKt.getPostponedSynchronizer(rdSelectionChangeBase.getEditorId());
        if (postponedEditorSynchronizer != null) {
            return postponedEditorSynchronizer;
        }
        Editor editor = FrontendTextControlHostKt.toEditorOrNull(rdSelectionChangeBase.getEditorId());
        if (editor == null) {
            FrontendSelectionChangeHandler frontendSelectionChangeHandler = this;
            boolean bl = false;
            FrontendSelectionChangeHandlerKt.access$getLogger$p().warn("There is no editor for " + rdSelectionChangeBase.getEditorId());
            return null;
        }
        Editor editor2 = editor;
        return DocumentExKt.getEditorSynchronizer(editor2, clientAppSession);
    }

    private final void x(RdSelectionChangeBase rdSelectionChangeBase, FrontendRdPatchHandlerContext frontendRdPatchHandlerContext, FrontendRebaseSession frontendRebaseSession) {
        Editor editor = FrontendTextControlHostKt.toEditorOrNull(rdSelectionChangeBase.getEditorId());
        if (editor == null) {
            Logger logger = FrontendSelectionChangeHandlerKt.access$getLogger$p();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Do not rollback caret state change: " + rdSelectionChangeBase.getEditorId() + " with operation type " + frontendRdPatchHandlerContext.getOperation() + " because editor does not exist");
            }
            return;
        }
        CaretRestoreHelper caretRestoreHelper = CaretRestoreHelper.Companion.getInstance();
        if (caretRestoreHelper.getLastCaretBeforeRollbackLeansForward() == null) {
            caretRestoreHelper.setLastCaretBeforeRollbackLeansForward(editor.getCaretModel().getPrimaryCaret().getLogicalPosition().leansForward);
        }
        Logger logger = FrontendSelectionChangeHandlerKt.access$getLogger$p();
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger3 = logger;
            boolean bl3 = false;
            logger3.trace("Rollback caret state change: " + rdSelectionChangeBase.getEditorId() + " with operation type " + frontendRdPatchHandlerContext.getOperation());
        }
        EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(editor, frontendRdPatchHandlerContext.getSession());
        if (editorSynchronizer == null) {
            throw new IllegalStateException("editor synchronizer is null".toString());
        }
        editorSynchronizer.receiveSelection(UtilKt.reverse(rdSelectionChangeBase));
        frontendRebaseSession.record(rdSelectionChangeBase);
    }

    private final void x(RdSelectionChangeBase rdSelectionChangeBase, FrontendRdPatchHandlerContext frontendRdPatchHandlerContext) {
        Editor editor = FrontendTextControlHostKt.toEditorOrNull(rdSelectionChangeBase.getEditorId());
        if (editor == null) {
            FrontendSelectionChangeHandler frontendSelectionChangeHandler = this;
            boolean bl = false;
            FrontendSelectionChangeHandlerKt.access$getLogger$p().warn("There is no editor for " + rdSelectionChangeBase.getEditorId());
            return;
        }
        Editor editor2 = editor;
        if (rdSelectionChangeBase instanceof RdCaretStateSnapshot && ((RdCaretStateSnapshot)rdSelectionChangeBase).getDocumentChangeWrapping()) {
            FrontendSelectionChangeHandlerKt.access$getLogger$p().trace("Do not replay item:" + IPrintableKt.printToString((Object)rdSelectionChangeBase) + " because it will be recorded for according document change by itself");
            return;
        }
        FrontendRebaseSession frontendRebaseSession = frontendRdPatchHandlerContext.getRebaseSession();
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        DocumentSynchronizer documentSynchronizer = DocumentExKt.getDocumentSynchronizer(document, frontendRdPatchHandlerContext.getSession());
        Intrinsics.checkNotNull((Object)documentSynchronizer);
        AbstractDocumentVersion abstractDocumentVersion = documentSynchronizer.getVersion();
        Intrinsics.checkNotNull((Object)abstractDocumentVersion, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentVersion");
        RdDocumentVersion rdDocumentVersion = (RdDocumentVersion)abstractDocumentVersion;
        RdCaretState rdCaretState = UtilKt.getActualState(frontendRebaseSession.replay(rdSelectionChangeBase, rdDocumentVersion));
        for (RdCaret rdCaret : rdCaretState.getCarets()) {
            RdSelection rdSelection;
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            Caret caret = UtilKt.getCaretById(caretModel, rdCaret.getId());
            if (caret == null) {
                LogicalPosition logicalPosition;
                boolean bl = Intrinsics.areEqual((Object)rdCaret.getId(), (Object)rdCaretState.getPrimaryCaretId());
                Intrinsics.checkNotNullExpressionValue((Object)editor2.offsetToLogicalPosition(rdCaret.getOffset().getOffset()), (String)"offsetToLogicalPosition(...)");
                Caret caret2 = caret = editor2.getCaretModel().addCaret(logicalPosition, bl);
                if (caret2 != null) {
                    UtilKt.setId(caret2, rdCaret.getId());
                }
            }
            if (rdCaret.getOffset().getOffset() != -1) {
                Caret caret3 = caret;
                if (caret3 != null) {
                    caret3.moveToOffset(rdCaret.getOffset().getOffset());
                }
            }
            if ((rdSelection = rdCaret.getSelection()).getStart().getOffset() == -1 || rdSelection.getEnd().getOffset() == -1 || rdSelection.getStart().getOffset() >= rdSelection.getEnd().getOffset()) continue;
            Caret caret4 = caret;
            if (caret4 == null) continue;
            caret4.setSelection(rdSelection.getStart().getOffset(), rdSelection.getEnd().getOffset());
        }
    }
}

