/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editors.patchItemHandlers;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.model.RdPatchItemVersion;
import com.jetbrains.rd.ide.model.RdScrollingRequest;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.editors.deferred.FrontendPostponedSynchronizersRegistry;
import com.jetbrains.rdclient.editors.deferred.PostponedEditorSynchronizer;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemPerformOnlyHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdclient/editors/patchItemHandlers/FrontendScrollingRequestHandler;", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchItemPerformOnlyHandler;", "Lcom/jetbrains/rd/ide/model/RdPatchItemVersion;", "Lcom/jetbrains/rd/ide/model/RdScrollingRequest;", "FrontendScrollingRequestHandler", "()V", "perform", "", "item", "context", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;", "x", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizer;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendScrollingRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendScrollingRequestHandler.kt\ncom/jetbrains/rdclient/editors/patchItemHandlers/FrontendScrollingRequestHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,37:1\n67#2,4:38\n13#2:44\n30#3,2:42\n*S KotlinDebug\n*F\n+ 1 FrontendScrollingRequestHandler.kt\ncom/jetbrains/rdclient/editors/patchItemHandlers/FrontendScrollingRequestHandler\n*L\n30#1:38,4\n20#1:44\n35#1:42,2\n*E\n"})
public final class FrontendScrollingRequestHandler
implements FrontendRdPatchItemPerformOnlyHandler<RdPatchItemVersion, RdScrollingRequest> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @Override
    public void perform(@NotNull RdScrollingRequest item, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        EditorSynchronizer editorSynchronizer = this.x(item.getEditorId(), context.getSession());
        if (editorSynchronizer == null) {
            logger.info("Scrolling request can not be applied for editor id " + item.getEditorId() + " with operation type " + context.getOperation() + ": synchronizer not found");
            return;
        }
        Logger logger = FrontendScrollingRequestHandler.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Applying scrolling request step: " + item.getEditorId() + " with operation type " + context.getOperation());
        }
        editorSynchronizer.receiveScrollingRequest(item.getInfo());
    }

    private final EditorSynchronizer x(TextControlId textControlId, ClientAppSession clientAppSession) {
        EditorSynchronizer editorSynchronizer;
        ComponentManager componentManager = (ComponentManager)ApplicationKt.getApplication();
        boolean bl = false;
        Class<FrontendPostponedSynchronizersRegistry> clazz = FrontendPostponedSynchronizersRegistry.class;
        Object object = componentManager.getService(clazz);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
        }
        PostponedEditorSynchronizer postponedEditorSynchronizer = ((FrontendPostponedSynchronizersRegistry)object).get$intellij_rd_client(textControlId);
        if (postponedEditorSynchronizer != null) {
            editorSynchronizer = postponedEditorSynchronizer;
        } else {
            Editor editor = FrontendTextControlHostKt.toEditorOrNull(textControlId);
            editorSynchronizer = editor != null ? DocumentExKt.getEditorSynchronizer(editor, clientAppSession) : null;
        }
        return editorSynchronizer;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendScrollingRequestHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendScrollingRequestHandler.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/editors/patchItemHandlers/FrontendScrollingRequestHandler$Companion;", "", "FrontendScrollingRequestHandler$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

