/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.document;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ThreeState;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizer;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdPatchDocumentVersion;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.RdResetDocumentChange;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.document.FrontendPatchDocumentItemHandlerKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemHandler;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rdclient/document/FrontendPatchDocumentItemHandler;", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchItemHandler;", "Lcom/jetbrains/rd/ide/model/RdPatchDocumentVersion;", "Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;", "FrontendPatchDocumentItemHandler", "()V", "validate", "", "version", "context", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;", "update", "", "apply", "item", "x", "Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "id", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "x", "Lcom/intellij/util/ThreeState;", "synchronizer", "expectedId", "", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendPatchDocumentItemHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendPatchDocumentItemHandler.kt\ncom/jetbrains/rdclient/document/FrontendPatchDocumentItemHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,141:1\n67#2,4:142\n67#2,4:146\n67#2,4:150\n67#2,4:154\n67#2,4:158\n*S KotlinDebug\n*F\n+ 1 FrontendPatchDocumentItemHandler.kt\ncom/jetbrains/rdclient/document/FrontendPatchDocumentItemHandler\n*L\n38#1:142,4\n55#1:146,4\n59#1:150,4\n119#1:154,4\n125#1:158,4\n*E\n"})
public final class FrontendPatchDocumentItemHandler
implements FrontendRdPatchItemHandler<RdPatchDocumentVersion, RdDocumentChangeBase> {
    @Override
    public boolean validate(@NotNull RdPatchDocumentVersion version, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RdPatchItemId rdPatchItemId = version.getId();
        Intrinsics.checkNotNull((Object)rdPatchItemId, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentId");
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this.x((RdDocumentId)rdPatchItemId, context.getSession());
        if (patchEngineDocumentSynchronizer == null) {
            return true;
        }
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer2 = patchEngineDocumentSynchronizer;
        if (this.x(patchEngineDocumentSynchronizer2, version.getUniqueId()) == ThreeState.NO) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)patchEngineDocumentSynchronizer2.getVersion(), (Object)version.getVersion())) {
            FrontendPatchDocumentItemHandlerKt.access$getLogger$p().error("Not matched versions for " + version.getId() + " documentId, actual: " + patchEngineDocumentSynchronizer2.getVersion() + ", expected: " + version.getVersion());
            return false;
        }
        return true;
    }

    @Override
    public void update(@NotNull RdPatchDocumentVersion version, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
        boolean bl = false;
        if (object.isTraceEnabled()) {
            Logger logger = object;
            boolean bl2 = false;
            logger.trace("Update document version: " + version.getId() + " to " + version.getVersion() + " with operation type " + context.getOperation());
        }
        RdPatchItemId rdPatchItemId = version.getId();
        Intrinsics.checkNotNull((Object)rdPatchItemId, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentId");
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this.x((RdDocumentId)rdPatchItemId, context.getSession());
        if (patchEngineDocumentSynchronizer == null) {
            return;
        }
        object = patchEngineDocumentSynchronizer;
        if (this.x((PatchEngineDocumentSynchronizer)object, version.getUniqueId()) == ThreeState.NO) {
            return;
        }
        PatchItemOperationType patchItemOperationType = context.getOperation();
        if (patchItemOperationType instanceof PatchItemOperationType.SoftRollback || patchItemOperationType instanceof PatchItemOperationType.Rollback) {
            ((PatchEngineDocumentSynchronizer)object).resetVersion(version.getVersion());
        } else if (patchItemOperationType instanceof PatchItemOperationType.Perform || patchItemOperationType instanceof PatchItemOperationType.SoftPerform) {
            ((PatchEngineDocumentSynchronizer)object).updateLastKnownVersion(version.getVersion());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void apply(@NotNull RdDocumentChangeBase item, @NotNull FrontendRdPatchHandlerContext context) {
        RdDocumentChangeBase rdDocumentChangeBase;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PatchItemOperationType patchItemOperationType = context.getOperation();
        Object object = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
        boolean bl2 = false;
        if (object.isTraceEnabled()) {
            Logger logger = object;
            bl = false;
            logger.trace("Apply document step: " + IPrintableKt.printToString((Object)item) + " with operation type " + patchItemOperationType);
        }
        object = this.x(item.getDocumentId(), context.getSession());
        if (object == null) {
            Logger logger = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
            bl = false;
            if (!logger.isTraceEnabled()) return;
            Logger logger2 = logger;
            boolean bl3 = false;
            logger2.trace("Document synchronizer not found for " + item.getDocumentId() + ": can not apply change: " + IPrintableKt.printToString((Object)item));
            return;
        }
        if (this.x((PatchEngineDocumentSynchronizer)object, item.getUniqueId()) == ThreeState.NO) {
            return;
        }
        if (patchItemOperationType instanceof PatchItemOperationType.SoftRollback) {
            return;
        }
        if (patchItemOperationType instanceof PatchItemOperationType.SoftRedo) {
            ((PatchEngineDocumentSynchronizer)object).updateDocumentLog(item, true);
            return;
        }
        if (patchItemOperationType instanceof PatchItemOperationType.SoftPerform) {
            ((PatchEngineDocumentSynchronizer)object).updateDocumentLog(item, false);
            ((PatchEngineDocumentSynchronizer)object).updateLastKnownVersion(item.getNewVersion());
            return;
        }
        PatchItemOperationType patchItemOperationType2 = patchItemOperationType;
        if (Intrinsics.areEqual((Object)patchItemOperationType2, (Object)PatchItemOperationType.Rollback.INSTANCE)) {
            var7_14 = item;
            if (var7_14 instanceof RdResetDocumentChange) {
                rdDocumentChangeBase = new RdResetDocumentChange(((RdResetDocumentChange)item).getText(), item.getDocumentId(), item.getOldVersion(), item.getNewVersion(), item.getUniqueId());
            } else {
                if (!(var7_14 instanceof RdDocumentChange)) throw new IllegalStateException((item.getClass() + " is not supported for revert operation").toString());
                rdDocumentChangeBase = UtilKt.reverse((RdDocumentChange)item);
            }
        } else if (Intrinsics.areEqual((Object)patchItemOperationType2, (Object)PatchItemOperationType.Redo.INSTANCE)) {
            var7_14 = item;
            if (var7_14 instanceof RdResetDocumentChange) {
                rdDocumentChangeBase = item;
            } else {
                boolean bl4;
                if (!(var7_14 instanceof RdDocumentChange)) throw new IllegalStateException((item.getClass() + " is not supported for redo operation").toString());
                RdDocumentChange rdDocumentChange = context.getRebaseSession().replay((RdDocumentChange)item, ((PatchEngineDocumentSynchronizer)object).getVersion());
                if (rdDocumentChange.getOffset() == -1 || rdDocumentChange.getMoveOffset() == -1 || rdDocumentChange.getOldDocumentLength() == -1) {
                    FrontendPatchDocumentItemHandlerKt.access$getLogger$p().warn("Can't redo change for " + DocumentExKt.toDebugString(item.getDocumentId()) + ": " + IPrintableKt.printToString((Object)item));
                    return;
                }
                boolean bl5 = bl4 = ((PatchEngineDocumentSynchronizer)object).getDocument().getTextLength() == rdDocumentChange.getOldDocumentLength();
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl6 = false;
                    String string = "Document length " + ((PatchEngineDocumentSynchronizer)object).getDocument().getTextLength() + " does not match with expected change length " + rdDocumentChange.getOldDocumentLength();
                    throw new AssertionError((Object)string);
                }
                rdDocumentChangeBase = rdDocumentChange;
            }
        } else {
            rdDocumentChangeBase = item;
        }
        RdDocumentChangeBase rdDocumentChangeBase2 = rdDocumentChangeBase;
        ((PatchEngineDocumentSynchronizer)object).receiveDocumentChange(rdDocumentChangeBase2, patchItemOperationType instanceof PatchItemOperationType.Redo);
        if (patchItemOperationType instanceof PatchItemOperationType.Perform) {
            ((PatchEngineDocumentSynchronizer)object).updateLastKnownVersion(item.getNewVersion());
        }
        if (Intrinsics.areEqual((Object)patchItemOperationType, (Object)PatchItemOperationType.Rollback.INSTANCE)) {
            context.getRebaseSession().record(item);
        }
        patchItemOperationType2 = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
        boolean bl7 = false;
        if (!patchItemOperationType2.isTraceEnabled()) return;
        PatchItemOperationType patchItemOperationType3 = patchItemOperationType2;
        boolean bl8 = false;
        patchItemOperationType3.trace("Change " + IPrintableKt.printToString((Object)rdDocumentChangeBase2) + " from operation type " + patchItemOperationType + " was applied. New document length: " + ((PatchEngineDocumentSynchronizer)object).getDocument().getTextLength());
    }

    private final PatchEngineDocumentSynchronizer x(RdDocumentId rdDocumentId, ClientAppSession clientAppSession) {
        FrontendDocumentHost frontendDocumentHost = FrontendDocumentHost.Companion.getInstance(clientAppSession);
        if (frontendDocumentHost.isRecentlyClosed(rdDocumentId)) {
            Logger logger = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Do not promote document version for a recently closed document (it is an expected race case); document: " + rdDocumentId);
            }
            return null;
        }
        DocumentSynchronizer documentSynchronizer = frontendDocumentHost.getSynchronizer(rdDocumentId);
        return documentSynchronizer instanceof PatchEngineDocumentSynchronizer ? (PatchEngineDocumentSynchronizer)documentSynchronizer : null;
    }

    private final ThreeState x(PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer, String string) {
        if (!Registry.Companion.is("rd.client.patch.engine.enable.unique.document.id")) {
            return ThreeState.UNSURE;
        }
        String string2 = patchEngineDocumentSynchronizer.getUniqueId();
        if (string2 == null) {
            FrontendPatchDocumentItemHandler frontendPatchDocumentItemHandler = this;
            boolean bl = false;
            FrontendPatchDocumentItemHandlerKt.access$getLogger$p().warn("Document " + patchEngineDocumentSynchronizer.getDocumentId() + " has no unique id");
            return ThreeState.UNSURE;
        }
        String string3 = string2;
        return Intrinsics.areEqual((Object)string3, (Object)string) ? ThreeState.YES : ThreeState.NO;
    }
}

