/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.document;

import com.intellij.ide.rpc.FrontendDocumentId;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.DocumentUniqueIdSessionRegistry;
import com.jetbrains.rd.ide.document.ProtocolDocumentHost;
import com.jetbrains.rd.ide.model.DocumentExtension;
import com.jetbrains.rd.ide.model.DocumentsOperationModel;
import com.jetbrains.rd.ide.model.DocumentsOperationModel_GeneratedKt;
import com.jetbrains.rd.ide.model.FrontendDocumentIdDocumentExtension;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.ViewableMap;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentEntry;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.document.FrontendDocumentExtensionsProvider;
import com.jetbrains.rdclient.document.FrontendDocumentHostKt;
import com.jetbrains.rdclient.document.FrontendDocumentHostListener;
import com.jetbrains.rdclient.document.FrontendDocumentIdRegistryService;
import com.jetbrains.rdclient.services.AppLevelIdeBackend;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0002?@B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bJ\u0006\u0010\u001e\u001a\u00020\u0018J*\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\u0018\u0010&\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u000bH\u0004J\"\u0010'\u001a\u0004\u0018\u00010\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0014J\u001a\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0002J0\u0010,\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J0\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\u0004H$J\u0010\u00102\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\fH\u0016J\u001e\u00103\u001a\u00020!2\u0006\u00104\u001a\u00020\f2\f\u00105\u001a\b\u0012\u0004\u0012\u00020706H$J\u0010\u0010:\u001a\u00020;2\u0006\u00104\u001a\u00020\fH\u0004J\u0010\u0010<\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\fH\u0016J\u0010\u0010=\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u000bH\u0016J\u0012\u0010>\u001a\u0004\u0018\u00010/2\u0006\u0010\u001d\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0010\u00101\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/jetbrains/rdclient/document/FrontendDocumentHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "Lcom/jetbrains/rd/ide/document/ProtocolDocumentHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "FrontendDocumentHost", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "openedDocuments", "Lcom/jetbrains/rd/util/reactive/ViewableMap;", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "Lcom/intellij/openapi/editor/Document;", "getOpenedDocuments$annotations", "()V", "getOpenedDocuments", "()Lcom/jetbrains/rd/util/reactive/ViewableMap;", "recentlyClosedDocuments", "", "documentsOperationModel", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "x", "()Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "ensureProtocolSubscriptionsReady", "", "x", "id", "isRecentlyClosed", "", "documentId", "beforeRecoveryStarts", "getOrCreateIdeaDocument", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "documentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "protocol", "Lcom/jetbrains/rd/framework/IProtocol;", "createDocumentWithoutFile", "createDocumentFromVirtualFile", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "x", "Lcom/jetbrains/rdclient/document/DocumentEntry;", "viewDocumentModel", "ideaDocument", "createDocumentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "lifetime", "currentlyBindingDocument", "bindDocument", "createModel", "document", "extensions", "", "Lcom/jetbrains/rd/ide/model/DocumentExtension;", "uniqueIdCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "getAndSetUniqueId", "", "createId", "unregisterDocument", "getSynchronizer", "Companion", "MyProtocolListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendDocumentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 DocumentEx.kt\ncom/jetbrains/rd/ide/document/DocumentExKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n*L\n1#1,285:1\n67#2,4:286\n67#2,4:307\n67#2,4:312\n67#2,4:322\n13#2:328\n1#3:290\n22#4:291\n23#4,4:303\n808#5,11:292\n1374#5:316\n1460#5,5:317\n66#6:311\n67#6,2:326\n*S KotlinDebug\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost\n*L\n115#1:286,4\n192#1:307,4\n234#1:312,4\n239#1:322,4\n41#1:328\n170#1:291\n170#1:303,4\n170#1:292,11\n235#1:316\n235#1:317,5\n233#1:311\n233#1:326,2\n*E\n"})
public abstract class FrontendDocumentHost
extends LifetimedService
implements ProtocolDocumentHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final ViewableMap<RdDocumentId, Document> openedDocuments;
    @NotNull
    private final List<RdDocumentId> recentlyClosedDocuments;
    @Nullable
    private Document currentlyBindingDocument;
    @NotNull
    private final AtomicLong uniqueIdCounter;
    @NotNull
    private static final Logger LOG;
    @ApiStatus.Internal
    @NotNull
    private static final Key<Boolean> shouldNotWaitInitialChange;

    public FrontendDocumentHost(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.openedDocuments = new ViewableMap(null, 1, null);
        this.recentlyClosedDocuments = new ArrayList();
        this.uniqueIdCounter = new AtomicLong(0L);
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    @NotNull
    protected final ViewableMap<RdDocumentId, Document> getOpenedDocuments() {
        return this.openedDocuments;
    }

    protected static /* synthetic */ void getOpenedDocuments$annotations() {
    }

    private final DocumentsOperationModel x() {
        return DocumentsOperationModel_GeneratedKt.getDocumentsOperationModel(FrontendSessionsUtilKt.getProtocol(this.session));
    }

    public final void ensureProtocolSubscriptionsReady() {
        this.x();
    }

    private final void x(RdDocumentId rdDocumentId) {
        this.x().getClientOpenedWithError().fire((Object)rdDocumentId);
        this.recentlyClosedDocuments.add(rdDocumentId);
    }

    public final boolean isRecentlyClosed(@NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return !((Map)this.openedDocuments).containsKey(documentId) && this.recentlyClosedDocuments.contains(documentId);
    }

    public final void beforeRecoveryStarts() {
        Logger logger = LOG;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Clear recentlyClosedDocuments before recovery starts.");
        }
        this.recentlyClosedDocuments.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Document getOrCreateIdeaDocument(@NotNull RdDocumentId documentId, @NotNull RdDocumentModel documentModel, @NotNull Lifetime documentLifetime, @NotNull IProtocol protocol) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)((Object)documentModel), (String)"documentModel");
        Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"IJPL-171425");
        Throwable throwable = null;
        try {
            AccessToken accessToken = (AccessToken)autoCloseable;
            boolean bl = false;
            DocumentEntry documentEntry = this.x(documentId, documentModel);
            if (documentEntry != null) {
                if (documentEntry.getOnBindingDispose() != null) {
                    RLifetimeKt.plusAssign((Lifetime)documentLifetime, () -> FrontendDocumentHost.x(documentEntry));
                }
                Document document = documentEntry.getDocument();
                return document;
            }
            Document document = this.currentlyBindingDocument;
            if (document != null) {
                Document document2 = document;
                boolean bl2 = false;
                Document document3 = document2;
                return document3;
            }
            Document document4 = (Document)this.openedDocuments.get((Object)documentId);
            if (document4 != null) {
                Document document5 = document4;
                boolean bl3 = false;
                Document document6 = document5;
                return document6;
            }
            VirtualFile virtualFile = AppLevelIdeBackend.Companion.getInstance().tryCreateVirtualFile(documentId);
            Document document7 = virtualFile != null ? this.createDocumentFromVirtualFile(documentModel, documentId, virtualFile) : this.createDocumentWithoutFile(documentModel, documentId);
            return document7;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    protected final Document createDocumentWithoutFile(@NotNull RdDocumentModel documentModel, @NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)((Object)documentModel), (String)"documentModel");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        EditorFactory editorFactory = EditorFactory.getInstance();
        boolean bl = documentModel.isWriteThreadOnly();
        EditorFactoryImpl editorFactoryImpl = editorFactory instanceof EditorFactoryImpl ? (EditorFactoryImpl)editorFactory : null;
        if (editorFactoryImpl == null || (editorFactoryImpl = editorFactoryImpl.createDocument(!bl)) == null) {
            Document document;
            Document document2 = editorFactory.createDocument((CharSequence)"");
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"createDocument(...)");
            Document document3 = document = document2;
            boolean bl2 = false;
            LOG.warn("It is not possible to create a document with defined `forUseInNonAWTThread` field, because current EditorFactory is not an instance of EditorFactoryImpl class:editorFactory.class=" + editorFactory.getClass() + " documentId=" + documentId + " forUseInNonAWTThread=" + !bl);
            editorFactoryImpl = document;
        }
        return editorFactoryImpl;
    }

    @Nullable
    protected Document createDocumentFromVirtualFile(@NotNull RdDocumentModel documentModel, @NotNull RdDocumentId documentId, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)((Object)documentModel), (String)"documentModel");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (Registry.Companion.is("rdclient.test.document.create.fail", false)) {
            throw new RuntimeException("Failed to create document");
        }
        return FileDocumentManager.getInstance().getDocument(virtualFile);
    }

    private final DocumentEntry x(RdDocumentId rdDocumentId, RdDocumentModel rdDocumentModel) {
        FrontendDocumentId frontendDocumentId;
        Object object;
        RdDocumentModel rdDocumentModel2 = rdDocumentModel;
        boolean bl = false;
        Object object2 = rdDocumentModel2.getExtensions();
        boolean bl2 = false;
        Iterable iterable = object2;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        for (Object t : iterable) {
            if (!(t instanceof FrontendDocumentIdDocumentExtension)) continue;
            collection.add(t);
        }
        List list2 = (List)collection;
        if (((Collection)list2).size() > 1) {
            Logger.getInstance((String)"com.jetbrains.rd.ide.document").error("Document has duplicates of an extension of type " + FrontendDocumentIdDocumentExtension.class);
        }
        if ((object = (FrontendDocumentIdDocumentExtension)((DocumentExtension)((Object)CollectionsKt.firstOrNull((List)list2)))) != null && (object = object.getFrontendDocumentId()) != null) {
            object2 = object;
            bl2 = false;
            v1 = FrontendDocumentId.Companion.fromString((String)object2);
        } else {
            v1 = frontendDocumentId = null;
        }
        if (frontendDocumentId == null) {
            return null;
        }
        DocumentEntry documentEntry = FrontendDocumentIdRegistryService.Companion.getInstance().getAndUnregisterDocument(frontendDocumentId);
        if (documentEntry == null) {
            LOG.warn("No document found for document which is already bind with backend: " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId) + " with frontend id: " + frontendDocumentId + ".");
            return null;
        }
        return documentEntry;
    }

    protected void viewDocumentModel(@NotNull Lifetime documentLifetime, @NotNull RdDocumentId documentId, @NotNull Document ideaDocument, @NotNull RdDocumentModel documentModel, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)ideaDocument, (String)"ideaDocument");
        Intrinsics.checkNotNullParameter((Object)((Object)documentModel), (String)"documentModel");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ThreadingAssertions.assertEventDispatchThread();
        Object object = LOG;
        boolean bl = false;
        if (object.isTraceEnabled()) {
            Logger logger = object;
            boolean bl2 = false;
            logger.trace("binding new document " + documentId + " with frontend document " + ideaDocument);
        }
        if (!(ideaDocument instanceof DocumentImpl)) {
            bl = false;
            String string = "ideaDocument is not a DocumentImpl";
            throw new IllegalArgumentException(string.toString());
        }
        object = DocumentUniqueIdSessionRegistry.Companion.getInstance(session);
        LOG.assertTrue(!((DocumentUniqueIdSessionRegistry)object).hasUniqueId(ideaDocument));
        ((DocumentUniqueIdSessionRegistry)object).registerUniqueId(ideaDocument, documentModel.getUniqueId());
        LOG.info("Subscribing for document changes.");
        RLifetimeKt.assertAlive((Lifetime)documentLifetime);
        DocumentSynchronizer documentSynchronizer = this.createDocumentSynchronizer(documentLifetime, documentId, ideaDocument, documentModel, session);
        DocumentExKt.putModel(ideaDocument, session, documentId, documentSynchronizer);
        FrontendDocumentHostKt.access$getBindingCounter(ideaDocument).incrementAndGet();
        ((Map)this.openedDocuments).put(documentId, ideaDocument);
        RLifetimeKt.plusAssign((Lifetime)documentLifetime, () -> FrontendDocumentHost.x(documentId, this, ideaDocument, session));
        FrontendDocumentHostListener frontendDocumentHostListener = (FrontendDocumentHostListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendDocumentHostListener.Companion.getTOPIC());
        frontendDocumentHostListener.documentBound(documentLifetime, session, documentId, documentModel, ideaDocument);
    }

    @NotNull
    protected abstract DocumentSynchronizer createDocumentSynchronizer(@NotNull Lifetime var1, @NotNull RdDocumentId var2, @NotNull Document var3, @NotNull RdDocumentModel var4, @NotNull ClientAppSession var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public RdDocumentId bindDocument(@NotNull Document ideaDocument) {
        Intrinsics.checkNotNullParameter((Object)ideaDocument, (String)"ideaDocument");
        try {
            this.currentlyBindingDocument = ideaDocument;
            RdDocumentId rdDocumentId = this.createId(ideaDocument);
            IMutableViewableMap<RdDocumentId, RdDocumentModel> iMutableViewableMap = this.x().getDocuments();
            Object object = (Map)iMutableViewableMap;
            RdDocumentId rdDocumentId2 = rdDocumentId;
            boolean bl = false;
            Object object2 = object.get(rdDocumentId2);
            if (object2 == null) {
                boolean bl2;
                Logger logger;
                RdDocumentId rdDocumentId3 = rdDocumentId2;
                boolean bl3 = false;
                Object object3 = FrontendDocumentHost.LOG;
                boolean bl4 = false;
                if (object3.isTraceEnabled()) {
                    logger = object3;
                    bl2 = false;
                    logger.trace("Creating model document. ee.Path: " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId));
                }
                Object object4 = FrontendDocumentExtensionsProvider.Companion.getEP_NAME().getExtensionList();
                bl2 = false;
                Iterable iterable = object4;
                Collection collection = new ArrayList();
                boolean bl5 = false;
                for (Object t : iterable) {
                    Object object5 = (FrontendDocumentExtensionsProvider)t;
                    boolean bl6 = false;
                    object5 = object5.getExtensions(ideaDocument);
                    CollectionsKt.addAll((Collection)collection, (Iterable)object5);
                }
                object3 = (List)collection;
                object4 = this.createModel(ideaDocument, (List<? extends DocumentExtension>)object3);
                Logger logger2 = FrontendDocumentHost.LOG;
                boolean bl7 = false;
                if (logger2.isTraceEnabled()) {
                    logger = logger2;
                    boolean bl8 = false;
                    logger.trace("Created model: " + (RdDocumentModel)((Object)object4) + ", creation side:" + ((RdDocumentModel)((Object)object4)).getCreationSide());
                }
                Object object6 = object4;
                boolean bl9 = false;
                object.put(rdDocumentId2, object6);
                object2 = object6;
            }
            LOG.info("finished registering document " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId));
            object = rdDocumentId;
            return object;
        }
        finally {
            this.currentlyBindingDocument = null;
        }
    }

    @NotNull
    protected abstract RdDocumentModel createModel(@NotNull Document var1, @NotNull List<? extends DocumentExtension> var2);

    @NotNull
    protected final String getAndSetUniqueId(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return Registry.Companion.is("rd.client.patch.engine.enable.unique.document.id") ? "frontend-document-" + this.uniqueIdCounter.getAndIncrement() : "";
    }

    @Override
    @NotNull
    public RdDocumentId createId(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        RdDocumentId rdDocumentId = DocumentExKt.getDocumentId(document, this.session);
        if (rdDocumentId != null) {
            return rdDocumentId;
        }
        return ProtocolDocumentHost.super.createId(document);
    }

    public void unregisterDocument(@NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        ThreadingAssertions.assertEventDispatchThread();
        DocumentSynchronizer documentSynchronizer = this.getSynchronizer(documentId);
        Document document = documentSynchronizer != null ? documentSynchronizer.getDocument() : null;
        LOG.assertTrue(document != null);
        Document document2 = document;
        if (document2 != null) {
            Document document3 = document2;
            boolean bl = false;
            DocumentUniqueIdSessionRegistry.Companion.getInstance(this.session).unregisterUniqueId(document3);
        }
        this.x().getDocuments().remove((Object)documentId);
    }

    @Nullable
    public DocumentSynchronizer getSynchronizer(@NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Document document = (Document)this.openedDocuments.get((Object)documentId);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        return DocumentExKt.getDocumentSynchronizer(document2, this.session);
    }

    private static final Unit x(DocumentEntry documentEntry) {
        documentEntry.getOnBindingDispose().invoke();
        return Unit.INSTANCE;
    }

    private static final Unit x(RdDocumentId rdDocumentId, FrontendDocumentHost frontendDocumentHost, Document document, ClientAppSession clientAppSession) {
        LOG.info("Unbinding document " + rdDocumentId);
        frontendDocumentHost.openedDocuments.remove((Object)rdDocumentId);
        FrontendDocumentHostKt.access$getBindingCounter(document).decrementAndGet();
        DocumentExKt.removeModel(document, clientAppSession);
        return Unit.INSTANCE;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendDocumentHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"FrontendDocumentHost.shouldNotWaitInitialChange");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        shouldNotWaitInitialChange = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rdclient/document/FrontendDocumentHost$Companion;", "", "FrontendDocumentHost$Companion", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdclient/document/FrontendDocumentHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "project", "Lcom/intellij/openapi/project/Project;", "shouldNotWaitInitialChange", "Lcom/intellij/openapi/util/Key;", "", "getShouldNotWaitInitialChange", "()Lcom/intellij/openapi/util/Key;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendDocumentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,285:1\n30#2,2:286\n*S KotlinDebug\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost$Companion\n*L\n43#1:286,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final FrontendDocumentHost getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager componentManager = (ComponentManager)session;
            boolean bl = false;
            Class<FrontendDocumentHost> clazz = FrontendDocumentHost.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (FrontendDocumentHost)object;
        }

        @Deprecated(message="Use an overload with client app session")
        @ApiStatus.ScheduledForRemoval
        @ApiStatus.Internal
        @NotNull
        public final FrontendDocumentHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project).getAppSession());
        }

        @NotNull
        public final Key<Boolean> getShouldNotWaitInitialChange() {
            return shouldNotWaitInitialChange;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdclient/document/FrontendDocumentHost$MyProtocolListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "FrontendDocumentHost$MyProtocolListener", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendDocumentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost$MyProtocolListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,285:1\n67#2,4:286\n67#2,4:290\n67#2,4:294\n67#2,4:298\n*S KotlinDebug\n*F\n+ 1 FrontendDocumentHost.kt\ncom/jetbrains/rdclient/document/FrontendDocumentHost$MyProtocolListener\n*L\n64#1:286,4\n71#1:290,4\n80#1:294,4\n95#1:298,4\n*E\n"})
    public static final class MyProtocolListener
    implements RootExtListener<DocumentsOperationModel> {
        @Override
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull DocumentsOperationModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
            Logger logger = Companion.getLOG();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("[service] MyProtocolListener$extensionCreated: subscribe on `documents` model");
            }
            Companion.getLOG().assertTrue(model2.getDocuments().isEmpty(), (Object)"Listener was created too last and the model was already obtained");
            model2.getDocuments().view(lifetime, (arg_0, arg_1, arg_2) -> MyProtocolListener.x(session, this, arg_0, arg_1, arg_2));
            model2.getHostReleasedDocument().advise(lifetime, arg_0 -> MyProtocolListener.x(session, arg_0));
        }

        private static final Unit x(ClientAppSession clientAppSession, MyProtocolListener myProtocolListener, Lifetime lifetime, RdDocumentId rdDocumentId, RdDocumentModel rdDocumentModel) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"documentLifetime");
            Intrinsics.checkNotNullParameter((Object)rdDocumentId, (String)"documentId");
            Intrinsics.checkNotNullParameter((Object)((Object)rdDocumentModel), (String)"documentModel");
            ThreadingAssertions.assertEventDispatchThread();
            Logger logger = Companion.getLOG();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("[file] MyProtocolListener$extensionCreated$solutions.view$documents.view before invokeLaterIfNeeded. document=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId));
            }
            try {
                Document document = Companion.getInstance(clientAppSession).getOrCreateIdeaDocument(rdDocumentId, rdDocumentModel, lifetime, FrontendSessionsUtilKt.getProtocol(clientAppSession));
                if (document == null) {
                    MyProtocolListener myProtocolListener2 = myProtocolListener;
                    boolean bl3 = false;
                    Companion.getLOG().warn("It's not possible to get or create a Document for " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId));
                    return Unit.INSTANCE;
                }
                logger = document;
                Companion.getInstance(clientAppSession).viewDocumentModel(lifetime, rdDocumentId, (Document)logger, rdDocumentModel, clientAppSession);
                lifetime.onTermination(() -> MyProtocolListener.x(clientAppSession, rdDocumentId, (Document)logger));
            }
            catch (ProcessCanceledException processCanceledException) {
                Companion.getInstance(clientAppSession).x(rdDocumentId);
                throw processCanceledException;
            }
            catch (Throwable throwable) {
                Companion.getInstance(clientAppSession).x(rdDocumentId);
                Companion.getLOG().error(throwable);
                return Unit.INSTANCE;
            }
            return Unit.INSTANCE;
        }

        private static final Unit x(ClientAppSession clientAppSession, RdDocumentId rdDocumentId, Document document) {
            Logger logger = Companion.getLOG();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("document lifetime is terminating. Moving it's id to recentlyClosedDocuments: documentId=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId));
            }
            Companion.getInstance(clientAppSession).recentlyClosedDocuments.add(rdDocumentId);
            DocumentUniqueIdSessionRegistry.Companion.getInstance(clientAppSession).unregisterUniqueId(document);
            return Unit.INSTANCE;
        }

        private static final Unit x(ClientAppSession clientAppSession, RdDocumentId rdDocumentId) {
            Intrinsics.checkNotNullParameter((Object)rdDocumentId, (String)"it");
            Logger logger = Companion.getLOG();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("document was released on host. Remove it's id from recentlyClosedEditors: documentId=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId) + " ");
            }
            Companion.getInstance(clientAppSession).recentlyClosedDocuments.remove(rdDocumentId);
            return Unit.INSTANCE;
        }
    }
}

